from utils.Observable import Observable


#
# Dummy Configuration backend.
#
class DummyBackend(Observable):

    OBS_UPDATE = 0


    def __init__(self, path):

        self.__path = path
        self.__config = {}
        
        self.__handlers = {}



    #
    # Propagates configuration changes.
    #
    def __on_notify(self, path, value):

        key = path.split("/")[-2:]
        if (value):
            self.update_observer(self.OBS_UPDATE, key, value)



    #
    # Propagates changes in the list of displays.
    #
    def __on_watch(self, path, value):

        key = path.split("/")[-2:]
        #path1 = path
        #path2 = path1[:path1.rfind("/")]
        self.update_observer(self.OBS_UPDATE, key, value)



    #
    # Sets a configuration entry.
    #
    def set(self, *args):

        args = list(args)
        path = "/".join([self.__path] + args[:-1])
        self.__config[path] = args[-1]
        self.__on_watch(path, args[-1])
        


    #
    # Returns a configuration entry.
    #
    def get(self, *args):

        args = list(args)
        path = "/".join([self.__path] + args)
        return self.__config.get(path, "")



    #
    # Registers callbacks for watching configuration changes.
    #
    def watch(self, *args):

        args = list(args)
        # ignore empty parts
        if ("" in args): args.remove("")
        handler = args[-1]
        path = "/".join([self.__path] + args[:-1])
        self.__handlers[path] = handler



    #
    # Removes the given folder.
    #
    def clear(self, *path):

        pass



    #
    # Returns a list of all directories at the given path.
    #
    def list(self, *args):

        return []
