#
# Module for migration tasks.
#

import settings


def check_for_profiles(config):

    # check for "profiles" dir
    if ("profiles" in config.list()): return
    
    # create "profiles" dir and set profile
    config.set("profile", settings.profile)
    
    # move everything into "profiles" dir
    entries = config.list()
    for e in entries:
        if (e != "profiles" and e != "profile"):
            config.copy([e], ["profiles", settings.profile])
            config.clear(e)
    #end for
