/*
 * Decompiled with CFR 0.152.
 */
package rfb;

import rdr.OutStream;
import rfb.ConnParams;
import rfb.Decoder;
import rfb.PixelFormat;

public abstract class CMsgWriter {
    ConnParams cp;
    OutStream os;

    public abstract void writeClientInit(boolean var1);

    public void writeSetPixelFormat(PixelFormat pixelFormat) {
        this.startMsg(0);
        this.os.pad(3);
        pixelFormat.write(this.os);
        this.endMsg();
    }

    public void writeSetEncodings(int n, int[] nArray) {
        this.startMsg(2);
        this.os.skip(1);
        this.os.writeU16(n);
        for (int i = 0; i < n; ++i) {
            this.os.writeU32(nArray[i]);
        }
        this.endMsg();
    }

    public void writeSetEncodings(int n, boolean bl) {
        int n2 = 0;
        int[] nArray = new int[257];
        if (this.cp.supportsLocalCursor) {
            nArray[n2++] = -239;
        }
        if (this.cp.supportsDesktopResize) {
            nArray[n2++] = -223;
        }
        if (Decoder.supported(n)) {
            nArray[n2++] = n;
        }
        if (bl) {
            nArray[n2++] = 1;
        }
        for (int i = 255; i >= 0; --i) {
            if (i == n || !Decoder.supported(i)) continue;
            nArray[n2++] = i;
        }
        this.writeSetEncodings(n2, nArray);
    }

    public void writeFramebufferUpdateRequest(int n, int n2, int n3, int n4, boolean bl) {
        this.startMsg(3);
        this.os.writeU8(bl ? 1 : 0);
        this.os.writeU16(n);
        this.os.writeU16(n2);
        this.os.writeU16(n3);
        this.os.writeU16(n4);
        this.endMsg();
    }

    public void writeKeyEvent(int n, boolean bl) {
        this.startMsg(4);
        this.os.writeU8(bl ? 1 : 0);
        this.os.pad(2);
        this.os.writeU32(n);
        this.endMsg();
    }

    public void writePointerEvent(int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n >= this.cp.width) {
            n = this.cp.width - 1;
        }
        if (n2 >= this.cp.height) {
            n2 = this.cp.height - 1;
        }
        this.startMsg(5);
        this.os.writeU8(n3);
        this.os.writeU16(n);
        this.os.writeU16(n2);
        this.endMsg();
    }

    public void writeClientCutText(String string) {
        this.startMsg(6);
        this.os.pad(3);
        this.os.writeString(string);
        this.endMsg();
    }

    public abstract void startMsg(int var1);

    public abstract void endMsg();

    public void setOutStream(OutStream outStream) {
        this.os = outStream;
    }

    ConnParams getConnParams() {
        return this.cp;
    }

    OutStream getOutStream() {
        return this.os;
    }

    protected CMsgWriter(ConnParams connParams, OutStream outStream) {
        this.cp = connParams;
        this.os = outStream;
    }
}

