# Note that this is NOT a relocatable package
%define ver      	1.0.2
%define RELEASE		1
%define rel      	%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define sysconfdir	/etc

%define gtk2_version 2.0.0
%define libgnomeui_version 2.0.0

Summary:	GNOME System Tools
Name: 		gnome-system-tools
Version: 	%ver
Release: 	%rel
Copyright: 	LGPL
Group: 		Applications/System
Source0:	%{name}-%{version}.tar.gz
BuildRoot: 	/var/tmp/%{name}-%{version}-root
URL: 		http://www.gnome.org/projects/gst/
Requires:       gtk2 >= %{gtk2_version}
Requires:       libgnomeui >= %{libgnomeui_version}
Requires:       libglade2
Requires:       libxml2
Requires:       wvdial
Requires:       usermode
Requires:       pam

Prereq:         GConf2
Prereq:         /usr/bin/gconftool-2
BuildRequires:  gtk2-devel >= %{gtk2_version}
BuildRequires:  libglade2-devel

%description
Day-to-day system management on Unix systems is a
chore. Even when you're using a friendly graphical desktop, seemingly
basic tasks like setting the system time, changing the network setup,
importing and exporting network shared filesystems and configuring
swap partitions requires editing configuration files by hand, and the
exact procedure varies between different operating systems and
distributions.

The GNOME System Tools solve all these problems, giving you a simple
graphical interface for each task, which uses an advanced backend to
edit all the relevant files and apply your changes. The interface
looks and acts in exactly the same way regardless of what platform
you're using.

%prep
%setup -q

%build
%configure --prefix=%{_prefix} --sysconfdir=%{sysconfdir}
CFLAGS="$RPM_OPT_FLAGS" make

%install
rm -rf %{buildroot}

export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1;
make install DESTDIR=%{buildroot}
unset GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL

# Get rid of stuff we don't want
rm -rf %{buildroot}/%{_libdir}/debug
rm -rf %{buildroot}/%{sysconfdir}/X11

mv %{buildroot}/%{_bindir} %{buildroot}/%{_sbindir} 
mkdir -p %{buildroot}/%{_bindir}
mkdir -p %{buildroot}/%{sysconfdir}/security/console.apps
mkdir -p %{buildroot}/%{sysconfdir}/pam.d
for wrappedapp in boot network services time users ; do
        ln -sf consolehelper %{buildroot}/%{_bindir}/${wrappedapp}-admin

        # If we add the console.app file to the dist we should install it this way
        cat << EOF > %{buildroot}/%{sysconfdir}/security/console.apps/${wrappedapp}-admin
USER=root
PROGRAM=/usr/sbin/${wrappedapp}-admin
SESSION=true
EOF
        chmod 644 %{buildroot}/%{sysconfdir}/security/console.apps/${wrappedapp}-admin
        cat << EOF > %{buildroot}/etc/pam.d/${wrappedapp}-admin
#%PAM-1.0
auth       sufficient   pam_rootok.so
auth       sufficient   pam_timestamp.so
auth       required     pam_stack.so service=system-auth
session    required     pam_permit.so
session    optional     pam_xauth.so
session    optional     pam_timestamp.so
account    required     pam_permit.so
EOF
done

%find_lang %{name}

%clean
rm -rf %{buildroot}

%post
GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source` gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/gnome-system-tools.schemas > /dev/null;

%files
%defattr(-, root, root)
%doc README AUTHORS COPYING HACKING NEWS ChangeLog
%config(noreplace) %{sysconfdir}/security/console.apps/*
%config(noreplace) %{sysconfdir}/pam.d/*
%{_bindir}/*
%{_sbindir}/*
%{_sysconfdir}/gconf/schemas/gnome-system-tools.schemas
%{_datadir}/applications/*.desktop
%{_datadir}/locale/*
%{_datadir}/gnome-system-tools/*
%{_datadir}/setup-tool-backends/*
%{_libdir}/pkgconfig/*

%changelog
* Tue Aug 26 2003 William Jon McCann <mccann@jhu.edu>
- Update for GNOME 2.  Use consolehelper.

* Wed Mar 03 2001 Chema Celorio <chema@ximian.com>
- Fixed http://bugzilla.ximian.com/show_bug.cgi?id=1644

* Wed Nov 29 2000 Ross Golder <rossigee@bigfoot.com>
- Knocked up preliminary RPM spec file, based on gnome-core spec.

