%define name accerciser
%define version 0.1.92
%define release %{?custom_release}%{!?custom_release:1}

Summary: An interactive Python tool for querying accessibility information
Name: %{name}
Version: %{version}
Release: %{release}
Source0: %{name}-%{version}.tar.gz
License: BSD
BuildRoot: %{_builddir}/%{name}-%{version}-rpmroot
Prefix: /usr/local
BuildArch: noarch
Group: Desktop/Accessibility
Vendor: IBM Corporation
Packager: Peter Parente <pparent@us.ibm.com>
Url: http://live.gnome.org/Accerciser

BuildRequires: gnome-common >= 2.12.0
Requires: gnome-python2-gconf >= 2.12
Requires: gnome-python2-libwnck >= 2.14
Requires: pygtk2 >= 2.8
Requires: python >= 2.4
Requires: pygtk2-libglade >= 2.8
Requires: pyorbit >= 2.14
Requires: at-spi >= 1.7
Requires: gnome-python2 >= 2.12
Requires: glib2 >= 2.10
Requires: gnome-python2-bonobo >= 2.12

%description
An interactive Python accessibility explorer.

%prep
%setup -q

%build
./configure --prefix=%{prefix} --disable-scrollkeeper --without-pyreqs
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%post
GCONF_CONFIG_SOURCE=""	gconftool-2 --makefile-install-rule $RPM_INSTALL_PREFIX/etc/gconf/schemas/accerciser.schemas

%preun
GCONF_CONFIG_SOURCE=""	gconftool-2 --makefile-uninstall-rule $RPM_INSTALL_PREFIX/etc/gconf/schemas/accerciser.schemas

%files
%defattr(-,root,root)
%doc AUTHORS README COPYING NEWS ChangeLog
%{prefix}/bin/accerciser
%{prefix}/lib/python?.?/site-packages/accerciser
%{prefix}/share/locale/*/*/accerciser*
%{prefix}/share/omf/accerciser/*
%{prefix}/share/gnome/help/accerciser/*
%{prefix}/share/accerciser/*
%{prefix}/share/icons/hicolor/16x16/apps/accerciser.png
%{prefix}/share/icons/hicolor/22x22/apps/accerciser.png
%{prefix}/share/icons/hicolor/32x32/apps/accerciser.png
%{prefix}/share/icons/hicolor/48x48/apps/accerciser.png
%{prefix}/share/icons/hicolor/scalable/apps/accerciser.svg
%{prefix}/share/applications/accerciser.desktop
%{prefix}/etc/gconf/schemas/accerciser.schemas
%changelog
* Thu Apr 12 2007 Peter Parente <parente@cs.unc.edu>
- Added gconf schema install, uninstall, and files
* Mon Apr 02 2007 Peter Parente <parente@cs.unc.edu>
- Added without-pyreqs flag to avoid checking for modules at rpmbuild time
- Added locales to files section
* Wed Feb 22 2007 Peter Parente <parente@cs.unc.edu>
- First release
