/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-document.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-document
 * @title: IAnjutaDocument
 * @short_description: Interface for all kind of editable resources that
 * will be managed by IAnjutaDocumentManager
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-document.h
 * 
 */

#include "ianjuta-document.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_document_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-document-quark");
	}
	
	return quark;
}

/**
 * ianjuta_document_begin_undo_action:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Begins the mark of undoable action. Calls to this are stacked and
 * each must be ended with ianjuta_document_end_action().
 */
void
ianjuta_document_begin_undo_action (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->begin_undo_action (obj, err);
}

/* Default implementation */
static void
ianjuta_document_begin_undo_action_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_document_can_redo:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Can the editor redo the last operation?
 *
 * Returns true if editor can redo, else FALSE
 */
gboolean
ianjuta_document_can_redo (IAnjutaDocument *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT(obj), FALSE);
	return IANJUTA_DOCUMENT_GET_IFACE (obj)->can_redo (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_document_can_redo_default (IAnjutaDocument *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_document_can_undo:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Can the editor undo the last operation?
 *
 * Returns true if editor can undo, else FALSE
 */
gboolean
ianjuta_document_can_undo (IAnjutaDocument *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT(obj), FALSE);
	return IANJUTA_DOCUMENT_GET_IFACE (obj)->can_undo (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_document_can_undo_default (IAnjutaDocument *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_document_clear:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Clear selection
 */
void
ianjuta_document_clear (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->clear (obj, err);
}

/* Default implementation */
static void
ianjuta_document_clear_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_document_copy:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Copy selection to clipboard.
 */
void
ianjuta_document_copy (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->copy (obj, err);
}

/* Default implementation */
static void
ianjuta_document_copy_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_document_cut:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Cut selection to clipboard.
 */
void
ianjuta_document_cut (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->cut (obj, err);
}

/* Default implementation */
static void
ianjuta_document_cut_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_document_end_undo_action:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Ends the mark of undoable action.
 */
void
ianjuta_document_end_undo_action (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->end_undo_action (obj, err);
}

/* Default implementation */
static void
ianjuta_document_end_undo_action_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_document_get_filename:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Allows obtaining of the filename the editor was loaded from.
 *
 * Return value: The name of the file. Not to be freed by caller.
 */
const gchar*
ianjuta_document_get_filename (IAnjutaDocument *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DOCUMENT(obj), NULL);
	return IANJUTA_DOCUMENT_GET_IFACE (obj)->get_filename (obj, err);
}

/* Default implementation */
static const gchar*
ianjuta_document_get_filename_default (IAnjutaDocument *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_document_grab_focus:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Grabs the focus.
 */
void
ianjuta_document_grab_focus (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->grab_focus (obj, err);
}

/* Default implementation */
static void
ianjuta_document_grab_focus_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_document_paste:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Paste clipboard at current position.
 */
void
ianjuta_document_paste (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->paste (obj, err);
}

/* Default implementation */
static void
ianjuta_document_paste_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_document_redo:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Redo last undo operation
 */
void
ianjuta_document_redo (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->redo (obj, err);
}

/* Default implementation */
static void
ianjuta_document_redo_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_document_undo:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Undo last operation
 */
void
ianjuta_document_undo (IAnjutaDocument *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_DOCUMENT(obj));
	IANJUTA_DOCUMENT_GET_IFACE (obj)->undo (obj, err);
}

/* Default implementation */
static void
ianjuta_document_undo_default (IAnjutaDocument *obj, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_document_base_init (IAnjutaDocumentIface* klass)
{
	static gboolean initialized = FALSE;

	klass->begin_undo_action = ianjuta_document_begin_undo_action_default;
	klass->can_redo = ianjuta_document_can_redo_default;
	klass->can_undo = ianjuta_document_can_undo_default;
	klass->clear = ianjuta_document_clear_default;
	klass->copy = ianjuta_document_copy_default;
	klass->cut = ianjuta_document_cut_default;
	klass->end_undo_action = ianjuta_document_end_undo_action_default;
	klass->get_filename = ianjuta_document_get_filename_default;
	klass->grab_focus = ianjuta_document_grab_focus_default;
	klass->paste = ianjuta_document_paste_default;
	klass->redo = ianjuta_document_redo_default;
	klass->undo = ianjuta_document_undo_default;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("update-ui",
			IANJUTA_TYPE_DOCUMENT,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaDocumentIface, update_ui),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE,
			0,
			NULL);


		initialized = TRUE;
	}
}

GType
ianjuta_document_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDocumentIface),
			(GBaseInitFunc) ianjuta_document_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDocument", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
