/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-symbol.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
 * SECTION:ianjuta-symbol
 * @title: IAnjutaSymbol
 * @short_description: Source code symbol interface
 * @see_also: #IAnjutaSymbolManager
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-symbol.h
 * 
 */

#include "ianjuta-symbol.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_symbol_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-symbol-quark");
	}
	
	return quark;
}

/**
 *ianjuta_symbol_get_args:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 	 *
 * If symbol is has a kind of "function" then this will return a string with the args of the
 * function itself.
 *
 * Returns: args as const string or NULL
 */	
const gchar *
ianjuta_symbol_get_args (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_args (obj, err);
}

/* Default implementation */
static const gchar *
ianjuta_symbol_get_args_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/** 
 * ianjuta_symbol_get_extra_info_string:
 * @obj: Self
 	 * @sym_info: Just one IANJUTA_SYMBOL_FIELD_* per time. It is NOT possible to pass something like
 * FIELD_1 | FIELD_2 | ....
 * Note: You will not have anything passing IANJUTA_SYMBOL_FIELD_SIMPLE, just a NULL value.
 * 
 * @err: Error propagation and reporting.
 *
 * Returns: a string representation of the field required. For instance passing
 * IANJUTA_SYMBOL_FIELD_FILE_PATH you'll have a const gchar* representing the absolute file path, 
 * passing IANJUTA_SYMBOL_FIELD_ACCESS the access attribute, as "public", "private", etc.
 	 */
const gchar *
ianjuta_symbol_get_extra_info_string (IAnjutaSymbol *obj, IAnjutaSymbolField sym_info, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_extra_info_string (obj, sym_info, err);
}

/* Default implementation */
static const gchar *
ianjuta_symbol_get_extra_info_string_default (IAnjutaSymbol *obj, IAnjutaSymbolField sym_info, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_get_file:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Returns: The file where the symbol is declared in.
 */
GFile *
ianjuta_symbol_get_file (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_file (obj, err);
}

/* Default implementation */
static GFile *
ianjuta_symbol_get_file_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/** 
 * ianjuta_symbol_get_icon:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * You *need* a symbol with #IANJUTA_SYMBOL_FIELD_ACCESS | 
 * #IANJUTA_SYMBOL_FIELD_KIND enabled attribute. e.g. use 
 * ianjuta_symbol_manager_search passing #IANJUTA_SYMBOL_FIELD_ACCESS | 
 * #IANJUTA_SYMBOL_FIELD_KIND as info_fields.
 *
 * Returns: a Pixbuf icon representing the symbol. 
 */
const GdkPixbuf *
ianjuta_symbol_get_icon (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_icon (obj, err);
}

/* Default implementation */
static const GdkPixbuf *
ianjuta_symbol_get_icon_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_get_id:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * An unique identifier for the symbol: pay attention that when engine re-parse
 * the files this id may change.
 *
 * Returns: 0 on error, otherwise the id of the symbol mapped in the db.
 */
gint
ianjuta_symbol_get_id (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), -1);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_id (obj, err);
}

/* Default implementation */
static gint
ianjuta_symbol_get_id_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (-1);
}

/**
 * ianjuta_symbol_get_line:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Returns: Line of the file the symbol is declared in.
 */	
gulong
ianjuta_symbol_get_line (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), 0);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_line (obj, err);
}

/* Default implementation */
static gulong
ianjuta_symbol_get_line_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (0);
}

/**
 * ianjuta_symbol_get_name:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Returns: The name of the symbol
 */
const gchar *
ianjuta_symbol_get_name (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), NULL);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_name (obj, err);
}

/* Default implementation */
static const gchar *
ianjuta_symbol_get_name_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (NULL);
}

/**
 * ianjuta_symbol_get_sym_type:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * You can obtain an IAnjutaSymbolType of the symbol.
 * To have a string representation see ianjuta_symbol_get_extra_info_string ().
 * You *need* a symbol with #IANJUTA_SYMBOL_FIELD_TYPE enabled attribute. e.g. use ianjuta_symbol_manager_search
 * passing #IANJUTA_SYMBOL_FIELD_TYPE as info_fields.
 *
 * Returns: a #IAnjutaSymbolType
 */
IAnjutaSymbolType
ianjuta_symbol_get_sym_type (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), 0);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->get_sym_type (obj, err);
}

/* Default implementation */
static IAnjutaSymbolType
ianjuta_symbol_get_sym_type_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (0);
}

/**
 * ianjuta_symbol_is_local:
 * @obj: Self
 * @err: Error propagation and reporting.
 *
 * Is the symbol a static (private) one?
 *
 * Returns: TRUE if the symbol is local (private, etc), FALSE elsewhere.
 */	
gboolean
ianjuta_symbol_is_local (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_SYMBOL(obj), FALSE);
	return IANJUTA_SYMBOL_GET_IFACE (obj)->is_local (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_symbol_is_local_default (IAnjutaSymbol *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_symbol_base_init (IAnjutaSymbolIface* klass)
{
	static gboolean initialized = FALSE;

	klass->get_args = ianjuta_symbol_get_args_default;
	klass->get_extra_info_string = ianjuta_symbol_get_extra_info_string_default;
	klass->get_file = ianjuta_symbol_get_file_default;
	klass->get_icon = ianjuta_symbol_get_icon_default;
	klass->get_id = ianjuta_symbol_get_id_default;
	klass->get_line = ianjuta_symbol_get_line_default;
	klass->get_name = ianjuta_symbol_get_name_default;
	klass->get_sym_type = ianjuta_symbol_get_sym_type_default;
	klass->is_local = ianjuta_symbol_is_local_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_symbol_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaSymbolIface),
			(GBaseInitFunc) ianjuta_symbol_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaSymbol", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}

GType
ianjuta_symbol_field_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_FIELD_SIMPLE, "IANJUTA_SYMBOL_FIELD_SIMPLE", "field-simple" }, 
		{ IANJUTA_SYMBOL_FIELD_FILE_PATH, "IANJUTA_SYMBOL_FIELD_FILE_PATH", "field-file-path" }, 
		{ IANJUTA_SYMBOL_FIELD_IMPLEMENTATION, "IANJUTA_SYMBOL_FIELD_IMPLEMENTATION", "field-implementation" }, 
		{ IANJUTA_SYMBOL_FIELD_ACCESS, "IANJUTA_SYMBOL_FIELD_ACCESS", "field-access" }, 
		{ IANJUTA_SYMBOL_FIELD_KIND, "IANJUTA_SYMBOL_FIELD_KIND", "field-kind" }, 
		{ IANJUTA_SYMBOL_FIELD_TYPE, "IANJUTA_SYMBOL_FIELD_TYPE", "field-type" }, 
		{ IANJUTA_SYMBOL_FIELD_TYPE_NAME, "IANJUTA_SYMBOL_FIELD_TYPE_NAME", "field-type-name" }, 
		{ IANJUTA_SYMBOL_FIELD_LANGUAGE, "IANJUTA_SYMBOL_FIELD_LANGUAGE", "field-language" }, 
		{ IANJUTA_SYMBOL_FIELD_FILE_IGNORE, "IANJUTA_SYMBOL_FIELD_FILE_IGNORE", "field-file-ignore" }, 
		{ IANJUTA_SYMBOL_FIELD_FILE_INCLUDE, "IANJUTA_SYMBOL_FIELD_FILE_INCLUDE", "field-file-include" }, 
		{ IANJUTA_SYMBOL_FIELD_PROJECT_NAME, "IANJUTA_SYMBOL_FIELD_PROJECT_NAME", "field-project-name" }, 
		{ IANJUTA_SYMBOL_FIELD_WORKSPACE_NAME, "IANJUTA_SYMBOL_FIELD_WORKSPACE_NAME", "field-workspace-name" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolField", values);
	}

	return type;
}

GType
ianjuta_symbol_type_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_SYMBOL_TYPE_UNDEF, "IANJUTA_SYMBOL_TYPE_UNDEF", "type-undef" }, 
		{ IANJUTA_SYMBOL_TYPE_CLASS, "IANJUTA_SYMBOL_TYPE_CLASS", "type-class" }, 
		{ IANJUTA_SYMBOL_TYPE_ENUM, "IANJUTA_SYMBOL_TYPE_ENUM", "type-enum" }, 
		{ IANJUTA_SYMBOL_TYPE_ENUMERATOR, "IANJUTA_SYMBOL_TYPE_ENUMERATOR", "type-enumerator" }, 
		{ IANJUTA_SYMBOL_TYPE_FIELD, "IANJUTA_SYMBOL_TYPE_FIELD", "type-field" }, 
		{ IANJUTA_SYMBOL_TYPE_FUNCTION, "IANJUTA_SYMBOL_TYPE_FUNCTION", "type-function" }, 
		{ IANJUTA_SYMBOL_TYPE_INTERFACE, "IANJUTA_SYMBOL_TYPE_INTERFACE", "type-interface" }, 
		{ IANJUTA_SYMBOL_TYPE_MEMBER, "IANJUTA_SYMBOL_TYPE_MEMBER", "type-member" }, 
		{ IANJUTA_SYMBOL_TYPE_METHOD, "IANJUTA_SYMBOL_TYPE_METHOD", "type-method" }, 
		{ IANJUTA_SYMBOL_TYPE_NAMESPACE, "IANJUTA_SYMBOL_TYPE_NAMESPACE", "type-namespace" }, 
		{ IANJUTA_SYMBOL_TYPE_PACKAGE, "IANJUTA_SYMBOL_TYPE_PACKAGE", "type-package" }, 
		{ IANJUTA_SYMBOL_TYPE_PROTOTYPE, "IANJUTA_SYMBOL_TYPE_PROTOTYPE", "type-prototype" }, 
		{ IANJUTA_SYMBOL_TYPE_STRUCT, "IANJUTA_SYMBOL_TYPE_STRUCT", "type-struct" }, 
		{ IANJUTA_SYMBOL_TYPE_TYPEDEF, "IANJUTA_SYMBOL_TYPE_TYPEDEF", "type-typedef" }, 
		{ IANJUTA_SYMBOL_TYPE_UNION, "IANJUTA_SYMBOL_TYPE_UNION", "type-union" }, 
		{ IANJUTA_SYMBOL_TYPE_VARIABLE, "IANJUTA_SYMBOL_TYPE_VARIABLE", "type-variable" }, 
		{ IANJUTA_SYMBOL_TYPE_EXTERNVAR, "IANJUTA_SYMBOL_TYPE_EXTERNVAR", "type-externvar" }, 
		{ IANJUTA_SYMBOL_TYPE_MACRO, "IANJUTA_SYMBOL_TYPE_MACRO", "type-macro" }, 
		{ IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG, "IANJUTA_SYMBOL_TYPE_MACRO_WITH_ARG", "type-macro-with-arg" }, 
		{ IANJUTA_SYMBOL_TYPE_FILE, "IANJUTA_SYMBOL_TYPE_FILE", "type-file" }, 
		{ IANJUTA_SYMBOL_TYPE_OTHER, "IANJUTA_SYMBOL_TYPE_OTHER", "type-other" }, 
		{ IANJUTA_SYMBOL_TYPE_MAX, "IANJUTA_SYMBOL_TYPE_MAX", "type-max" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaSymbolType", values);
	}

	return type;
}
