/* ctags-visitor.c generated by valac, the Vala compiler
 * generated from ctags-visitor.vala, do not modify */

/*
 * ctags-visitor.vala
 *
 * Copyright 2008, 2010 Abderrahim Kitouni <a.kitouni@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>
#include <valagee.h>


#define TYPE_CTAGS_ENTRY (ctags_entry_get_type ())
typedef struct _CTagsEntry CTagsEntry;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DUMMY_REPORT (dummy_report_get_type ())
#define DUMMY_REPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DUMMY_REPORT, DummyReport))
#define DUMMY_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DUMMY_REPORT, DummyReportClass))
#define IS_DUMMY_REPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DUMMY_REPORT))
#define IS_DUMMY_REPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DUMMY_REPORT))
#define DUMMY_REPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DUMMY_REPORT, DummyReportClass))

typedef struct _DummyReport DummyReport;
typedef struct _DummyReportClass DummyReportClass;
typedef struct _DummyReportPrivate DummyReportPrivate;

#define TYPE_CTAGS_VISITOR (ctags_visitor_get_type ())
#define CTAGS_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CTAGS_VISITOR, CTagsVisitor))
#define CTAGS_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CTAGS_VISITOR, CTagsVisitorClass))
#define IS_CTAGS_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CTAGS_VISITOR))
#define IS_CTAGS_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CTAGS_VISITOR))
#define CTAGS_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CTAGS_VISITOR, CTagsVisitorClass))

typedef struct _CTagsVisitor CTagsVisitor;
typedef struct _CTagsVisitorClass CTagsVisitorClass;
typedef struct _CTagsVisitorPrivate CTagsVisitorPrivate;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))
#define __g_list_free_ctags_entry_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_ctags_entry_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _ctags_entry_free0(var) ((var == NULL) ? NULL : (var = (ctags_entry_free (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _CTagsEntry {
	gint line_number;
	char* name;
	char* kind_name;
	gchar kind;
	char* access;
	char* implementation;
	char* inheritance;
	char* scope[2];
	char* signature;
	char* typeref;
};

struct _DummyReport {
	ValaReport parent_instance;
	DummyReportPrivate * priv;
};

struct _DummyReportClass {
	ValaReportClass parent_class;
};

typedef void (*CTagsEntryMaker) (CTagsEntry* entry);
struct _CTagsVisitor {
	ValaCodeVisitor parent_instance;
	CTagsVisitorPrivate * priv;
};

struct _CTagsVisitorClass {
	ValaCodeVisitorClass parent_class;
};

struct _CTagsVisitorPrivate {
	ValaParser* vala_parser;
	ValaGenieParser* genie_parser;
	GList* taglist;
};


static gpointer dummy_report_parent_class = NULL;
static gpointer ctags_visitor_parent_class = NULL;

GType ctags_entry_get_type (void);
CTagsEntry* ctags_entry_dup (const CTagsEntry* self);
void ctags_entry_free (CTagsEntry* self);
void ctags_entry_copy (const CTagsEntry* self, CTagsEntry* dest);
void ctags_entry_destroy (CTagsEntry* self);
GType dummy_report_get_type (void);
enum  {
	DUMMY_REPORT_DUMMY_PROPERTY
};
static void dummy_report_real_warn (ValaReport* base, ValaSourceReference* source, const char* message);
static void dummy_report_real_err (ValaReport* base, ValaSourceReference* source, const char* message);
DummyReport* dummy_report_new (void);
DummyReport* dummy_report_construct (GType object_type);
GType ctags_visitor_get_type (void);
#define CTAGS_VISITOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CTAGS_VISITOR, CTagsVisitorPrivate))
enum  {
	CTAGS_VISITOR_DUMMY_PROPERTY
};
static void _g_list_free_ctags_entry_free (GList* self);
CTagsVisitor* ctags_visitor_new (void);
CTagsVisitor* ctags_visitor_construct (GType object_type);
static char* ctags_visitor_get_access (ValaSymbol* sym);
static char* ctags_visitor_to_string (ValaIterable* seq, const char* sep);
static void _g_list_free_g_free (GList* self);
static char* ctags_visitor_implementation (ValaSymbol* sym);
static char* ctags_visitor_signature (ValaList* parameter);
static void ctags_visitor_scope (ValaSymbol* s, char** scope, int scope_length1);
static void ctags_visitor_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void ctags_visitor_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void ctags_visitor_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void ctags_visitor_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void ctags_visitor_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void ctags_visitor_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain);
static void ctags_visitor_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void ctags_visitor_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode);
static void ctags_visitor_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void ctags_visitor_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void ctags_visitor_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void ctags_visitor_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void ctags_visitor_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void ctags_visitor_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void ctags_visitor_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
void ctags_visitor_parse_vala (CTagsVisitor* self, const char* filename, CTagsEntryMaker maker);
void ctags_visitor_parse_genie (CTagsVisitor* self, const char* filename, CTagsEntryMaker maker);
static void ctags_visitor_finalize (ValaCodeVisitor* obj);



void ctags_entry_copy (const CTagsEntry* self, CTagsEntry* dest) {
	dest->line_number = self->line_number;
	dest->name = g_strdup (self->name);
	dest->kind_name = g_strdup (self->kind_name);
	dest->kind = self->kind;
	dest->access = g_strdup (self->access);
	dest->implementation = g_strdup (self->implementation);
	dest->inheritance = g_strdup (self->inheritance);
	memcpy (dest->scope, self->scope, 2 * sizeof (char*));
	dest->signature = g_strdup (self->signature);
	dest->typeref = g_strdup (self->typeref);
}


void ctags_entry_destroy (CTagsEntry* self) {
	_g_free0 (self->name);
	_g_free0 (self->kind_name);
	_g_free0 (self->access);
	_g_free0 (self->implementation);
	_g_free0 (self->inheritance);
	_g_free0 (self->signature);
	_g_free0 (self->typeref);
}


CTagsEntry* ctags_entry_dup (const CTagsEntry* self) {
	CTagsEntry* dup;
	dup = g_new0 (CTagsEntry, 1);
	ctags_entry_copy (self, dup);
	return dup;
}


void ctags_entry_free (CTagsEntry* self) {
	ctags_entry_destroy (self);
	g_free (self);
}


GType ctags_entry_get_type (void) {
	static GType ctags_entry_type_id = 0;
	if (ctags_entry_type_id == 0) {
		ctags_entry_type_id = g_boxed_type_register_static ("CTagsEntry", (GBoxedCopyFunc) ctags_entry_dup, (GBoxedFreeFunc) ctags_entry_free);
	}
	return ctags_entry_type_id;
}


#line 38 "ctags-visitor.vala"
static void dummy_report_real_warn (ValaReport* base, ValaSourceReference* source, const char* message) {
#line 210 "ctags-visitor.c"
	DummyReport * self;
	self = (DummyReport*) base;
#line 38 "ctags-visitor.vala"
	g_return_if_fail (message != NULL);
#line 215 "ctags-visitor.c"
}


#line 39 "ctags-visitor.vala"
static void dummy_report_real_err (ValaReport* base, ValaSourceReference* source, const char* message) {
#line 221 "ctags-visitor.c"
	DummyReport * self;
	self = (DummyReport*) base;
#line 39 "ctags-visitor.vala"
	g_return_if_fail (message != NULL);
#line 226 "ctags-visitor.c"
}


#line 37 "ctags-visitor.vala"
DummyReport* dummy_report_construct (GType object_type) {
#line 232 "ctags-visitor.c"
	DummyReport * self;
#line 37 "ctags-visitor.vala"
	self = (DummyReport*) vala_report_construct (object_type);
#line 236 "ctags-visitor.c"
	return self;
}


#line 37 "ctags-visitor.vala"
DummyReport* dummy_report_new (void) {
#line 37 "ctags-visitor.vala"
	return dummy_report_construct (TYPE_DUMMY_REPORT);
#line 245 "ctags-visitor.c"
}


static void dummy_report_class_init (DummyReportClass * klass) {
	dummy_report_parent_class = g_type_class_peek_parent (klass);
	VALA_REPORT_CLASS (klass)->warn = dummy_report_real_warn;
	VALA_REPORT_CLASS (klass)->err = dummy_report_real_err;
}


static void dummy_report_instance_init (DummyReport * self) {
}


GType dummy_report_get_type (void) {
	static GType dummy_report_type_id = 0;
	if (dummy_report_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DummyReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dummy_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DummyReport), 0, (GInstanceInitFunc) dummy_report_instance_init, NULL };
		dummy_report_type_id = g_type_register_static (VALA_TYPE_REPORT, "DummyReport", &g_define_type_info, 0);
	}
	return dummy_report_type_id;
}


static void _g_list_free_ctags_entry_free (GList* self) {
	g_list_foreach (self, (GFunc) ctags_entry_free, NULL);
	g_list_free (self);
}


#line 49 "ctags-visitor.vala"
CTagsVisitor* ctags_visitor_construct (GType object_type) {
#line 278 "ctags-visitor.c"
	CTagsVisitor* self;
	ValaParser* _tmp0_;
	ValaGenieParser* _tmp1_;
#line 49 "ctags-visitor.vala"
	self = (CTagsVisitor*) vala_code_visitor_construct (object_type);
#line 50 "ctags-visitor.vala"
	self->priv->vala_parser = (_tmp0_ = vala_parser_new (), _vala_code_visitor_unref0 (self->priv->vala_parser), _tmp0_);
#line 51 "ctags-visitor.vala"
	self->priv->genie_parser = (_tmp1_ = vala_genie_parser_new (), _vala_code_visitor_unref0 (self->priv->genie_parser), _tmp1_);
#line 288 "ctags-visitor.c"
	return self;
}


#line 49 "ctags-visitor.vala"
CTagsVisitor* ctags_visitor_new (void) {
#line 49 "ctags-visitor.vala"
	return ctags_visitor_construct (TYPE_CTAGS_VISITOR);
#line 297 "ctags-visitor.c"
}


#line 54 "ctags-visitor.vala"
static char* ctags_visitor_get_access (ValaSymbol* sym) {
#line 303 "ctags-visitor.c"
	char* result;
#line 54 "ctags-visitor.vala"
	g_return_val_if_fail (sym != NULL, NULL);
#line 55 "ctags-visitor.vala"
	switch (vala_symbol_get_access (sym)) {
#line 309 "ctags-visitor.c"
		case VALA_SYMBOL_ACCESSIBILITY_PRIVATE:
		{
			result = g_strdup ("private");
#line 56 "ctags-visitor.vala"
			return result;
#line 315 "ctags-visitor.c"
		}
		case VALA_SYMBOL_ACCESSIBILITY_INTERNAL:
		{
			result = g_strdup ("internal");
#line 57 "ctags-visitor.vala"
			return result;
#line 322 "ctags-visitor.c"
		}
		case VALA_SYMBOL_ACCESSIBILITY_PROTECTED:
		{
			result = g_strdup ("protected");
#line 58 "ctags-visitor.vala"
			return result;
#line 329 "ctags-visitor.c"
		}
		case VALA_SYMBOL_ACCESSIBILITY_PUBLIC:
		{
			result = g_strdup ("public");
#line 59 "ctags-visitor.vala"
			return result;
#line 336 "ctags-visitor.c"
		}
	}
#line 61 "ctags-visitor.vala"
	g_assert_not_reached ();
#line 341 "ctags-visitor.c"
}


#line 63 "ctags-visitor.vala"
static char* ctags_visitor_to_string (ValaIterable* seq, const char* sep) {
#line 347 "ctags-visitor.c"
	char* result;
	GString* str;
	gboolean first;
#line 63 "ctags-visitor.vala"
	g_return_val_if_fail (seq != NULL, NULL);
#line 63 "ctags-visitor.vala"
	g_return_val_if_fail (sep != NULL, NULL);
#line 64 "ctags-visitor.vala"
	str = g_string_new ("");
#line 65 "ctags-visitor.vala"
	first = TRUE;
#line 359 "ctags-visitor.c"
	{
		ValaIterator* _type_it;
		_type_it = vala_iterable_iterator (seq);
#line 66 "ctags-visitor.vala"
		while (TRUE) {
#line 365 "ctags-visitor.c"
			ValaDataType* type;
			char* _tmp0_;
#line 66 "ctags-visitor.vala"
			if (!vala_iterator_next (_type_it)) {
#line 66 "ctags-visitor.vala"
				break;
#line 372 "ctags-visitor.c"
			}
#line 66 "ctags-visitor.vala"
			type = (ValaDataType*) vala_iterator_get (_type_it);
#line 67 "ctags-visitor.vala"
			if (first) {
#line 68 "ctags-visitor.vala"
				first = FALSE;
#line 380 "ctags-visitor.c"
			} else {
#line 70 "ctags-visitor.vala"
				g_string_append (str, sep);
#line 384 "ctags-visitor.c"
			}
#line 72 "ctags-visitor.vala"
			g_string_append (str, _tmp0_ = vala_data_type_to_qualified_string (type, NULL));
#line 388 "ctags-visitor.c"
			_g_free0 (_tmp0_);
			_vala_code_node_unref0 (type);
		}
		_vala_collection_object_unref0 (_type_it);
	}
	result = g_strdup (str->str);
	_g_string_free0 (str);
#line 74 "ctags-visitor.vala"
	return result;
#line 398 "ctags-visitor.c"
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


#line 76 "ctags-visitor.vala"
static char* ctags_visitor_implementation (ValaSymbol* sym) {
#line 415 "ctags-visitor.c"
	char* result;
	GList* list;
	GString* ret;
	gboolean first;
#line 76 "ctags-visitor.vala"
	g_return_val_if_fail (sym != NULL, NULL);
#line 77 "ctags-visitor.vala"
	list = NULL;
#line 79 "ctags-visitor.vala"
	if (VALA_IS_SIGNAL (sym)) {
#line 426 "ctags-visitor.c"
		ValaSignal* sig;
#line 80 "ctags-visitor.vala"
		sig = _vala_code_node_ref0 (VALA_SIGNAL (sym));
#line 81 "ctags-visitor.vala"
		if (vala_signal_get_is_virtual (sig)) {
#line 82 "ctags-visitor.vala"
			list = g_list_append (list, g_strdup ("virtual"));
#line 434 "ctags-visitor.c"
		}
		_vala_code_node_unref0 (sig);
	} else {
#line 83 "ctags-visitor.vala"
		if (VALA_IS_CLASS (sym)) {
#line 440 "ctags-visitor.c"
			ValaClass* cls;
#line 84 "ctags-visitor.vala"
			cls = _vala_code_node_ref0 (VALA_CLASS (sym));
#line 85 "ctags-visitor.vala"
			if (vala_class_get_is_abstract (cls)) {
#line 86 "ctags-visitor.vala"
				list = g_list_append (list, g_strdup ("abstract"));
#line 448 "ctags-visitor.c"
			}
			_vala_code_node_unref0 (cls);
		} else {
#line 87 "ctags-visitor.vala"
			if (VALA_IS_METHOD (sym)) {
#line 454 "ctags-visitor.c"
				ValaMethod* meth;
#line 88 "ctags-visitor.vala"
				meth = _vala_code_node_ref0 (VALA_METHOD (sym));
#line 89 "ctags-visitor.vala"
				if (vala_method_get_is_abstract (meth)) {
#line 90 "ctags-visitor.vala"
					list = g_list_append (list, g_strdup ("abstract"));
#line 462 "ctags-visitor.c"
				} else {
#line 91 "ctags-visitor.vala"
					if (vala_method_get_is_virtual (meth)) {
#line 92 "ctags-visitor.vala"
						list = g_list_append (list, g_strdup ("virtual"));
#line 468 "ctags-visitor.c"
					}
				}
				_vala_code_node_unref0 (meth);
			} else {
#line 93 "ctags-visitor.vala"
				if (VALA_IS_PROPERTY (sym)) {
#line 475 "ctags-visitor.c"
					ValaProperty* prop;
#line 94 "ctags-visitor.vala"
					prop = _vala_code_node_ref0 (VALA_PROPERTY (sym));
#line 95 "ctags-visitor.vala"
					if (vala_property_get_is_abstract (prop)) {
#line 96 "ctags-visitor.vala"
						list = g_list_append (list, g_strdup ("abstract"));
#line 483 "ctags-visitor.c"
					} else {
#line 97 "ctags-visitor.vala"
						if (vala_property_get_is_virtual (prop)) {
#line 98 "ctags-visitor.vala"
							list = g_list_append (list, g_strdup ("virtual"));
#line 489 "ctags-visitor.c"
						}
					}
					_vala_code_node_unref0 (prop);
				} else {
#line 100 "ctags-visitor.vala"
					g_return_val_if_reached (NULL);
#line 496 "ctags-visitor.c"
				}
			}
		}
	}
#line 102 "ctags-visitor.vala"
	ret = g_string_new ("");
#line 103 "ctags-visitor.vala"
	first = TRUE;
#line 505 "ctags-visitor.c"
	{
		GList* str_collection;
		GList* str_it;
#line 104 "ctags-visitor.vala"
		str_collection = list;
#line 511 "ctags-visitor.c"
		for (str_it = str_collection; str_it != NULL; str_it = str_it->next) {
			char* str;
#line 104 "ctags-visitor.vala"
			str = g_strdup ((const char*) str_it->data);
#line 516 "ctags-visitor.c"
			{
#line 105 "ctags-visitor.vala"
				if (first) {
#line 106 "ctags-visitor.vala"
					first = FALSE;
#line 522 "ctags-visitor.c"
				} else {
#line 108 "ctags-visitor.vala"
					g_string_append (ret, ",");
#line 526 "ctags-visitor.c"
				}
#line 110 "ctags-visitor.vala"
				g_string_append (ret, str);
#line 530 "ctags-visitor.c"
				_g_free0 (str);
			}
		}
	}
	result = g_strdup (ret->str);
	__g_list_free_g_free0 (list);
	_g_string_free0 (ret);
#line 112 "ctags-visitor.vala"
	return result;
#line 540 "ctags-visitor.c"
}


#line 114 "ctags-visitor.vala"
static char* ctags_visitor_signature (ValaList* parameter) {
#line 546 "ctags-visitor.c"
	char* result;
	GString* ret;
	gboolean first;
#line 114 "ctags-visitor.vala"
	g_return_val_if_fail (parameter != NULL, NULL);
#line 115 "ctags-visitor.vala"
	ret = g_string_new ("(");
#line 116 "ctags-visitor.vala"
	first = TRUE;
#line 556 "ctags-visitor.c"
	{
		ValaIterator* _p_it;
		_p_it = vala_iterable_iterator ((ValaIterable*) parameter);
#line 117 "ctags-visitor.vala"
		while (TRUE) {
#line 562 "ctags-visitor.c"
			ValaFormalParameter* p;
#line 117 "ctags-visitor.vala"
			if (!vala_iterator_next (_p_it)) {
#line 117 "ctags-visitor.vala"
				break;
#line 568 "ctags-visitor.c"
			}
#line 117 "ctags-visitor.vala"
			p = (ValaFormalParameter*) vala_iterator_get (_p_it);
#line 118 "ctags-visitor.vala"
			if (first) {
#line 119 "ctags-visitor.vala"
				first = FALSE;
#line 576 "ctags-visitor.c"
			} else {
#line 121 "ctags-visitor.vala"
				g_string_append (ret, ",");
#line 580 "ctags-visitor.c"
			}
#line 123 "ctags-visitor.vala"
			if (vala_formal_parameter_get_ellipsis (p)) {
#line 124 "ctags-visitor.vala"
				g_string_append (ret, "...");
#line 586 "ctags-visitor.c"
			} else {
				char* _tmp0_;
#line 126 "ctags-visitor.vala"
				g_string_append (ret, _tmp0_ = vala_data_type_to_qualified_string (vala_formal_parameter_get_parameter_type (p), NULL));
#line 591 "ctags-visitor.c"
				_g_free0 (_tmp0_);
#line 127 "ctags-visitor.vala"
				g_string_append (ret, " ");
#line 128 "ctags-visitor.vala"
				g_string_append (ret, vala_symbol_get_name ((ValaSymbol*) p));
#line 597 "ctags-visitor.c"
			}
			_vala_code_node_unref0 (p);
		}
		_vala_collection_object_unref0 (_p_it);
	}
#line 131 "ctags-visitor.vala"
	g_string_append (ret, ")");
#line 605 "ctags-visitor.c"
	result = g_strdup (ret->str);
	_g_string_free0 (ret);
#line 132 "ctags-visitor.vala"
	return result;
#line 610 "ctags-visitor.c"
}


#line 134 "ctags-visitor.vala"
static void ctags_visitor_scope (ValaSymbol* s, char** scope, int scope_length1) {
#line 616 "ctags-visitor.c"
	ValaSymbol* par;
	gboolean _tmp0_ = FALSE;
#line 134 "ctags-visitor.vala"
	g_return_if_fail (s != NULL);
#line 135 "ctags-visitor.vala"
	par = _vala_code_node_ref0 (vala_symbol_get_parent_symbol (s));
#line 136 "ctags-visitor.vala"
	if (par != NULL) {
#line 136 "ctags-visitor.vala"
		_tmp0_ = vala_symbol_get_name (par) != NULL;
#line 627 "ctags-visitor.c"
	} else {
#line 136 "ctags-visitor.vala"
		_tmp0_ = FALSE;
#line 631 "ctags-visitor.c"
	}
#line 136 "ctags-visitor.vala"
	if (_tmp0_) {
#line 635 "ctags-visitor.c"
		char* _tmp4_;
#line 137 "ctags-visitor.vala"
		if (VALA_IS_CLASS (par)) {
#line 639 "ctags-visitor.c"
			char* _tmp1_;
#line 138 "ctags-visitor.vala"
			scope[0] = (_tmp1_ = g_strdup ("class"), _g_free0 (scope[0]), _tmp1_);
#line 643 "ctags-visitor.c"
		} else {
#line 139 "ctags-visitor.vala"
			if (VALA_IS_STRUCT (par)) {
#line 647 "ctags-visitor.c"
				char* _tmp2_;
#line 140 "ctags-visitor.vala"
				scope[0] = (_tmp2_ = g_strdup ("struct"), _g_free0 (scope[0]), _tmp2_);
#line 651 "ctags-visitor.c"
			} else {
#line 141 "ctags-visitor.vala"
				if (VALA_IS_INTERFACE (par)) {
#line 655 "ctags-visitor.c"
					char* _tmp3_;
#line 142 "ctags-visitor.vala"
					scope[0] = (_tmp3_ = g_strdup ("interface"), _g_free0 (scope[0]), _tmp3_);
#line 659 "ctags-visitor.c"
				} else {
					_vala_code_node_unref0 (par);
#line 144 "ctags-visitor.vala"
					return;
#line 664 "ctags-visitor.c"
				}
			}
		}
#line 145 "ctags-visitor.vala"
		scope[1] = (_tmp4_ = g_strdup (vala_symbol_get_name (par)), _g_free0 (scope[1]), _tmp4_);
#line 670 "ctags-visitor.c"
	}
	_vala_code_node_unref0 (par);
}


#line 152 "ctags-visitor.vala"
static void ctags_visitor_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
#line 678 "ctags-visitor.c"
	CTagsVisitor * self;
	self = (CTagsVisitor*) base;
#line 152 "ctags-visitor.vala"
	g_return_if_fail (source_file != NULL);
#line 153 "ctags-visitor.vala"
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) self);
#line 685 "ctags-visitor.c"
}


static gpointer _ctags_entry_dup0 (gpointer self) {
	return self ? ctags_entry_dup (self) : NULL;
}


#line 156 "ctags-visitor.vala"
static void ctags_visitor_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
#line 696 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp6_;
	ValaList* _tmp5_;
	self = (CTagsVisitor*) base;
#line 156 "ctags-visitor.vala"
	g_return_if_fail (cl != NULL);
#line 157 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 159 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) cl));
#line 160 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) cl)), _g_free0 (entry.name), _tmp1_);
#line 161 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("class"), _g_free0 (entry.kind_name), _tmp2_);
#line 162 "ctags-visitor.vala"
	entry.kind = 'c';
#line 163 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) cl), _g_free0 (entry.access), _tmp3_);
#line 164 "ctags-visitor.vala"
	entry.implementation = (_tmp4_ = ctags_visitor_implementation ((ValaSymbol*) cl), _g_free0 (entry.implementation), _tmp4_);
#line 165 "ctags-visitor.vala"
	entry.inheritance = (_tmp6_ = ctags_visitor_to_string ((ValaIterable*) (_tmp5_ = vala_class_get_base_types (cl)), ","), _g_free0 (entry.inheritance), _tmp6_);
#line 725 "ctags-visitor.c"
	_vala_collection_object_unref0 (_tmp5_);
#line 166 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) cl, entry.scope, 2);
#line 168 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 170 "ctags-visitor.vala"
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
#line 733 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 172 "ctags-visitor.vala"
static void ctags_visitor_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
#line 740 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	self = (CTagsVisitor*) base;
#line 172 "ctags-visitor.vala"
	g_return_if_fail (st != NULL);
#line 173 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 174 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) st));
#line 175 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) st)), _g_free0 (entry.name), _tmp1_);
#line 176 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("struct"), _g_free0 (entry.kind_name), _tmp2_);
#line 177 "ctags-visitor.vala"
	entry.kind = 's';
#line 178 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) st), _g_free0 (entry.access), _tmp3_);
#line 179 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) st, entry.scope, 2);
#line 181 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 183 "ctags-visitor.vala"
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
#line 768 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 185 "ctags-visitor.vala"
static void ctags_visitor_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
#line 775 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp5_;
	ValaList* _tmp4_;
	self = (CTagsVisitor*) base;
#line 185 "ctags-visitor.vala"
	g_return_if_fail (iface != NULL);
#line 186 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 188 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) iface));
#line 189 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) iface)), _g_free0 (entry.name), _tmp1_);
#line 190 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("interface"), _g_free0 (entry.kind_name), _tmp2_);
#line 191 "ctags-visitor.vala"
	entry.kind = 'i';
#line 192 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) iface), _g_free0 (entry.access), _tmp3_);
#line 193 "ctags-visitor.vala"
	entry.inheritance = (_tmp5_ = ctags_visitor_to_string ((ValaIterable*) (_tmp4_ = vala_interface_get_prerequisites (iface)), ","), _g_free0 (entry.inheritance), _tmp5_);
#line 801 "ctags-visitor.c"
	_vala_collection_object_unref0 (_tmp4_);
#line 194 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) iface, entry.scope, 2);
#line 196 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 198 "ctags-visitor.vala"
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
#line 809 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 201 "ctags-visitor.vala"
static void ctags_visitor_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
#line 816 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	self = (CTagsVisitor*) base;
#line 201 "ctags-visitor.vala"
	g_return_if_fail (en != NULL);
#line 202 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 204 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) en));
#line 205 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) en)), _g_free0 (entry.name), _tmp1_);
#line 206 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("enum"), _g_free0 (entry.kind_name), _tmp2_);
#line 207 "ctags-visitor.vala"
	entry.kind = 'e';
#line 208 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) en), _g_free0 (entry.access), _tmp3_);
#line 209 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) en, entry.scope, 2);
#line 211 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 213 "ctags-visitor.vala"
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
#line 844 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 215 "ctags-visitor.vala"
static void ctags_visitor_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* edomain) {
#line 851 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	self = (CTagsVisitor*) base;
#line 215 "ctags-visitor.vala"
	g_return_if_fail (edomain != NULL);
#line 216 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 218 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) edomain));
#line 219 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) edomain)), _g_free0 (entry.name), _tmp1_);
#line 220 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("errordomain"), _g_free0 (entry.kind_name), _tmp2_);
#line 221 "ctags-visitor.vala"
	entry.kind = 'E';
#line 222 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) edomain), _g_free0 (entry.access), _tmp3_);
#line 223 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) edomain, entry.scope, 2);
#line 225 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 227 "ctags-visitor.vala"
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) self);
#line 879 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 230 "ctags-visitor.vala"
static void ctags_visitor_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
#line 886 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	self = (CTagsVisitor*) base;
#line 230 "ctags-visitor.vala"
	g_return_if_fail (ev != NULL);
#line 231 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 233 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) ev));
#line 234 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) ev)), _g_free0 (entry.name), _tmp1_);
#line 235 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("enumvalue"), _g_free0 (entry.kind_name), _tmp2_);
#line 236 "ctags-visitor.vala"
	entry.kind = 'v';
#line 237 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) ev), _g_free0 (entry.access), _tmp3_);
#line 238 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) ev, entry.scope, 2);
#line 240 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 912 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 243 "ctags-visitor.vala"
static void ctags_visitor_real_visit_error_code (ValaCodeVisitor* base, ValaErrorCode* ecode) {
#line 919 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	self = (CTagsVisitor*) base;
#line 243 "ctags-visitor.vala"
	g_return_if_fail (ecode != NULL);
#line 244 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 247 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) ecode)), _g_free0 (entry.name), _tmp1_);
#line 248 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("errorcode"), _g_free0 (entry.kind_name), _tmp2_);
#line 249 "ctags-visitor.vala"
	entry.kind = 'r';
#line 250 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) ecode), _g_free0 (entry.access), _tmp3_);
#line 251 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) ecode, entry.scope, 2);
#line 253 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 943 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 257 "ctags-visitor.vala"
static void ctags_visitor_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
#line 950 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp6_;
	ValaList* _tmp5_;
	self = (CTagsVisitor*) base;
#line 257 "ctags-visitor.vala"
	g_return_if_fail (d != NULL);
#line 258 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 260 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) d));
#line 261 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) d)), _g_free0 (entry.name), _tmp1_);
#line 262 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("delegate"), _g_free0 (entry.kind_name), _tmp2_);
#line 263 "ctags-visitor.vala"
	entry.kind = 'd';
#line 264 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) d), _g_free0 (entry.access), _tmp3_);
#line 265 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) d, entry.scope, 2);
#line 266 "ctags-visitor.vala"
	entry.typeref = (_tmp4_ = vala_data_type_to_qualified_string (vala_delegate_get_return_type (d), NULL), _g_free0 (entry.typeref), _tmp4_);
#line 267 "ctags-visitor.vala"
	entry.signature = (_tmp6_ = ctags_visitor_signature (_tmp5_ = vala_delegate_get_parameters (d)), _g_free0 (entry.signature), _tmp6_);
#line 981 "ctags-visitor.c"
	_vala_collection_object_unref0 (_tmp5_);
#line 269 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 985 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 272 "ctags-visitor.vala"
static void ctags_visitor_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
#line 992 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp7_;
	ValaList* _tmp6_;
	self = (CTagsVisitor*) base;
#line 272 "ctags-visitor.vala"
	g_return_if_fail (sig != NULL);
#line 273 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 275 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) sig));
#line 276 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) sig)), _g_free0 (entry.name), _tmp1_);
#line 277 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("signal"), _g_free0 (entry.kind_name), _tmp2_);
#line 278 "ctags-visitor.vala"
	entry.kind = 'S';
#line 279 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) sig), _g_free0 (entry.access), _tmp3_);
#line 280 "ctags-visitor.vala"
	entry.implementation = (_tmp4_ = ctags_visitor_implementation ((ValaSymbol*) sig), _g_free0 (entry.implementation), _tmp4_);
#line 281 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) sig, entry.scope, 2);
#line 282 "ctags-visitor.vala"
	entry.typeref = (_tmp5_ = vala_data_type_to_qualified_string (vala_signal_get_return_type (sig), NULL), _g_free0 (entry.typeref), _tmp5_);
#line 283 "ctags-visitor.vala"
	entry.signature = (_tmp7_ = ctags_visitor_signature (_tmp6_ = vala_signal_get_parameters (sig)), _g_free0 (entry.signature), _tmp7_);
#line 1026 "ctags-visitor.c"
	_vala_collection_object_unref0 (_tmp6_);
#line 285 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 1030 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 288 "ctags-visitor.vala"
static void ctags_visitor_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
#line 1037 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	self = (CTagsVisitor*) base;
#line 288 "ctags-visitor.vala"
	g_return_if_fail (f != NULL);
#line 289 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 291 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) f));
#line 292 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) f)), _g_free0 (entry.name), _tmp1_);
#line 293 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("field"), _g_free0 (entry.kind_name), _tmp2_);
#line 294 "ctags-visitor.vala"
	entry.kind = 'f';
#line 295 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) f), _g_free0 (entry.access), _tmp3_);
#line 296 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) f, entry.scope, 2);
#line 297 "ctags-visitor.vala"
	entry.typeref = (_tmp4_ = vala_data_type_to_qualified_string (vala_field_get_field_type (f), NULL), _g_free0 (entry.typeref), _tmp4_);
#line 299 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 1066 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 302 "ctags-visitor.vala"
static void ctags_visitor_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
#line 1073 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	self = (CTagsVisitor*) base;
#line 302 "ctags-visitor.vala"
	g_return_if_fail (c != NULL);
#line 303 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 305 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) c));
#line 306 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) c)), _g_free0 (entry.name), _tmp1_);
#line 307 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("field"), _g_free0 (entry.kind_name), _tmp2_);
#line 308 "ctags-visitor.vala"
	entry.kind = 'f';
#line 309 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) c), _g_free0 (entry.access), _tmp3_);
#line 310 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) c, entry.scope, 2);
#line 311 "ctags-visitor.vala"
	entry.typeref = (_tmp4_ = vala_data_type_to_qualified_string (vala_constant_get_type_reference (c), NULL), _g_free0 (entry.typeref), _tmp4_);
#line 313 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 1102 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 316 "ctags-visitor.vala"
static void ctags_visitor_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
#line 1109 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	self = (CTagsVisitor*) base;
#line 316 "ctags-visitor.vala"
	g_return_if_fail (prop != NULL);
#line 317 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 319 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) prop));
#line 320 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) prop)), _g_free0 (entry.name), _tmp1_);
#line 321 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("property"), _g_free0 (entry.kind_name), _tmp2_);
#line 322 "ctags-visitor.vala"
	entry.kind = 'p';
#line 323 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) prop), _g_free0 (entry.access), _tmp3_);
#line 324 "ctags-visitor.vala"
	entry.implementation = (_tmp4_ = ctags_visitor_implementation ((ValaSymbol*) prop), _g_free0 (entry.implementation), _tmp4_);
#line 325 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) prop, entry.scope, 2);
#line 326 "ctags-visitor.vala"
	entry.typeref = (_tmp5_ = vala_data_type_to_qualified_string (vala_property_get_property_type (prop), NULL), _g_free0 (entry.typeref), _tmp5_);
#line 328 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 1141 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 332 "ctags-visitor.vala"
static void ctags_visitor_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
#line 1148 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp7_;
	ValaList* _tmp6_;
	self = (CTagsVisitor*) base;
#line 332 "ctags-visitor.vala"
	g_return_if_fail (m != NULL);
#line 333 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 335 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) m));
#line 336 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) m)), _g_free0 (entry.name), _tmp1_);
#line 337 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("method"), _g_free0 (entry.kind_name), _tmp2_);
#line 338 "ctags-visitor.vala"
	entry.kind = 'm';
#line 339 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) m), _g_free0 (entry.access), _tmp3_);
#line 340 "ctags-visitor.vala"
	entry.implementation = (_tmp4_ = ctags_visitor_implementation ((ValaSymbol*) m), _g_free0 (entry.implementation), _tmp4_);
#line 341 "ctags-visitor.vala"
	ctags_visitor_scope ((ValaSymbol*) m, entry.scope, 2);
#line 342 "ctags-visitor.vala"
	entry.typeref = (_tmp5_ = vala_data_type_to_qualified_string (vala_method_get_return_type (m), NULL), _g_free0 (entry.typeref), _tmp5_);
#line 343 "ctags-visitor.vala"
	entry.signature = (_tmp7_ = ctags_visitor_signature (_tmp6_ = vala_method_get_parameters (m)), _g_free0 (entry.signature), _tmp7_);
#line 1182 "ctags-visitor.c"
	_vala_collection_object_unref0 (_tmp6_);
#line 345 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 1186 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 349 "ctags-visitor.vala"
static void ctags_visitor_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
#line 1193 "ctags-visitor.c"
	CTagsVisitor * self;
	CTagsEntry _tmp0_ = {0};
	CTagsEntry entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	self = (CTagsVisitor*) base;
#line 349 "ctags-visitor.vala"
	g_return_if_fail (local != NULL);
#line 350 "ctags-visitor.vala"
	entry = (memset (&_tmp0_, 0, sizeof (CTagsEntry)), _tmp0_);
#line 352 "ctags-visitor.vala"
	entry.line_number = vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) local));
#line 353 "ctags-visitor.vala"
	entry.name = (_tmp1_ = g_strdup (vala_symbol_get_name ((ValaSymbol*) local)), _g_free0 (entry.name), _tmp1_);
#line 354 "ctags-visitor.vala"
	entry.kind_name = (_tmp2_ = g_strdup ("local"), _g_free0 (entry.kind_name), _tmp2_);
#line 355 "ctags-visitor.vala"
	entry.kind = 'l';
#line 356 "ctags-visitor.vala"
	entry.access = (_tmp3_ = ctags_visitor_get_access ((ValaSymbol*) local), _g_free0 (entry.access), _tmp3_);
#line 358 "ctags-visitor.vala"
	self->priv->taglist = g_list_append (self->priv->taglist, _ctags_entry_dup0 (&entry));
#line 1217 "ctags-visitor.c"
	ctags_entry_destroy (&entry);
}


#line 362 "ctags-visitor.vala"
void ctags_visitor_parse_vala (CTagsVisitor* self, const char* filename, CTagsEntryMaker maker) {
#line 1224 "ctags-visitor.c"
	GList* _tmp0_;
	ValaCodeContext* context;
	DummyReport* _tmp1_;
	ValaSourceFile* source_file;
	GList* _tmp2_;
#line 362 "ctags-visitor.vala"
	g_return_if_fail (self != NULL);
#line 362 "ctags-visitor.vala"
	g_return_if_fail (filename != NULL);
#line 363 "ctags-visitor.vala"
	self->priv->taglist = (_tmp0_ = NULL, __g_list_free_ctags_entry_free0 (self->priv->taglist), _tmp0_);
#line 367 "ctags-visitor.vala"
	context = vala_code_context_new ();
#line 368 "ctags-visitor.vala"
	vala_code_context_set_report (context, (ValaReport*) (_tmp1_ = dummy_report_new ()));
#line 1240 "ctags-visitor.c"
	_g_object_unref0 (_tmp1_);
#line 369 "ctags-visitor.vala"
	source_file = vala_source_file_new (context, filename, g_str_has_suffix (filename, "vapi"), NULL);
#line 371 "ctags-visitor.vala"
	vala_code_context_push (context);
#line 372 "ctags-visitor.vala"
	vala_code_context_add_source_file (context, source_file);
#line 373 "ctags-visitor.vala"
	vala_parser_parse (self->priv->vala_parser, context);
#line 374 "ctags-visitor.vala"
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
#line 1252 "ctags-visitor.c"
	{
		GList* tagentry_collection;
		GList* tagentry_it;
#line 375 "ctags-visitor.vala"
		tagentry_collection = self->priv->taglist;
#line 1258 "ctags-visitor.c"
		for (tagentry_it = tagentry_collection; tagentry_it != NULL; tagentry_it = tagentry_it->next) {
			CTagsEntry* tagentry;
#line 375 "ctags-visitor.vala"
			tagentry = _ctags_entry_dup0 ((CTagsEntry*) tagentry_it->data);
#line 1263 "ctags-visitor.c"
			{
#line 376 "ctags-visitor.vala"
				maker (tagentry);
#line 1267 "ctags-visitor.c"
				_ctags_entry_free0 (tagentry);
			}
		}
	}
#line 378 "ctags-visitor.vala"
	self->priv->taglist = (_tmp2_ = NULL, __g_list_free_ctags_entry_free0 (self->priv->taglist), _tmp2_);
#line 379 "ctags-visitor.vala"
	vala_code_context_pop ();
#line 1276 "ctags-visitor.c"
	_vala_code_context_unref0 (context);
	_vala_source_file_unref0 (source_file);
}


#line 381 "ctags-visitor.vala"
void ctags_visitor_parse_genie (CTagsVisitor* self, const char* filename, CTagsEntryMaker maker) {
#line 1284 "ctags-visitor.c"
	GList* _tmp0_;
	ValaCodeContext* context;
	DummyReport* _tmp1_;
	ValaSourceFile* source_file;
	GList* _tmp2_;
#line 381 "ctags-visitor.vala"
	g_return_if_fail (self != NULL);
#line 381 "ctags-visitor.vala"
	g_return_if_fail (filename != NULL);
#line 382 "ctags-visitor.vala"
	self->priv->taglist = (_tmp0_ = NULL, __g_list_free_ctags_entry_free0 (self->priv->taglist), _tmp0_);
#line 383 "ctags-visitor.vala"
	context = vala_code_context_new ();
#line 384 "ctags-visitor.vala"
	vala_code_context_set_report (context, (ValaReport*) (_tmp1_ = dummy_report_new ()));
#line 1300 "ctags-visitor.c"
	_g_object_unref0 (_tmp1_);
#line 385 "ctags-visitor.vala"
	source_file = vala_source_file_new (context, filename, FALSE, NULL);
#line 386 "ctags-visitor.vala"
	vala_code_context_add_source_file (context, source_file);
#line 388 "ctags-visitor.vala"
	vala_code_context_push (context);
#line 389 "ctags-visitor.vala"
	vala_genie_parser_parse (self->priv->genie_parser, context);
#line 390 "ctags-visitor.vala"
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
#line 1312 "ctags-visitor.c"
	{
		GList* tagentry_collection;
		GList* tagentry_it;
#line 391 "ctags-visitor.vala"
		tagentry_collection = self->priv->taglist;
#line 1318 "ctags-visitor.c"
		for (tagentry_it = tagentry_collection; tagentry_it != NULL; tagentry_it = tagentry_it->next) {
			CTagsEntry* tagentry;
#line 391 "ctags-visitor.vala"
			tagentry = _ctags_entry_dup0 ((CTagsEntry*) tagentry_it->data);
#line 1323 "ctags-visitor.c"
			{
#line 392 "ctags-visitor.vala"
				maker (tagentry);
#line 1327 "ctags-visitor.c"
				_ctags_entry_free0 (tagentry);
			}
		}
	}
#line 394 "ctags-visitor.vala"
	self->priv->taglist = (_tmp2_ = NULL, __g_list_free_ctags_entry_free0 (self->priv->taglist), _tmp2_);
#line 395 "ctags-visitor.vala"
	vala_code_context_pop ();
#line 1336 "ctags-visitor.c"
	_vala_code_context_unref0 (context);
	_vala_source_file_unref0 (source_file);
}


static void ctags_visitor_class_init (CTagsVisitorClass * klass) {
	ctags_visitor_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = ctags_visitor_finalize;
	g_type_class_add_private (klass, sizeof (CTagsVisitorPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = ctags_visitor_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = ctags_visitor_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = ctags_visitor_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = ctags_visitor_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = ctags_visitor_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = ctags_visitor_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = ctags_visitor_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_code = ctags_visitor_real_visit_error_code;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = ctags_visitor_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = ctags_visitor_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = ctags_visitor_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = ctags_visitor_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = ctags_visitor_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = ctags_visitor_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = ctags_visitor_real_visit_local_variable;
}


static void ctags_visitor_instance_init (CTagsVisitor * self) {
	self->priv = CTAGS_VISITOR_GET_PRIVATE (self);
}


static void ctags_visitor_finalize (ValaCodeVisitor* obj) {
	CTagsVisitor * self;
	self = CTAGS_VISITOR (obj);
	_vala_code_visitor_unref0 (self->priv->vala_parser);
	_vala_code_visitor_unref0 (self->priv->genie_parser);
	__g_list_free_ctags_entry_free0 (self->priv->taglist);
	VALA_CODE_VISITOR_CLASS (ctags_visitor_parent_class)->finalize (obj);
}


GType ctags_visitor_get_type (void) {
	static GType ctags_visitor_type_id = 0;
	if (ctags_visitor_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (CTagsVisitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ctags_visitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CTagsVisitor), 0, (GInstanceInitFunc) ctags_visitor_instance_init, NULL };
		ctags_visitor_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "CTagsVisitor", &g_define_type_info, 0);
	}
	return ctags_visitor_type_id;
}




