/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-instruction.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
* SECTION:ianjuta-debugger-instruction
* @title: IAnjutaDebuggerInstruction
* @short_description: Debugger interface for machine instruction
* @see_also: 
* @stability: Unstable
* @include: libanjuta/interfaces/ianjuta-debugger-instruction.h
* 
 	* This interface is used to debuger as machine instruction level.
*/

#include "ianjuta-debugger-instruction.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debugger_instruction_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debugger-instruction-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_instruction_disassemble:
* @obj: Self
* @address: Start address of the memory block
* @length: Length of memory block
* @callback: Call back with a IAnjutaDebuggerInstructionDisassembly as argument
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
* 
* Disassemble a part of the memory
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_instruction_disassemble (IAnjutaDebuggerInstruction *obj, gulong address,   guint length,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_INSTRUCTION(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_INSTRUCTION_GET_IFACE (obj)->disassemble (obj, address, length, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_instruction_disassemble_default (IAnjutaDebuggerInstruction *obj, gulong address,   guint length,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_instruction_run_from_address:
* @obj: Self
* @address: Run from this addresss
* @err: Error propagation and reporting.
* 
* Restart the program starting from address address
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_instruction_run_from_address (IAnjutaDebuggerInstruction *obj, gulong address, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_INSTRUCTION(obj), FALSE);
	return IANJUTA_DEBUGGER_INSTRUCTION_GET_IFACE (obj)->run_from_address (obj, address, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_instruction_run_from_address_default (IAnjutaDebuggerInstruction *obj, gulong address, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_instruction_run_to_address:
* @obj: Self
* @address: Run to this addresss
* @err: Error propagation and reporting.
* 
* Start the program until it reachs the address address
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_instruction_run_to_address (IAnjutaDebuggerInstruction *obj, gulong address, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_INSTRUCTION(obj), FALSE);
	return IANJUTA_DEBUGGER_INSTRUCTION_GET_IFACE (obj)->run_to_address (obj, address, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_instruction_run_to_address_default (IAnjutaDebuggerInstruction *obj, gulong address, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_instruction_step_in_instruction:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Execute one assembler instruction in the program.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_instruction_step_in_instruction (IAnjutaDebuggerInstruction *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_INSTRUCTION(obj), FALSE);
	return IANJUTA_DEBUGGER_INSTRUCTION_GET_IFACE (obj)->step_in_instruction (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_instruction_step_in_instruction_default (IAnjutaDebuggerInstruction *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_instruction_step_over_instruction:
* @obj: Self
* @err: Error propagation and reporting.
* 
* Execute one assembler instruction in the program, if the instruction
* is a function call, continues until the function returns.
*
* Returns: TRUE if the request succeed and the callback is called. If 
* FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_instruction_step_over_instruction (IAnjutaDebuggerInstruction *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_INSTRUCTION(obj), FALSE);
	return IANJUTA_DEBUGGER_INSTRUCTION_GET_IFACE (obj)->step_over_instruction (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_instruction_step_over_instruction_default (IAnjutaDebuggerInstruction *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_debugger_instruction_base_init (IAnjutaDebuggerInstructionIface* klass)
{
	static gboolean initialized = FALSE;

	klass->disassemble = ianjuta_debugger_instruction_disassemble_default;
	klass->run_from_address = ianjuta_debugger_instruction_run_from_address_default;
	klass->run_to_address = ianjuta_debugger_instruction_run_to_address_default;
	klass->step_in_instruction = ianjuta_debugger_instruction_step_in_instruction_default;
	klass->step_over_instruction = ianjuta_debugger_instruction_step_over_instruction_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_debugger_instruction_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebuggerInstructionIface),
			(GBaseInitFunc) ianjuta_debugger_instruction_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebuggerInstruction", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_DEBUGGER);
	}
	return type;			
}
