#include <stdio.h>
#include <sys/uio.h>
#include "IIOP.h"
#include "giop-msg-buffer.h"
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

int main(int argc, char *argv[])
{
	GIOPMessageBuffer *b;
	#define request_buffer b
	GIOPConnection *c;
	gchar *astring = "Hiho, hello world\n";
	gushort portnum = 9999;
	char *buf = g_malloc(2048);

	if(argc > 1)
		portnum = (gushort)atoi(argv[1]);

	giop_init();

	c = GIOP_CONNECTION(iiop_connection_get("localhost", portnum));

	g_return_val_if_fail(c != NULL, 1);

	b = giop_request_buffer_use(c, NULL, giop_get_request_id(), TRUE,
				    NULL, "hello", NULL);

	ENCODER_CALL(CORBA_string, astring);

	g_print("message is %p, first item is %p, string is %p[%d]\n",
		b->message, ((struct iovec *)b->iovecs->data)[0].iov_base,
		astring, strlen(astring));

	giop_request_buffer_dump(b);
	giop_request_buffer_write(b);

	sleep(2);

	fcntl(GIOP_CONNECTION_GET_FD(c), F_SETFL, O_NONBLOCK);
	read(GIOP_CONNECTION_GET_FD(c), buf, 2048);

	return 0;
}
