#ifndef IIOP_ENDIAN_H
#define IIOP_ENDIAN_H 1

#include <glib.h>

/* This is also defined in IIOP-types.c */
G_INLINE_FUNC void iiop_byteswap(guchar *outdata,
				 const guchar *data,
				 gulong datalen)
#ifdef G_CAN_INLINE
{
  const guchar *source_ptr = data;
  guchar *dest_ptr = outdata + datalen - 1;
  while(dest_ptr >= outdata)
    *dest_ptr-- = *source_ptr++;
}
#else
;
#endif

#endif
