#include <stdio.h>
#include "interface_repository.h"

/*** App-specific servant structures ***/

typedef struct {
	POA_CORBA_Repository servant;
	PortableServer_POA poa;

	CORBA_DefinitionKind attr_def_kind;
	GHashTable *id_hash;
} impl_POA_CORBA_Repository;

typedef struct {
	POA_CORBA_ModuleDef servant;
	PortableServer_POA poa;
	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
} impl_POA_CORBA_ModuleDef;

typedef struct {
	POA_CORBA_ConstantDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_type;

	CORBA_IDLType attr_type_def;

	CORBA_any attr_value;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
} impl_POA_CORBA_ConstantDef;

typedef struct {
	POA_CORBA_StructDef servant;
	PortableServer_POA poa;
	CORBA_StructMemberSeq attr_members;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_StructDef;

typedef struct {
	POA_CORBA_UnionDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_discriminator_type;

	CORBA_IDLType attr_discriminator_type_def;

	CORBA_UnionMemberSeq attr_members;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_UnionDef;

typedef struct {
	POA_CORBA_EnumDef servant;
	PortableServer_POA poa;
	CORBA_EnumMemberSeq attr_members;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_EnumDef;

typedef struct {
	POA_CORBA_AliasDef servant;
	PortableServer_POA poa;
	CORBA_IDLType attr_original_type_def;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_AliasDef;

typedef struct {
	POA_CORBA_PrimitiveDef servant;
	PortableServer_POA poa;
	CORBA_PrimitiveKind attr_kind;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_PrimitiveDef;

typedef struct {
	POA_CORBA_StringDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_bound;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_StringDef;

typedef struct {
	POA_CORBA_WstringDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_bound;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_WstringDef;

typedef struct {
	POA_CORBA_FixedDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_short attr_digits;

	CORBA_short attr_scale;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_FixedDef;

typedef struct {
	POA_CORBA_SequenceDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_bound;

	CORBA_TypeCode attr_element_type;

	CORBA_IDLType attr_element_type_def;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_SequenceDef;

typedef struct {
	POA_CORBA_ArrayDef servant;
	PortableServer_POA poa;
	CORBA_unsigned_long attr_length;

	CORBA_TypeCode attr_element_type;

	CORBA_IDLType attr_element_type_def;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_ArrayDef;

typedef struct {
	POA_CORBA_ExceptionDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_type;

	CORBA_StructMemberSeq attr_members;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
} impl_POA_CORBA_ExceptionDef;

typedef struct {
	POA_CORBA_AttributeDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_type;

	CORBA_IDLType attr_type_def;

	CORBA_AttributeMode attr_mode;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
} impl_POA_CORBA_AttributeDef;

typedef struct {
	POA_CORBA_OperationDef servant;
	PortableServer_POA poa;
	CORBA_TypeCode attr_result;

	CORBA_IDLType attr_result_def;

	CORBA_ParDescriptionSeq attr_params;

	CORBA_OperationMode attr_mode;

	CORBA_ContextIdSeq attr_contexts;

	CORBA_ExceptionDefSeq attr_exceptions;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
} impl_POA_CORBA_OperationDef;

typedef struct {
	POA_CORBA_InterfaceDef servant;
	PortableServer_POA poa;
	CORBA_InterfaceDefSeq attr_base_interfaces;

	CORBA_DefinitionKind attr_def_kind;
	CORBA_RepositoryId attr_id;
	CORBA_Identifier attr_name;
	CORBA_VersionSpec attr_version;
	CORBA_Container attr_defined_in;
	CORBA_ScopedName attr_absolute_name;
	CORBA_Repository attr_containing_repository;
	CORBA_TypeCode attr_type;
} impl_POA_CORBA_InterfaceDef;

/*** Implementation stub prototypes ***/

static void impl_CORBA_Repository__destroy(impl_POA_CORBA_Repository * servant,
					   CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_Repository_lookup_id(impl_POA_CORBA_Repository * servant,
				CORBA_RepositoryId search_id,
				CORBA_Environment * ev);

CORBA_PrimitiveDef
impl_CORBA_Repository_get_primitive(impl_POA_CORBA_Repository * servant,
				    CORBA_PrimitiveKind kind,
				    CORBA_Environment * ev);

CORBA_StringDef
impl_CORBA_Repository_create_string(impl_POA_CORBA_Repository * servant,
				    CORBA_unsigned_long bound,
				    CORBA_Environment * ev);

CORBA_WstringDef
impl_CORBA_Repository_create_wstring(impl_POA_CORBA_Repository * servant,
				     CORBA_unsigned_long bound,
				     CORBA_Environment * ev);

CORBA_SequenceDef
impl_CORBA_Repository_create_sequence(impl_POA_CORBA_Repository * servant,
				      CORBA_unsigned_long bound,
				      CORBA_IDLType element_type,
				      CORBA_Environment * ev);

CORBA_ArrayDef
impl_CORBA_Repository_create_array(impl_POA_CORBA_Repository * servant,
				   CORBA_unsigned_long length,
				   CORBA_IDLType element_type,
				   CORBA_Environment * ev);

CORBA_FixedDef
impl_CORBA_Repository_create_fixed(impl_POA_CORBA_Repository * servant,
				   CORBA_unsigned_short digits,
				   CORBA_short scale,
				   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_Repository__get_def_kind(impl_POA_CORBA_Repository * servant,
				    CORBA_Environment * ev);
void
 impl_CORBA_Repository_destroy(impl_POA_CORBA_Repository * servant,
			       CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_Repository_lookup(impl_POA_CORBA_Repository * servant,
			     CORBA_ScopedName search_name,
			     CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_Repository_contents(impl_POA_CORBA_Repository * servant,
				CORBA_DefinitionKind limit_type,
				CORBA_boolean exclude_inherited,
				CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_Repository_lookup_name(impl_POA_CORBA_Repository * servant,
				   CORBA_Identifier search_name,
				   CORBA_long levels_to_search,
				   CORBA_DefinitionKind limit_type,
				   CORBA_boolean exclude_inherited,
				   CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_Repository_describe_contents(impl_POA_CORBA_Repository * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					 CORBA_long max_returned_objs,
					 CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_Repository_create_module(impl_POA_CORBA_Repository * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_Repository_create_constant(impl_POA_CORBA_Repository * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_IDLType type,
				      CORBA_any * value,
				      CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_Repository_create_struct(impl_POA_CORBA_Repository * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_StructMemberSeq * members,
				    CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_Repository_create_union(impl_POA_CORBA_Repository * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_IDLType discriminator_type,
				   CORBA_UnionMemberSeq * members,
				   CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_Repository_create_enum(impl_POA_CORBA_Repository * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_EnumMemberSeq * members,
				  CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_Repository_create_alias(impl_POA_CORBA_Repository * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_IDLType original_type,
				   CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_Repository_create_interface(impl_POA_CORBA_Repository * servant,
				       CORBA_RepositoryId id,
				       CORBA_Identifier name,
				       CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				       CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_Repository_create_exception(impl_POA_CORBA_Repository * servant,
				       CORBA_RepositoryId id,
				       CORBA_Identifier name,
				       CORBA_VersionSpec version,
				       CORBA_StructMemberSeq * members,
				       CORBA_Environment * ev);

static void impl_CORBA_ModuleDef__destroy(impl_POA_CORBA_ModuleDef * servant,
					  CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_ModuleDef__get_def_kind(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef_destroy(impl_POA_CORBA_ModuleDef * servant,
			      CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_ModuleDef_lookup(impl_POA_CORBA_ModuleDef * servant,
			    CORBA_ScopedName search_name,
			    CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_ModuleDef_contents(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_DefinitionKind limit_type,
			       CORBA_boolean exclude_inherited,
			       CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_ModuleDef_lookup_name(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Identifier search_name,
				  CORBA_long levels_to_search,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_ModuleDef_describe_contents(impl_POA_CORBA_ModuleDef * servant,
					CORBA_DefinitionKind limit_type,
					CORBA_boolean exclude_inherited,
					CORBA_long max_returned_objs,
					CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_ModuleDef_create_module(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_ModuleDef_create_constant(impl_POA_CORBA_ModuleDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType type,
				     CORBA_any * value,
				     CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_ModuleDef_create_struct(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_StructMemberSeq * members,
				   CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_ModuleDef_create_union(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType discriminator_type,
				  CORBA_UnionMemberSeq * members,
				  CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_ModuleDef_create_enum(impl_POA_CORBA_ModuleDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_EnumMemberSeq * members,
				 CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_ModuleDef_create_alias(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType original_type,
				  CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_ModuleDef_create_interface(impl_POA_CORBA_ModuleDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				      CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_ModuleDef_create_exception(impl_POA_CORBA_ModuleDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev);
CORBA_RepositoryId
impl_CORBA_ModuleDef__get_id(impl_POA_CORBA_ModuleDef * servant,
			     CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef__set_id(impl_POA_CORBA_ModuleDef * servant,
			      CORBA_RepositoryId value,
			      CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_ModuleDef__get_name(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef__set_name(impl_POA_CORBA_ModuleDef * servant,
				CORBA_Identifier value,
				CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_ModuleDef__get_version(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef__set_version(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_VersionSpec value,
				   CORBA_Environment * ev);

CORBA_Container
impl_CORBA_ModuleDef__get_defined_in(impl_POA_CORBA_ModuleDef * servant,
				     CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_ModuleDef__get_absolute_name(impl_POA_CORBA_ModuleDef * servant,
					CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_ModuleDef__get_containing_repository(impl_POA_CORBA_ModuleDef * servant,
						CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_ModuleDef_describe(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_ModuleDef_move(impl_POA_CORBA_ModuleDef * servant,
			   CORBA_Container new_container,
			   CORBA_Identifier new_name,
			   CORBA_VersionSpec new_version,
			   CORBA_Environment * ev);

static void impl_CORBA_ConstantDef__destroy(impl_POA_CORBA_ConstantDef * servant,
					    CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_ConstantDef__get_type(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_ConstantDef__get_type_def(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_type_def(impl_POA_CORBA_ConstantDef * servant,
				      CORBA_IDLType value,
				      CORBA_Environment * ev);

CORBA_any *
 impl_CORBA_ConstantDef__get_value(impl_POA_CORBA_ConstantDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_value(impl_POA_CORBA_ConstantDef * servant,
				   CORBA_any * value,
				   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_ConstantDef__get_def_kind(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef_destroy(impl_POA_CORBA_ConstantDef * servant,
				CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_ConstantDef__get_id(impl_POA_CORBA_ConstantDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_id(impl_POA_CORBA_ConstantDef * servant,
				CORBA_RepositoryId value,
				CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_ConstantDef__get_name(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_name(impl_POA_CORBA_ConstantDef * servant,
				  CORBA_Identifier value,
				  CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_ConstantDef__get_version(impl_POA_CORBA_ConstantDef * servant,
				    CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef__set_version(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_VersionSpec value,
				     CORBA_Environment * ev);

CORBA_Container
impl_CORBA_ConstantDef__get_defined_in(impl_POA_CORBA_ConstantDef * servant,
				       CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_ConstantDef__get_absolute_name(impl_POA_CORBA_ConstantDef * servant,
					  CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_ConstantDef__get_containing_repository(impl_POA_CORBA_ConstantDef * servant,
						  CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_ConstantDef_describe(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_ConstantDef_move(impl_POA_CORBA_ConstantDef * servant,
			     CORBA_Container new_container,
			     CORBA_Identifier new_name,
			     CORBA_VersionSpec new_version,
			     CORBA_Environment * ev);

static void impl_CORBA_StructDef__destroy(impl_POA_CORBA_StructDef * servant,
					  CORBA_Environment * ev);
CORBA_StructMemberSeq *
 impl_CORBA_StructDef__get_members(impl_POA_CORBA_StructDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_StructDef__set_members(impl_POA_CORBA_StructDef * servant,
				   CORBA_StructMemberSeq * value,
				   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_StructDef__get_def_kind(impl_POA_CORBA_StructDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_StructDef_destroy(impl_POA_CORBA_StructDef * servant,
			      CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_StructDef__get_id(impl_POA_CORBA_StructDef * servant,
			     CORBA_Environment * ev);
void
 impl_CORBA_StructDef__set_id(impl_POA_CORBA_StructDef * servant,
			      CORBA_RepositoryId value,
			      CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_StructDef__get_name(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_StructDef__set_name(impl_POA_CORBA_StructDef * servant,
				CORBA_Identifier value,
				CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_StructDef__get_version(impl_POA_CORBA_StructDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_StructDef__set_version(impl_POA_CORBA_StructDef * servant,
				   CORBA_VersionSpec value,
				   CORBA_Environment * ev);

CORBA_Container
impl_CORBA_StructDef__get_defined_in(impl_POA_CORBA_StructDef * servant,
				     CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_StructDef__get_absolute_name(impl_POA_CORBA_StructDef * servant,
					CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_StructDef__get_containing_repository(impl_POA_CORBA_StructDef * servant,
						CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_StructDef_describe(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_StructDef_move(impl_POA_CORBA_StructDef * servant,
			   CORBA_Container new_container,
			   CORBA_Identifier new_name,
			   CORBA_VersionSpec new_version,
			   CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_StructDef__get_type(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev);
CORBA_Contained
impl_CORBA_StructDef_lookup(impl_POA_CORBA_StructDef * servant,
			    CORBA_ScopedName search_name,
			    CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_StructDef_contents(impl_POA_CORBA_StructDef * servant,
			       CORBA_DefinitionKind limit_type,
			       CORBA_boolean exclude_inherited,
			       CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_StructDef_lookup_name(impl_POA_CORBA_StructDef * servant,
				  CORBA_Identifier search_name,
				  CORBA_long levels_to_search,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_StructDef_describe_contents(impl_POA_CORBA_StructDef * servant,
					CORBA_DefinitionKind limit_type,
					CORBA_boolean exclude_inherited,
					CORBA_long max_returned_objs,
					CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_StructDef_create_module(impl_POA_CORBA_StructDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_StructDef_create_constant(impl_POA_CORBA_StructDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType type,
				     CORBA_any * value,
				     CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_StructDef_create_struct(impl_POA_CORBA_StructDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_StructMemberSeq * members,
				   CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_StructDef_create_union(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType discriminator_type,
				  CORBA_UnionMemberSeq * members,
				  CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_StructDef_create_enum(impl_POA_CORBA_StructDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_EnumMemberSeq * members,
				 CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_StructDef_create_alias(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType original_type,
				  CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_StructDef_create_interface(impl_POA_CORBA_StructDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				      CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_StructDef_create_exception(impl_POA_CORBA_StructDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev);

static void impl_CORBA_UnionDef__destroy(impl_POA_CORBA_UnionDef * servant,
					 CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_UnionDef__get_discriminator_type(impl_POA_CORBA_UnionDef * servant,
					    CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_UnionDef__get_discriminator_type_def(impl_POA_CORBA_UnionDef * servant,
						CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_discriminator_type_def(impl_POA_CORBA_UnionDef * servant,
						 CORBA_IDLType value,
						 CORBA_Environment * ev);

CORBA_UnionMemberSeq *
 impl_CORBA_UnionDef__get_members(impl_POA_CORBA_UnionDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_members(impl_POA_CORBA_UnionDef * servant,
				  CORBA_UnionMemberSeq * value,
				  CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_UnionDef__get_def_kind(impl_POA_CORBA_UnionDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_UnionDef_destroy(impl_POA_CORBA_UnionDef * servant,
			     CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_UnionDef__get_id(impl_POA_CORBA_UnionDef * servant,
			    CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_id(impl_POA_CORBA_UnionDef * servant,
			     CORBA_RepositoryId value,
			     CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_UnionDef__get_name(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_name(impl_POA_CORBA_UnionDef * servant,
			       CORBA_Identifier value,
			       CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_UnionDef__get_version(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_UnionDef__set_version(impl_POA_CORBA_UnionDef * servant,
				  CORBA_VersionSpec value,
				  CORBA_Environment * ev);

CORBA_Container
impl_CORBA_UnionDef__get_defined_in(impl_POA_CORBA_UnionDef * servant,
				    CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_UnionDef__get_absolute_name(impl_POA_CORBA_UnionDef * servant,
				       CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_UnionDef__get_containing_repository(impl_POA_CORBA_UnionDef * servant,
					       CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_UnionDef_describe(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_UnionDef_move(impl_POA_CORBA_UnionDef * servant,
			  CORBA_Container new_container,
			  CORBA_Identifier new_name,
			  CORBA_VersionSpec new_version,
			  CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_UnionDef__get_type(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev);
CORBA_Contained
impl_CORBA_UnionDef_lookup(impl_POA_CORBA_UnionDef * servant,
			   CORBA_ScopedName search_name,
			   CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_UnionDef_contents(impl_POA_CORBA_UnionDef * servant,
			      CORBA_DefinitionKind limit_type,
			      CORBA_boolean exclude_inherited,
			      CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_UnionDef_lookup_name(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Identifier search_name,
				 CORBA_long levels_to_search,
				 CORBA_DefinitionKind limit_type,
				 CORBA_boolean exclude_inherited,
				 CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_UnionDef_describe_contents(impl_POA_CORBA_UnionDef * servant,
				       CORBA_DefinitionKind limit_type,
				       CORBA_boolean exclude_inherited,
				       CORBA_long max_returned_objs,
				       CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_UnionDef_create_module(impl_POA_CORBA_UnionDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_UnionDef_create_constant(impl_POA_CORBA_UnionDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_IDLType type,
				    CORBA_any * value,
				    CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_UnionDef_create_struct(impl_POA_CORBA_UnionDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_StructMemberSeq * members,
				  CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_UnionDef_create_union(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_IDLType discriminator_type,
				 CORBA_UnionMemberSeq * members,
				 CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_UnionDef_create_enum(impl_POA_CORBA_UnionDef * servant,
				CORBA_RepositoryId id,
				CORBA_Identifier name,
				CORBA_VersionSpec version,
				CORBA_EnumMemberSeq * members,
				CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_UnionDef_create_alias(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_IDLType original_type,
				 CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_UnionDef_create_interface(impl_POA_CORBA_UnionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				     CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_UnionDef_create_exception(impl_POA_CORBA_UnionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_StructMemberSeq * members,
				     CORBA_Environment * ev);

static void impl_CORBA_EnumDef__destroy(impl_POA_CORBA_EnumDef * servant,
					CORBA_Environment * ev);
CORBA_EnumMemberSeq *
 impl_CORBA_EnumDef__get_members(impl_POA_CORBA_EnumDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_EnumDef__set_members(impl_POA_CORBA_EnumDef * servant,
				 CORBA_EnumMemberSeq * value,
				 CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_EnumDef__get_def_kind(impl_POA_CORBA_EnumDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_EnumDef_destroy(impl_POA_CORBA_EnumDef * servant,
			    CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_EnumDef__get_id(impl_POA_CORBA_EnumDef * servant,
			   CORBA_Environment * ev);
void
 impl_CORBA_EnumDef__set_id(impl_POA_CORBA_EnumDef * servant,
			    CORBA_RepositoryId value,
			    CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_EnumDef__get_name(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev);
void
 impl_CORBA_EnumDef__set_name(impl_POA_CORBA_EnumDef * servant,
			      CORBA_Identifier value,
			      CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_EnumDef__get_version(impl_POA_CORBA_EnumDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_EnumDef__set_version(impl_POA_CORBA_EnumDef * servant,
				 CORBA_VersionSpec value,
				 CORBA_Environment * ev);

CORBA_Container
impl_CORBA_EnumDef__get_defined_in(impl_POA_CORBA_EnumDef * servant,
				   CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_EnumDef__get_absolute_name(impl_POA_CORBA_EnumDef * servant,
				      CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_EnumDef__get_containing_repository(impl_POA_CORBA_EnumDef * servant,
					      CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_EnumDef_describe(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev);
void
 impl_CORBA_EnumDef_move(impl_POA_CORBA_EnumDef * servant,
			 CORBA_Container new_container,
			 CORBA_Identifier new_name,
			 CORBA_VersionSpec new_version,
			 CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_EnumDef__get_type(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev);

static void impl_CORBA_AliasDef__destroy(impl_POA_CORBA_AliasDef * servant,
					 CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_AliasDef__get_original_type_def(impl_POA_CORBA_AliasDef * servant,
					   CORBA_Environment * ev);
void
 impl_CORBA_AliasDef__set_original_type_def(impl_POA_CORBA_AliasDef * servant,
					    CORBA_IDLType value,
					    CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_AliasDef__get_def_kind(impl_POA_CORBA_AliasDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_AliasDef_destroy(impl_POA_CORBA_AliasDef * servant,
			     CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_AliasDef__get_id(impl_POA_CORBA_AliasDef * servant,
			    CORBA_Environment * ev);
void
 impl_CORBA_AliasDef__set_id(impl_POA_CORBA_AliasDef * servant,
			     CORBA_RepositoryId value,
			     CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_AliasDef__get_name(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_AliasDef__set_name(impl_POA_CORBA_AliasDef * servant,
			       CORBA_Identifier value,
			       CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_AliasDef__get_version(impl_POA_CORBA_AliasDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_AliasDef__set_version(impl_POA_CORBA_AliasDef * servant,
				  CORBA_VersionSpec value,
				  CORBA_Environment * ev);

CORBA_Container
impl_CORBA_AliasDef__get_defined_in(impl_POA_CORBA_AliasDef * servant,
				    CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_AliasDef__get_absolute_name(impl_POA_CORBA_AliasDef * servant,
				       CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_AliasDef__get_containing_repository(impl_POA_CORBA_AliasDef * servant,
					       CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_AliasDef_describe(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev);
void
 impl_CORBA_AliasDef_move(impl_POA_CORBA_AliasDef * servant,
			  CORBA_Container new_container,
			  CORBA_Identifier new_name,
			  CORBA_VersionSpec new_version,
			  CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_AliasDef__get_type(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev);

static void impl_CORBA_PrimitiveDef__destroy(impl_POA_CORBA_PrimitiveDef * servant,
					     CORBA_Environment * ev);

CORBA_PrimitiveKind
impl_CORBA_PrimitiveDef__get_kind(impl_POA_CORBA_PrimitiveDef * servant,
				  CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_PrimitiveDef__get_def_kind(impl_POA_CORBA_PrimitiveDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_PrimitiveDef_destroy(impl_POA_CORBA_PrimitiveDef * servant,
				 CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_PrimitiveDef__get_type(impl_POA_CORBA_PrimitiveDef * servant,
				  CORBA_Environment * ev);

static void impl_CORBA_StringDef__destroy(impl_POA_CORBA_StringDef * servant,
					  CORBA_Environment * ev);

CORBA_unsigned_long
impl_CORBA_StringDef__get_bound(impl_POA_CORBA_StringDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_StringDef__set_bound(impl_POA_CORBA_StringDef * servant,
				 CORBA_unsigned_long value,
				 CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_StringDef__get_def_kind(impl_POA_CORBA_StringDef * servant,
				   CORBA_Environment * ev);
void
 impl_CORBA_StringDef_destroy(impl_POA_CORBA_StringDef * servant,
			      CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_StringDef__get_type(impl_POA_CORBA_StringDef * servant,
			       CORBA_Environment * ev);

static void impl_CORBA_WstringDef__destroy(impl_POA_CORBA_WstringDef * servant,
					   CORBA_Environment * ev);

CORBA_unsigned_long
impl_CORBA_WstringDef__get_bound(impl_POA_CORBA_WstringDef * servant,
				 CORBA_Environment * ev);
void
 impl_CORBA_WstringDef__set_bound(impl_POA_CORBA_WstringDef * servant,
				  CORBA_unsigned_long value,
				  CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_WstringDef__get_def_kind(impl_POA_CORBA_WstringDef * servant,
				    CORBA_Environment * ev);
void
 impl_CORBA_WstringDef_destroy(impl_POA_CORBA_WstringDef * servant,
			       CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_WstringDef__get_type(impl_POA_CORBA_WstringDef * servant,
				CORBA_Environment * ev);

static void impl_CORBA_FixedDef__destroy(impl_POA_CORBA_FixedDef * servant,
					 CORBA_Environment * ev);

CORBA_unsigned_short
impl_CORBA_FixedDef__get_digits(impl_POA_CORBA_FixedDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_FixedDef__set_digits(impl_POA_CORBA_FixedDef * servant,
				 CORBA_unsigned_short value,
				 CORBA_Environment * ev);

CORBA_short
impl_CORBA_FixedDef__get_scale(impl_POA_CORBA_FixedDef * servant,
			       CORBA_Environment * ev);
void
 impl_CORBA_FixedDef__set_scale(impl_POA_CORBA_FixedDef * servant,
				CORBA_short value,
				CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_FixedDef__get_def_kind(impl_POA_CORBA_FixedDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_FixedDef_destroy(impl_POA_CORBA_FixedDef * servant,
			     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_FixedDef__get_type(impl_POA_CORBA_FixedDef * servant,
			      CORBA_Environment * ev);

static void impl_CORBA_SequenceDef__destroy(impl_POA_CORBA_SequenceDef * servant,
					    CORBA_Environment * ev);

CORBA_unsigned_long
impl_CORBA_SequenceDef__get_bound(impl_POA_CORBA_SequenceDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_SequenceDef__set_bound(impl_POA_CORBA_SequenceDef * servant,
				   CORBA_unsigned_long value,
				   CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_SequenceDef__get_element_type(impl_POA_CORBA_SequenceDef * servant,
					 CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_SequenceDef__get_element_type_def(impl_POA_CORBA_SequenceDef * servant,
					     CORBA_Environment * ev);
void
 impl_CORBA_SequenceDef__set_element_type_def(impl_POA_CORBA_SequenceDef * servant,
					      CORBA_IDLType value,
					      CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_SequenceDef__get_def_kind(impl_POA_CORBA_SequenceDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_SequenceDef_destroy(impl_POA_CORBA_SequenceDef * servant,
				CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_SequenceDef__get_type(impl_POA_CORBA_SequenceDef * servant,
				 CORBA_Environment * ev);

static void impl_CORBA_ArrayDef__destroy(impl_POA_CORBA_ArrayDef * servant,
					 CORBA_Environment * ev);

CORBA_unsigned_long
impl_CORBA_ArrayDef__get_length(impl_POA_CORBA_ArrayDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_ArrayDef__set_length(impl_POA_CORBA_ArrayDef * servant,
				 CORBA_unsigned_long value,
				 CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_ArrayDef__get_element_type(impl_POA_CORBA_ArrayDef * servant,
				      CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_ArrayDef__get_element_type_def(impl_POA_CORBA_ArrayDef * servant,
					  CORBA_Environment * ev);
void
 impl_CORBA_ArrayDef__set_element_type_def(impl_POA_CORBA_ArrayDef * servant,
					   CORBA_IDLType value,
					   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_ArrayDef__get_def_kind(impl_POA_CORBA_ArrayDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_ArrayDef_destroy(impl_POA_CORBA_ArrayDef * servant,
			     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_ArrayDef__get_type(impl_POA_CORBA_ArrayDef * servant,
			      CORBA_Environment * ev);

static void impl_CORBA_ExceptionDef__destroy(impl_POA_CORBA_ExceptionDef * servant,
					     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_ExceptionDef__get_type(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev);

CORBA_StructMemberSeq *
 impl_CORBA_ExceptionDef__get_members(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef__set_members(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_StructMemberSeq * value,
				      CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_ExceptionDef__get_def_kind(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef_destroy(impl_POA_CORBA_ExceptionDef * servant,
				 CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_ExceptionDef__get_id(impl_POA_CORBA_ExceptionDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef__set_id(impl_POA_CORBA_ExceptionDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_ExceptionDef__get_name(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef__set_name(impl_POA_CORBA_ExceptionDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_ExceptionDef__get_version(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef__set_version(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev);

CORBA_Container
impl_CORBA_ExceptionDef__get_defined_in(impl_POA_CORBA_ExceptionDef * servant,
					CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_ExceptionDef__get_absolute_name(impl_POA_CORBA_ExceptionDef * servant,
					   CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_ExceptionDef__get_containing_repository(impl_POA_CORBA_ExceptionDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_ExceptionDef_describe(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_ExceptionDef_move(impl_POA_CORBA_ExceptionDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_ExceptionDef_lookup(impl_POA_CORBA_ExceptionDef * servant,
			       CORBA_ScopedName search_name,
			       CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_ExceptionDef_contents(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_ExceptionDef_lookup_name(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Identifier search_name,
				     CORBA_long levels_to_search,
				     CORBA_DefinitionKind limit_type,
				     CORBA_boolean exclude_inherited,
				     CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_ExceptionDef_describe_contents(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					   CORBA_long max_returned_objs,
					   CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_ExceptionDef_create_module(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_ExceptionDef_create_constant(impl_POA_CORBA_ExceptionDef * servant,
					CORBA_RepositoryId id,
					CORBA_Identifier name,
					CORBA_VersionSpec version,
					CORBA_IDLType type,
					CORBA_any * value,
					CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_ExceptionDef_create_struct(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_ExceptionDef_create_union(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType discriminator_type,
				     CORBA_UnionMemberSeq * members,
				     CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_ExceptionDef_create_enum(impl_POA_CORBA_ExceptionDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_EnumMemberSeq * members,
				    CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_ExceptionDef_create_alias(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType original_type,
				     CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_ExceptionDef_create_interface(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
					 CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_ExceptionDef_create_exception(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_StructMemberSeq * members,
					 CORBA_Environment * ev);

static void impl_CORBA_AttributeDef__destroy(impl_POA_CORBA_AttributeDef * servant,
					     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_AttributeDef__get_type(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_AttributeDef__get_type_def(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_type_def(impl_POA_CORBA_AttributeDef * servant,
				       CORBA_IDLType value,
				       CORBA_Environment * ev);

CORBA_AttributeMode
impl_CORBA_AttributeDef__get_mode(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_mode(impl_POA_CORBA_AttributeDef * servant,
				   CORBA_AttributeMode value,
				   CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_AttributeDef__get_def_kind(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef_destroy(impl_POA_CORBA_AttributeDef * servant,
				 CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_AttributeDef__get_id(impl_POA_CORBA_AttributeDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_id(impl_POA_CORBA_AttributeDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_AttributeDef__get_name(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_name(impl_POA_CORBA_AttributeDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_AttributeDef__get_version(impl_POA_CORBA_AttributeDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef__set_version(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev);

CORBA_Container
impl_CORBA_AttributeDef__get_defined_in(impl_POA_CORBA_AttributeDef * servant,
					CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_AttributeDef__get_absolute_name(impl_POA_CORBA_AttributeDef * servant,
					   CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_AttributeDef__get_containing_repository(impl_POA_CORBA_AttributeDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_AttributeDef_describe(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_AttributeDef_move(impl_POA_CORBA_AttributeDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev);

static void impl_CORBA_OperationDef__destroy(impl_POA_CORBA_OperationDef * servant,
					     CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_OperationDef__get_result(impl_POA_CORBA_OperationDef * servant,
				    CORBA_Environment * ev);

CORBA_IDLType
impl_CORBA_OperationDef__get_result_def(impl_POA_CORBA_OperationDef * servant,
					CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_result_def(impl_POA_CORBA_OperationDef * servant,
					 CORBA_IDLType value,
					 CORBA_Environment * ev);

CORBA_ParDescriptionSeq *
 impl_CORBA_OperationDef__get_params(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_params(impl_POA_CORBA_OperationDef * servant,
				     CORBA_ParDescriptionSeq * value,
				     CORBA_Environment * ev);

CORBA_OperationMode
impl_CORBA_OperationDef__get_mode(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_mode(impl_POA_CORBA_OperationDef * servant,
				   CORBA_OperationMode value,
				   CORBA_Environment * ev);

CORBA_ContextIdSeq *
 impl_CORBA_OperationDef__get_contexts(impl_POA_CORBA_OperationDef * servant,
				       CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_contexts(impl_POA_CORBA_OperationDef * servant,
				       CORBA_ContextIdSeq * value,
				       CORBA_Environment * ev);

CORBA_ExceptionDefSeq *
 impl_CORBA_OperationDef__get_exceptions(impl_POA_CORBA_OperationDef * servant,
					 CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_exceptions(impl_POA_CORBA_OperationDef * servant,
					 CORBA_ExceptionDefSeq * value,
					 CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_OperationDef__get_def_kind(impl_POA_CORBA_OperationDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_OperationDef_destroy(impl_POA_CORBA_OperationDef * servant,
				 CORBA_Environment * ev);

CORBA_RepositoryId
impl_CORBA_OperationDef__get_id(impl_POA_CORBA_OperationDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_id(impl_POA_CORBA_OperationDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_OperationDef__get_name(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_name(impl_POA_CORBA_OperationDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_OperationDef__get_version(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_OperationDef__set_version(impl_POA_CORBA_OperationDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev);

CORBA_Container
impl_CORBA_OperationDef__get_defined_in(impl_POA_CORBA_OperationDef * servant,
					CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_OperationDef__get_absolute_name(impl_POA_CORBA_OperationDef * servant,
					   CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_OperationDef__get_containing_repository(impl_POA_CORBA_OperationDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_OperationDef_describe(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_OperationDef_move(impl_POA_CORBA_OperationDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev);

static void impl_CORBA_InterfaceDef__destroy(impl_POA_CORBA_InterfaceDef * servant,
					     CORBA_Environment * ev);
CORBA_InterfaceDefSeq *
 impl_CORBA_InterfaceDef__get_base_interfaces(impl_POA_CORBA_InterfaceDef * servant,
					      CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef__set_base_interfaces(impl_POA_CORBA_InterfaceDef * servant,
					   CORBA_InterfaceDefSeq * value,
					      CORBA_Environment * ev);

CORBA_boolean
impl_CORBA_InterfaceDef_is_a(impl_POA_CORBA_InterfaceDef * servant,
			     CORBA_RepositoryId interface_id,
			     CORBA_Environment * ev);

CORBA_InterfaceDef_FullInterfaceDescription *
 impl_CORBA_InterfaceDef_describe_interface(impl_POA_CORBA_InterfaceDef * servant,
					    CORBA_Environment * ev);

CORBA_AttributeDef
impl_CORBA_InterfaceDef_create_attribute(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_IDLType type,
					 CORBA_AttributeMode mode,
					 CORBA_Environment * ev);

CORBA_OperationDef
impl_CORBA_InterfaceDef_create_operation(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_IDLType result,
					 CORBA_OperationMode mode,
					 CORBA_ParDescriptionSeq * params,
				      CORBA_ExceptionDefSeq * exceptions,
					 CORBA_ContextIdSeq * contexts,
					 CORBA_Environment * ev);

CORBA_DefinitionKind
impl_CORBA_InterfaceDef__get_def_kind(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef_destroy(impl_POA_CORBA_InterfaceDef * servant,
				 CORBA_Environment * ev);

CORBA_Contained
impl_CORBA_InterfaceDef_lookup(impl_POA_CORBA_InterfaceDef * servant,
			       CORBA_ScopedName search_name,
			       CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_InterfaceDef_contents(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev);
CORBA_ContainedSeq *
 impl_CORBA_InterfaceDef_lookup_name(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Identifier search_name,
				     CORBA_long levels_to_search,
				     CORBA_DefinitionKind limit_type,
				     CORBA_boolean exclude_inherited,
				     CORBA_Environment * ev);
CORBA_Container_DescriptionSeq *
 impl_CORBA_InterfaceDef_describe_contents(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					   CORBA_long max_returned_objs,
					   CORBA_Environment * ev);

CORBA_ModuleDef
impl_CORBA_InterfaceDef_create_module(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_Environment * ev);
CORBA_ConstantDef
impl_CORBA_InterfaceDef_create_constant(impl_POA_CORBA_InterfaceDef * servant,
					CORBA_RepositoryId id,
					CORBA_Identifier name,
					CORBA_VersionSpec version,
					CORBA_IDLType type,
					CORBA_any * value,
					CORBA_Environment * ev);
CORBA_StructDef
impl_CORBA_InterfaceDef_create_struct(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev);
CORBA_UnionDef
impl_CORBA_InterfaceDef_create_union(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType discriminator_type,
				     CORBA_UnionMemberSeq * members,
				     CORBA_Environment * ev);
CORBA_EnumDef
impl_CORBA_InterfaceDef_create_enum(impl_POA_CORBA_InterfaceDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_EnumMemberSeq * members,
				    CORBA_Environment * ev);
CORBA_AliasDef
impl_CORBA_InterfaceDef_create_alias(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType original_type,
				     CORBA_Environment * ev);
CORBA_InterfaceDef
impl_CORBA_InterfaceDef_create_interface(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
					 CORBA_Environment * ev);
CORBA_ExceptionDef
impl_CORBA_InterfaceDef_create_exception(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_StructMemberSeq * members,
					 CORBA_Environment * ev);
CORBA_RepositoryId
impl_CORBA_InterfaceDef__get_id(impl_POA_CORBA_InterfaceDef * servant,
				CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef__set_id(impl_POA_CORBA_InterfaceDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev);

CORBA_Identifier
impl_CORBA_InterfaceDef__get_name(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef__set_name(impl_POA_CORBA_InterfaceDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev);

CORBA_VersionSpec
impl_CORBA_InterfaceDef__get_version(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef__set_version(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev);

CORBA_Container
impl_CORBA_InterfaceDef__get_defined_in(impl_POA_CORBA_InterfaceDef * servant,
					CORBA_Environment * ev);
CORBA_ScopedName
impl_CORBA_InterfaceDef__get_absolute_name(impl_POA_CORBA_InterfaceDef * servant,
					   CORBA_Environment * ev);
CORBA_Repository
impl_CORBA_InterfaceDef__get_containing_repository(impl_POA_CORBA_InterfaceDef * servant,
						 CORBA_Environment * ev);
CORBA_Contained_Description *
 impl_CORBA_InterfaceDef_describe(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev);
void
 impl_CORBA_InterfaceDef_move(impl_POA_CORBA_InterfaceDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev);

CORBA_TypeCode
impl_CORBA_InterfaceDef__get_type(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev);

/*** epv structures ***/

static PortableServer_ServantBase__epv impl_CORBA_Repository_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_Repository__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_Repository__epv impl_CORBA_Repository_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_Repository_lookup_id,

	(gpointer) & impl_CORBA_Repository_get_primitive,

	(gpointer) & impl_CORBA_Repository_create_string,

	(gpointer) & impl_CORBA_Repository_create_wstring,

	(gpointer) & impl_CORBA_Repository_create_sequence,

	(gpointer) & impl_CORBA_Repository_create_array,

	(gpointer) & impl_CORBA_Repository_create_fixed,

};
static POA_CORBA_IRObject__epv impl_CORBA_Repository_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_Repository__get_def_kind,
	(gpointer) & impl_CORBA_Repository_destroy,
};
static POA_CORBA_Container__epv impl_CORBA_Repository_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_Repository_lookup,
	(gpointer) & impl_CORBA_Repository_contents,
	(gpointer) & impl_CORBA_Repository_lookup_name,
	(gpointer) & impl_CORBA_Repository_describe_contents,
	(gpointer) & impl_CORBA_Repository_create_module,
	(gpointer) & impl_CORBA_Repository_create_constant,
	(gpointer) & impl_CORBA_Repository_create_struct,
	(gpointer) & impl_CORBA_Repository_create_union,
	(gpointer) & impl_CORBA_Repository_create_enum,
	(gpointer) & impl_CORBA_Repository_create_alias,
	(gpointer) & impl_CORBA_Repository_create_interface,
	(gpointer) & impl_CORBA_Repository_create_exception,
};
static PortableServer_ServantBase__epv impl_CORBA_ModuleDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_ModuleDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_ModuleDef__epv impl_CORBA_ModuleDef_epv =
{
	NULL,			/* _private */
};
static POA_CORBA_IRObject__epv impl_CORBA_ModuleDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ModuleDef__get_def_kind,
	(gpointer) & impl_CORBA_ModuleDef_destroy,
};
static POA_CORBA_Container__epv impl_CORBA_ModuleDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ModuleDef_lookup,
	(gpointer) & impl_CORBA_ModuleDef_contents,
	(gpointer) & impl_CORBA_ModuleDef_lookup_name,
	(gpointer) & impl_CORBA_ModuleDef_describe_contents,
	(gpointer) & impl_CORBA_ModuleDef_create_module,
	(gpointer) & impl_CORBA_ModuleDef_create_constant,
	(gpointer) & impl_CORBA_ModuleDef_create_struct,
	(gpointer) & impl_CORBA_ModuleDef_create_union,
	(gpointer) & impl_CORBA_ModuleDef_create_enum,
	(gpointer) & impl_CORBA_ModuleDef_create_alias,
	(gpointer) & impl_CORBA_ModuleDef_create_interface,
	(gpointer) & impl_CORBA_ModuleDef_create_exception,
};
static POA_CORBA_Contained__epv impl_CORBA_ModuleDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ModuleDef__get_id,
	(gpointer) & impl_CORBA_ModuleDef__set_id,
	(gpointer) & impl_CORBA_ModuleDef__get_name,
	(gpointer) & impl_CORBA_ModuleDef__set_name,
	(gpointer) & impl_CORBA_ModuleDef__get_version,
	(gpointer) & impl_CORBA_ModuleDef__set_version,
	(gpointer) & impl_CORBA_ModuleDef__get_defined_in,
	(gpointer) & impl_CORBA_ModuleDef__get_absolute_name,
	(gpointer) & impl_CORBA_ModuleDef__get_containing_repository,
	(gpointer) & impl_CORBA_ModuleDef_describe,
	(gpointer) & impl_CORBA_ModuleDef_move,
};

static PortableServer_ServantBase__epv impl_CORBA_ConstantDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_ConstantDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_ConstantDef__epv impl_CORBA_ConstantDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ConstantDef__get_type,

	(gpointer) & impl_CORBA_ConstantDef__get_type_def,
	(gpointer) & impl_CORBA_ConstantDef__set_type_def,

	(gpointer) & impl_CORBA_ConstantDef__get_value,
	(gpointer) & impl_CORBA_ConstantDef__set_value,

};
static POA_CORBA_IRObject__epv impl_CORBA_ConstantDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ConstantDef__get_def_kind,
	(gpointer) & impl_CORBA_ConstantDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_ConstantDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ConstantDef__get_id,
	(gpointer) & impl_CORBA_ConstantDef__set_id,
	(gpointer) & impl_CORBA_ConstantDef__get_name,
	(gpointer) & impl_CORBA_ConstantDef__set_name,
	(gpointer) & impl_CORBA_ConstantDef__get_version,
	(gpointer) & impl_CORBA_ConstantDef__set_version,
	(gpointer) & impl_CORBA_ConstantDef__get_defined_in,
	(gpointer) & impl_CORBA_ConstantDef__get_absolute_name,
	(gpointer) & impl_CORBA_ConstantDef__get_containing_repository,
	(gpointer) & impl_CORBA_ConstantDef_describe,
	(gpointer) & impl_CORBA_ConstantDef_move,
};

static PortableServer_ServantBase__epv impl_CORBA_StructDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_StructDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_StructDef__epv impl_CORBA_StructDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef__get_members,
	(gpointer) & impl_CORBA_StructDef__set_members,

};
static POA_CORBA_IRObject__epv impl_CORBA_StructDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef__get_def_kind,
	(gpointer) & impl_CORBA_StructDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_StructDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef__get_id,
	(gpointer) & impl_CORBA_StructDef__set_id,
	(gpointer) & impl_CORBA_StructDef__get_name,
	(gpointer) & impl_CORBA_StructDef__set_name,
	(gpointer) & impl_CORBA_StructDef__get_version,
	(gpointer) & impl_CORBA_StructDef__set_version,
	(gpointer) & impl_CORBA_StructDef__get_defined_in,
	(gpointer) & impl_CORBA_StructDef__get_absolute_name,
	(gpointer) & impl_CORBA_StructDef__get_containing_repository,
	(gpointer) & impl_CORBA_StructDef_describe,
	(gpointer) & impl_CORBA_StructDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_StructDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef__get_type,
};
static POA_CORBA_TypedefDef__epv impl_CORBA_StructDef_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static POA_CORBA_Container__epv impl_CORBA_StructDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StructDef_lookup,
	(gpointer) & impl_CORBA_StructDef_contents,
	(gpointer) & impl_CORBA_StructDef_lookup_name,
	(gpointer) & impl_CORBA_StructDef_describe_contents,
	(gpointer) & impl_CORBA_StructDef_create_module,
	(gpointer) & impl_CORBA_StructDef_create_constant,
	(gpointer) & impl_CORBA_StructDef_create_struct,
	(gpointer) & impl_CORBA_StructDef_create_union,
	(gpointer) & impl_CORBA_StructDef_create_enum,
	(gpointer) & impl_CORBA_StructDef_create_alias,
	(gpointer) & impl_CORBA_StructDef_create_interface,
	(gpointer) & impl_CORBA_StructDef_create_exception,
};
static PortableServer_ServantBase__epv impl_CORBA_UnionDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_UnionDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_UnionDef__epv impl_CORBA_UnionDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef__get_discriminator_type,

	(gpointer) & impl_CORBA_UnionDef__get_discriminator_type_def,
	(gpointer) & impl_CORBA_UnionDef__set_discriminator_type_def,

	(gpointer) & impl_CORBA_UnionDef__get_members,
	(gpointer) & impl_CORBA_UnionDef__set_members,

};
static POA_CORBA_IRObject__epv impl_CORBA_UnionDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef__get_def_kind,
	(gpointer) & impl_CORBA_UnionDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_UnionDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef__get_id,
	(gpointer) & impl_CORBA_UnionDef__set_id,
	(gpointer) & impl_CORBA_UnionDef__get_name,
	(gpointer) & impl_CORBA_UnionDef__set_name,
	(gpointer) & impl_CORBA_UnionDef__get_version,
	(gpointer) & impl_CORBA_UnionDef__set_version,
	(gpointer) & impl_CORBA_UnionDef__get_defined_in,
	(gpointer) & impl_CORBA_UnionDef__get_absolute_name,
	(gpointer) & impl_CORBA_UnionDef__get_containing_repository,
	(gpointer) & impl_CORBA_UnionDef_describe,
	(gpointer) & impl_CORBA_UnionDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_UnionDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef__get_type,
};
static POA_CORBA_TypedefDef__epv impl_CORBA_UnionDef_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static POA_CORBA_Container__epv impl_CORBA_UnionDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_UnionDef_lookup,
	(gpointer) & impl_CORBA_UnionDef_contents,
	(gpointer) & impl_CORBA_UnionDef_lookup_name,
	(gpointer) & impl_CORBA_UnionDef_describe_contents,
	(gpointer) & impl_CORBA_UnionDef_create_module,
	(gpointer) & impl_CORBA_UnionDef_create_constant,
	(gpointer) & impl_CORBA_UnionDef_create_struct,
	(gpointer) & impl_CORBA_UnionDef_create_union,
	(gpointer) & impl_CORBA_UnionDef_create_enum,
	(gpointer) & impl_CORBA_UnionDef_create_alias,
	(gpointer) & impl_CORBA_UnionDef_create_interface,
	(gpointer) & impl_CORBA_UnionDef_create_exception,
};
static PortableServer_ServantBase__epv impl_CORBA_EnumDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_EnumDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_EnumDef__epv impl_CORBA_EnumDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_EnumDef__get_members,
	(gpointer) & impl_CORBA_EnumDef__set_members,

};
static POA_CORBA_IRObject__epv impl_CORBA_EnumDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_EnumDef__get_def_kind,
	(gpointer) & impl_CORBA_EnumDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_EnumDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_EnumDef__get_id,
	(gpointer) & impl_CORBA_EnumDef__set_id,
	(gpointer) & impl_CORBA_EnumDef__get_name,
	(gpointer) & impl_CORBA_EnumDef__set_name,
	(gpointer) & impl_CORBA_EnumDef__get_version,
	(gpointer) & impl_CORBA_EnumDef__set_version,
	(gpointer) & impl_CORBA_EnumDef__get_defined_in,
	(gpointer) & impl_CORBA_EnumDef__get_absolute_name,
	(gpointer) & impl_CORBA_EnumDef__get_containing_repository,
	(gpointer) & impl_CORBA_EnumDef_describe,
	(gpointer) & impl_CORBA_EnumDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_EnumDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_EnumDef__get_type,
};
static POA_CORBA_TypedefDef__epv impl_CORBA_EnumDef_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static PortableServer_ServantBase__epv impl_CORBA_AliasDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_AliasDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_AliasDef__epv impl_CORBA_AliasDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AliasDef__get_original_type_def,
	(gpointer) & impl_CORBA_AliasDef__set_original_type_def,

};
static POA_CORBA_IRObject__epv impl_CORBA_AliasDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AliasDef__get_def_kind,
	(gpointer) & impl_CORBA_AliasDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_AliasDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AliasDef__get_id,
	(gpointer) & impl_CORBA_AliasDef__set_id,
	(gpointer) & impl_CORBA_AliasDef__get_name,
	(gpointer) & impl_CORBA_AliasDef__set_name,
	(gpointer) & impl_CORBA_AliasDef__get_version,
	(gpointer) & impl_CORBA_AliasDef__set_version,
	(gpointer) & impl_CORBA_AliasDef__get_defined_in,
	(gpointer) & impl_CORBA_AliasDef__get_absolute_name,
	(gpointer) & impl_CORBA_AliasDef__get_containing_repository,
	(gpointer) & impl_CORBA_AliasDef_describe,
	(gpointer) & impl_CORBA_AliasDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_AliasDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AliasDef__get_type,
};
static POA_CORBA_TypedefDef__epv impl_CORBA_AliasDef_CORBA_TypedefDef_epv =
{
	NULL,			/* _private */
};
static PortableServer_ServantBase__epv impl_CORBA_PrimitiveDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_PrimitiveDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_PrimitiveDef__epv impl_CORBA_PrimitiveDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_PrimitiveDef__get_kind,

};
static POA_CORBA_IRObject__epv impl_CORBA_PrimitiveDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_PrimitiveDef__get_def_kind,
	(gpointer) & impl_CORBA_PrimitiveDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_PrimitiveDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_PrimitiveDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_StringDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_StringDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_StringDef__epv impl_CORBA_StringDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StringDef__get_bound,
	(gpointer) & impl_CORBA_StringDef__set_bound,

};
static POA_CORBA_IRObject__epv impl_CORBA_StringDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StringDef__get_def_kind,
	(gpointer) & impl_CORBA_StringDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_StringDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_StringDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_WstringDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_WstringDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_WstringDef__epv impl_CORBA_WstringDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_WstringDef__get_bound,
	(gpointer) & impl_CORBA_WstringDef__set_bound,

};
static POA_CORBA_IRObject__epv impl_CORBA_WstringDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_WstringDef__get_def_kind,
	(gpointer) & impl_CORBA_WstringDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_WstringDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_WstringDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_FixedDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_FixedDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_FixedDef__epv impl_CORBA_FixedDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_FixedDef__get_digits,
	(gpointer) & impl_CORBA_FixedDef__set_digits,

	(gpointer) & impl_CORBA_FixedDef__get_scale,
	(gpointer) & impl_CORBA_FixedDef__set_scale,

};
static POA_CORBA_IRObject__epv impl_CORBA_FixedDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_FixedDef__get_def_kind,
	(gpointer) & impl_CORBA_FixedDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_FixedDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_FixedDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_SequenceDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_SequenceDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_SequenceDef__epv impl_CORBA_SequenceDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_SequenceDef__get_bound,
	(gpointer) & impl_CORBA_SequenceDef__set_bound,

	(gpointer) & impl_CORBA_SequenceDef__get_element_type,

	(gpointer) & impl_CORBA_SequenceDef__get_element_type_def,
	(gpointer) & impl_CORBA_SequenceDef__set_element_type_def,

};
static POA_CORBA_IRObject__epv impl_CORBA_SequenceDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_SequenceDef__get_def_kind,
	(gpointer) & impl_CORBA_SequenceDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_SequenceDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_SequenceDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_ArrayDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_ArrayDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_ArrayDef__epv impl_CORBA_ArrayDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ArrayDef__get_length,
	(gpointer) & impl_CORBA_ArrayDef__set_length,

	(gpointer) & impl_CORBA_ArrayDef__get_element_type,

	(gpointer) & impl_CORBA_ArrayDef__get_element_type_def,
	(gpointer) & impl_CORBA_ArrayDef__set_element_type_def,

};
static POA_CORBA_IRObject__epv impl_CORBA_ArrayDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ArrayDef__get_def_kind,
	(gpointer) & impl_CORBA_ArrayDef_destroy,
};
static POA_CORBA_IDLType__epv impl_CORBA_ArrayDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ArrayDef__get_type,
};
static PortableServer_ServantBase__epv impl_CORBA_ExceptionDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_ExceptionDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_ExceptionDef__epv impl_CORBA_ExceptionDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ExceptionDef__get_type,

	(gpointer) & impl_CORBA_ExceptionDef__get_members,
	(gpointer) & impl_CORBA_ExceptionDef__set_members,

};
static POA_CORBA_IRObject__epv impl_CORBA_ExceptionDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ExceptionDef__get_def_kind,
	(gpointer) & impl_CORBA_ExceptionDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_ExceptionDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ExceptionDef__get_id,
	(gpointer) & impl_CORBA_ExceptionDef__set_id,
	(gpointer) & impl_CORBA_ExceptionDef__get_name,
	(gpointer) & impl_CORBA_ExceptionDef__set_name,
	(gpointer) & impl_CORBA_ExceptionDef__get_version,
	(gpointer) & impl_CORBA_ExceptionDef__set_version,
	(gpointer) & impl_CORBA_ExceptionDef__get_defined_in,
	(gpointer) & impl_CORBA_ExceptionDef__get_absolute_name,
	(gpointer) & impl_CORBA_ExceptionDef__get_containing_repository,
	(gpointer) & impl_CORBA_ExceptionDef_describe,
	(gpointer) & impl_CORBA_ExceptionDef_move,
};
static POA_CORBA_Container__epv impl_CORBA_ExceptionDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_ExceptionDef_lookup,
	(gpointer) & impl_CORBA_ExceptionDef_contents,
	(gpointer) & impl_CORBA_ExceptionDef_lookup_name,
	(gpointer) & impl_CORBA_ExceptionDef_describe_contents,
	(gpointer) & impl_CORBA_ExceptionDef_create_module,
	(gpointer) & impl_CORBA_ExceptionDef_create_constant,
	(gpointer) & impl_CORBA_ExceptionDef_create_struct,
	(gpointer) & impl_CORBA_ExceptionDef_create_union,
	(gpointer) & impl_CORBA_ExceptionDef_create_enum,
	(gpointer) & impl_CORBA_ExceptionDef_create_alias,
	(gpointer) & impl_CORBA_ExceptionDef_create_interface,
	(gpointer) & impl_CORBA_ExceptionDef_create_exception,
};

static PortableServer_ServantBase__epv impl_CORBA_AttributeDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_AttributeDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_AttributeDef__epv impl_CORBA_AttributeDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AttributeDef__get_type,

	(gpointer) & impl_CORBA_AttributeDef__get_type_def,
	(gpointer) & impl_CORBA_AttributeDef__set_type_def,

	(gpointer) & impl_CORBA_AttributeDef__get_mode,
	(gpointer) & impl_CORBA_AttributeDef__set_mode,

};
static POA_CORBA_IRObject__epv impl_CORBA_AttributeDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AttributeDef__get_def_kind,
	(gpointer) & impl_CORBA_AttributeDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_AttributeDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_AttributeDef__get_id,
	(gpointer) & impl_CORBA_AttributeDef__set_id,
	(gpointer) & impl_CORBA_AttributeDef__get_name,
	(gpointer) & impl_CORBA_AttributeDef__set_name,
	(gpointer) & impl_CORBA_AttributeDef__get_version,
	(gpointer) & impl_CORBA_AttributeDef__set_version,
	(gpointer) & impl_CORBA_AttributeDef__get_defined_in,
	(gpointer) & impl_CORBA_AttributeDef__get_absolute_name,
	(gpointer) & impl_CORBA_AttributeDef__get_containing_repository,
	(gpointer) & impl_CORBA_AttributeDef_describe,
	(gpointer) & impl_CORBA_AttributeDef_move,
};

static PortableServer_ServantBase__epv impl_CORBA_OperationDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_OperationDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_OperationDef__epv impl_CORBA_OperationDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_OperationDef__get_result,

	(gpointer) & impl_CORBA_OperationDef__get_result_def,
	(gpointer) & impl_CORBA_OperationDef__set_result_def,

	(gpointer) & impl_CORBA_OperationDef__get_params,
	(gpointer) & impl_CORBA_OperationDef__set_params,

	(gpointer) & impl_CORBA_OperationDef__get_mode,
	(gpointer) & impl_CORBA_OperationDef__set_mode,

	(gpointer) & impl_CORBA_OperationDef__get_contexts,
	(gpointer) & impl_CORBA_OperationDef__set_contexts,

	(gpointer) & impl_CORBA_OperationDef__get_exceptions,
	(gpointer) & impl_CORBA_OperationDef__set_exceptions,

};
static POA_CORBA_IRObject__epv impl_CORBA_OperationDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_OperationDef__get_def_kind,
	(gpointer) & impl_CORBA_OperationDef_destroy,
};
static POA_CORBA_Contained__epv impl_CORBA_OperationDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_OperationDef__get_id,
	(gpointer) & impl_CORBA_OperationDef__set_id,
	(gpointer) & impl_CORBA_OperationDef__get_name,
	(gpointer) & impl_CORBA_OperationDef__set_name,
	(gpointer) & impl_CORBA_OperationDef__get_version,
	(gpointer) & impl_CORBA_OperationDef__set_version,
	(gpointer) & impl_CORBA_OperationDef__get_defined_in,
	(gpointer) & impl_CORBA_OperationDef__get_absolute_name,
	(gpointer) & impl_CORBA_OperationDef__get_containing_repository,
	(gpointer) & impl_CORBA_OperationDef_describe,
	(gpointer) & impl_CORBA_OperationDef_move,
};

static PortableServer_ServantBase__epv impl_CORBA_InterfaceDef_base_epv =
{
	NULL,			/* _private data */
	(gpointer) & impl_CORBA_InterfaceDef__destroy,	/* finalize
							 * routine */
	NULL,			/* default_POA routine */
};
static POA_CORBA_InterfaceDef__epv impl_CORBA_InterfaceDef_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef__get_base_interfaces,
	(gpointer) & impl_CORBA_InterfaceDef__set_base_interfaces,

	(gpointer) & impl_CORBA_InterfaceDef_is_a,

	(gpointer) & impl_CORBA_InterfaceDef_describe_interface,

	(gpointer) & impl_CORBA_InterfaceDef_create_attribute,

	(gpointer) & impl_CORBA_InterfaceDef_create_operation,

};
static POA_CORBA_IRObject__epv impl_CORBA_InterfaceDef_CORBA_IRObject_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef__get_def_kind,
	(gpointer) & impl_CORBA_InterfaceDef_destroy,
};
static POA_CORBA_Container__epv impl_CORBA_InterfaceDef_CORBA_Container_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef_lookup,
	(gpointer) & impl_CORBA_InterfaceDef_contents,
	(gpointer) & impl_CORBA_InterfaceDef_lookup_name,
	(gpointer) & impl_CORBA_InterfaceDef_describe_contents,
	(gpointer) & impl_CORBA_InterfaceDef_create_module,
	(gpointer) & impl_CORBA_InterfaceDef_create_constant,
	(gpointer) & impl_CORBA_InterfaceDef_create_struct,
	(gpointer) & impl_CORBA_InterfaceDef_create_union,
	(gpointer) & impl_CORBA_InterfaceDef_create_enum,
	(gpointer) & impl_CORBA_InterfaceDef_create_alias,
	(gpointer) & impl_CORBA_InterfaceDef_create_interface,
	(gpointer) & impl_CORBA_InterfaceDef_create_exception,
};
static POA_CORBA_Contained__epv impl_CORBA_InterfaceDef_CORBA_Contained_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef__get_id,
	(gpointer) & impl_CORBA_InterfaceDef__set_id,
	(gpointer) & impl_CORBA_InterfaceDef__get_name,
	(gpointer) & impl_CORBA_InterfaceDef__set_name,
	(gpointer) & impl_CORBA_InterfaceDef__get_version,
	(gpointer) & impl_CORBA_InterfaceDef__set_version,
	(gpointer) & impl_CORBA_InterfaceDef__get_defined_in,
	(gpointer) & impl_CORBA_InterfaceDef__get_absolute_name,
	(gpointer) & impl_CORBA_InterfaceDef__get_containing_repository,
	(gpointer) & impl_CORBA_InterfaceDef_describe,
	(gpointer) & impl_CORBA_InterfaceDef_move,
};
static POA_CORBA_IDLType__epv impl_CORBA_InterfaceDef_CORBA_IDLType_epv =
{
	NULL,			/* _private */
	(gpointer) & impl_CORBA_InterfaceDef__get_type,
};

/*** vepv structures ***/

static POA_CORBA_Repository__vepv impl_CORBA_Repository_vepv =
{
	&impl_CORBA_Repository_base_epv,
	&impl_CORBA_Repository_CORBA_IRObject_epv,
	&impl_CORBA_Repository_CORBA_Container_epv,
	&impl_CORBA_Repository_epv,
};
static POA_CORBA_ModuleDef__vepv impl_CORBA_ModuleDef_vepv =
{
	&impl_CORBA_ModuleDef_base_epv,
	&impl_CORBA_ModuleDef_CORBA_IRObject_epv,
	&impl_CORBA_ModuleDef_CORBA_Container_epv,
	&impl_CORBA_ModuleDef_CORBA_Contained_epv,
	&impl_CORBA_ModuleDef_epv,
};

static POA_CORBA_ConstantDef__vepv impl_CORBA_ConstantDef_vepv =
{
	&impl_CORBA_ConstantDef_base_epv,
	&impl_CORBA_ConstantDef_CORBA_IRObject_epv,
	&impl_CORBA_ConstantDef_CORBA_Contained_epv,
	&impl_CORBA_ConstantDef_epv,
};

static POA_CORBA_StructDef__vepv impl_CORBA_StructDef_vepv =
{
	&impl_CORBA_StructDef_base_epv,
	&impl_CORBA_StructDef_CORBA_IRObject_epv,
	&impl_CORBA_StructDef_CORBA_Contained_epv,
	&impl_CORBA_StructDef_CORBA_IDLType_epv,
	&impl_CORBA_StructDef_CORBA_TypedefDef_epv,
	&impl_CORBA_StructDef_CORBA_Container_epv,
	&impl_CORBA_StructDef_epv,
};
static POA_CORBA_UnionDef__vepv impl_CORBA_UnionDef_vepv =
{
	&impl_CORBA_UnionDef_base_epv,
	&impl_CORBA_UnionDef_CORBA_IRObject_epv,
	&impl_CORBA_UnionDef_CORBA_Contained_epv,
	&impl_CORBA_UnionDef_CORBA_IDLType_epv,
	&impl_CORBA_UnionDef_CORBA_TypedefDef_epv,
	&impl_CORBA_UnionDef_CORBA_Container_epv,
	&impl_CORBA_UnionDef_epv,
};
static POA_CORBA_EnumDef__vepv impl_CORBA_EnumDef_vepv =
{
	&impl_CORBA_EnumDef_base_epv,
	&impl_CORBA_EnumDef_CORBA_IRObject_epv,
	&impl_CORBA_EnumDef_CORBA_Contained_epv,
	&impl_CORBA_EnumDef_CORBA_IDLType_epv,
	&impl_CORBA_EnumDef_CORBA_TypedefDef_epv,
	&impl_CORBA_EnumDef_epv,
};
static POA_CORBA_AliasDef__vepv impl_CORBA_AliasDef_vepv =
{
	&impl_CORBA_AliasDef_base_epv,
	&impl_CORBA_AliasDef_CORBA_IRObject_epv,
	&impl_CORBA_AliasDef_CORBA_Contained_epv,
	&impl_CORBA_AliasDef_CORBA_IDLType_epv,
	&impl_CORBA_AliasDef_CORBA_TypedefDef_epv,
	&impl_CORBA_AliasDef_epv,
};
static POA_CORBA_PrimitiveDef__vepv impl_CORBA_PrimitiveDef_vepv =
{
	&impl_CORBA_PrimitiveDef_base_epv,
	&impl_CORBA_PrimitiveDef_CORBA_IRObject_epv,
	&impl_CORBA_PrimitiveDef_CORBA_IDLType_epv,
	&impl_CORBA_PrimitiveDef_epv,
};
static POA_CORBA_StringDef__vepv impl_CORBA_StringDef_vepv =
{
	&impl_CORBA_StringDef_base_epv,
	&impl_CORBA_StringDef_CORBA_IRObject_epv,
	&impl_CORBA_StringDef_CORBA_IDLType_epv,
	&impl_CORBA_StringDef_epv,
};
static POA_CORBA_WstringDef__vepv impl_CORBA_WstringDef_vepv =
{
	&impl_CORBA_WstringDef_base_epv,
	&impl_CORBA_WstringDef_CORBA_IRObject_epv,
	&impl_CORBA_WstringDef_CORBA_IDLType_epv,
	&impl_CORBA_WstringDef_epv,
};
static POA_CORBA_FixedDef__vepv impl_CORBA_FixedDef_vepv =
{
	&impl_CORBA_FixedDef_base_epv,
	&impl_CORBA_FixedDef_CORBA_IRObject_epv,
	&impl_CORBA_FixedDef_CORBA_IDLType_epv,
	&impl_CORBA_FixedDef_epv,
};
static POA_CORBA_SequenceDef__vepv impl_CORBA_SequenceDef_vepv =
{
	&impl_CORBA_SequenceDef_base_epv,
	&impl_CORBA_SequenceDef_CORBA_IRObject_epv,
	&impl_CORBA_SequenceDef_CORBA_IDLType_epv,
	&impl_CORBA_SequenceDef_epv,
};
static POA_CORBA_ArrayDef__vepv impl_CORBA_ArrayDef_vepv =
{
	&impl_CORBA_ArrayDef_base_epv,
	&impl_CORBA_ArrayDef_CORBA_IRObject_epv,
	&impl_CORBA_ArrayDef_CORBA_IDLType_epv,
	&impl_CORBA_ArrayDef_epv,
};
static POA_CORBA_ExceptionDef__vepv impl_CORBA_ExceptionDef_vepv =
{
	&impl_CORBA_ExceptionDef_base_epv,
	&impl_CORBA_ExceptionDef_CORBA_IRObject_epv,
	&impl_CORBA_ExceptionDef_CORBA_Contained_epv,
	&impl_CORBA_ExceptionDef_CORBA_Container_epv,
	&impl_CORBA_ExceptionDef_epv,
};

static POA_CORBA_AttributeDef__vepv impl_CORBA_AttributeDef_vepv =
{
	&impl_CORBA_AttributeDef_base_epv,
	&impl_CORBA_AttributeDef_CORBA_IRObject_epv,
	&impl_CORBA_AttributeDef_CORBA_Contained_epv,
	&impl_CORBA_AttributeDef_epv,
};

static POA_CORBA_OperationDef__vepv impl_CORBA_OperationDef_vepv =
{
	&impl_CORBA_OperationDef_base_epv,
	&impl_CORBA_OperationDef_CORBA_IRObject_epv,
	&impl_CORBA_OperationDef_CORBA_Contained_epv,
	&impl_CORBA_OperationDef_epv,
};

static POA_CORBA_InterfaceDef__vepv impl_CORBA_InterfaceDef_vepv =
{
	&impl_CORBA_InterfaceDef_base_epv,
	&impl_CORBA_InterfaceDef_CORBA_IRObject_epv,
	&impl_CORBA_InterfaceDef_CORBA_Container_epv,
	&impl_CORBA_InterfaceDef_CORBA_Contained_epv,
	&impl_CORBA_InterfaceDef_CORBA_IDLType_epv,
	&impl_CORBA_InterfaceDef_epv,
};

/*** Stub implementations ***/

static CORBA_Repository impl_CORBA_Repository__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_Repository retval;
	impl_POA_CORBA_Repository *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_Repository, 1);
	newservant->servant.vepv = &impl_CORBA_Repository_vepv;
	newservant->poa = poa;

	newservant->id_hash=g_hash_table_new(g_str_hash, g_str_equal);

	POA_CORBA_Repository__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_Repository__destroy(impl_POA_CORBA_Repository * servant, CORBA_Environment * ev)
{

	g_hash_table_destroy(servant->id_hash);
	POA_CORBA_Repository__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_Contained
impl_CORBA_Repository_lookup_id(impl_POA_CORBA_Repository * servant,
				CORBA_RepositoryId search_id,
				CORBA_Environment * ev)
{
	CORBA_Contained retval;

	retval = g_hash_table_lookup(servant->id_hash, search_id);

	return retval;
}

CORBA_PrimitiveDef
impl_CORBA_Repository_get_primitive(impl_POA_CORBA_Repository * servant,
				    CORBA_PrimitiveKind kind,
				    CORBA_Environment * ev)
{
	CORBA_PrimitiveDef retval;

	return retval;
}

CORBA_StringDef
impl_CORBA_Repository_create_string(impl_POA_CORBA_Repository * servant,
				    CORBA_unsigned_long bound,
				    CORBA_Environment * ev)
{
	CORBA_StringDef retval;

	return retval;
}

CORBA_WstringDef
impl_CORBA_Repository_create_wstring(impl_POA_CORBA_Repository * servant,
				     CORBA_unsigned_long bound,
				     CORBA_Environment * ev)
{
	CORBA_WstringDef retval;

	return retval;
}

CORBA_SequenceDef
impl_CORBA_Repository_create_sequence(impl_POA_CORBA_Repository * servant,
				      CORBA_unsigned_long bound,
				      CORBA_IDLType element_type,
				      CORBA_Environment * ev)
{
	CORBA_SequenceDef retval;

	return retval;
}

CORBA_ArrayDef
impl_CORBA_Repository_create_array(impl_POA_CORBA_Repository * servant,
				   CORBA_unsigned_long length,
				   CORBA_IDLType element_type,
				   CORBA_Environment * ev)
{
	CORBA_ArrayDef retval;

	return retval;
}

CORBA_FixedDef
impl_CORBA_Repository_create_fixed(impl_POA_CORBA_Repository * servant,
				   CORBA_unsigned_short digits,
				   CORBA_short scale,
				   CORBA_Environment * ev)
{
	CORBA_FixedDef retval;

	return retval;
}

CORBA_DefinitionKind
impl_CORBA_Repository__get_def_kind(impl_POA_CORBA_Repository * servant,
				    CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_Repository_destroy(impl_POA_CORBA_Repository * servant,
				   CORBA_Environment * ev)
{
	PortableServer_POA_deactivate_object(servant->poa, PortableServer_POA_servant_to_id(servant->poa, servant, ev), ev);
	impl_CORBA_Repository__destroy(servant, ev);
}

CORBA_Contained
impl_CORBA_Repository_lookup(impl_POA_CORBA_Repository * servant,
			     CORBA_ScopedName search_name,
			     CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_Repository_contents(impl_POA_CORBA_Repository * servant,
				CORBA_DefinitionKind limit_type,
				CORBA_boolean exclude_inherited,
				CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_Repository_lookup_name(impl_POA_CORBA_Repository * servant,
				   CORBA_Identifier search_name,
				   CORBA_long levels_to_search,
				   CORBA_DefinitionKind limit_type,
				   CORBA_boolean exclude_inherited,
				   CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_Repository_describe_contents(impl_POA_CORBA_Repository * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					 CORBA_long max_returned_objs,
					 CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_Repository_create_module(impl_POA_CORBA_Repository * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	return retval;
}

CORBA_ConstantDef
impl_CORBA_Repository_create_constant(impl_POA_CORBA_Repository * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_IDLType type,
				      CORBA_any * value,
				      CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	return retval;
}

CORBA_StructDef
impl_CORBA_Repository_create_struct(impl_POA_CORBA_Repository * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_StructMemberSeq * members,
				    CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	return retval;
}

CORBA_UnionDef
impl_CORBA_Repository_create_union(impl_POA_CORBA_Repository * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_IDLType discriminator_type,
				   CORBA_UnionMemberSeq * members,
				   CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	return retval;
}

CORBA_EnumDef
impl_CORBA_Repository_create_enum(impl_POA_CORBA_Repository * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_EnumMemberSeq * members,
				  CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	return retval;
}

CORBA_AliasDef
impl_CORBA_Repository_create_alias(impl_POA_CORBA_Repository * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_IDLType original_type,
				   CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	return retval;
}

CORBA_InterfaceDef
impl_CORBA_Repository_create_interface(impl_POA_CORBA_Repository * servant,
				       CORBA_RepositoryId id,
				       CORBA_Identifier name,
				       CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				       CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	return retval;
}

CORBA_ExceptionDef
impl_CORBA_Repository_create_exception(impl_POA_CORBA_Repository * servant,
				       CORBA_RepositoryId id,
				       CORBA_Identifier name,
				       CORBA_VersionSpec version,
				       CORBA_StructMemberSeq * members,
				       CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	return retval;
}

static CORBA_ModuleDef impl_CORBA_ModuleDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;
	impl_POA_CORBA_ModuleDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_ModuleDef, 1);
	newservant->servant.vepv = &impl_CORBA_ModuleDef_vepv;
	newservant->poa = poa;
	POA_CORBA_ModuleDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_ModuleDef__destroy(impl_POA_CORBA_ModuleDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_ModuleDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_DefinitionKind
impl_CORBA_ModuleDef__get_def_kind(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_ModuleDef_destroy(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Environment * ev)
{
}

CORBA_Contained
impl_CORBA_ModuleDef_lookup(impl_POA_CORBA_ModuleDef * servant,
			    CORBA_ScopedName search_name,
			    CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_ModuleDef_contents(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_DefinitionKind limit_type,
			       CORBA_boolean exclude_inherited,
			       CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_ModuleDef_lookup_name(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Identifier search_name,
				  CORBA_long levels_to_search,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_ModuleDef_describe_contents(impl_POA_CORBA_ModuleDef * servant,
					CORBA_DefinitionKind limit_type,
					CORBA_boolean exclude_inherited,
					CORBA_long max_returned_objs,
					CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_ModuleDef_create_module(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	return retval;
}

CORBA_ConstantDef
impl_CORBA_ModuleDef_create_constant(impl_POA_CORBA_ModuleDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType type,
				     CORBA_any * value,
				     CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	return retval;
}

CORBA_StructDef
impl_CORBA_ModuleDef_create_struct(impl_POA_CORBA_ModuleDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_StructMemberSeq * members,
				   CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	return retval;
}

CORBA_UnionDef
impl_CORBA_ModuleDef_create_union(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType discriminator_type,
				  CORBA_UnionMemberSeq * members,
				  CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	return retval;
}

CORBA_EnumDef
impl_CORBA_ModuleDef_create_enum(impl_POA_CORBA_ModuleDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_EnumMemberSeq * members,
				 CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	return retval;
}

CORBA_AliasDef
impl_CORBA_ModuleDef_create_alias(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType original_type,
				  CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	return retval;
}

CORBA_InterfaceDef
impl_CORBA_ModuleDef_create_interface(impl_POA_CORBA_ModuleDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				      CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	return retval;
}

CORBA_ExceptionDef
impl_CORBA_ModuleDef_create_exception(impl_POA_CORBA_ModuleDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	return retval;
}

CORBA_RepositoryId
impl_CORBA_ModuleDef__get_id(impl_POA_CORBA_ModuleDef * servant,
			     CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_ModuleDef__set_id(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_RepositoryId value,
				  CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_ModuleDef__get_name(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_ModuleDef__set_name(impl_POA_CORBA_ModuleDef * servant,
				    CORBA_Identifier value,
				    CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_ModuleDef__get_version(impl_POA_CORBA_ModuleDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_ModuleDef__set_version(impl_POA_CORBA_ModuleDef * servant,
				       CORBA_VersionSpec value,
				       CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_ModuleDef__get_defined_in(impl_POA_CORBA_ModuleDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_ModuleDef__get_absolute_name(impl_POA_CORBA_ModuleDef * servant,
					CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_ModuleDef__get_containing_repository(impl_POA_CORBA_ModuleDef * servant,
						CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_ModuleDef_describe(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_ModuleDef_move(impl_POA_CORBA_ModuleDef * servant,
			       CORBA_Container new_container,
			       CORBA_Identifier new_name,
			       CORBA_VersionSpec new_version,
			       CORBA_Environment * ev)
{
}

static CORBA_ConstantDef impl_CORBA_ConstantDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;
	impl_POA_CORBA_ConstantDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_ConstantDef, 1);
	newservant->servant.vepv = &impl_CORBA_ConstantDef_vepv;
	newservant->poa = poa;
	POA_CORBA_ConstantDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_ConstantDef__destroy(impl_POA_CORBA_ConstantDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_ConstantDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_ConstantDef__get_type(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_ConstantDef__get_type_def(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_IDLType retval;

	return retval;
}

void impl_CORBA_ConstantDef__set_type_def(impl_POA_CORBA_ConstantDef * servant,
					  CORBA_IDLType value,
					  CORBA_Environment * ev)
{
}

CORBA_any *
 impl_CORBA_ConstantDef__get_value(impl_POA_CORBA_ConstantDef * servant,
				   CORBA_Environment * ev)
{
	CORBA_any *retval;

	return retval;
}

void impl_CORBA_ConstantDef__set_value(impl_POA_CORBA_ConstantDef * servant,
				       CORBA_any * value,
				       CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_ConstantDef__get_def_kind(impl_POA_CORBA_ConstantDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_ConstantDef_destroy(impl_POA_CORBA_ConstantDef * servant,
				    CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_ConstantDef__get_id(impl_POA_CORBA_ConstantDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_ConstantDef__set_id(impl_POA_CORBA_ConstantDef * servant,
				    CORBA_RepositoryId value,
				    CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_ConstantDef__get_name(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_ConstantDef__set_name(impl_POA_CORBA_ConstantDef * servant,
				      CORBA_Identifier value,
				      CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_ConstantDef__get_version(impl_POA_CORBA_ConstantDef * servant,
				    CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_ConstantDef__set_version(impl_POA_CORBA_ConstantDef * servant,
					 CORBA_VersionSpec value,
					 CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_ConstantDef__get_defined_in(impl_POA_CORBA_ConstantDef * servant,
				       CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_ConstantDef__get_absolute_name(impl_POA_CORBA_ConstantDef * servant,
					  CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_ConstantDef__get_containing_repository(impl_POA_CORBA_ConstantDef * servant,
						  CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_ConstantDef_describe(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_ConstantDef_move(impl_POA_CORBA_ConstantDef * servant,
				 CORBA_Container new_container,
				 CORBA_Identifier new_name,
				 CORBA_VersionSpec new_version,
				 CORBA_Environment * ev)
{
}

static CORBA_StructDef impl_CORBA_StructDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_StructDef retval;
	impl_POA_CORBA_StructDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_StructDef, 1);
	newservant->servant.vepv = &impl_CORBA_StructDef_vepv;
	newservant->poa = poa;
	POA_CORBA_StructDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_StructDef__destroy(impl_POA_CORBA_StructDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_StructDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_StructMemberSeq *
 impl_CORBA_StructDef__get_members(impl_POA_CORBA_StructDef * servant,
				   CORBA_Environment * ev)
{
	CORBA_StructMemberSeq *retval;

	return retval;
}

void impl_CORBA_StructDef__set_members(impl_POA_CORBA_StructDef * servant,
				       CORBA_StructMemberSeq * value,
				       CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_StructDef__get_def_kind(impl_POA_CORBA_StructDef * servant,
				   CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_StructDef_destroy(impl_POA_CORBA_StructDef * servant,
				  CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_StructDef__get_id(impl_POA_CORBA_StructDef * servant,
			     CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_StructDef__set_id(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId value,
				  CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_StructDef__get_name(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_StructDef__set_name(impl_POA_CORBA_StructDef * servant,
				    CORBA_Identifier value,
				    CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_StructDef__get_version(impl_POA_CORBA_StructDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_StructDef__set_version(impl_POA_CORBA_StructDef * servant,
				       CORBA_VersionSpec value,
				       CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_StructDef__get_defined_in(impl_POA_CORBA_StructDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_StructDef__get_absolute_name(impl_POA_CORBA_StructDef * servant,
					CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_StructDef__get_containing_repository(impl_POA_CORBA_StructDef * servant,
						CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_StructDef_describe(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_StructDef_move(impl_POA_CORBA_StructDef * servant,
			       CORBA_Container new_container,
			       CORBA_Identifier new_name,
			       CORBA_VersionSpec new_version,
			       CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_StructDef__get_type(impl_POA_CORBA_StructDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_Contained
impl_CORBA_StructDef_lookup(impl_POA_CORBA_StructDef * servant,
			    CORBA_ScopedName search_name,
			    CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_StructDef_contents(impl_POA_CORBA_StructDef * servant,
			       CORBA_DefinitionKind limit_type,
			       CORBA_boolean exclude_inherited,
			       CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_StructDef_lookup_name(impl_POA_CORBA_StructDef * servant,
				  CORBA_Identifier search_name,
				  CORBA_long levels_to_search,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_StructDef_describe_contents(impl_POA_CORBA_StructDef * servant,
					CORBA_DefinitionKind limit_type,
					CORBA_boolean exclude_inherited,
					CORBA_long max_returned_objs,
					CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_StructDef_create_module(impl_POA_CORBA_StructDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	return retval;
}

CORBA_ConstantDef
impl_CORBA_StructDef_create_constant(impl_POA_CORBA_StructDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType type,
				     CORBA_any * value,
				     CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	return retval;
}

CORBA_StructDef
impl_CORBA_StructDef_create_struct(impl_POA_CORBA_StructDef * servant,
				   CORBA_RepositoryId id,
				   CORBA_Identifier name,
				   CORBA_VersionSpec version,
				   CORBA_StructMemberSeq * members,
				   CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	return retval;
}

CORBA_UnionDef
impl_CORBA_StructDef_create_union(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType discriminator_type,
				  CORBA_UnionMemberSeq * members,
				  CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	return retval;
}

CORBA_EnumDef
impl_CORBA_StructDef_create_enum(impl_POA_CORBA_StructDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_EnumMemberSeq * members,
				 CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	return retval;
}

CORBA_AliasDef
impl_CORBA_StructDef_create_alias(impl_POA_CORBA_StructDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_IDLType original_type,
				  CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	return retval;
}

CORBA_InterfaceDef
impl_CORBA_StructDef_create_interface(impl_POA_CORBA_StructDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				      CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	return retval;
}

CORBA_ExceptionDef
impl_CORBA_StructDef_create_exception(impl_POA_CORBA_StructDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	return retval;
}

static CORBA_UnionDef impl_CORBA_UnionDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_UnionDef retval;
	impl_POA_CORBA_UnionDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_UnionDef, 1);
	newservant->servant.vepv = &impl_CORBA_UnionDef_vepv;
	newservant->poa = poa;
	POA_CORBA_UnionDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_UnionDef__destroy(impl_POA_CORBA_UnionDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_UnionDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_UnionDef__get_discriminator_type(impl_POA_CORBA_UnionDef * servant,
					    CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_UnionDef__get_discriminator_type_def(impl_POA_CORBA_UnionDef * servant,
						CORBA_Environment * ev)
{
	CORBA_IDLType retval;

	return retval;
}

void impl_CORBA_UnionDef__set_discriminator_type_def(impl_POA_CORBA_UnionDef * servant,
						     CORBA_IDLType value,
						  CORBA_Environment * ev)
{
}

CORBA_UnionMemberSeq *
 impl_CORBA_UnionDef__get_members(impl_POA_CORBA_UnionDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_UnionMemberSeq *retval;

	return retval;
}

void impl_CORBA_UnionDef__set_members(impl_POA_CORBA_UnionDef * servant,
				      CORBA_UnionMemberSeq * value,
				      CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_UnionDef__get_def_kind(impl_POA_CORBA_UnionDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_UnionDef_destroy(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_UnionDef__get_id(impl_POA_CORBA_UnionDef * servant,
			    CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_UnionDef__set_id(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_UnionDef__get_name(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_UnionDef__set_name(impl_POA_CORBA_UnionDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_UnionDef__get_version(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_UnionDef__set_version(impl_POA_CORBA_UnionDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_UnionDef__get_defined_in(impl_POA_CORBA_UnionDef * servant,
				    CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_UnionDef__get_absolute_name(impl_POA_CORBA_UnionDef * servant,
				       CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_UnionDef__get_containing_repository(impl_POA_CORBA_UnionDef * servant,
					       CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_UnionDef_describe(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_UnionDef_move(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_UnionDef__get_type(impl_POA_CORBA_UnionDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_Contained
impl_CORBA_UnionDef_lookup(impl_POA_CORBA_UnionDef * servant,
			   CORBA_ScopedName search_name,
			   CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_UnionDef_contents(impl_POA_CORBA_UnionDef * servant,
			      CORBA_DefinitionKind limit_type,
			      CORBA_boolean exclude_inherited,
			      CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_UnionDef_lookup_name(impl_POA_CORBA_UnionDef * servant,
				 CORBA_Identifier search_name,
				 CORBA_long levels_to_search,
				 CORBA_DefinitionKind limit_type,
				 CORBA_boolean exclude_inherited,
				 CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_UnionDef_describe_contents(impl_POA_CORBA_UnionDef * servant,
				       CORBA_DefinitionKind limit_type,
				       CORBA_boolean exclude_inherited,
				       CORBA_long max_returned_objs,
				       CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_UnionDef_create_module(impl_POA_CORBA_UnionDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	return retval;
}

CORBA_ConstantDef
impl_CORBA_UnionDef_create_constant(impl_POA_CORBA_UnionDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_IDLType type,
				    CORBA_any * value,
				    CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	return retval;
}

CORBA_StructDef
impl_CORBA_UnionDef_create_struct(impl_POA_CORBA_UnionDef * servant,
				  CORBA_RepositoryId id,
				  CORBA_Identifier name,
				  CORBA_VersionSpec version,
				  CORBA_StructMemberSeq * members,
				  CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	return retval;
}

CORBA_UnionDef
impl_CORBA_UnionDef_create_union(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_IDLType discriminator_type,
				 CORBA_UnionMemberSeq * members,
				 CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	return retval;
}

CORBA_EnumDef
impl_CORBA_UnionDef_create_enum(impl_POA_CORBA_UnionDef * servant,
				CORBA_RepositoryId id,
				CORBA_Identifier name,
				CORBA_VersionSpec version,
				CORBA_EnumMemberSeq * members,
				CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	return retval;
}

CORBA_AliasDef
impl_CORBA_UnionDef_create_alias(impl_POA_CORBA_UnionDef * servant,
				 CORBA_RepositoryId id,
				 CORBA_Identifier name,
				 CORBA_VersionSpec version,
				 CORBA_IDLType original_type,
				 CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	return retval;
}

CORBA_InterfaceDef
impl_CORBA_UnionDef_create_interface(impl_POA_CORBA_UnionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
				     CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	return retval;
}

CORBA_ExceptionDef
impl_CORBA_UnionDef_create_exception(impl_POA_CORBA_UnionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_StructMemberSeq * members,
				     CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	return retval;
}

static CORBA_EnumDef impl_CORBA_EnumDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_EnumDef retval;
	impl_POA_CORBA_EnumDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_EnumDef, 1);
	newservant->servant.vepv = &impl_CORBA_EnumDef_vepv;
	newservant->poa = poa;
	POA_CORBA_EnumDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_EnumDef__destroy(impl_POA_CORBA_EnumDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_EnumDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_EnumMemberSeq *
 impl_CORBA_EnumDef__get_members(impl_POA_CORBA_EnumDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_EnumMemberSeq *retval;

	return retval;
}

void impl_CORBA_EnumDef__set_members(impl_POA_CORBA_EnumDef * servant,
				     CORBA_EnumMemberSeq * value,
				     CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_EnumDef__get_def_kind(impl_POA_CORBA_EnumDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_EnumDef_destroy(impl_POA_CORBA_EnumDef * servant,
				CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_EnumDef__get_id(impl_POA_CORBA_EnumDef * servant,
			   CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_EnumDef__set_id(impl_POA_CORBA_EnumDef * servant,
				CORBA_RepositoryId value,
				CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_EnumDef__get_name(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_EnumDef__set_name(impl_POA_CORBA_EnumDef * servant,
				  CORBA_Identifier value,
				  CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_EnumDef__get_version(impl_POA_CORBA_EnumDef * servant,
				CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_EnumDef__set_version(impl_POA_CORBA_EnumDef * servant,
				     CORBA_VersionSpec value,
				     CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_EnumDef__get_defined_in(impl_POA_CORBA_EnumDef * servant,
				   CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_EnumDef__get_absolute_name(impl_POA_CORBA_EnumDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_EnumDef__get_containing_repository(impl_POA_CORBA_EnumDef * servant,
					      CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_EnumDef_describe(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_EnumDef_move(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Container new_container,
			     CORBA_Identifier new_name,
			     CORBA_VersionSpec new_version,
			     CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_EnumDef__get_type(impl_POA_CORBA_EnumDef * servant,
			     CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_AliasDef impl_CORBA_AliasDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_AliasDef retval;
	impl_POA_CORBA_AliasDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_AliasDef, 1);
	newservant->servant.vepv = &impl_CORBA_AliasDef_vepv;
	newservant->poa = poa;
	POA_CORBA_AliasDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_AliasDef__destroy(impl_POA_CORBA_AliasDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_AliasDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_IDLType
impl_CORBA_AliasDef__get_original_type_def(impl_POA_CORBA_AliasDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_IDLType retval;

	return retval;
}

void impl_CORBA_AliasDef__set_original_type_def(impl_POA_CORBA_AliasDef * servant,
						CORBA_IDLType value,
						CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_AliasDef__get_def_kind(impl_POA_CORBA_AliasDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_AliasDef_destroy(impl_POA_CORBA_AliasDef * servant,
				 CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_AliasDef__get_id(impl_POA_CORBA_AliasDef * servant,
			    CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_AliasDef__set_id(impl_POA_CORBA_AliasDef * servant,
				 CORBA_RepositoryId value,
				 CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_AliasDef__get_name(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_AliasDef__set_name(impl_POA_CORBA_AliasDef * servant,
				   CORBA_Identifier value,
				   CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_AliasDef__get_version(impl_POA_CORBA_AliasDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_AliasDef__set_version(impl_POA_CORBA_AliasDef * servant,
				      CORBA_VersionSpec value,
				      CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_AliasDef__get_defined_in(impl_POA_CORBA_AliasDef * servant,
				    CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_AliasDef__get_absolute_name(impl_POA_CORBA_AliasDef * servant,
				       CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_AliasDef__get_containing_repository(impl_POA_CORBA_AliasDef * servant,
					       CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_AliasDef_describe(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_AliasDef_move(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Container new_container,
			      CORBA_Identifier new_name,
			      CORBA_VersionSpec new_version,
			      CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_AliasDef__get_type(impl_POA_CORBA_AliasDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_PrimitiveDef impl_CORBA_PrimitiveDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_PrimitiveDef retval;
	impl_POA_CORBA_PrimitiveDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_PrimitiveDef, 1);
	newservant->servant.vepv = &impl_CORBA_PrimitiveDef_vepv;
	newservant->poa = poa;
	POA_CORBA_PrimitiveDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_PrimitiveDef__destroy(impl_POA_CORBA_PrimitiveDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_PrimitiveDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_PrimitiveKind
impl_CORBA_PrimitiveDef__get_kind(impl_POA_CORBA_PrimitiveDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_PrimitiveKind retval;

	return retval;
}

CORBA_DefinitionKind
impl_CORBA_PrimitiveDef__get_def_kind(impl_POA_CORBA_PrimitiveDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_PrimitiveDef_destroy(impl_POA_CORBA_PrimitiveDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_PrimitiveDef__get_type(impl_POA_CORBA_PrimitiveDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_StringDef impl_CORBA_StringDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_StringDef retval;
	impl_POA_CORBA_StringDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_StringDef, 1);
	newservant->servant.vepv = &impl_CORBA_StringDef_vepv;
	newservant->poa = poa;
	POA_CORBA_StringDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_StringDef__destroy(impl_POA_CORBA_StringDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_StringDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_long
impl_CORBA_StringDef__get_bound(impl_POA_CORBA_StringDef * servant,
				CORBA_Environment * ev)
{
	CORBA_unsigned_long retval;

	return retval;
}

void impl_CORBA_StringDef__set_bound(impl_POA_CORBA_StringDef * servant,
				     CORBA_unsigned_long value,
				     CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_StringDef__get_def_kind(impl_POA_CORBA_StringDef * servant,
				   CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_StringDef_destroy(impl_POA_CORBA_StringDef * servant,
				  CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_StringDef__get_type(impl_POA_CORBA_StringDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_WstringDef impl_CORBA_WstringDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_WstringDef retval;
	impl_POA_CORBA_WstringDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_WstringDef, 1);
	newservant->servant.vepv = &impl_CORBA_WstringDef_vepv;
	newservant->poa = poa;
	POA_CORBA_WstringDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_WstringDef__destroy(impl_POA_CORBA_WstringDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_WstringDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_long
impl_CORBA_WstringDef__get_bound(impl_POA_CORBA_WstringDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_unsigned_long retval;

	return retval;
}

void impl_CORBA_WstringDef__set_bound(impl_POA_CORBA_WstringDef * servant,
				      CORBA_unsigned_long value,
				      CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_WstringDef__get_def_kind(impl_POA_CORBA_WstringDef * servant,
				    CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_WstringDef_destroy(impl_POA_CORBA_WstringDef * servant,
				   CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_WstringDef__get_type(impl_POA_CORBA_WstringDef * servant,
				CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_FixedDef impl_CORBA_FixedDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_FixedDef retval;
	impl_POA_CORBA_FixedDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_FixedDef, 1);
	newservant->servant.vepv = &impl_CORBA_FixedDef_vepv;
	newservant->poa = poa;
	POA_CORBA_FixedDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_FixedDef__destroy(impl_POA_CORBA_FixedDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_FixedDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_short
impl_CORBA_FixedDef__get_digits(impl_POA_CORBA_FixedDef * servant,
				CORBA_Environment * ev)
{
	CORBA_unsigned_short retval;

	return retval;
}

void impl_CORBA_FixedDef__set_digits(impl_POA_CORBA_FixedDef * servant,
				     CORBA_unsigned_short value,
				     CORBA_Environment * ev)
{
}

CORBA_short
impl_CORBA_FixedDef__get_scale(impl_POA_CORBA_FixedDef * servant,
			       CORBA_Environment * ev)
{
	CORBA_short retval;

	return retval;
}

void impl_CORBA_FixedDef__set_scale(impl_POA_CORBA_FixedDef * servant,
				    CORBA_short value,
				    CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_FixedDef__get_def_kind(impl_POA_CORBA_FixedDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_FixedDef_destroy(impl_POA_CORBA_FixedDef * servant,
				 CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_FixedDef__get_type(impl_POA_CORBA_FixedDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_SequenceDef impl_CORBA_SequenceDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_SequenceDef retval;
	impl_POA_CORBA_SequenceDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_SequenceDef, 1);
	newservant->servant.vepv = &impl_CORBA_SequenceDef_vepv;
	newservant->poa = poa;
	POA_CORBA_SequenceDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_SequenceDef__destroy(impl_POA_CORBA_SequenceDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_SequenceDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_long
impl_CORBA_SequenceDef__get_bound(impl_POA_CORBA_SequenceDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_unsigned_long retval;

	return retval;
}

void impl_CORBA_SequenceDef__set_bound(impl_POA_CORBA_SequenceDef * servant,
				       CORBA_unsigned_long value,
				       CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_SequenceDef__get_element_type(impl_POA_CORBA_SequenceDef * servant,
					 CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_SequenceDef__get_element_type_def(impl_POA_CORBA_SequenceDef * servant,
					     CORBA_Environment * ev)
{
	CORBA_IDLType retval;

	return retval;
}

void impl_CORBA_SequenceDef__set_element_type_def(impl_POA_CORBA_SequenceDef * servant,
						  CORBA_IDLType value,
						  CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_SequenceDef__get_def_kind(impl_POA_CORBA_SequenceDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_SequenceDef_destroy(impl_POA_CORBA_SequenceDef * servant,
				    CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_SequenceDef__get_type(impl_POA_CORBA_SequenceDef * servant,
				 CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_ArrayDef impl_CORBA_ArrayDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_ArrayDef retval;
	impl_POA_CORBA_ArrayDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_ArrayDef, 1);
	newservant->servant.vepv = &impl_CORBA_ArrayDef_vepv;
	newservant->poa = poa;
	POA_CORBA_ArrayDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_ArrayDef__destroy(impl_POA_CORBA_ArrayDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_ArrayDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_unsigned_long
impl_CORBA_ArrayDef__get_length(impl_POA_CORBA_ArrayDef * servant,
				CORBA_Environment * ev)
{
	CORBA_unsigned_long retval;

	return retval;
}

void impl_CORBA_ArrayDef__set_length(impl_POA_CORBA_ArrayDef * servant,
				     CORBA_unsigned_long value,
				     CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_ArrayDef__get_element_type(impl_POA_CORBA_ArrayDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_ArrayDef__get_element_type_def(impl_POA_CORBA_ArrayDef * servant,
					  CORBA_Environment * ev)
{
	CORBA_IDLType retval;

	return retval;
}

void impl_CORBA_ArrayDef__set_element_type_def(impl_POA_CORBA_ArrayDef * servant,
					       CORBA_IDLType value,
					       CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_ArrayDef__get_def_kind(impl_POA_CORBA_ArrayDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_ArrayDef_destroy(impl_POA_CORBA_ArrayDef * servant,
				 CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_ArrayDef__get_type(impl_POA_CORBA_ArrayDef * servant,
			      CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

static CORBA_ExceptionDef impl_CORBA_ExceptionDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;
	impl_POA_CORBA_ExceptionDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_ExceptionDef, 1);
	newservant->servant.vepv = &impl_CORBA_ExceptionDef_vepv;
	newservant->poa = poa;
	POA_CORBA_ExceptionDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_ExceptionDef__destroy(impl_POA_CORBA_ExceptionDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_ExceptionDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_ExceptionDef__get_type(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_StructMemberSeq *
 impl_CORBA_ExceptionDef__get_members(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_StructMemberSeq *retval;

	return retval;
}

void impl_CORBA_ExceptionDef__set_members(impl_POA_CORBA_ExceptionDef * servant,
					  CORBA_StructMemberSeq * value,
					  CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_ExceptionDef__get_def_kind(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_ExceptionDef_destroy(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_ExceptionDef__get_id(impl_POA_CORBA_ExceptionDef * servant,
				CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_ExceptionDef__set_id(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId value,
				     CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_ExceptionDef__get_name(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_ExceptionDef__set_name(impl_POA_CORBA_ExceptionDef * servant,
				       CORBA_Identifier value,
				       CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_ExceptionDef__get_version(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_ExceptionDef__set_version(impl_POA_CORBA_ExceptionDef * servant,
					  CORBA_VersionSpec value,
					  CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_ExceptionDef__get_defined_in(impl_POA_CORBA_ExceptionDef * servant,
					CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_ExceptionDef__get_absolute_name(impl_POA_CORBA_ExceptionDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_ExceptionDef__get_containing_repository(impl_POA_CORBA_ExceptionDef * servant,
						   CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_ExceptionDef_describe(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_ExceptionDef_move(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_Container new_container,
				  CORBA_Identifier new_name,
				  CORBA_VersionSpec new_version,
				  CORBA_Environment * ev)
{
}

CORBA_Contained
impl_CORBA_ExceptionDef_lookup(impl_POA_CORBA_ExceptionDef * servant,
			       CORBA_ScopedName search_name,
			       CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_ExceptionDef_contents(impl_POA_CORBA_ExceptionDef * servant,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_ExceptionDef_lookup_name(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_Identifier search_name,
				     CORBA_long levels_to_search,
				     CORBA_DefinitionKind limit_type,
				     CORBA_boolean exclude_inherited,
				     CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_ExceptionDef_describe_contents(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					   CORBA_long max_returned_objs,
					   CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_ExceptionDef_create_module(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	return retval;
}

CORBA_ConstantDef
impl_CORBA_ExceptionDef_create_constant(impl_POA_CORBA_ExceptionDef * servant,
					CORBA_RepositoryId id,
					CORBA_Identifier name,
					CORBA_VersionSpec version,
					CORBA_IDLType type,
					CORBA_any * value,
					CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	return retval;
}

CORBA_StructDef
impl_CORBA_ExceptionDef_create_struct(impl_POA_CORBA_ExceptionDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	return retval;
}

CORBA_UnionDef
impl_CORBA_ExceptionDef_create_union(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType discriminator_type,
				     CORBA_UnionMemberSeq * members,
				     CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	return retval;
}

CORBA_EnumDef
impl_CORBA_ExceptionDef_create_enum(impl_POA_CORBA_ExceptionDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_EnumMemberSeq * members,
				    CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	return retval;
}

CORBA_AliasDef
impl_CORBA_ExceptionDef_create_alias(impl_POA_CORBA_ExceptionDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType original_type,
				     CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	return retval;
}

CORBA_InterfaceDef
impl_CORBA_ExceptionDef_create_interface(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
					 CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	return retval;
}

CORBA_ExceptionDef
impl_CORBA_ExceptionDef_create_exception(impl_POA_CORBA_ExceptionDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_StructMemberSeq * members,
					 CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	return retval;
}

static CORBA_AttributeDef impl_CORBA_AttributeDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_AttributeDef retval;
	impl_POA_CORBA_AttributeDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_AttributeDef, 1);
	newservant->servant.vepv = &impl_CORBA_AttributeDef_vepv;
	newservant->poa = poa;
	POA_CORBA_AttributeDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_AttributeDef__destroy(impl_POA_CORBA_AttributeDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_AttributeDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_AttributeDef__get_type(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_AttributeDef__get_type_def(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_IDLType retval;

	return retval;
}

void impl_CORBA_AttributeDef__set_type_def(impl_POA_CORBA_AttributeDef * servant,
					   CORBA_IDLType value,
					   CORBA_Environment * ev)
{
}

CORBA_AttributeMode
impl_CORBA_AttributeDef__get_mode(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_AttributeMode retval;

	return retval;
}

void impl_CORBA_AttributeDef__set_mode(impl_POA_CORBA_AttributeDef * servant,
				       CORBA_AttributeMode value,
				       CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_AttributeDef__get_def_kind(impl_POA_CORBA_AttributeDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_AttributeDef_destroy(impl_POA_CORBA_AttributeDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_AttributeDef__get_id(impl_POA_CORBA_AttributeDef * servant,
				CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_AttributeDef__set_id(impl_POA_CORBA_AttributeDef * servant,
				     CORBA_RepositoryId value,
				     CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_AttributeDef__get_name(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_AttributeDef__set_name(impl_POA_CORBA_AttributeDef * servant,
				       CORBA_Identifier value,
				       CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_AttributeDef__get_version(impl_POA_CORBA_AttributeDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_AttributeDef__set_version(impl_POA_CORBA_AttributeDef * servant,
					  CORBA_VersionSpec value,
					  CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_AttributeDef__get_defined_in(impl_POA_CORBA_AttributeDef * servant,
					CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_AttributeDef__get_absolute_name(impl_POA_CORBA_AttributeDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_AttributeDef__get_containing_repository(impl_POA_CORBA_AttributeDef * servant,
						   CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_AttributeDef_describe(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_AttributeDef_move(impl_POA_CORBA_AttributeDef * servant,
				  CORBA_Container new_container,
				  CORBA_Identifier new_name,
				  CORBA_VersionSpec new_version,
				  CORBA_Environment * ev)
{
}

static CORBA_OperationDef impl_CORBA_OperationDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_OperationDef retval;
	impl_POA_CORBA_OperationDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_OperationDef, 1);
	newservant->servant.vepv = &impl_CORBA_OperationDef_vepv;
	newservant->poa = poa;
	POA_CORBA_OperationDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_OperationDef__destroy(impl_POA_CORBA_OperationDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_OperationDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_TypeCode
impl_CORBA_OperationDef__get_result(impl_POA_CORBA_OperationDef * servant,
				    CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

CORBA_IDLType
impl_CORBA_OperationDef__get_result_def(impl_POA_CORBA_OperationDef * servant,
					CORBA_Environment * ev)
{
	CORBA_IDLType retval;

	return retval;
}

void impl_CORBA_OperationDef__set_result_def(impl_POA_CORBA_OperationDef * servant,
					     CORBA_IDLType value,
					     CORBA_Environment * ev)
{
}

CORBA_ParDescriptionSeq *
 impl_CORBA_OperationDef__get_params(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_ParDescriptionSeq *retval;

	return retval;
}

void impl_CORBA_OperationDef__set_params(impl_POA_CORBA_OperationDef * servant,
					 CORBA_ParDescriptionSeq * value,
					 CORBA_Environment * ev)
{
}

CORBA_OperationMode
impl_CORBA_OperationDef__get_mode(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_OperationMode retval;

	return retval;
}

void impl_CORBA_OperationDef__set_mode(impl_POA_CORBA_OperationDef * servant,
				       CORBA_OperationMode value,
				       CORBA_Environment * ev)
{
}

CORBA_ContextIdSeq *
 impl_CORBA_OperationDef__get_contexts(impl_POA_CORBA_OperationDef * servant,
				       CORBA_Environment * ev)
{
	CORBA_ContextIdSeq *retval;

	return retval;
}

void impl_CORBA_OperationDef__set_contexts(impl_POA_CORBA_OperationDef * servant,
					   CORBA_ContextIdSeq * value,
					   CORBA_Environment * ev)
{
}

CORBA_ExceptionDefSeq *
 impl_CORBA_OperationDef__get_exceptions(impl_POA_CORBA_OperationDef * servant,
					 CORBA_Environment * ev)
{
	CORBA_ExceptionDefSeq *retval;

	return retval;
}

void impl_CORBA_OperationDef__set_exceptions(impl_POA_CORBA_OperationDef * servant,
					   CORBA_ExceptionDefSeq * value,
					     CORBA_Environment * ev)
{
}

CORBA_DefinitionKind
impl_CORBA_OperationDef__get_def_kind(impl_POA_CORBA_OperationDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_OperationDef_destroy(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_RepositoryId
impl_CORBA_OperationDef__get_id(impl_POA_CORBA_OperationDef * servant,
				CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_OperationDef__set_id(impl_POA_CORBA_OperationDef * servant,
				     CORBA_RepositoryId value,
				     CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_OperationDef__get_name(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_OperationDef__set_name(impl_POA_CORBA_OperationDef * servant,
				       CORBA_Identifier value,
				       CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_OperationDef__get_version(impl_POA_CORBA_OperationDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_OperationDef__set_version(impl_POA_CORBA_OperationDef * servant,
					  CORBA_VersionSpec value,
					  CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_OperationDef__get_defined_in(impl_POA_CORBA_OperationDef * servant,
					CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_OperationDef__get_absolute_name(impl_POA_CORBA_OperationDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_OperationDef__get_containing_repository(impl_POA_CORBA_OperationDef * servant,
						   CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_OperationDef_describe(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_OperationDef_move(impl_POA_CORBA_OperationDef * servant,
				  CORBA_Container new_container,
				  CORBA_Identifier new_name,
				  CORBA_VersionSpec new_version,
				  CORBA_Environment * ev)
{
}

static CORBA_InterfaceDef impl_CORBA_InterfaceDef__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;
	impl_POA_CORBA_InterfaceDef *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_CORBA_InterfaceDef, 1);
	newservant->servant.vepv = &impl_CORBA_InterfaceDef_vepv;
	newservant->poa = poa;
	POA_CORBA_InterfaceDef__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);
	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

/* You shouldn't call this routine directly without first deactivating the servant... */
static void impl_CORBA_InterfaceDef__destroy(impl_POA_CORBA_InterfaceDef * servant, CORBA_Environment * ev)
{

	POA_CORBA_InterfaceDef__fini((PortableServer_Servant) servant, ev);
	g_free(servant);
}

CORBA_InterfaceDefSeq *
 impl_CORBA_InterfaceDef__get_base_interfaces(impl_POA_CORBA_InterfaceDef * servant,
					      CORBA_Environment * ev)
{
	CORBA_InterfaceDefSeq *retval;

	return retval;
}

void impl_CORBA_InterfaceDef__set_base_interfaces(impl_POA_CORBA_InterfaceDef * servant,
					   CORBA_InterfaceDefSeq * value,
						  CORBA_Environment * ev)
{
}

CORBA_boolean
impl_CORBA_InterfaceDef_is_a(impl_POA_CORBA_InterfaceDef * servant,
			     CORBA_RepositoryId interface_id,
			     CORBA_Environment * ev)
{
	CORBA_boolean retval;

	return retval;
}

CORBA_InterfaceDef_FullInterfaceDescription *
 impl_CORBA_InterfaceDef_describe_interface(impl_POA_CORBA_InterfaceDef * servant,
					    CORBA_Environment * ev)
{
	CORBA_InterfaceDef_FullInterfaceDescription *retval;

	return retval;
}

CORBA_AttributeDef
impl_CORBA_InterfaceDef_create_attribute(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_IDLType type,
					 CORBA_AttributeMode mode,
					 CORBA_Environment * ev)
{
	CORBA_AttributeDef retval;

	return retval;
}

CORBA_OperationDef
impl_CORBA_InterfaceDef_create_operation(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_IDLType result,
					 CORBA_OperationMode mode,
					 CORBA_ParDescriptionSeq * params,
				      CORBA_ExceptionDefSeq * exceptions,
					 CORBA_ContextIdSeq * contexts,
					 CORBA_Environment * ev)
{
	CORBA_OperationDef retval;

	return retval;
}

CORBA_DefinitionKind
impl_CORBA_InterfaceDef__get_def_kind(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_Environment * ev)
{
	CORBA_DefinitionKind retval;

	return retval;
}

void impl_CORBA_InterfaceDef_destroy(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Environment * ev)
{
}

CORBA_Contained
impl_CORBA_InterfaceDef_lookup(impl_POA_CORBA_InterfaceDef * servant,
			       CORBA_ScopedName search_name,
			       CORBA_Environment * ev)
{
	CORBA_Contained retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_InterfaceDef_contents(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_DefinitionKind limit_type,
				  CORBA_boolean exclude_inherited,
				  CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_ContainedSeq *
 impl_CORBA_InterfaceDef_lookup_name(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Identifier search_name,
				     CORBA_long levels_to_search,
				     CORBA_DefinitionKind limit_type,
				     CORBA_boolean exclude_inherited,
				     CORBA_Environment * ev)
{
	CORBA_ContainedSeq *retval;

	return retval;
}

CORBA_Container_DescriptionSeq *
 impl_CORBA_InterfaceDef_describe_contents(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_DefinitionKind limit_type,
					 CORBA_boolean exclude_inherited,
					   CORBA_long max_returned_objs,
					   CORBA_Environment * ev)
{
	CORBA_Container_DescriptionSeq *retval;

	return retval;
}

CORBA_ModuleDef
impl_CORBA_InterfaceDef_create_module(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_Environment * ev)
{
	CORBA_ModuleDef retval;

	return retval;
}

CORBA_ConstantDef
impl_CORBA_InterfaceDef_create_constant(impl_POA_CORBA_InterfaceDef * servant,
					CORBA_RepositoryId id,
					CORBA_Identifier name,
					CORBA_VersionSpec version,
					CORBA_IDLType type,
					CORBA_any * value,
					CORBA_Environment * ev)
{
	CORBA_ConstantDef retval;

	return retval;
}

CORBA_StructDef
impl_CORBA_InterfaceDef_create_struct(impl_POA_CORBA_InterfaceDef * servant,
				      CORBA_RepositoryId id,
				      CORBA_Identifier name,
				      CORBA_VersionSpec version,
				      CORBA_StructMemberSeq * members,
				      CORBA_Environment * ev)
{
	CORBA_StructDef retval;

	return retval;
}

CORBA_UnionDef
impl_CORBA_InterfaceDef_create_union(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType discriminator_type,
				     CORBA_UnionMemberSeq * members,
				     CORBA_Environment * ev)
{
	CORBA_UnionDef retval;

	return retval;
}

CORBA_EnumDef
impl_CORBA_InterfaceDef_create_enum(impl_POA_CORBA_InterfaceDef * servant,
				    CORBA_RepositoryId id,
				    CORBA_Identifier name,
				    CORBA_VersionSpec version,
				    CORBA_EnumMemberSeq * members,
				    CORBA_Environment * ev)
{
	CORBA_EnumDef retval;

	return retval;
}

CORBA_AliasDef
impl_CORBA_InterfaceDef_create_alias(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId id,
				     CORBA_Identifier name,
				     CORBA_VersionSpec version,
				     CORBA_IDLType original_type,
				     CORBA_Environment * ev)
{
	CORBA_AliasDef retval;

	return retval;
}

CORBA_InterfaceDef
impl_CORBA_InterfaceDef_create_interface(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
				 CORBA_InterfaceDefSeq * base_interfaces,
					 CORBA_Environment * ev)
{
	CORBA_InterfaceDef retval;

	return retval;
}

CORBA_ExceptionDef
impl_CORBA_InterfaceDef_create_exception(impl_POA_CORBA_InterfaceDef * servant,
					 CORBA_RepositoryId id,
					 CORBA_Identifier name,
					 CORBA_VersionSpec version,
					 CORBA_StructMemberSeq * members,
					 CORBA_Environment * ev)
{
	CORBA_ExceptionDef retval;

	return retval;
}

CORBA_RepositoryId
impl_CORBA_InterfaceDef__get_id(impl_POA_CORBA_InterfaceDef * servant,
				CORBA_Environment * ev)
{
	CORBA_RepositoryId retval;

	return retval;
}

void impl_CORBA_InterfaceDef__set_id(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_RepositoryId value,
				     CORBA_Environment * ev)
{
}

CORBA_Identifier
impl_CORBA_InterfaceDef__get_name(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Identifier retval;

	return retval;
}

void impl_CORBA_InterfaceDef__set_name(impl_POA_CORBA_InterfaceDef * servant,
				       CORBA_Identifier value,
				       CORBA_Environment * ev)
{
}

CORBA_VersionSpec
impl_CORBA_InterfaceDef__get_version(impl_POA_CORBA_InterfaceDef * servant,
				     CORBA_Environment * ev)
{
	CORBA_VersionSpec retval;

	return retval;
}

void impl_CORBA_InterfaceDef__set_version(impl_POA_CORBA_InterfaceDef * servant,
					  CORBA_VersionSpec value,
					  CORBA_Environment * ev)
{
}

CORBA_Container
impl_CORBA_InterfaceDef__get_defined_in(impl_POA_CORBA_InterfaceDef * servant,
					CORBA_Environment * ev)
{
	CORBA_Container retval;

	return retval;
}

CORBA_ScopedName
impl_CORBA_InterfaceDef__get_absolute_name(impl_POA_CORBA_InterfaceDef * servant,
					   CORBA_Environment * ev)
{
	CORBA_ScopedName retval;

	return retval;
}

CORBA_Repository
impl_CORBA_InterfaceDef__get_containing_repository(impl_POA_CORBA_InterfaceDef * servant,
						   CORBA_Environment * ev)
{
	CORBA_Repository retval;

	return retval;
}

CORBA_Contained_Description *
 impl_CORBA_InterfaceDef_describe(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_Contained_Description *retval;

	return retval;
}

void impl_CORBA_InterfaceDef_move(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Container new_container,
				  CORBA_Identifier new_name,
				  CORBA_VersionSpec new_version,
				  CORBA_Environment * ev)
{
}

CORBA_TypeCode
impl_CORBA_InterfaceDef__get_type(impl_POA_CORBA_InterfaceDef * servant,
				  CORBA_Environment * ev)
{
	CORBA_TypeCode retval;

	return retval;
}

int main(int argc, char **argv)
{
	PortableServer_POA poa;
	CORBA_Environment ev;
	char *retval;
	CORBA_ORB orb;
	CORBA_Repository client;

	CORBA_exception_init(&ev);
	orb = CORBA_ORB_init(&argc, argv, "orbit-local-orb", &ev);

	poa = (PortableServer_POA)CORBA_ORB_resolve_initial_references(orb, "RootPOA", &ev);
	PortableServer_POAManager_activate(PortableServer_POA__get_the_POAManager(poa, &ev), &ev);

	client = impl_CORBA_Repository__create(poa, &ev);
	if(!client) {
		g_print("Cannot get object reference for Interface Repository\n");
		exit(-1);
	}

	retval = CORBA_ORB_object_to_string(orb, client, &ev);
	g_print("Interface Repository: %s\n", retval);
	fflush(stdout);
	CORBA_free(retval);

	CORBA_ORB_run(orb, &ev);

	exit(0);
}
