/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 *
 * Copyright 2009-2010  Red Hat, Inc,
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by: Matthias Clasen <mclasen@redhat.com>
 */

#include "config.h"

#include <glib.h>
#include <glib/gi18n.h>

#include "um-utils.h"
#include "um-user-manager.h"

gchar *
um_compute_short_name (const gchar *name)
{
        gchar **names;
        gint len;
        gchar *shortname;
        gchar *res;
        gchar *tmp;
        gint i;
        UmUserManager *manager;
        UmUser *user;

        /* TODO: pluggable algorithms for this */
        names = g_strsplit (name, " ", 0);
        len = g_strv_length (names);

        if (len == 0) {
                shortname = g_strdup ("");
        }
        else if (len == 1) {
                shortname = g_strndup (names[0], 8);
        }
        else {
                gchar *first;
                gchar *suffix;
                first = g_strndup (names[0], 1);
                suffix = g_strndup (names[1], 7);
                shortname = g_strconcat (first, suffix, NULL);
                g_free (first);
                g_free (suffix);
        }

        res = g_ascii_strdown (shortname, -1);

        g_strfreev (names);
        g_free (shortname);

        if (res && res[0]) {
                manager = um_user_manager_ref_default ();
                tmp = g_strdup (res);
                for (i = 2; i < 10; i++) {
                        user = um_user_manager_get_user (manager, tmp);
                        if (user == NULL) {
                                g_free (res);
                                res = tmp;
                                break;
                        }
                        g_free (tmp);
                        tmp = g_strdup_printf ("%s%d", res, i);
                }
                g_object_unref (manager);
        }

        return res;
}
