/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-zoom.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-editor-zoom
 * @title: IAnjutaEditorZoom
 * @short_description: Text editor zoom interface
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-zoom.h
 * 
 */

#include "ianjuta-editor-zoom.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_zoom_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-zoom-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_zoom_in:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Zoom in
 */
void
ianjuta_editor_zoom_in (IAnjutaEditorZoom *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ZOOM(obj));
	IANJUTA_EDITOR_ZOOM_GET_IFACE (obj)->in (obj, err);
}

/**
 * ianjuta_editor_zoom_out:
 * @obj: Self
 * @err: Error propagation and reporting
 *
 * Zoom out
 */
void
ianjuta_editor_zoom_out (IAnjutaEditorZoom *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_EDITOR_ZOOM(obj));
	IANJUTA_EDITOR_ZOOM_GET_IFACE (obj)->out (obj, err);
}

static void
ianjuta_editor_zoom_base_init (gpointer gclass)
{
	static gboolean initialized = FALSE;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_zoom_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorZoomIface),
			ianjuta_editor_zoom_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorZoom", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_EDITOR);
	}
	return type;			
}
