/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-file-savable.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-file-savable
 * @title: IAnjutaFileSavable
 * @short_description: Implemented by plugins that can save files.
 * @see_also: #IAnjutaFile
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-file-savable.h
 * 
 * Plugins implementing #IAnjutaFile inteface that can also save files
 * should also implement this interface.
 */

#include "ianjuta-file-savable.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_file_savable_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-file-savable-quark");
	}
	
	return quark;
}

/**
 * ianjuta_file_savable_is_dirty:
 * @obj: Self
 * @err: Error propagation and reporting
 * 
 * Returns the dirty status of the content.
 *
 * Return value: TRUE if dirty, FALSE otherwise.
 */
gboolean
ianjuta_file_savable_is_dirty (IAnjutaFileSavable *obj, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_FILE_SAVABLE(obj), FALSE);
	return IANJUTA_FILE_SAVABLE_GET_IFACE (obj)->is_dirty (obj, err);
}

/* Default implementation */
static gboolean
ianjuta_file_savable_is_dirty_default (IAnjutaFileSavable *obj, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
 * ianjuta_file_savable_save:
 * @obj: Self
 * @err: Error propagation and reporting
 * 
 * Saves the content to the original URI from which it was loaded.
 */
void
ianjuta_file_savable_save (IAnjutaFileSavable *obj, GError **err)
{
	g_return_if_fail (IANJUTA_IS_FILE_SAVABLE(obj));
	IANJUTA_FILE_SAVABLE_GET_IFACE (obj)->save (obj, err);
}

/* Default implementation */
static void
ianjuta_file_savable_save_default (IAnjutaFileSavable *obj, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_file_savable_save_as:
 * @obj: Self
 * @uri: URI to save the content.
 * @err: Error propagation and reporting
 * 
 * Saves the content to a different URI.
 */
void
ianjuta_file_savable_save_as (IAnjutaFileSavable *obj, const gchar *uri, GError **err)
{
	g_return_if_fail (IANJUTA_IS_FILE_SAVABLE(obj));
	g_return_if_fail (uri != NULL);
	IANJUTA_FILE_SAVABLE_GET_IFACE (obj)->save_as (obj, uri, err);
}

/* Default implementation */
static void
ianjuta_file_savable_save_as_default (IAnjutaFileSavable *obj, const gchar *uri, GError **err)
{
	g_return_if_reached ();
}

/**
 * ianjuta_file_savable_set_dirty:
 * @obj: Self
 * @dirty: 
 * @err: Error propagation and reporting
 * 
 * if @dirty is TRUE, sets dirty for the content. Save point will be
 * left and the content will be considered not saved. Otherwise,
 * content will considered saved and save-point will be entered.
 */
void
ianjuta_file_savable_set_dirty (IAnjutaFileSavable *obj, gboolean dirty, GError **err)
{
	g_return_if_fail (IANJUTA_IS_FILE_SAVABLE(obj));
	IANJUTA_FILE_SAVABLE_GET_IFACE (obj)->set_dirty (obj, dirty, err);
}

/* Default implementation */
static void
ianjuta_file_savable_set_dirty_default (IAnjutaFileSavable *obj, gboolean dirty, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_file_savable_base_init (IAnjutaFileSavableIface* klass)
{
	static gboolean initialized = FALSE;

	klass->is_dirty = ianjuta_file_savable_is_dirty_default;
	klass->save = ianjuta_file_savable_save_default;
	klass->save_as = ianjuta_file_savable_save_as_default;
	klass->set_dirty = ianjuta_file_savable_set_dirty_default;
	
	if (!initialized) {
		/* Signal */
		g_signal_new ("save-point",
			IANJUTA_TYPE_FILE_SAVABLE,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaFileSavableIface, save_point),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__BOOLEAN,
			G_TYPE_NONE,
			1,
			G_TYPE_BOOLEAN);

		/* Signal */
		g_signal_new ("saved",
			IANJUTA_TYPE_FILE_SAVABLE,
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (IAnjutaFileSavableIface, saved),
			NULL, NULL,
			libanjuta_iface_cclosure_marshal_VOID__STRING,
			G_TYPE_NONE,
			1,
			G_TYPE_STRING);


		initialized = TRUE;
	}
}

GType
ianjuta_file_savable_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaFileSavableIface),
			(GBaseInitFunc) ianjuta_file_savable_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaFileSavable", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_FILE);
	}
	return type;			
}
