/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-stream-savable.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-stream-savable
 * @title: IAnjutaStreamSavable
 * @short_description: Implemented by plugins that can save file streams
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-stream-savable.h
 * 
 */

#include "ianjuta-stream-savable.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_stream_savable_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-stream-savable-quark");
	}
	
	return quark;
}

/**
 * ianjuta_stream_save:
 * @obj: Self
 * @stream: Stream to save to.
 * @err: Error propagation and reporting
 *
 * The implementor saves the content to the given stream.
 */
void
ianjuta_stream_savable_save (IAnjutaStreamSavable *obj, FILE* stream, GError **err)
{
	g_return_if_fail (IANJUTA_IS_STREAM_SAVABLE(obj));
	IANJUTA_STREAM_SAVABLE_GET_IFACE (obj)->save (obj, stream, err);
}

/* Default implementation */
static void
ianjuta_stream_savable_save_default (IAnjutaStreamSavable *obj, FILE* stream, GError **err)
{
	g_return_if_reached ();
}

static void
ianjuta_stream_savable_base_init (IAnjutaStreamSavableIface* klass)
{
	static gboolean initialized = FALSE;

	klass->save = ianjuta_stream_savable_save_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_stream_savable_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaStreamSavableIface),
			(GBaseInitFunc) ianjuta_stream_savable_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaStreamSavable", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_STREAM);
	}
	return type;			
}
