/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-variable-debugger.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-variable-debugger
 * @title: IAnjutaVariableDebugger
 * @short_description: Variables interface for debuggers
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-variable-debugger.h
 * 
 */

#include "ianjuta-variable-debugger.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_variable_debugger_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-variable-debugger-quark");
	}
	
	return quark;
}

/**
* ianjuta_variable_debugger_assign:
* @obj: Self
* @name: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_variable_debugger_assign (IAnjutaVariableDebugger *obj, const gchar *name,   const gchar *value, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_VARIABLE_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	return IANJUTA_VARIABLE_DEBUGGER_GET_IFACE (obj)->assign (obj, name, value, err);
}

/* Default implementation */
static gboolean
ianjuta_variable_debugger_assign_default (IAnjutaVariableDebugger *obj, const gchar *name,   const gchar *value, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_variable_debugger_create:
* @obj: Self
* @name: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_variable_debugger_create (IAnjutaVariableDebugger *obj, const gchar *name,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_VARIABLE_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_VARIABLE_DEBUGGER_GET_IFACE (obj)->create (obj, name, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_variable_debugger_create_default (IAnjutaVariableDebugger *obj, const gchar *name,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_variable_debugger_delete:
* @obj: Self
* @name: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_variable_debugger_delete_var (IAnjutaVariableDebugger *obj, const gchar *name, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_VARIABLE_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	return IANJUTA_VARIABLE_DEBUGGER_GET_IFACE (obj)->delete_var (obj, name, err);
}

/* Default implementation */
static gboolean
ianjuta_variable_debugger_delete_var_default (IAnjutaVariableDebugger *obj, const gchar *name, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_variable_debugger_evaluate:
* @obj: Self
* @name: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_variable_debugger_evaluate (IAnjutaVariableDebugger *obj, const gchar *name,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_VARIABLE_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_VARIABLE_DEBUGGER_GET_IFACE (obj)->evaluate (obj, name, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_variable_debugger_evaluate_default (IAnjutaVariableDebugger *obj, const gchar *name,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_variable_debugger_list_children:
* @obj: Self
* @name: fixme
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_variable_debugger_list_children (IAnjutaVariableDebugger *obj, const gchar *name,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_VARIABLE_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_VARIABLE_DEBUGGER_GET_IFACE (obj)->list_children (obj, name, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_variable_debugger_list_children_default (IAnjutaVariableDebugger *obj, const gchar *name,   IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_variable_debugger_update:
* @obj: Self
* @callback: fixme
* @user_data: fixme
* @err: Error propagation and reporting.
* 
* fixme
*
* Returns: fixme
*/
gboolean
ianjuta_variable_debugger_update (IAnjutaVariableDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_VARIABLE_DEBUGGER(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_VARIABLE_DEBUGGER_GET_IFACE (obj)->update (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_variable_debugger_update_default (IAnjutaVariableDebugger *obj, IAnjutaDebuggerCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_variable_debugger_base_init (IAnjutaVariableDebuggerIface* klass)
{
	static gboolean initialized = FALSE;

	klass->assign = ianjuta_variable_debugger_assign_default;
	klass->create = ianjuta_variable_debugger_create_default;
	klass->delete_var = ianjuta_variable_debugger_delete_var_default;
	klass->evaluate = ianjuta_variable_debugger_evaluate_default;
	klass->list_children = ianjuta_variable_debugger_list_children_default;
	klass->update = ianjuta_variable_debugger_update_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_variable_debugger_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaVariableDebuggerIface),
			(GBaseInitFunc) ianjuta_variable_debugger_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaVariableDebugger", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
