/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-editor-factory.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
 * SECTION:ianjuta-editor-factory
 * @title: IAnjutaEditorFactory
 * @short_description: Text editor factory that creates IAnjutaEditor objects
 * @see_also: 
 * @stability: Unstable
 * @include: libanjuta/interfaces/ianjuta-editor-factory.h
 * 
 */

#include "ianjuta-editor-factory.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_editor_factory_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-editor-factory-quark");
	}
	
	return quark;
}

/**
 * ianjuta_editor_factory_new_editor:
 * @obj: Self
 * @uri: Uri to open
 * @filename: filename to open
 * @err: Error propagation and reporting
 *
 * Get a new GtkWidget* which implements IAnjutaEditor
 *
 * Return value: An object implementing IAnjutaEditor
 */
IAnjutaEditor*
ianjuta_editor_factory_new_editor (IAnjutaEditorFactory *obj, const gchar* uri,   const gchar* filename, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_EDITOR_FACTORY(obj), NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	return IANJUTA_EDITOR_FACTORY_GET_IFACE (obj)->new_editor (obj, uri, filename, err);
}

/* Default implementation */
static IAnjutaEditor*
ianjuta_editor_factory_new_editor_default (IAnjutaEditorFactory *obj, const gchar* uri,   const gchar* filename, GError **err)
{
	g_return_val_if_reached (NULL);
}

static void
ianjuta_editor_factory_base_init (IAnjutaEditorFactoryIface* klass)
{
	static gboolean initialized = FALSE;

	klass->new_editor = ianjuta_editor_factory_new_editor_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_editor_factory_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaEditorFactoryIface),
			(GBaseInitFunc) ianjuta_editor_factory_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaEditorFactory", &info, 0);
		g_type_interface_add_prerequisite (type, G_TYPE_OBJECT);
	}
	return type;			
}
