/* Aravis - Digital camera library
 *
 * Copyright © 2009-2010 Emmanuel Pacaud
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General
 * Public License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Emmanuel Pacaud <emmanuel@gnome.org>
 */

#ifndef ARV_GC_NODE_H
#define ARV_GC_NODE_H

#include <arvtypes.h>

G_BEGIN_DECLS

#define ARV_TYPE_GC_NODE             (arv_gc_node_get_type ())
#define ARV_GC_NODE(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), ARV_TYPE_GC_NODE, ArvGcNode))
#define ARV_GC_NODE_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), ARV_TYPE_GC_NODE, ArvGcNodeClass))
#define ARV_IS_GC_NODE(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ARV_TYPE_GC_NODE))
#define ARV_IS_GC_NODE_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), ARV_TYPE_GC_NODE))
#define ARV_GC_NODE_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS((obj), ARV_TYPE_GC_NODE, ArvGcNodeClass))

typedef struct _ArvGcNodePrivate ArvGcNodePrivate;
typedef struct _ArvGcNodeClass ArvGcNodeClass;

struct _ArvGcNode {
	GObject	object;

	ArvGcNodePrivate *priv;
};

struct _ArvGcNodeClass {
	GObjectClass parent_class;

	const char *	(*get_node_name)		(ArvGcNode *gc_node);

	void		(*set_attribute)		(ArvGcNode *gc_node, const char *name, const char *value);
	void 		(*add_element)			(ArvGcNode *gc_node, const char *name, const char *content,
							 const char **attributes);
	GType		(*get_value_type)		(ArvGcNode *gc_node);
	gboolean 	(*can_add_child) 		(ArvGcNode *gc_node, ArvGcNode *child);

	void		(*set_value_from_string)	(ArvGcNode *gc_node, const char *string);
	const char *	(*get_value_as_string)		(ArvGcNode *gc_node);
};

GType arv_gc_node_get_type (void);

ArvGcNode * 	arv_gc_node_new 			(void);
const char *	arv_gc_node_get_node_name		(ArvGcNode *gc_node);
GType 		arv_gc_node_get_value_type 		(ArvGcNode *gc_node);
void		arv_gc_node_set_value_from_string	(ArvGcNode *gc_node, const char *string);
const char *	arv_gc_node_get_value_as_string		(ArvGcNode *gc_node);
void		arv_gc_node_set_genicam			(ArvGcNode *gc_node, ArvGc *genicam);
ArvGc * 	arv_gc_node_get_genicam			(ArvGcNode *gc_node);
const char *	arv_gc_node_get_name			(ArvGcNode *gc_node);
const char *	arv_gc_node_get_tooltip			(ArvGcNode *gc_node);
const char *	arv_gc_node_get_description		(ArvGcNode *gc_node);
gboolean	arv_gc_node_is_available		(ArvGcNode *gc_node);
void		arv_gc_node_set_attribute 		(ArvGcNode *gc_node, const char *name, const char *value);
void 		arv_gc_node_add_element 		(ArvGcNode *gc_node, const char *name, const char *content,
							 const char **attributes);
gboolean 	arv_gc_node_can_add_child 		(ArvGcNode *gc_node, ArvGcNode *child);
void 		arv_gc_node_add_child 			(ArvGcNode *gc_node, ArvGcNode *child);
const GSList *	arv_gc_node_get_childs 			(ArvGcNode *gc_node);
unsigned int 	arv_gc_node_get_n_childs 		(ArvGcNode *gc_node);
void 		arv_gc_node_inc_modification_count 	(ArvGcNode *gc_node);
gint 		arv_gc_node_get_modification_count 	(ArvGcNode *gc_node);

G_END_DECLS

#endif
