/* Atomixed -- the level-/themeeditor for atomix.
 * Copyright (C) 1999-2000 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "theme_properties.h"
#include "theme_ctrl.h"
#include "support.h"
#include "main.h"
#include "callbacks.h"

static Theme *current_theme = NULL;

void theme_properties_update_view(void);

void theme_properties_set_theme(Theme *theme)
{
	current_theme = theme;
	theme_properties_update_view();
}

void theme_properties_delete_theme(void)
{
	current_theme = NULL;
}

void theme_properties_update_view(void)
{
	if(current_theme != NULL)
	{
		GtkWidget *theme_name_entry;
		GtkWidget *theme_dir_name_entry;
		GtkWidget *theme_color_picker;
		GtkWidget *theme_selector_file;
		GtkWidget *theme_selector_image;
		gchar *dir_name;
		gushort r,g,b;
		
		/* update theme name */
		theme_name_entry = lookup_widget(get_app(), "theme_name");
		gtk_signal_handler_block_by_func(GTK_OBJECT(theme_name_entry),
						 GTK_SIGNAL_FUNC(on_theme_name_changed),
						 NULL);
		gtk_entry_set_text(GTK_ENTRY(theme_name_entry), current_theme->name);

		/* update dir name */
		theme_dir_name_entry = lookup_widget(get_app(), "theme_dir_name");
		gtk_signal_handler_block_by_func(GTK_OBJECT(theme_dir_name_entry),
						 GTK_SIGNAL_FUNC(on_theme_dir_name_changed),
						 NULL);
		dir_name = g_basename(current_theme->path);
		gtk_entry_set_text(GTK_ENTRY(theme_dir_name_entry), dir_name);
		if(!theme_ctrl_is_locale_theme(current_theme))
		{
			gtk_widget_set_sensitive(GTK_WIDGET(theme_name_entry), FALSE);
		}
		else
		{
			gtk_widget_set_sensitive(GTK_WIDGET(theme_name_entry), TRUE);
		}
		
		/* update color field */
		theme_color_picker = lookup_widget(get_app(), "theme_color_picker");
		r = current_theme->bg_color.red;
		g = current_theme->bg_color.green;
		b = current_theme->bg_color.blue;
		gnome_color_picker_set_i16(GNOME_COLOR_PICKER(theme_color_picker),
					   r,g,b,0);
		
		/* update selector image */
		theme_selector_file = lookup_widget(get_app(), "theme_selector_file");
		theme_selector_image = lookup_widget(get_app(), "theme_selector_pixmap");
		
		if(current_theme->selector != NULL)
		{
			gchar *file_path;
			file_path = g_concat_dir_and_file(current_theme->path, current_theme->selector->file);
			
			gtk_entry_set_text(GTK_ENTRY(theme_selector_file),
					   current_theme->selector->file);
			gnome_pixmap_load_file(GNOME_PIXMAP(theme_selector_image),
					       file_path);
			g_free(file_path);
		}
		else
		{
			GdkPixmap *pixmap;
			GdkImlibImage *image;

			pixmap = gdk_pixmap_new(NULL, 1, 1,
						gdk_visual_get_system()->depth);
			image = gdk_imlib_create_image_from_drawable(pixmap, NULL, 0, 0,
								     1, 1);

			gtk_entry_set_text(GTK_ENTRY(theme_selector_file), "");
			
			gnome_pixmap_load_imlib(GNOME_PIXMAP(theme_selector_image),
						image);
		}


		gtk_signal_handler_unblock_by_func(GTK_OBJECT(theme_name_entry),
						 GTK_SIGNAL_FUNC(on_theme_name_changed),
						 NULL);
		gtk_signal_handler_unblock_by_func(GTK_OBJECT(theme_dir_name_entry),
						 GTK_SIGNAL_FUNC(on_theme_dir_name_changed),
						 NULL);

	}
}

void theme_properties_update_theme(void)
{
	if(current_theme != NULL)
	{
		GtkWidget *theme_name_entry;
		GtkWidget *theme_dir_name_entry;
		GtkWidget *theme_color_picker;
		GtkWidget *theme_selector_file;
		gchar *dir_name;
		gushort r = 0;
		gushort g = 0;
		gushort b = 0;
		gushort a = 0;

		/* update theme name */
		theme_name_entry = lookup_widget(get_app(), "theme_name");
		if(current_theme->name) g_free(current_theme->name);
		current_theme->name = gtk_editable_get_chars(GTK_EDITABLE(theme_name_entry),
							     0, -1);

		/* update dir name */
		theme_dir_name_entry = lookup_widget(get_app(), "theme_dir_name");
		if(current_theme->path) g_free(current_theme->path);
		dir_name = gtk_editable_get_chars(GTK_EDITABLE(theme_dir_name_entry),0,-1);
		current_theme->path = g_strconcat(g_get_home_dir(), "/.atomix/themes/", dir_name, NULL);
		g_free(dir_name);

		/* update color */
		theme_color_picker = lookup_widget(get_app(), "theme_color_picker");
		gnome_color_picker_get_i16(GNOME_COLOR_PICKER(theme_color_picker),
					   &r, &g, &b, &a);
		current_theme->bg_color.red = r;
		current_theme->bg_color.green = g;
		current_theme->bg_color.blue = b;
		
		/* update selector image */
//		theme_selector_file = lookup_widget(get_app(), "theme_selector_file");

		/* update tile size */

		/* update anim step */
	}
}
