/* Atomixed -- the level-/themeeditor for atomix.
 * Copyright (C) 1999-2000 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef _ATOMIXED_LEVEL_CTRL_H 
#define _ATOMIXED_LEVEL_CTRL_H 
#include "level.h"

typedef struct _ItemUpdateInfo ItemUpdateInfo;
struct _ItemUpdateInfo
{
	gint counter;
	GtkCList *clist;
};

void level_ctrl_init(void);

void level_ctrl_destroy(void);

Level* level_ctrl_get_level(gint row);

Level* level_ctrl_get_actual_level(void);

void level_ctrl_select_row(gint row);

void level_ctrl_new_level(const gchar *name, const gchar *file, const gchar *theme_name,
			  guint n_rows, guint n_cols,
			  guint goal_n_rows, guint goal_n_col);

void level_ctrl_load_level(gchar *file_path);

void level_ctrl_actual_level_renamed(void);

void level_ctrl_remove_actual_level(void);

void level_ctrl_save_actual_level(void);

void level_ctrl_set_actual_level_modified(void);

gboolean level_ctrl_check_for_modifications(void);

gboolean level_ctrl_does_name_exists(gchar *name);

void level_ctrl_save_all_levels(void);

void level_ctrl_move_up(void);

void level_ctrl_move_down(void);

#endif /* _ATOMIXED_LEVEL_CTRL_H */
