/* Atomixed -- the level-/themeeditor for atomix.
 * Copyright (C) 1999-2000 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "level_properties.h"
#include "theme_ctrl.h"
#include "main.h"
#include "support.h"
#include "callbacks.h"

static Level *current_level = NULL;

void level_properties_update_view(void);

void level_properties_set_level(Level *level)
{
	current_level = level;
	level_properties_update_view();
}

void level_properties_delete_level(void)
{
	current_level = NULL;
}

void level_properties_update_view(void)
{
	GList *theme_name_list;
	GtkWidget *en_level_name;
	GtkWidget *en_theme_name;
	GtkWidget *en_file_name;
	GtkWidget *sb_time_minutes;
	GtkWidget *sb_time_seconds;
	GtkWidget *tb_bonus_level;
	guint minutes;
	guint seconds;

	g_return_if_fail(current_level!=NULL);

	/* the call to gtk_signal_handler_block_by_func prevents overwriting
	   the current settings of the level */
	
	/* set level name */
	en_level_name = lookup_widget(get_app(), "level_name");
	gtk_signal_handler_block_by_func(GTK_OBJECT(en_level_name),
					 GTK_SIGNAL_FUNC(on_level_name_changed),
					 NULL);
	gtk_entry_set_text(GTK_ENTRY(en_level_name), current_level->name);

	/* set theme name */
	en_theme_name = lookup_widget(get_app(), "level_theme_name_combo");
	gtk_signal_handler_block_by_func(GTK_OBJECT(GTK_COMBO(en_theme_name)->entry),
					 GTK_SIGNAL_FUNC(on_level_theme_name_entry_changed),
					 NULL);
	theme_name_list = theme_ctrl_get_theme_name_list();
	if(theme_name_list != NULL)
	{
		gtk_combo_set_popdown_strings(GTK_COMBO(en_theme_name),
					      theme_name_list);
	}
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(en_theme_name)->entry), 
			   current_level->theme_name);

	/* set file name */
	en_file_name = lookup_widget(get_app(), "level_file_name");
	gtk_signal_handler_block_by_func(GTK_OBJECT(en_file_name),
					 GTK_SIGNAL_FUNC(on_level_prop_changed),
					 NULL);
	gtk_entry_set_text(GTK_ENTRY(en_file_name), current_level->file_name);

	/* set if bonus level */
	tb_bonus_level = lookup_widget(get_app(), "bonus_level");
	gtk_signal_handler_block_by_func(GTK_OBJECT(tb_bonus_level),
					 GTK_SIGNAL_FUNC(on_level_prop_changed),
					 NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tb_bonus_level),
				     current_level->bonus_level);

	/* set time */
	minutes = current_level->time / 60;
	seconds = current_level->time % 60;
	sb_time_minutes = lookup_widget(get_app(), "level_time_minutes");
	sb_time_seconds = lookup_widget(get_app(), "level_time_seconds");
	gtk_signal_handler_block_by_func(GTK_OBJECT(sb_time_minutes),
					 GTK_SIGNAL_FUNC(on_level_prop_changed),
					 NULL);
	gtk_signal_handler_block_by_func(GTK_OBJECT(sb_time_seconds),
					 GTK_SIGNAL_FUNC(on_level_prop_changed),
					 NULL);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(sb_time_minutes),
				  minutes);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(sb_time_seconds),
				  seconds);

        /* unblock all handlers */
	gtk_signal_handler_unblock_by_func(GTK_OBJECT(en_level_name),
					   GTK_SIGNAL_FUNC(on_level_name_changed),
					   NULL);
	gtk_signal_handler_unblock_by_func(GTK_OBJECT(GTK_COMBO(en_theme_name)->entry),
					   GTK_SIGNAL_FUNC(on_level_theme_name_entry_changed),
					   NULL);
	gtk_signal_handler_unblock_by_func(GTK_OBJECT(en_file_name),
					   GTK_SIGNAL_FUNC(on_level_prop_changed),
					   NULL);
	gtk_signal_handler_unblock_by_func(GTK_OBJECT(tb_bonus_level),
					   GTK_SIGNAL_FUNC(on_level_prop_changed),
					   NULL);
	gtk_signal_handler_unblock_by_func(GTK_OBJECT(sb_time_minutes),
					   GTK_SIGNAL_FUNC(on_level_prop_changed),
					   NULL);
	gtk_signal_handler_unblock_by_func(GTK_OBJECT(sb_time_seconds),
					   GTK_SIGNAL_FUNC(on_level_prop_changed),
					   NULL);
}

void level_properties_update_level(void)
{
	if(current_level != NULL)
	{
		GtkWidget *en_level_name;
		GtkWidget *en_theme_name;
		GtkWidget *en_file_name;
		GtkWidget *sb_time_minutes;
		GtkWidget *sb_time_seconds;
		GtkWidget *tb_bonus_level;
		guint minutes;
		guint seconds;

		/* update name */
		en_level_name = lookup_widget(get_app(), "level_name");
		if(current_level->name) g_free(current_level->name);
		current_level->name = gtk_editable_get_chars(GTK_EDITABLE(en_level_name),0,-1);
		
		/* update theme name */
		en_theme_name = lookup_widget(get_app(), "level_theme_name_entry");
		if(current_level->theme_name) g_free(current_level->theme_name);
		current_level->theme_name = gtk_editable_get_chars(GTK_EDITABLE(en_theme_name),
								   0,-1);
		
		/* update file name */
		en_file_name = lookup_widget(get_app(), "level_file_name");
		if(current_level->file_name) g_free(current_level->file_name);
		current_level->file_name = gtk_editable_get_chars(GTK_EDITABLE(en_file_name),
								  0,-1);

		/* update bonus level */
		tb_bonus_level = lookup_widget(get_app(), "bonus_level");
		current_level->bonus_level = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(tb_bonus_level));

		/* update time */
		sb_time_minutes = lookup_widget(get_app(), "level_time_minutes");
		sb_time_seconds = lookup_widget(get_app(), "level_time_seconds");
		minutes = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sb_time_minutes));
		seconds = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(sb_time_seconds));
		current_level->time = minutes*60 + seconds;
	}
}

