/* Atomix -- a little mind game about atoms and molecules.
 * Copyright (C) 1999 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _ATOMIXED_MAIN_H_
#define _ATOMIXED_MAIN_H_

#include <gnome.h>
#include "theme.h"
#include "playfield_editor.h"
#include "level.h"
#include "theme_img_editor.h"

GtkWidget* get_app(void);

PlayFieldEditor* get_level_editor(void);

PlayFieldEditor* get_goal_editor(void);

ThemeImgEditor* get_moveable_editor(void);

ThemeImgEditor* get_obstacle_editor(void);

ThemeImgEditor* get_connection_editor(void);

ThemeImgEditor* get_image_editor_by_ref(GnomeIconList *gil);

Theme* get_theme_by_name(gchar *name);

void theme_image_win_show(void);

void theme_image_win_hide(void);

void theme_image_win_destroy(void);

#endif /* _ATOMIXED_MAIN_H_ */
