/* Atomixed -- the level-/themeeditor for atomix.
 * Copyright (C) 1999-2000 Jens Finke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef _ATOMIXED_THEME_CTRL_H_ 
#define _ATOMIXED_THEME_CTRL_H_ 

#include <gnome.h>
#include "theme.h"

void theme_ctrl_init(void);

void theme_ctrl_destroy(void);

Theme* theme_ctrl_get_theme(gint row);

Theme* theme_ctrl_get_theme_by_name(const gchar *name);

Theme* theme_ctrl_get_actual_theme(void);

GList* theme_ctrl_get_theme_name_list(void);

void theme_ctrl_actual_theme_renamed(void);

void theme_ctrl_new_selector_image(gchar *path);

void theme_ctrl_select_row(gint row);

void theme_ctrl_set_actual_theme_modified(void);

void theme_ctr_clear_update_flag(void);

void theme_ctrl_new_theme(const gchar *name, const gchar *dir_name);

void theme_ctrl_does_theme_exist(gchar *theme_name, gchar *dir_name, 
				 gboolean *name_exists, gboolean *dir_exists);

gboolean theme_ctrl_check_for_modifications(void);

void theme_ctrl_save_actual_theme(void);

void theme_ctrl_save_all_themes(void);

void theme_ctrl_save_theme(Theme *theme, gpointer data);

gboolean theme_ctrl_is_locale_theme(Theme *theme);

gboolean theme_ctrl_make_theme_locale(Theme *theme);

gboolean theme_ctrl_copy_image_into_theme_dir(gchar *path, Theme *theme);

void theme_ctrl_remove_image(Theme *theme, ThemeElement *element);

void theme_ctrl_test_suite(void); // only for internal use


#endif /* _ATOMIXED_THEME_CTRL_H_ */
