/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <bakery/App/GtkDialogs.h>
#include <bakery/App/Dialog_OfferSave.h>
#include <bakery/App/Dialog_OverwriteFile.h>
#include <gtkmm/stock.h>
#include <gtkmm/messagedialog.h>
#include <gtkmm/filechooserdialog.h>
#include <libintl.h>


namespace Bakery
{

void GtkDialogs::ui_warning(const Glib::ustring& text)
{
  Gtk::MessageDialog dialog(text, Gtk::MESSAGE_WARNING);
  dialog.run(); //deletes it too.
}

Glib::ustring GtkDialogs::ui_file_select_open()
{
  Gtk::FileChooserDialog fileChooser_Open(gettext("Open Document"), Gtk::FILE_CHOOSER_ACTION_OPEN);
  fileChooser_Open.add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
  fileChooser_Open.add_button(Gtk::Stock::OPEN, Gtk::RESPONSE_OK);

  fileChooser_Open.set_default_response(Gtk::RESPONSE_OK);

  int response_id = fileChooser_Open.run();
  fileChooser_Open.hide();
  if(response_id != Gtk::RESPONSE_CANCEL)
  {
    return fileChooser_Open.get_filename();
  }
  else
    return "";
}

Glib::ustring GtkDialogs::ui_file_select_save(const Glib::ustring& old_filepath)
{
  Gtk::FileChooserDialog fileChooser_Save(gettext("Save Document"), Gtk::FILE_CHOOSER_ACTION_SAVE);
  fileChooser_Save.add_button(Gtk::Stock::CANCEL, Gtk::RESPONSE_CANCEL);
  fileChooser_Save.add_button(Gtk::Stock::SAVE, Gtk::RESPONSE_OK);

  fileChooser_Save.set_default_response(Gtk::RESPONSE_OK);
   
  //Make the save dialog show the existing filename, if any:
  if(!old_filepath.empty())
    fileChooser_Save.set_filename(old_filepath);

  int response_id = fileChooser_Save.run();
  fileChooser_Save.hide();
  if(response_id != Gtk::RESPONSE_CANCEL)
  {
    return fileChooser_Save.get_filename();
  }
  else
    return "";
}

App_WithDoc::enumSaveChanges GtkDialogs::ui_offer_to_save_changes(const std::string& filepath)
{
  App_WithDoc::enumSaveChanges result = App_WithDoc::SAVECHANGES_Cancel;

  Bakery::Dialog_OfferSave* pDialogQuestion = new Bakery::Dialog_OfferSave(filepath);
  Bakery::Dialog_OfferSave::enumButtons buttonClicked = (Bakery::Dialog_OfferSave::enumButtons)pDialogQuestion->run();
  delete pDialogQuestion;
  pDialogQuestion = 0;

  if(buttonClicked == Bakery::Dialog_OfferSave::BUTTON_Save)
     result = App_WithDoc::SAVECHANGES_Save;
  else if(buttonClicked == Bakery::Dialog_OfferSave::BUTTON_Discard)
     result = App_WithDoc::SAVECHANGES_Discard;
  else
     result = App_WithDoc::SAVECHANGES_Cancel;

  return result;
}

bool GtkDialogs::ui_ask_overwrite(const std::string& filepath)
{
   Bakery::Dialog_OverwriteFile* pDialogQuestion = new Bakery::Dialog_OverwriteFile(filepath);
   Bakery::Dialog_OverwriteFile::enumButtons buttonClicked = (Bakery::Dialog_OverwriteFile::enumButtons)pDialogQuestion->run();
   delete pDialogQuestion;
   pDialogQuestion = 0;

   return buttonClicked == Dialog_OverwriteFile::BUTTON_Overwrite;
}


} //namespace
