// -*- C++ -*-

/* viewexample.h
 * 
 * Copyright (C) 2000 Murray Cumming  
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "viewexample.h"

ViewExample::ViewExample(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
:  Gtk::VBox(cobject),
   m_pEntry(0)
{
  //Get the glade-instantiated entry:
  refGlade->get_widget("entry_example", m_pEntry);

  //Connect signals:
  m_pEntry->signal_changed().connect(sigc::mem_fun(*this, &ViewExample::on_Entry_changed));
 
  show_all();
}

ViewExample::~ViewExample()
{
}

void ViewExample::load_from_document()
{
  if(get_document())
    m_pEntry->set_text( get_document()->get_something() );
}

void ViewExample::save_to_document()
{
  if(get_document())
  {
    const std::string& strText =  m_pEntry->get_text();

    if(strText != get_document()->get_something()) //Don't trigger 'modified' unless it really is different.
      get_document()->set_something(strText);
  }
}

void ViewExample::on_Entry_changed()
{
  //We don't really need to do this, but it updates the modified status,
  //and a more complicated View might need its Document updated all the time.
  save_to_document();
}
