/*
 * Copyright 2001 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOG_OVERWRITEFILE_H
#define DIALOG_OVERWRITEFILE_H

#include <bakeryconfig.h>

#ifdef BAKERY_MAEMO_ENABLED
#include <hildonmm/note.h>
#else
#include <gtkmm/messagedialog.h>
#endif

namespace Bakery
{

#ifdef BAKERY_MAEMO_ENABLED
class Dialog_OverwriteFile : public Hildon::Note
#else
class Dialog_OverwriteFile : public Gtk::MessageDialog
#endif
{
public:
  Dialog_OverwriteFile(const Glib::ustring& filepath);
  virtual ~Dialog_OverwriteFile();

  ///Return values:
  enum enumButtons
  {
    BUTTON_Overwrite,
    BUTTON_ChooseNewFilename
  };
};

} //namespace

#endif //DIALOG_OVERWRITEFILE_H
