#include <bakery/App/Dialog_OfferSave.h>
#include <bakery/App/App_Gtk.h>
#include <gtkmm/box.h>
#include <gtkmm/stock.h>
#include <libintl.h>

namespace
{
  Glib::ustring get_confirmation_message(const Glib::ustring& file_uri)
  {
    Glib::ustring message = gettext("This document has unsaved changes. Would you like to save the document?");
    if(!file_uri.empty())
      message += gettext("\n\nDocument:\n") + Glib::filename_display_basename(file_uri); //TODO: Can we use filename_display_basename() with a URI?
    return message;
  }
}

namespace Bakery
{


Dialog_OfferSave::Dialog_OfferSave(const Glib::ustring& file_uri)
#ifdef BAKERY_MAEMO_ENABLED
: Hildon::Note(Hildon::NOTE_TYPE_CONFIRMATION_BUTTON, get_confirmation_message(file_uri))
#else
: Gtk::MessageDialog( App_Gtk::util_bold_message(gettext("Close without Saving")), true /* use markup */, Gtk::MESSAGE_QUESTION, Gtk::BUTTONS_NONE)
#endif
{
  set_title(""); //The HIG says that alert dialogs should not have titles. The default comes from the message type.

#ifndef BAKERY_MAEMO_ENABLED
  set_secondary_text(get_confirmation_message(file_uri));
#endif

  add_button(gettext("Discard"), BUTTON_Discard);
  Gtk::Button* cancel_button = add_button(Gtk::Stock::CANCEL, BUTTON_Cancel);
  add_button(Gtk::Stock::SAVE, BUTTON_Save);

  // Otherwise Discard has focus initially which seems inconvenient:
  cancel_button->grab_focus();
}

Dialog_OfferSave::~Dialog_OfferSave()
{

}


} //namespace
