/* -*- Mode: csharp; tab-width: 4; c-basic-offset: 4; indent-tabs-mode: t -*- */
/***************************************************************************
 *  ActiveUserEventsManager.cs
 *
 *  Copyright (C) 2005 Novell
 *  Written by Aaron Bockover (aaron@aaronbock.net)
 ****************************************************************************/

/*  THIS FILE IS LICENSED UNDER THE MIT LICENSE AS OUTLINED IMMEDIATELY BELOW: 
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),  
 *  to deal in the Software without restriction, including without limitation  
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,  
 *  and/or sell copies of the Software, and to permit persons to whom the  
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
 
using System;
using System.Collections;
using Gtk;
 
namespace Banshee
{    
    public class ActiveUserEventsManager : VBox
    {
        private static ActiveUserEventsManager instance;
        public static ActiveUserEventsManager Instance {
            get {
                return instance;
            }
        }
        
        private ArrayList user_events;
        
        public ActiveUserEventsManager() : base()
        {
            if(instance != null) {
                throw new ApplicationException("Only one instance is allowed");
            }
            
            Spacing = 8;
            instance = this;
        
            user_events = new ArrayList();
            
            Hide();
        }
        
        public void Clear()
        {
            while(user_events.Count > 0) {
                (user_events[0] as ActiveUserEvent).Dispose();
            }
        }
        
        private bool canceling = false;
        public void CancelAll()
        {
            if(canceling) {
                return;
            }
            
            canceling = true;
            
            while(user_events.Count > 0) {
                (user_events[0] as ActiveUserEvent).Cancel();
            }
        }
        
        private void OnUserEventDisposed(object o, EventArgs args)
        {
            user_events.Remove(o);
            
            Core.ProxyToMainThread(delegate {
                Remove((o as ActiveUserEvent).Widget);
                
                if(user_events.Count == 0) {
                    Hide();
                }
            });
        }
        
        public void Register(ActiveUserEvent userEvent)
        {
            userEvent.Disposed += OnUserEventDisposed;
            user_events.Add(userEvent);
            Core.ProxyToMainThread(delegate {
                PackStart(userEvent.Widget, false, false, 0);
                Show();
            });
        }
    }
}
