/* baobab-location.c generated by valac 0.25.1.6-a1f05, the Vala compiler
 * generated from baobab-location.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define BAOBAB_TYPE_HOSTNAME_IFACE (baobab_hostname_iface_get_type ())
#define BAOBAB_HOSTNAME_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_HOSTNAME_IFACE, BaobabHostnameIface))
#define BAOBAB_IS_HOSTNAME_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_HOSTNAME_IFACE))
#define BAOBAB_HOSTNAME_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BAOBAB_TYPE_HOSTNAME_IFACE, BaobabHostnameIfaceIface))

typedef struct _BaobabHostnameIface BaobabHostnameIface;
typedef struct _BaobabHostnameIfaceIface BaobabHostnameIfaceIface;

#define BAOBAB_TYPE_HOSTNAME_IFACE_PROXY (baobab_hostname_iface_proxy_get_type ())
typedef GDBusProxy BaobabHostnameIfaceProxy;
typedef GDBusProxyClass BaobabHostnameIfaceProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BAOBAB_TYPE_LOCATION (baobab_location_get_type ())
#define BAOBAB_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_LOCATION, BaobabLocation))
#define BAOBAB_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_LOCATION, BaobabLocationClass))
#define BAOBAB_IS_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_LOCATION))
#define BAOBAB_IS_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_LOCATION))
#define BAOBAB_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_LOCATION, BaobabLocationClass))

typedef struct _BaobabLocation BaobabLocation;
typedef struct _BaobabLocationClass BaobabLocationClass;
typedef struct _BaobabLocationPrivate BaobabLocationPrivate;

#define BAOBAB_TYPE_SCANNER (baobab_scanner_get_type ())
#define BAOBAB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_SCANNER, BaobabScanner))
#define BAOBAB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_SCANNER, BaobabScannerClass))
#define BAOBAB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_SCANNER))
#define BAOBAB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_SCANNER))
#define BAOBAB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_SCANNER, BaobabScannerClass))

typedef struct _BaobabScanner BaobabScanner;
typedef struct _BaobabScannerClass BaobabScannerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))

#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BaobabLocationMountVolumeData BaobabLocationMountVolumeData;
typedef struct _BaobabParamSpecLocation BaobabParamSpecLocation;

struct _BaobabHostnameIfaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_pretty_hostname) (BaobabHostnameIface* self);
	void (*set_pretty_hostname) (BaobabHostnameIface* self, const gchar* value);
	gchar* (*get_hostname) (BaobabHostnameIface* self);
	void (*set_hostname) (BaobabHostnameIface* self, const gchar* value);
};

struct _BaobabLocation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BaobabLocationPrivate * priv;
};

struct _BaobabLocationClass {
	GTypeClass parent_class;
	void (*finalize) (BaobabLocation *self);
};

struct _BaobabLocationPrivate {
	gchar* _name;
	GFile* _file;
	GFileInfo* _info;
	gboolean _is_volume;
	guint64* _size;
	guint64* _used;
	guint64* _reserved;
	GIcon* _icon;
	GVolume* _volume;
	GMount* _mount;
	BaobabScanner* _scanner;
};

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;

struct _BaobabLocationMountVolumeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BaobabLocation* self;
	gboolean _tmp0_;
	GMount* _tmp1_;
	GVolume* _tmp2_;
	GtkMountOperation* mount_op;
	GtkMountOperation* _tmp3_;
	GVolume* _tmp4_;
	GtkMountOperation* _tmp5_;
	GError * _inner_error_;
};

struct _BaobabParamSpecLocation {
	GParamSpec parent_instance;
};


static gpointer baobab_location_parent_class = NULL;
static BaobabLocation* baobab_location_home_location;
static BaobabLocation* baobab_location_home_location = NULL;

GType baobab_hostname_iface_get_type (void) G_GNUC_CONST;
GType baobab_hostname_iface_proxy_get_type (void) G_GNUC_CONST;
guint baobab_hostname_iface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
gchar* baobab_hostname_iface_get_pretty_hostname (BaobabHostnameIface* self);
void baobab_hostname_iface_set_pretty_hostname (BaobabHostnameIface* self, const gchar* value);
gchar* baobab_hostname_iface_get_hostname (BaobabHostnameIface* self);
void baobab_hostname_iface_set_hostname (BaobabHostnameIface* self, const gchar* value);
static void baobab_hostname_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar* baobab_hostname_iface_dbus_proxy_get_pretty_hostname (BaobabHostnameIface* self);
static void baobab_hostname_iface_dbus_proxy_set_pretty_hostname (BaobabHostnameIface* self, const gchar* value);
static gchar* baobab_hostname_iface_dbus_proxy_get_hostname (BaobabHostnameIface* self);
static void baobab_hostname_iface_dbus_proxy_set_hostname (BaobabHostnameIface* self, const gchar* value);
static void baobab_hostname_iface_proxy_baobab_hostname_iface_interface_init (BaobabHostnameIfaceIface* iface);
static void baobab_hostname_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* baobab_hostname_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_baobab_hostname_iface_get_pretty_hostname (BaobabHostnameIface* self);
static GVariant* _dbus_baobab_hostname_iface_get_hostname (BaobabHostnameIface* self);
static gboolean baobab_hostname_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_baobab_hostname_iface_set_pretty_hostname (BaobabHostnameIface* self, GVariant* _value);
static void _dbus_baobab_hostname_iface_set_hostname (BaobabHostnameIface* self, GVariant* _value);
static void _baobab_hostname_iface_unregister_object (gpointer user_data);
gpointer baobab_location_ref (gpointer instance);
void baobab_location_unref (gpointer instance);
GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_location (GValue* value, gpointer v_object);
void baobab_value_take_location (GValue* value, gpointer v_object);
gpointer baobab_value_get_location (const GValue* value);
GType baobab_location_get_type (void) G_GNUC_CONST;
GType baobab_scanner_get_type (void) G_GNUC_CONST;
#define BAOBAB_LOCATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_LOCATION, BaobabLocationPrivate))
enum  {
	BAOBAB_LOCATION_DUMMY_PROPERTY
};
#define BAOBAB_LOCATION_FS_ATTRIBUTES G_FILE_ATTRIBUTE_FILESYSTEM_SIZE "," G_FILE_ATTRIBUTE_FILESYSTEM_USED
#define BAOBAB_LOCATION_FILE_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_ICON "," G_FILE_ATTRIBUTE_STANDARD_TYPE
static gchar* baobab_location_get_hostname (BaobabLocation* self, GError** error);
static void baobab_location_make_this_home_location (BaobabLocation* self);
static void baobab_location_set_name (BaobabLocation* self, const gchar* value);
static void baobab_location_set_icon (BaobabLocation* self, GIcon* value);
static BaobabLocation* baobab_location_new_for_home_folder (void);
static BaobabLocation* baobab_location_construct_for_home_folder (GType object_type);
static void baobab_location_set_is_volume (BaobabLocation* self, gboolean value);
static void baobab_location_set_file (BaobabLocation* self, GFile* value);
static void baobab_location_get_file_info (BaobabLocation* self);
static void baobab_location_get_fs_usage (BaobabLocation* self);
GFile* baobab_location_get_file (BaobabLocation* self);
GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
BaobabScanner* baobab_scanner_new (GFile* directory, BaobabScanFlags flags);
BaobabScanner* baobab_scanner_construct (GType object_type, GFile* directory, BaobabScanFlags flags);
static void baobab_location_set_scanner (BaobabLocation* self, BaobabScanner* value);
BaobabLocation* baobab_location_get_home_location (void);
BaobabLocation* baobab_location_new_from_volume (GVolume* volume_);
BaobabLocation* baobab_location_construct_from_volume (GType object_type, GVolume* volume_);
static void baobab_location_set_volume (BaobabLocation* self, GVolume* value);
GVolume* baobab_location_get_volume (BaobabLocation* self);
static void __lambda5_ (BaobabLocation* self, GVolume* vol);
static void baobab_location_update_volume_info (BaobabLocation* self);
static void ___lambda5__g_volume_changed (GVolume* _sender, gpointer self);
BaobabLocation* baobab_location_new_from_mount (GMount* mount_);
BaobabLocation* baobab_location_construct_from_mount (GType object_type, GMount* mount_);
static void baobab_location_set_mount (BaobabLocation* self, GMount* value);
static void baobab_location_fill_from_mount (BaobabLocation* self);
BaobabLocation* baobab_location_new_for_main_volume (void);
BaobabLocation* baobab_location_construct_for_main_volume (GType object_type);
const gchar* baobab_location_get_name (BaobabLocation* self);
BaobabLocation* baobab_location_new_for_recent_info (GtkRecentInfo* recent_info);
BaobabLocation* baobab_location_construct_for_recent_info (GType object_type, GtkRecentInfo* recent_info);
BaobabLocation* baobab_location_new_for_file (GFile* file_, BaobabScanFlags flags);
BaobabLocation* baobab_location_construct_for_file (GType object_type, GFile* file_, BaobabScanFlags flags);
GFileInfo* baobab_location_get_info (BaobabLocation* self);
void baobab_location_update (BaobabLocation* self);
GMount* baobab_location_get_mount (BaobabLocation* self);
static void baobab_location_set_info (BaobabLocation* self, GFileInfo* value);
static void baobab_location_set_size (BaobabLocation* self, guint64* value);
static void baobab_location_set_used (BaobabLocation* self, guint64* value);
static void baobab_location_set_reserved (BaobabLocation* self, guint64* value);
guint64* baobab_location_get_size (BaobabLocation* self);
guint64* baobab_location_get_used (BaobabLocation* self);
static void baobab_location_mount_volume_data_free (gpointer _data);
void baobab_location_mount_volume (BaobabLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void baobab_location_mount_volume_finish (BaobabLocation* self, GAsyncResult* _res_, GError** error);
static gboolean baobab_location_mount_volume_co (BaobabLocationMountVolumeData* _data_);
static void baobab_location_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
BaobabLocation* baobab_location_new (void);
BaobabLocation* baobab_location_construct (GType object_type);
gboolean baobab_location_get_is_volume (BaobabLocation* self);
static guint64* _uint64_dup (guint64* self);
guint64* baobab_location_get_reserved (BaobabLocation* self);
GIcon* baobab_location_get_icon (BaobabLocation* self);
BaobabScanner* baobab_location_get_scanner (BaobabLocation* self);
gboolean baobab_location_get_is_home (BaobabLocation* self);
static void baobab_location_finalize (BaobabLocation* obj);

static const GDBusMethodInfo * const _baobab_hostname_iface_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _baobab_hostname_iface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _baobab_hostname_iface_dbus_property_info_pretty_hostname = {-1, "PrettyHostname", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo _baobab_hostname_iface_dbus_property_info_hostname = {-1, "Hostname", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _baobab_hostname_iface_dbus_property_info[] = {&_baobab_hostname_iface_dbus_property_info_pretty_hostname, &_baobab_hostname_iface_dbus_property_info_hostname, NULL};
static const GDBusInterfaceInfo _baobab_hostname_iface_dbus_interface_info = {-1, "org.freedesktop.hostname1", (GDBusMethodInfo **) (&_baobab_hostname_iface_dbus_method_info), (GDBusSignalInfo **) (&_baobab_hostname_iface_dbus_signal_info), (GDBusPropertyInfo **) (&_baobab_hostname_iface_dbus_property_info)};
static const GDBusInterfaceVTable _baobab_hostname_iface_dbus_interface_vtable = {baobab_hostname_iface_dbus_interface_method_call, baobab_hostname_iface_dbus_interface_get_property, baobab_hostname_iface_dbus_interface_set_property};

gchar* baobab_hostname_iface_get_pretty_hostname (BaobabHostnameIface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return BAOBAB_HOSTNAME_IFACE_GET_INTERFACE (self)->get_pretty_hostname (self);
}


void baobab_hostname_iface_set_pretty_hostname (BaobabHostnameIface* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	BAOBAB_HOSTNAME_IFACE_GET_INTERFACE (self)->set_pretty_hostname (self, value);
}


gchar* baobab_hostname_iface_get_hostname (BaobabHostnameIface* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return BAOBAB_HOSTNAME_IFACE_GET_INTERFACE (self)->get_hostname (self);
}


void baobab_hostname_iface_set_hostname (BaobabHostnameIface* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	BAOBAB_HOSTNAME_IFACE_GET_INTERFACE (self)->set_hostname (self, value);
}


static void baobab_hostname_iface_base_init (BaobabHostnameIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType baobab_hostname_iface_get_type (void) {
	static volatile gsize baobab_hostname_iface_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_hostname_iface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabHostnameIfaceIface), (GBaseInitFunc) baobab_hostname_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType baobab_hostname_iface_type_id;
		baobab_hostname_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "BaobabHostnameIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (baobab_hostname_iface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (baobab_hostname_iface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) baobab_hostname_iface_proxy_get_type);
		g_type_set_qdata (baobab_hostname_iface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.hostname1");
		g_type_set_qdata (baobab_hostname_iface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) baobab_hostname_iface_register_object);
		g_once_init_leave (&baobab_hostname_iface_type_id__volatile, baobab_hostname_iface_type_id);
	}
	return baobab_hostname_iface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (BaobabHostnameIfaceProxy, baobab_hostname_iface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BAOBAB_TYPE_HOSTNAME_IFACE, baobab_hostname_iface_proxy_baobab_hostname_iface_interface_init) )
static void baobab_hostname_iface_proxy_class_init (BaobabHostnameIfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = baobab_hostname_iface_proxy_g_signal;
}


static void baobab_hostname_iface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void baobab_hostname_iface_proxy_init (BaobabHostnameIfaceProxy* self) {
}


static gchar* baobab_hostname_iface_dbus_proxy_get_pretty_hostname (BaobabHostnameIface* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PrettyHostname");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrettyHostname"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void baobab_hostname_iface_dbus_proxy_set_pretty_hostname (BaobabHostnameIface* self, const gchar* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrettyHostname"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static gchar* baobab_hostname_iface_dbus_proxy_get_hostname (BaobabHostnameIface* self) {
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Hostname");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Hostname"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}


static void baobab_hostname_iface_dbus_proxy_set_hostname (BaobabHostnameIface* self, const gchar* value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.hostname1"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Hostname"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static void baobab_hostname_iface_proxy_baobab_hostname_iface_interface_init (BaobabHostnameIfaceIface* iface) {
	iface->get_pretty_hostname = baobab_hostname_iface_dbus_proxy_get_pretty_hostname;
	iface->set_pretty_hostname = baobab_hostname_iface_dbus_proxy_set_pretty_hostname;
	iface->get_hostname = baobab_hostname_iface_dbus_proxy_get_hostname;
	iface->set_hostname = baobab_hostname_iface_dbus_proxy_set_hostname;
}


static void baobab_hostname_iface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_baobab_hostname_iface_get_pretty_hostname (BaobabHostnameIface* self) {
	gchar* result;
	GVariant* _reply;
	result = baobab_hostname_iface_get_pretty_hostname (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* _dbus_baobab_hostname_iface_get_hostname (BaobabHostnameIface* self) {
	gchar* result;
	GVariant* _reply;
	result = baobab_hostname_iface_get_hostname (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}


static GVariant* baobab_hostname_iface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrettyHostname") == 0) {
		return _dbus_baobab_hostname_iface_get_pretty_hostname (object);
	} else if (strcmp (property_name, "Hostname") == 0) {
		return _dbus_baobab_hostname_iface_get_hostname (object);
	}
	return NULL;
}


static void _dbus_baobab_hostname_iface_set_pretty_hostname (BaobabHostnameIface* self, GVariant* _value) {
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	baobab_hostname_iface_set_pretty_hostname (self, value);
	_g_free0 (value);
}


static void _dbus_baobab_hostname_iface_set_hostname (BaobabHostnameIface* self, GVariant* _value) {
	gchar* value = NULL;
	value = g_variant_dup_string (_value, NULL);
	baobab_hostname_iface_set_hostname (self, value);
	_g_free0 (value);
}


static gboolean baobab_hostname_iface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrettyHostname") == 0) {
		_dbus_baobab_hostname_iface_set_pretty_hostname (object, value);
		return TRUE;
	} else if (strcmp (property_name, "Hostname") == 0) {
		_dbus_baobab_hostname_iface_set_hostname (object, value);
		return TRUE;
	}
	return FALSE;
}


guint baobab_hostname_iface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_baobab_hostname_iface_dbus_interface_info), &_baobab_hostname_iface_dbus_interface_vtable, data, _baobab_hostname_iface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _baobab_hostname_iface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static gchar* baobab_location_get_hostname (BaobabLocation* self, GError** error) {
	gchar* result = NULL;
	BaobabHostnameIface* hostname_iface = NULL;
	BaobabHostnameIface* _tmp0_ = NULL;
	BaobabHostnameIface* _tmp1_ = NULL;
	BaobabHostnameIface* _tmp2_ = NULL;
	gchar* pretty_name = NULL;
	BaobabHostnameIface* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = g_initable_new (BAOBAB_TYPE_HOSTNAME_IFACE_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.freedesktop.hostname1", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/hostname1", "g-interface-name", "org.freedesktop.hostname1", NULL);
	_tmp0_ = (BaobabHostnameIface*) _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (hostname_iface);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (hostname_iface);
	hostname_iface = _tmp2_;
	_tmp3_ = hostname_iface;
	_tmp4_ = baobab_hostname_iface_get_pretty_hostname (_tmp3_);
	_tmp5_ = _tmp4_;
	pretty_name = _tmp5_;
	_tmp6_ = pretty_name;
	if (g_strcmp0 (_tmp6_, "") != 0) {
		result = pretty_name;
		_g_object_unref0 (_tmp0_);
		_g_object_unref0 (hostname_iface);
		return result;
	} else {
		BaobabHostnameIface* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp7_ = hostname_iface;
		_tmp8_ = baobab_hostname_iface_get_hostname (_tmp7_);
		_tmp9_ = _tmp8_;
		result = _tmp9_;
		_g_free0 (pretty_name);
		_g_object_unref0 (_tmp0_);
		_g_object_unref0 (hostname_iface);
		return result;
	}
	_g_free0 (pretty_name);
	_g_object_unref0 (_tmp0_);
	_g_object_unref0 (hostname_iface);
}


static gpointer _baobab_location_ref0 (gpointer self) {
	return self ? baobab_location_ref (self) : NULL;
}


static void baobab_location_make_this_home_location (BaobabLocation* self) {
	const gchar* _tmp0_ = NULL;
	GThemedIcon* _tmp1_ = NULL;
	GThemedIcon* _tmp2_ = NULL;
	BaobabLocation* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Home folder");
	baobab_location_set_name (self, _tmp0_);
	_tmp1_ = (GThemedIcon*) g_themed_icon_new ("user-home");
	_tmp2_ = _tmp1_;
	baobab_location_set_icon (self, (GIcon*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = _baobab_location_ref0 (self);
	_baobab_location_unref0 (baobab_location_home_location);
	baobab_location_home_location = _tmp3_;
}


static BaobabLocation* baobab_location_construct_for_home_folder (GType object_type) {
	BaobabLocation* self = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	BaobabScanner* _tmp4_ = NULL;
	BaobabScanner* _tmp5_ = NULL;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	baobab_location_set_is_volume (self, FALSE);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_tmp2_ = _tmp1_;
	baobab_location_set_file (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	baobab_location_get_file_info (self);
	baobab_location_get_fs_usage (self);
	baobab_location_make_this_home_location (self);
	_tmp3_ = self->priv->_file;
	_tmp4_ = baobab_scanner_new (_tmp3_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
	_tmp5_ = _tmp4_;
	baobab_location_set_scanner (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	return self;
}


static BaobabLocation* baobab_location_new_for_home_folder (void) {
	return baobab_location_construct_for_home_folder (BAOBAB_TYPE_LOCATION);
}


BaobabLocation* baobab_location_get_home_location (void) {
	BaobabLocation* result = NULL;
	BaobabLocation* _tmp0_ = NULL;
	BaobabLocation* _tmp2_ = NULL;
	BaobabLocation* _tmp3_ = NULL;
	_tmp0_ = baobab_location_home_location;
	if (_tmp0_ == NULL) {
		BaobabLocation* _tmp1_ = NULL;
		_tmp1_ = baobab_location_new_for_home_folder ();
		_baobab_location_unref0 (baobab_location_home_location);
		baobab_location_home_location = _tmp1_;
	}
	_tmp2_ = baobab_location_home_location;
	_tmp3_ = _baobab_location_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static void __lambda5_ (BaobabLocation* self, GVolume* vol) {
	g_return_if_fail (vol != NULL);
	baobab_location_update_volume_info (self);
}


static void ___lambda5__g_volume_changed (GVolume* _sender, gpointer self) {
	__lambda5_ ((BaobabLocation*) self, _sender);
}


BaobabLocation* baobab_location_construct_from_volume (GType object_type, GVolume* volume_) {
	BaobabLocation* self = NULL;
	GVolume* _tmp0_ = NULL;
	GVolume* _tmp1_ = NULL;
	g_return_val_if_fail (volume_ != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	_tmp0_ = volume_;
	baobab_location_set_volume (self, _tmp0_);
	_tmp1_ = self->priv->_volume;
	g_signal_connect (_tmp1_, "changed", (GCallback) ___lambda5__g_volume_changed, self);
	baobab_location_update_volume_info (self);
	return self;
}


BaobabLocation* baobab_location_new_from_volume (GVolume* volume_) {
	return baobab_location_construct_from_volume (BAOBAB_TYPE_LOCATION, volume_);
}


BaobabLocation* baobab_location_construct_from_mount (GType object_type, GMount* mount_) {
	BaobabLocation* self = NULL;
	GMount* _tmp0_ = NULL;
	g_return_val_if_fail (mount_ != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	_tmp0_ = mount_;
	baobab_location_set_mount (self, _tmp0_);
	baobab_location_fill_from_mount (self);
	return self;
}


BaobabLocation* baobab_location_new_from_mount (GMount* mount_) {
	return baobab_location_construct_from_mount (BAOBAB_TYPE_LOCATION, mount_);
}


BaobabLocation* baobab_location_construct_for_main_volume (GType object_type) {
	BaobabLocation* self = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GThemedIcon* _tmp6_ = NULL;
	GThemedIcon* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	BaobabScanner* _tmp9_ = NULL;
	BaobabScanner* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		_tmp1_ = baobab_location_get_hostname (self, &_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		baobab_location_set_name (self, _tmp0_);
		_g_free0 (_tmp0_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		baobab_location_set_name (self, NULL);
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp2_ = self->priv->_name;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = _ ("Computer");
		baobab_location_set_name (self, _tmp3_);
	}
	_tmp4_ = g_file_new_for_path ("/");
	_tmp5_ = _tmp4_;
	baobab_location_set_file (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	baobab_location_get_file_info (self);
	_tmp6_ = (GThemedIcon*) g_themed_icon_new ("drive-harddisk-system");
	_tmp7_ = _tmp6_;
	baobab_location_set_icon (self, (GIcon*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	baobab_location_get_fs_usage (self);
	_tmp8_ = self->priv->_file;
	_tmp9_ = baobab_scanner_new (_tmp8_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
	_tmp10_ = _tmp9_;
	baobab_location_set_scanner (self, _tmp10_);
	_g_object_unref0 (_tmp10_);
	return self;
}


BaobabLocation* baobab_location_new_for_main_volume (void) {
	return baobab_location_construct_for_main_volume (BAOBAB_TYPE_LOCATION);
}


BaobabLocation* baobab_location_construct_for_recent_info (GType object_type, GtkRecentInfo* recent_info) {
	BaobabLocation* self = NULL;
	GtkRecentInfo* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GtkRecentInfo* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkRecentInfo* _tmp6_ = NULL;
	GIcon* _tmp7_ = NULL;
	GtkRecentInfo* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GFile* _tmp10_ = NULL;
	BaobabScanner* _tmp11_ = NULL;
	BaobabScanner* _tmp12_ = NULL;
	g_return_val_if_fail (recent_info != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	baobab_location_set_is_volume (self, FALSE);
	_tmp0_ = recent_info;
	_tmp1_ = gtk_recent_info_get_uri (_tmp0_);
	_tmp2_ = g_file_new_for_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	baobab_location_set_file (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = recent_info;
	_tmp5_ = gtk_recent_info_get_display_name (_tmp4_);
	baobab_location_set_name (self, _tmp5_);
	_tmp6_ = recent_info;
	_tmp7_ = gtk_recent_info_get_gicon (_tmp6_);
	baobab_location_set_icon (self, _tmp7_);
	_tmp8_ = recent_info;
	_tmp9_ = gtk_recent_info_is_local (_tmp8_);
	if (_tmp9_) {
		baobab_location_get_fs_usage (self);
	}
	_tmp10_ = self->priv->_file;
	_tmp11_ = baobab_scanner_new (_tmp10_, BAOBAB_SCAN_FLAGS_NONE);
	_tmp12_ = _tmp11_;
	baobab_location_set_scanner (self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	return self;
}


BaobabLocation* baobab_location_new_for_recent_info (GtkRecentInfo* recent_info) {
	return baobab_location_construct_for_recent_info (BAOBAB_TYPE_LOCATION, recent_info);
}


BaobabLocation* baobab_location_construct_for_file (GType object_type, GFile* file_, BaobabScanFlags flags) {
	BaobabLocation* self = NULL;
	GFile* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	GFile* _tmp9_ = NULL;
	BaobabScanFlags _tmp10_ = 0;
	BaobabScanner* _tmp11_ = NULL;
	BaobabScanner* _tmp12_ = NULL;
	g_return_val_if_fail (file_ != NULL, NULL);
	self = (BaobabLocation*) g_type_create_instance (object_type);
	baobab_location_set_is_volume (self, FALSE);
	_tmp0_ = file_;
	baobab_location_set_file (self, _tmp0_);
	baobab_location_get_file_info (self);
	_tmp1_ = self->priv->_info;
	if (_tmp1_ != NULL) {
		GFileInfo* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		GFileInfo* _tmp4_ = NULL;
		GIcon* _tmp5_ = NULL;
		_tmp2_ = self->priv->_info;
		_tmp3_ = g_file_info_get_display_name (_tmp2_);
		baobab_location_set_name (self, _tmp3_);
		_tmp4_ = self->priv->_info;
		_tmp5_ = g_file_info_get_icon (_tmp4_);
		baobab_location_set_icon (self, _tmp5_);
	} else {
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = file_;
		_tmp7_ = g_file_get_parse_name (_tmp6_);
		_tmp8_ = _tmp7_;
		baobab_location_set_name (self, _tmp8_);
		_g_free0 (_tmp8_);
		baobab_location_set_icon (self, NULL);
	}
	baobab_location_get_fs_usage (self);
	_tmp9_ = self->priv->_file;
	_tmp10_ = flags;
	_tmp11_ = baobab_scanner_new (_tmp9_, _tmp10_);
	_tmp12_ = _tmp11_;
	baobab_location_set_scanner (self, _tmp12_);
	_g_object_unref0 (_tmp12_);
	return self;
}


BaobabLocation* baobab_location_new_for_file (GFile* file_, BaobabScanFlags flags) {
	return baobab_location_construct_for_file (BAOBAB_TYPE_LOCATION, file_, flags);
}


void baobab_location_update (BaobabLocation* self) {
	g_return_if_fail (self != NULL);
	baobab_location_update_volume_info (self);
}


static void baobab_location_update_volume_info (BaobabLocation* self) {
	GVolume* _tmp0_ = NULL;
	GMount* _tmp1_ = NULL;
	GMount* _tmp2_ = NULL;
	GMount* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	_tmp2_ = _tmp1_;
	baobab_location_set_mount (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_mount;
	if (_tmp3_ != NULL) {
		baobab_location_fill_from_mount (self);
	} else {
		GVolume* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		GVolume* _tmp7_ = NULL;
		GIcon* _tmp8_ = NULL;
		GIcon* _tmp9_ = NULL;
		_tmp4_ = self->priv->_volume;
		_tmp5_ = g_volume_get_name (_tmp4_);
		_tmp6_ = _tmp5_;
		baobab_location_set_name (self, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->_volume;
		_tmp8_ = g_volume_get_icon (_tmp7_);
		_tmp9_ = _tmp8_;
		baobab_location_set_icon (self, _tmp9_);
		_g_object_unref0 (_tmp9_);
		baobab_location_set_file (self, NULL);
		baobab_location_set_info (self, NULL);
		baobab_location_set_size (self, NULL);
		baobab_location_set_used (self, NULL);
		baobab_location_set_scanner (self, NULL);
	}
}


static void baobab_location_fill_from_mount (BaobabLocation* self) {
	GMount* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GMount* _tmp3_ = NULL;
	GIcon* _tmp4_ = NULL;
	GIcon* _tmp5_ = NULL;
	GMount* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GFile* _tmp10_ = NULL;
	GFile* _tmp16_ = NULL;
	BaobabScanner* _tmp17_ = NULL;
	BaobabScanner* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_mount;
	_tmp1_ = g_mount_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	baobab_location_set_name (self, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->_mount;
	_tmp4_ = g_mount_get_icon (_tmp3_);
	_tmp5_ = _tmp4_;
	baobab_location_set_icon (self, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_mount;
	_tmp7_ = g_mount_get_root (_tmp6_);
	_tmp8_ = _tmp7_;
	baobab_location_set_file (self, _tmp8_);
	_g_object_unref0 (_tmp8_);
	baobab_location_get_file_info (self);
	_tmp10_ = self->priv->_file;
	if (_tmp10_ != NULL) {
		GFile* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GFile* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
		gboolean _tmp15_ = FALSE;
		_tmp11_ = self->priv->_file;
		_tmp12_ = g_get_home_dir ();
		_tmp13_ = g_file_new_for_path (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_file_equal (_tmp11_, _tmp14_);
		_tmp9_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		baobab_location_make_this_home_location (self);
	}
	baobab_location_get_fs_usage (self);
	_tmp16_ = self->priv->_file;
	_tmp17_ = baobab_scanner_new (_tmp16_, BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS);
	_tmp18_ = _tmp17_;
	baobab_location_set_scanner (self, _tmp18_);
	_g_object_unref0 (_tmp18_);
}


static void baobab_location_get_file_info (BaobabLocation* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GFileInfo* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		_tmp1_ = self->priv->_file;
		_tmp2_ = g_file_query_info (_tmp1_, BAOBAB_LOCATION_FILE_ATTRIBUTES, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		baobab_location_set_info (self, _tmp0_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		baobab_location_set_info (self, NULL);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void baobab_location_get_fs_usage (BaobabLocation* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	baobab_location_set_size (self, NULL);
	baobab_location_set_used (self, NULL);
	baobab_location_set_reserved (self, NULL);
	{
		GFileInfo* info = NULL;
		GFile* _tmp0_ = NULL;
		GFileInfo* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		guint64* _tmp8_ = NULL;
		_tmp0_ = self->priv->_file;
		_tmp1_ = g_file_query_filesystem_info (_tmp0_, BAOBAB_LOCATION_FS_ATTRIBUTES, NULL, &_inner_error_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		_tmp2_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
		if (_tmp2_) {
			guint64 _tmp3_ = 0ULL;
			_tmp3_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_SIZE);
			baobab_location_set_size (self, &_tmp3_);
		}
		_tmp4_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_USED);
		if (_tmp4_) {
			guint64 _tmp5_ = 0ULL;
			_tmp5_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_USED);
			baobab_location_set_used (self, &_tmp5_);
		}
		_tmp8_ = self->priv->_size;
		if (_tmp8_ != NULL) {
			guint64* _tmp9_ = NULL;
			_tmp9_ = self->priv->_used;
			_tmp7_ = _tmp9_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			gboolean _tmp10_ = FALSE;
			_tmp10_ = g_file_info_has_attribute (info, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
			_tmp6_ = _tmp10_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			guint64 free = 0ULL;
			guint64 _tmp11_ = 0ULL;
			guint64* _tmp12_ = NULL;
			guint64 _tmp13_ = 0ULL;
			guint64* _tmp14_ = NULL;
			guint64 _tmp15_ = 0ULL;
			_tmp11_ = g_file_info_get_attribute_uint64 (info, G_FILE_ATTRIBUTE_FILESYSTEM_FREE);
			free = _tmp11_;
			_tmp12_ = self->priv->_size;
			_tmp13_ = free;
			_tmp14_ = self->priv->_used;
			_tmp15_ = ((*_tmp12_) - _tmp13_) - (*_tmp14_);
			baobab_location_set_reserved (self, &_tmp15_);
		}
		_g_object_unref0 (info);
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void baobab_location_mount_volume_data_free (gpointer _data) {
	BaobabLocationMountVolumeData* _data_;
	_data_ = _data;
	_baobab_location_unref0 (_data_->self);
	g_slice_free (BaobabLocationMountVolumeData, _data_);
}


void baobab_location_mount_volume (BaobabLocation* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BaobabLocationMountVolumeData* _data_;
	BaobabLocation* _tmp0_ = NULL;
	_data_ = g_slice_new0 (BaobabLocationMountVolumeData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, baobab_location_mount_volume);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, baobab_location_mount_volume_data_free);
	_tmp0_ = _baobab_location_ref0 (self);
	_data_->self = _tmp0_;
	baobab_location_mount_volume_co (_data_);
}


void baobab_location_mount_volume_finish (BaobabLocation* self, GAsyncResult* _res_, GError** error) {
	BaobabLocationMountVolumeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void baobab_location_mount_volume_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BaobabLocationMountVolumeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	baobab_location_mount_volume_co (_data_);
}


static gboolean baobab_location_mount_volume_co (BaobabLocationMountVolumeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->self->priv->_mount;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp0_ = TRUE;
	} else {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->self->priv->_volume;
		_data_->_tmp0_ = _data_->_tmp2_ == NULL;
	}
	if (_data_->_tmp0_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = (GtkMountOperation*) gtk_mount_operation_new (NULL);
	_data_->mount_op = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->_volume;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->mount_op;
	_data_->_state_ = 1;
	g_volume_mount (_data_->_tmp4_, G_MOUNT_MOUNT_NONE, (GMountOperation*) _data_->_tmp5_, NULL, baobab_location_mount_volume_ready, _data_);
	return FALSE;
	_state_1:
	g_volume_mount_finish (_data_->_tmp4_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->mount_op);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	baobab_location_update_volume_info (_data_->self);
	_g_object_unref0 (_data_->mount_op);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


BaobabLocation* baobab_location_construct (GType object_type) {
	BaobabLocation* self = NULL;
	self = (BaobabLocation*) g_type_create_instance (object_type);
	return self;
}


BaobabLocation* baobab_location_new (void) {
	return baobab_location_construct (BAOBAB_TYPE_LOCATION);
}


const gchar* baobab_location_get_name (BaobabLocation* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_name (BaobabLocation* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
}


GFile* baobab_location_get_file (BaobabLocation* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_location_set_file (BaobabLocation* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp1_;
}


GFileInfo* baobab_location_get_info (BaobabLocation* self) {
	GFileInfo* result;
	GFileInfo* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_info (BaobabLocation* self, GFileInfo* value) {
	GFileInfo* _tmp0_ = NULL;
	GFileInfo* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_info);
	self->priv->_info = _tmp1_;
}


gboolean baobab_location_get_is_volume (BaobabLocation* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_volume;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_is_volume (BaobabLocation* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_volume = _tmp0_;
}


guint64* baobab_location_get_size (BaobabLocation* self) {
	guint64* result;
	guint64* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_size;
	result = _tmp0_;
	return result;
}


static guint64* _uint64_dup (guint64* self) {
	guint64* dup;
	dup = g_new0 (guint64, 1);
	memcpy (dup, self, sizeof (guint64));
	return dup;
}


static gpointer __uint64_dup0 (gpointer self) {
	return self ? _uint64_dup (self) : NULL;
}


static void baobab_location_set_size (BaobabLocation* self, guint64* value) {
	guint64* _tmp0_ = NULL;
	guint64* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __uint64_dup0 (_tmp0_);
	_g_free0 (self->priv->_size);
	self->priv->_size = _tmp1_;
}


guint64* baobab_location_get_used (BaobabLocation* self) {
	guint64* result;
	guint64* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_used;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_used (BaobabLocation* self, guint64* value) {
	guint64* _tmp0_ = NULL;
	guint64* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __uint64_dup0 (_tmp0_);
	_g_free0 (self->priv->_used);
	self->priv->_used = _tmp1_;
}


guint64* baobab_location_get_reserved (BaobabLocation* self) {
	guint64* result;
	guint64* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_reserved;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_reserved (BaobabLocation* self, guint64* value) {
	guint64* _tmp0_ = NULL;
	guint64* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __uint64_dup0 (_tmp0_);
	_g_free0 (self->priv->_reserved);
	self->priv->_reserved = _tmp1_;
}


GIcon* baobab_location_get_icon (BaobabLocation* self) {
	GIcon* result;
	GIcon* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_icon (BaobabLocation* self, GIcon* value) {
	GIcon* _tmp0_ = NULL;
	GIcon* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = _tmp1_;
}


GVolume* baobab_location_get_volume (BaobabLocation* self) {
	GVolume* result;
	GVolume* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_volume;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_volume (BaobabLocation* self, GVolume* value) {
	GVolume* _tmp0_ = NULL;
	GVolume* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_volume);
	self->priv->_volume = _tmp1_;
}


GMount* baobab_location_get_mount (BaobabLocation* self) {
	GMount* result;
	GMount* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mount;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_mount (BaobabLocation* self, GMount* value) {
	GMount* _tmp0_ = NULL;
	GMount* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_mount);
	self->priv->_mount = _tmp1_;
}


BaobabScanner* baobab_location_get_scanner (BaobabLocation* self) {
	BaobabScanner* result;
	BaobabScanner* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_scanner;
	result = _tmp0_;
	return result;
}


static void baobab_location_set_scanner (BaobabLocation* self, BaobabScanner* value) {
	BaobabScanner* _tmp0_ = NULL;
	BaobabScanner* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_scanner);
	self->priv->_scanner = _tmp1_;
}


gboolean baobab_location_get_is_home (BaobabLocation* self) {
	gboolean result;
	BaobabLocation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = baobab_location_home_location;
	result = _tmp0_ == self;
	return result;
}


static void baobab_value_location_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void baobab_value_location_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		baobab_location_unref (value->data[0].v_pointer);
	}
}


static void baobab_value_location_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = baobab_location_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer baobab_value_location_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* baobab_value_location_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BaobabLocation* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = baobab_location_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* baobab_value_location_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BaobabLocation** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = baobab_location_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* baobab_param_spec_location (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BaobabParamSpecLocation* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BAOBAB_TYPE_LOCATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer baobab_value_get_location (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION), NULL);
	return value->data[0].v_pointer;
}


void baobab_value_set_location (GValue* value, gpointer v_object) {
	BaobabLocation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		baobab_location_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_location_unref (old);
	}
}


void baobab_value_take_location (GValue* value, gpointer v_object) {
	BaobabLocation* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_LOCATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_LOCATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_location_unref (old);
	}
}


static void baobab_location_class_init (BaobabLocationClass * klass) {
	baobab_location_parent_class = g_type_class_peek_parent (klass);
	((BaobabLocationClass *) klass)->finalize = baobab_location_finalize;
	g_type_class_add_private (klass, sizeof (BaobabLocationPrivate));
}


static void baobab_location_instance_init (BaobabLocation * self) {
	self->priv = BAOBAB_LOCATION_GET_PRIVATE (self);
	self->priv->_is_volume = TRUE;
	self->ref_count = 1;
}


static void baobab_location_finalize (BaobabLocation* obj) {
	BaobabLocation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_LOCATION, BaobabLocation);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_name);
	_g_object_unref0 (self->priv->_file);
	_g_object_unref0 (self->priv->_info);
	_g_free0 (self->priv->_size);
	_g_free0 (self->priv->_used);
	_g_free0 (self->priv->_reserved);
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->priv->_volume);
	_g_object_unref0 (self->priv->_mount);
	_g_object_unref0 (self->priv->_scanner);
}


GType baobab_location_get_type (void) {
	static volatile gsize baobab_location_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_location_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { baobab_value_location_init, baobab_value_location_free_value, baobab_value_location_copy_value, baobab_value_location_peek_pointer, "p", baobab_value_location_collect_value, "p", baobab_value_location_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BaobabLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabLocation), 0, (GInstanceInitFunc) baobab_location_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType baobab_location_type_id;
		baobab_location_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BaobabLocation", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&baobab_location_type_id__volatile, baobab_location_type_id);
	}
	return baobab_location_type_id__volatile;
}


gpointer baobab_location_ref (gpointer instance) {
	BaobabLocation* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void baobab_location_unref (gpointer instance) {
	BaobabLocation* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BAOBAB_LOCATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



