/* baobab-ringschart.c generated by valac 0.38.1.8-0ab50-dirty, the Vala compiler
 * generated from baobab-ringschart.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2008  Igalia
 * Copyright (C) 2013  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors of the original code:
 *   Felipe Erias <femorandeira@igalia.com>
 *   Pablo Santamaria <psantamaria@igalia.com>
 *   Jacobo Aragunde <jaragunde@igalia.com>
 *   Eduardo Lima <elima@igalia.com>
 *   Mario Sanchez <msanchez@igalia.com>
 *   Miguel Gomez <magomez@igalia.com>
 *   Henrique Ferreiro <hferreiro@igalia.com>
 *   Alejandro Pinheiro <apinheiro@igalia.com>
 *   Carlos Sanmartin <csanmartin@igalia.com>
 *   Alejandro Garcia <alex@igalia.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <pango/pango.h>


#define BAOBAB_TYPE_CHART_ITEM (baobab_chart_item_get_type ())
#define BAOBAB_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItem))
#define BAOBAB_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))
#define BAOBAB_IS_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_IS_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_CHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))

typedef struct _BaobabChartItem BaobabChartItem;
typedef struct _BaobabChartItemClass BaobabChartItemClass;
typedef struct _BaobabChartItemPrivate BaobabChartItemPrivate;

#define BAOBAB_TYPE_RINGSCHART_ITEM (baobab_ringschart_item_get_type ())
#define BAOBAB_RINGSCHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItem))
#define BAOBAB_RINGSCHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItemClass))
#define BAOBAB_IS_RINGSCHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_RINGSCHART_ITEM))
#define BAOBAB_IS_RINGSCHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_RINGSCHART_ITEM))
#define BAOBAB_RINGSCHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItemClass))

typedef struct _BaobabRingschartItem BaobabRingschartItem;
typedef struct _BaobabRingschartItemClass BaobabRingschartItemClass;
typedef struct _BaobabRingschartItemPrivate BaobabRingschartItemPrivate;
enum  {
	BAOBAB_RINGSCHART_ITEM_DUMMY_PROPERTY,
	BAOBAB_RINGSCHART_ITEM_LAST_PROPERTY
};
static GParamSpec* baobab_ringschart_item_properties[BAOBAB_RINGSCHART_ITEM_LAST_PROPERTY];

#define BAOBAB_TYPE_CHART (baobab_chart_get_type ())
#define BAOBAB_CHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART, BaobabChart))
#define BAOBAB_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART, BaobabChartClass))
#define BAOBAB_IS_CHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART))
#define BAOBAB_IS_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART))
#define BAOBAB_CHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART, BaobabChartClass))

typedef struct _BaobabChart BaobabChart;
typedef struct _BaobabChartClass BaobabChartClass;
typedef struct _BaobabChartPrivate BaobabChartPrivate;

#define BAOBAB_TYPE_RINGSCHART (baobab_ringschart_get_type ())
#define BAOBAB_RINGSCHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_RINGSCHART, BaobabRingschart))
#define BAOBAB_RINGSCHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_RINGSCHART, BaobabRingschartClass))
#define BAOBAB_IS_RINGSCHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_RINGSCHART))
#define BAOBAB_IS_RINGSCHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_RINGSCHART))
#define BAOBAB_RINGSCHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_RINGSCHART, BaobabRingschartClass))

typedef struct _BaobabRingschart BaobabRingschart;
typedef struct _BaobabRingschartClass BaobabRingschartClass;
typedef struct _BaobabRingschartPrivate BaobabRingschartPrivate;
enum  {
	BAOBAB_RINGSCHART_DUMMY_PROPERTY,
	BAOBAB_RINGSCHART_LAST_PROPERTY
};
static GParamSpec* baobab_ringschart_properties[BAOBAB_RINGSCHART_LAST_PROPERTY];
#define __g_list_free__baobab_chart_item_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__baobab_chart_item_unref0_ (var), NULL)))
#define _baobab_chart_item_unref0(var) ((var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _BaobabChartItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BaobabChartItemPrivate * priv;
	gchar* name;
	gchar* size;
	guint depth;
	gdouble rel_start;
	gdouble rel_size;
	GtkTreeIter iter;
	gboolean visible;
	gboolean has_any_child;
	gboolean has_visible_children;
	GdkRectangle rect;
	GList* parent;
};

struct _BaobabChartItemClass {
	GTypeClass parent_class;
	void (*finalize) (BaobabChartItem *self);
};

struct _BaobabRingschartItem {
	BaobabChartItem parent_instance;
	BaobabRingschartItemPrivate * priv;
	gdouble min_radius;
	gdouble max_radius;
	gdouble start_angle;
	gdouble angle;
	gboolean continued;
};

struct _BaobabRingschartItemClass {
	BaobabChartItemClass parent_class;
};

struct _BaobabChart {
	GtkDrawingArea parent_instance;
	BaobabChartPrivate * priv;
};

struct _BaobabChartClass {
	GtkDrawingAreaClass parent_class;
	void (*post_draw) (BaobabChart* self, cairo_t* cr);
	void (*draw_item) (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
	void (*calculate_item_geometry) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*is_point_over_item) (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
	void (*get_item_rectangle) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*can_zoom_in) (BaobabChart* self);
	gboolean (*can_zoom_out) (BaobabChart* self);
	BaobabChartItem* (*create_new_chartitem) (BaobabChart* self);
	void (*item_activated) (BaobabChart* self, GtkTreeIter* iter);
};

struct _BaobabRingschart {
	BaobabChart parent_instance;
	BaobabRingschartPrivate * priv;
};

struct _BaobabRingschartClass {
	BaobabChartClass parent_class;
};

struct _BaobabRingschartPrivate {
	guint tips_timeout_id;
	gboolean drawing_subtips;
	GList* subtip_items;
};


static gpointer baobab_ringschart_item_parent_class = NULL;
static gpointer baobab_ringschart_parent_class = NULL;

gpointer baobab_chart_item_ref (gpointer instance);
void baobab_chart_item_unref (gpointer instance);
GParamSpec* baobab_param_spec_chart_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_chart_item (GValue* value, gpointer v_object);
void baobab_value_take_chart_item (GValue* value, gpointer v_object);
gpointer baobab_value_get_chart_item (const GValue* value);
GType baobab_chart_item_get_type (void) G_GNUC_CONST;
GType baobab_ringschart_item_get_type (void) G_GNUC_CONST;
BaobabRingschartItem* baobab_ringschart_item_new (void);
BaobabRingschartItem* baobab_ringschart_item_construct (GType object_type);
BaobabChartItem* baobab_chart_item_construct (GType object_type);
static void baobab_ringschart_item_finalize (BaobabChartItem * obj);
GType baobab_chart_get_type (void) G_GNUC_CONST;
GType baobab_ringschart_get_type (void) G_GNUC_CONST;
#define BAOBAB_RINGSCHART_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_RINGSCHART, BaobabRingschartPrivate))
static void _baobab_chart_item_unref0_ (gpointer var);
static inline void _g_list_free__baobab_chart_item_unref0_ (GList* self);
#define BAOBAB_RINGSCHART_ITEM_BORDER_WIDTH 1
#define BAOBAB_RINGSCHART_ITEM_MIN_ANGLE 0.03
#define BAOBAB_RINGSCHART_EDGE_ANGLE 0.004
#define BAOBAB_RINGSCHART_SUBTIP_TIMEOUT 1000
static void baobab_ringschart_subtips_update (BaobabRingschart* self);
BaobabChartItem* baobab_chart_get_highlighted_item (BaobabChart* self);
static gboolean ___lambda23_ (BaobabRingschart* self);
static gboolean ____lambda23__gsource_func (gpointer self);
static BaobabChartItem* baobab_ringschart_real_create_new_chartitem (BaobabChart* base);
static void baobab_ringschart_real_post_draw (BaobabChart* base, cairo_t* cr);
static void baobab_ringschart_real_draw_item (BaobabChart* base, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
void baobab_chart_get_item_color (BaobabChart* self, gdouble rel_position, guint depth, gboolean highlighted, GdkRGBA* result);
static void baobab_ringschart_real_calculate_item_geometry (BaobabChart* base, BaobabChartItem* item);
guint baobab_chart_get_max_depth (BaobabChart* self);
void baobab_chart_get_item_rectangle (BaobabChart* self, BaobabChartItem* item);
static void baobab_ringschart_get_point_min_rect (BaobabRingschart* self, gdouble cx, gdouble cy, gdouble radius, gdouble angle, GdkRectangle* r);
static void baobab_ringschart_real_get_item_rectangle (BaobabChart* base, BaobabChartItem* item);
static gboolean baobab_ringschart_real_is_point_over_item (BaobabChart* base, BaobabChartItem* item, gdouble x, gdouble y);
static gboolean baobab_ringschart_real_can_zoom_out (BaobabChart* base);
#define BAOBAB_CHART_MAX_DEPTH ((guint) 5)
static gboolean baobab_ringschart_real_can_zoom_in (BaobabChart* base);
#define BAOBAB_CHART_MIN_DEPTH ((guint) 1)
BaobabRingschart* baobab_ringschart_new (void);
BaobabRingschart* baobab_ringschart_construct (GType object_type);
BaobabChart* baobab_chart_construct (GType object_type);
static GObject * baobab_ringschart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _baobab_ringschart_subtips_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void baobab_ringschart_finalize (GObject * obj);


BaobabRingschartItem* baobab_ringschart_item_construct (GType object_type) {
	BaobabRingschartItem* self = NULL;
	self = (BaobabRingschartItem*) baobab_chart_item_construct (object_type);
	return self;
}


BaobabRingschartItem* baobab_ringschart_item_new (void) {
	return baobab_ringschart_item_construct (BAOBAB_TYPE_RINGSCHART_ITEM);
}


static void baobab_ringschart_item_class_init (BaobabRingschartItemClass * klass) {
	baobab_ringschart_item_parent_class = g_type_class_peek_parent (klass);
	((BaobabChartItemClass *) klass)->finalize = baobab_ringschart_item_finalize;
}


static void baobab_ringschart_item_instance_init (BaobabRingschartItem * self) {
}


static void baobab_ringschart_item_finalize (BaobabChartItem * obj) {
	BaobabRingschartItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART_ITEM, BaobabRingschartItem);
	BAOBAB_CHART_ITEM_CLASS (baobab_ringschart_item_parent_class)->finalize (obj);
}


GType baobab_ringschart_item_get_type (void) {
	static volatile gsize baobab_ringschart_item_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_ringschart_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabRingschartItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_ringschart_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabRingschartItem), 0, (GInstanceInitFunc) baobab_ringschart_item_instance_init, NULL };
		GType baobab_ringschart_item_type_id;
		baobab_ringschart_item_type_id = g_type_register_static (BAOBAB_TYPE_CHART_ITEM, "BaobabRingschartItem", &g_define_type_info, 0);
		g_once_init_leave (&baobab_ringschart_item_type_id__volatile, baobab_ringschart_item_type_id);
	}
	return baobab_ringschart_item_type_id__volatile;
}


static void _baobab_chart_item_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL));
}


static inline void _g_list_free__baobab_chart_item_unref0_ (GList* self) {
	g_list_free_full (self, (GDestroyNotify) _baobab_chart_item_unref0_);
}


static gboolean ___lambda23_ (BaobabRingschart* self) {
	gboolean result = FALSE;
	self->priv->drawing_subtips = TRUE;
	self->priv->tips_timeout_id = (guint) 0;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean ____lambda23__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda23_ ((BaobabRingschart*) self);
	return result;
}


static void baobab_ringschart_subtips_update (BaobabRingschart* self) {
	gboolean _tmp0_;
	guint _tmp1_;
	BaobabChartItem* _tmp3_;
	BaobabChartItem* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drawing_subtips;
	if (_tmp0_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	self->priv->drawing_subtips = FALSE;
	_tmp1_ = self->priv->tips_timeout_id;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->tips_timeout_id;
		g_source_remove (_tmp2_);
		self->priv->tips_timeout_id = (guint) 0;
	}
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->subtip_items);
	self->priv->subtip_items = NULL;
	_tmp3_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		guint _tmp5_;
		_tmp5_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BAOBAB_RINGSCHART_SUBTIP_TIMEOUT, ____lambda23__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->tips_timeout_id = _tmp5_;
	}
}


static BaobabChartItem* baobab_ringschart_real_create_new_chartitem (BaobabChart* base) {
	BaobabRingschart * self;
	BaobabChartItem* result = NULL;
	BaobabRingschartItem* _tmp0_;
	BaobabChartItem* _tmp1_;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_ringschart_item_new ();
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_CHART_ITEM) ? ((BaobabChartItem*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_baobab_chart_item_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _baobab_chart_item_ref0 (gpointer self) {
	return self ? baobab_chart_item_ref (self) : NULL;
}


static void baobab_ringschart_real_post_draw (BaobabChart* base, cairo_t* cr) {
	BaobabRingschart * self;
	gboolean _tmp0_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStateFlags context_state = 0;
	GtkStyleContext* _tmp3_;
	GtkStateFlags _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp7_ = {0};
	gint q_width = 0;
	GtkAllocation _tmp8_;
	gint _tmp9_;
	gint q_height = 0;
	GtkAllocation _tmp10_;
	gint _tmp11_;
	gdouble q_angle = 0.0;
	gint _tmp12_;
	gint _tmp13_;
	gdouble _tmp14_;
	GdkRectangle last_rect = {0};
	GtkBorder padding = {0};
	GtkStyleContext* _tmp15_;
	GtkStateFlags _tmp16_;
	GtkBorder _tmp17_ = {0};
	gint16 vpadding = 0;
	GtkBorder _tmp18_;
	gint16 _tmp19_;
	GtkBorder _tmp20_;
	gint16 _tmp21_;
	gint16 hpadding = 0;
	GtkBorder _tmp22_;
	gint16 _tmp23_;
	GtkBorder _tmp24_;
	gint16 _tmp25_;
	GList* _tmp26_;
	GtkStyleContext* _tmp212_;
	self = (BaobabRingschart*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = self->priv->drawing_subtips;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	context = _tmp2_;
	_tmp3_ = context;
	_tmp4_ = gtk_style_context_get_state (_tmp3_);
	context_state = _tmp4_;
	_tmp5_ = context;
	gtk_style_context_save (_tmp5_);
	_tmp6_ = context;
	gtk_style_context_add_class (_tmp6_, "subfolder-tip");
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp7_);
	allocation = _tmp7_;
	_tmp8_ = allocation;
	_tmp9_ = _tmp8_.width;
	q_width = _tmp9_ / 2;
	_tmp10_ = allocation;
	_tmp11_ = _tmp10_.height;
	q_height = _tmp11_ / 2;
	_tmp12_ = q_height;
	_tmp13_ = q_width;
	_tmp14_ = atan2 ((gdouble) _tmp12_, (gdouble) _tmp13_);
	q_angle = _tmp14_;
	memset (&last_rect, 0, sizeof (GdkRectangle));
	_tmp15_ = context;
	_tmp16_ = context_state;
	gtk_style_context_get_padding (_tmp15_, _tmp16_, &_tmp17_);
	padding = _tmp17_;
	_tmp18_ = padding;
	_tmp19_ = _tmp18_.top;
	_tmp20_ = padding;
	_tmp21_ = _tmp20_.bottom;
	vpadding = _tmp19_ + _tmp21_;
	_tmp22_ = padding;
	_tmp23_ = _tmp22_.left;
	_tmp24_ = padding;
	_tmp25_ = _tmp24_.right;
	hpadding = _tmp23_ + _tmp25_;
	_tmp26_ = self->priv->subtip_items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp26_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp27_;
			BaobabChartItem* item = NULL;
			_tmp27_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp27_;
			{
				BaobabRingschartItem* ringsitem = NULL;
				BaobabChartItem* _tmp28_;
				BaobabRingschartItem* _tmp29_;
				gdouble middle_angle = 0.0;
				BaobabRingschartItem* _tmp30_;
				gdouble _tmp31_;
				BaobabRingschartItem* _tmp32_;
				gdouble _tmp33_;
				gdouble middle_angle_n = 0.0;
				gdouble _tmp34_;
				gdouble _tmp37_;
				gdouble _tmp38_;
				PangoLayout* layout = NULL;
				PangoLayout* _tmp39_;
				gchar* markup = NULL;
				BaobabChartItem* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				PangoLayout* _tmp48_;
				const gchar* _tmp49_;
				PangoLayout* _tmp50_;
				PangoLayout* _tmp51_;
				PangoLayout* _tmp52_;
				gint _tmp53_;
				PangoLayout* _tmp54_;
				PangoRectangle layout_rect = {0};
				PangoLayout* _tmp55_;
				PangoRectangle _tmp56_ = {0};
				gdouble tip_x = 0.0;
				gdouble tip_y = 0.0;
				gdouble _tmp57_;
				gdouble _tmp58_;
				cairo_rectangle_t tooltip_rect = {0};
				gint _tmp73_;
				gdouble _tmp74_;
				PangoRectangle _tmp75_;
				gint _tmp76_;
				GtkBorder _tmp77_;
				gint16 _tmp78_;
				gint _tmp79_;
				gdouble _tmp80_;
				PangoRectangle _tmp81_;
				gint _tmp82_;
				GtkBorder _tmp83_;
				gint16 _tmp84_;
				PangoRectangle _tmp85_;
				gint _tmp86_;
				gint16 _tmp87_;
				PangoRectangle _tmp88_;
				gint _tmp89_;
				gint16 _tmp90_;
				gdouble a = 0.0;
				gdouble _tmp91_;
				gint i = 0;
				GdkRectangle _rect = {0};
				cairo_rectangle_t _tmp108_;
				gdouble _tmp109_;
				cairo_rectangle_t _tmp110_;
				gdouble _tmp111_;
				cairo_rectangle_t _tmp112_;
				gdouble _tmp113_;
				cairo_rectangle_t _tmp114_;
				gdouble _tmp115_;
				GdkRectangle _tmp116_;
				gboolean _tmp117_;
				_tmp28_ = item;
				_tmp29_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp28_) : NULL);
				ringsitem = _tmp29_;
				_tmp30_ = ringsitem;
				_tmp31_ = _tmp30_->start_angle;
				_tmp32_ = ringsitem;
				_tmp33_ = _tmp32_->angle;
				middle_angle = _tmp31_ + (_tmp33_ / 2);
				_tmp34_ = middle_angle;
				middle_angle_n = _tmp34_;
				while (TRUE) {
					gdouble _tmp35_;
					gdouble _tmp36_;
					_tmp35_ = middle_angle_n;
					if (!(_tmp35_ > (G_PI / 2))) {
						break;
					}
					_tmp36_ = middle_angle_n;
					middle_angle_n = _tmp36_ - G_PI;
				}
				_tmp37_ = middle_angle_n;
				_tmp38_ = fabs (_tmp37_);
				middle_angle_n = _tmp38_;
				_tmp39_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
				layout = _tmp39_;
				_tmp40_ = item;
				_tmp41_ = _tmp40_->name;
				_tmp42_ = g_markup_escape_text (_tmp41_, (gssize) -1);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strconcat ("<span size=\"small\">", _tmp43_, NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strconcat (_tmp45_, "</span>", NULL);
				_tmp47_ = _tmp46_;
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				markup = _tmp47_;
				_tmp48_ = layout;
				_tmp49_ = markup;
				pango_layout_set_markup (_tmp48_, _tmp49_, -1);
				_tmp50_ = layout;
				pango_layout_set_indent (_tmp50_, 0);
				_tmp51_ = layout;
				pango_layout_set_spacing (_tmp51_, 0);
				_tmp52_ = layout;
				_tmp53_ = q_width;
				pango_layout_set_width (_tmp52_, (PANGO_SCALE * _tmp53_) / 2);
				_tmp54_ = layout;
				pango_layout_set_ellipsize (_tmp54_, PANGO_ELLIPSIZE_END);
				_tmp55_ = layout;
				pango_layout_get_pixel_extents (_tmp55_, NULL, &_tmp56_);
				layout_rect = _tmp56_;
				_tmp57_ = middle_angle_n;
				_tmp58_ = q_angle;
				if (_tmp57_ < _tmp58_) {
					gint _tmp59_;
					PangoRectangle _tmp60_;
					gint _tmp61_;
					gint16 _tmp62_;
					gdouble _tmp63_;
					gdouble _tmp64_;
					gdouble _tmp65_;
					_tmp59_ = q_width;
					_tmp60_ = layout_rect;
					_tmp61_ = _tmp60_.width;
					_tmp62_ = hpadding;
					tip_x = (gdouble) ((_tmp59_ - (_tmp61_ / 2)) - _tmp62_);
					_tmp63_ = middle_angle_n;
					_tmp64_ = tan (_tmp63_);
					_tmp65_ = tip_x;
					tip_y = _tmp64_ * _tmp65_;
				} else {
					gint _tmp66_;
					PangoRectangle _tmp67_;
					gint _tmp68_;
					gint16 _tmp69_;
					gdouble _tmp70_;
					gdouble _tmp71_;
					gdouble _tmp72_;
					_tmp66_ = q_height;
					_tmp67_ = layout_rect;
					_tmp68_ = _tmp67_.height;
					_tmp69_ = vpadding;
					tip_y = (gdouble) ((_tmp66_ - (_tmp68_ / 2)) - _tmp69_);
					_tmp70_ = tip_y;
					_tmp71_ = middle_angle_n;
					_tmp72_ = tan (_tmp71_);
					tip_x = _tmp70_ / _tmp72_;
				}
				memset (&tooltip_rect, 0, sizeof (cairo_rectangle_t));
				_tmp73_ = q_width;
				_tmp74_ = tip_x;
				_tmp75_ = layout_rect;
				_tmp76_ = _tmp75_.width;
				_tmp77_ = padding;
				_tmp78_ = _tmp77_.left;
				tooltip_rect.x = ((_tmp73_ + _tmp74_) - (_tmp76_ / 2)) - _tmp78_;
				_tmp79_ = q_height;
				_tmp80_ = tip_y;
				_tmp81_ = layout_rect;
				_tmp82_ = _tmp81_.height;
				_tmp83_ = padding;
				_tmp84_ = _tmp83_.top;
				tooltip_rect.y = ((_tmp79_ + _tmp80_) - (_tmp82_ / 2)) - _tmp84_;
				_tmp85_ = layout_rect;
				_tmp86_ = _tmp85_.width;
				_tmp87_ = hpadding;
				tooltip_rect.width = (gdouble) (_tmp86_ + _tmp87_);
				_tmp88_ = layout_rect;
				_tmp89_ = _tmp88_.height;
				_tmp90_ = vpadding;
				tooltip_rect.height = (gdouble) (_tmp89_ + _tmp90_);
				_tmp91_ = middle_angle;
				a = _tmp91_;
				i = 0;
				while (TRUE) {
					gdouble _tmp92_;
					gint _tmp93_;
					gint _tmp106_;
					gdouble _tmp107_;
					_tmp92_ = a;
					if (!(_tmp92_ > (G_PI / 2))) {
						break;
					}
					_tmp93_ = i;
					if ((_tmp93_ % 2) == 0) {
						GtkAllocation _tmp94_;
						gint _tmp95_;
						cairo_rectangle_t _tmp96_;
						gdouble _tmp97_;
						cairo_rectangle_t _tmp98_;
						gdouble _tmp99_;
						_tmp94_ = allocation;
						_tmp95_ = _tmp94_.width;
						_tmp96_ = tooltip_rect;
						_tmp97_ = _tmp96_.x;
						_tmp98_ = tooltip_rect;
						_tmp99_ = _tmp98_.width;
						tooltip_rect.x = (_tmp95_ - _tmp97_) - _tmp99_;
					} else {
						GtkAllocation _tmp100_;
						gint _tmp101_;
						cairo_rectangle_t _tmp102_;
						gdouble _tmp103_;
						cairo_rectangle_t _tmp104_;
						gdouble _tmp105_;
						_tmp100_ = allocation;
						_tmp101_ = _tmp100_.height;
						_tmp102_ = tooltip_rect;
						_tmp103_ = _tmp102_.y;
						_tmp104_ = tooltip_rect;
						_tmp105_ = _tmp104_.height;
						tooltip_rect.y = (_tmp101_ - _tmp103_) - _tmp105_;
					}
					_tmp106_ = i;
					i = _tmp106_ + 1;
					_tmp107_ = a;
					a = _tmp107_ - (G_PI / 2);
				}
				memset (&_rect, 0, sizeof (GdkRectangle));
				_tmp108_ = tooltip_rect;
				_tmp109_ = _tmp108_.x;
				_rect.x = (gint) (_tmp109_ - 1);
				_tmp110_ = tooltip_rect;
				_tmp111_ = _tmp110_.y;
				_rect.y = (gint) (_tmp111_ - 1);
				_tmp112_ = tooltip_rect;
				_tmp113_ = _tmp112_.width;
				_rect.width = (gint) (_tmp113_ + 2);
				_tmp114_ = tooltip_rect;
				_tmp115_ = _tmp114_.height;
				_rect.height = (gint) (_tmp115_ + 2);
				_tmp116_ = last_rect;
				_tmp117_ = gdk_rectangle_intersect (&_rect, &_tmp116_, NULL);
				if (!_tmp117_) {
					GdkRectangle _tmp118_;
					cairo_rectangle_t _tmp119_;
					gdouble _tmp120_;
					gdouble _tmp121_;
					cairo_rectangle_t _tmp122_;
					gdouble _tmp123_;
					gdouble _tmp124_;
					gdouble middle_radius = 0.0;
					BaobabRingschartItem* _tmp125_;
					gdouble _tmp126_;
					BaobabRingschartItem* _tmp127_;
					gdouble _tmp128_;
					BaobabRingschartItem* _tmp129_;
					gdouble _tmp130_;
					gdouble sector_center_x = 0.0;
					gint _tmp131_;
					gdouble _tmp132_;
					gdouble _tmp133_;
					gdouble _tmp134_;
					gdouble sector_center_y = 0.0;
					gint _tmp135_;
					gdouble _tmp136_;
					gdouble _tmp137_;
					gdouble _tmp138_;
					cairo_t* _tmp139_;
					cairo_t* _tmp140_;
					GtkAllocation _tmp141_;
					gint _tmp142_;
					GtkAllocation _tmp143_;
					gint _tmp144_;
					cairo_t* _tmp145_;
					cairo_rectangle_t _tmp146_;
					gdouble _tmp147_;
					cairo_rectangle_t _tmp148_;
					gdouble _tmp149_;
					cairo_rectangle_t _tmp150_;
					gdouble _tmp151_;
					cairo_rectangle_t _tmp152_;
					gdouble _tmp153_;
					cairo_rectangle_t _tmp154_;
					gdouble _tmp155_;
					cairo_t* _tmp156_;
					GdkRGBA bg_color = {0};
					GtkStyleContext* _tmp157_;
					GtkStateFlags _tmp158_;
					GdkRGBA _tmp159_ = {0};
					cairo_t* _tmp160_;
					cairo_t* _tmp161_;
					gdouble _tmp162_;
					gdouble _tmp163_;
					cairo_t* _tmp164_;
					GdkRGBA _tmp165_;
					cairo_t* _tmp166_;
					cairo_rectangle_t _tmp167_;
					gdouble _tmp168_;
					cairo_rectangle_t _tmp169_;
					gdouble _tmp170_;
					cairo_rectangle_t _tmp171_;
					gdouble _tmp172_;
					cairo_rectangle_t _tmp173_;
					gdouble _tmp174_;
					cairo_t* _tmp175_;
					cairo_t* _tmp176_;
					cairo_t* _tmp177_;
					gdouble _tmp178_;
					gdouble _tmp179_;
					cairo_t* _tmp180_;
					GtkStyleContext* _tmp181_;
					cairo_t* _tmp182_;
					cairo_rectangle_t _tmp183_;
					gdouble _tmp184_;
					cairo_rectangle_t _tmp185_;
					gdouble _tmp186_;
					cairo_rectangle_t _tmp187_;
					gdouble _tmp188_;
					cairo_rectangle_t _tmp189_;
					gdouble _tmp190_;
					GtkStyleContext* _tmp191_;
					cairo_t* _tmp192_;
					cairo_rectangle_t _tmp193_;
					gdouble _tmp194_;
					cairo_rectangle_t _tmp195_;
					gdouble _tmp196_;
					cairo_rectangle_t _tmp197_;
					gdouble _tmp198_;
					cairo_rectangle_t _tmp199_;
					gdouble _tmp200_;
					GtkStyleContext* _tmp201_;
					cairo_t* _tmp202_;
					cairo_rectangle_t _tmp203_;
					gdouble _tmp204_;
					GtkBorder _tmp205_;
					gint16 _tmp206_;
					cairo_rectangle_t _tmp207_;
					gdouble _tmp208_;
					GtkBorder _tmp209_;
					gint16 _tmp210_;
					PangoLayout* _tmp211_;
					_tmp118_ = _rect;
					last_rect = _tmp118_;
					_tmp119_ = tooltip_rect;
					_tmp120_ = _tmp119_.x;
					_tmp121_ = floor (_tmp120_);
					tooltip_rect.x = _tmp121_;
					_tmp122_ = tooltip_rect;
					_tmp123_ = _tmp122_.y;
					_tmp124_ = floor (_tmp123_);
					tooltip_rect.y = _tmp124_;
					_tmp125_ = ringsitem;
					_tmp126_ = _tmp125_->min_radius;
					_tmp127_ = ringsitem;
					_tmp128_ = _tmp127_->max_radius;
					_tmp129_ = ringsitem;
					_tmp130_ = _tmp129_->min_radius;
					middle_radius = _tmp126_ + ((_tmp128_ - _tmp130_) / 2);
					_tmp131_ = q_width;
					_tmp132_ = middle_radius;
					_tmp133_ = middle_angle;
					_tmp134_ = cos (_tmp133_);
					sector_center_x = _tmp131_ + (_tmp132_ * _tmp134_);
					_tmp135_ = q_height;
					_tmp136_ = middle_radius;
					_tmp137_ = middle_angle;
					_tmp138_ = sin (_tmp137_);
					sector_center_y = _tmp135_ + (_tmp136_ * _tmp138_);
					_tmp139_ = cr;
					cairo_save (_tmp139_);
					_tmp140_ = cr;
					_tmp141_ = allocation;
					_tmp142_ = _tmp141_.width;
					_tmp143_ = allocation;
					_tmp144_ = _tmp143_.height;
					cairo_rectangle (_tmp140_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp142_, (gdouble) _tmp144_);
					_tmp145_ = cr;
					_tmp146_ = tooltip_rect;
					_tmp147_ = _tmp146_.x;
					_tmp148_ = tooltip_rect;
					_tmp149_ = _tmp148_.width;
					_tmp150_ = tooltip_rect;
					_tmp151_ = _tmp150_.y;
					_tmp152_ = tooltip_rect;
					_tmp153_ = _tmp152_.width;
					_tmp154_ = tooltip_rect;
					_tmp155_ = _tmp154_.height;
					cairo_rectangle (_tmp145_, _tmp147_ + _tmp149_, _tmp151_, -_tmp153_, _tmp155_);
					_tmp156_ = cr;
					cairo_clip (_tmp156_);
					_tmp157_ = context;
					_tmp158_ = context_state;
					gtk_style_context_get_background_color (_tmp157_, _tmp158_, &_tmp159_);
					bg_color = _tmp159_;
					_tmp160_ = cr;
					cairo_set_line_width (_tmp160_, (gdouble) 1);
					_tmp161_ = cr;
					_tmp162_ = sector_center_x;
					_tmp163_ = sector_center_y;
					cairo_move_to (_tmp161_, _tmp162_, _tmp163_);
					_tmp164_ = cr;
					_tmp165_ = bg_color;
					gdk_cairo_set_source_rgba (_tmp164_, &_tmp165_);
					_tmp166_ = cr;
					_tmp167_ = tooltip_rect;
					_tmp168_ = _tmp167_.x;
					_tmp169_ = tooltip_rect;
					_tmp170_ = _tmp169_.width;
					_tmp171_ = tooltip_rect;
					_tmp172_ = _tmp171_.y;
					_tmp173_ = tooltip_rect;
					_tmp174_ = _tmp173_.height;
					cairo_line_to (_tmp166_, _tmp168_ + (_tmp170_ / 2), _tmp172_ + (_tmp174_ / 2));
					_tmp175_ = cr;
					cairo_stroke (_tmp175_);
					_tmp176_ = cr;
					cairo_restore (_tmp176_);
					_tmp177_ = cr;
					_tmp178_ = sector_center_x;
					_tmp179_ = sector_center_y;
					cairo_arc (_tmp177_, _tmp178_, _tmp179_, 1.0, (gdouble) 0, 2 * G_PI);
					_tmp180_ = cr;
					cairo_stroke (_tmp180_);
					_tmp181_ = context;
					_tmp182_ = cr;
					_tmp183_ = tooltip_rect;
					_tmp184_ = _tmp183_.x;
					_tmp185_ = tooltip_rect;
					_tmp186_ = _tmp185_.y;
					_tmp187_ = tooltip_rect;
					_tmp188_ = _tmp187_.width;
					_tmp189_ = tooltip_rect;
					_tmp190_ = _tmp189_.height;
					gtk_render_background (_tmp181_, _tmp182_, _tmp184_, _tmp186_, _tmp188_, _tmp190_);
					_tmp191_ = context;
					_tmp192_ = cr;
					_tmp193_ = tooltip_rect;
					_tmp194_ = _tmp193_.x;
					_tmp195_ = tooltip_rect;
					_tmp196_ = _tmp195_.y;
					_tmp197_ = tooltip_rect;
					_tmp198_ = _tmp197_.width;
					_tmp199_ = tooltip_rect;
					_tmp200_ = _tmp199_.height;
					gtk_render_frame (_tmp191_, _tmp192_, _tmp194_, _tmp196_, _tmp198_, _tmp200_);
					_tmp201_ = context;
					_tmp202_ = cr;
					_tmp203_ = tooltip_rect;
					_tmp204_ = _tmp203_.x;
					_tmp205_ = padding;
					_tmp206_ = _tmp205_.left;
					_tmp207_ = tooltip_rect;
					_tmp208_ = _tmp207_.y;
					_tmp209_ = padding;
					_tmp210_ = _tmp209_.top;
					_tmp211_ = layout;
					gtk_render_layout (_tmp201_, _tmp202_, _tmp204_ + _tmp206_, _tmp208_ + _tmp210_, _tmp211_);
				}
				_g_free0 (markup);
				_g_object_unref0 (layout);
				_baobab_chart_item_unref0 (ringsitem);
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	_tmp212_ = context;
	gtk_style_context_restore (_tmp212_);
	_g_object_unref0 (context);
}


static void baobab_ringschart_real_draw_item (BaobabChart* base, cairo_t* cr, BaobabChartItem* item, gboolean highlighted) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_;
	BaobabRingschartItem* _tmp1_;
	gboolean _tmp2_;
	cairo_t* _tmp16_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp17_ = {0};
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp18_;
	GtkStyleContext* _tmp19_;
	GtkStateFlags context_state = 0;
	GtkStyleContext* _tmp20_;
	GtkStateFlags _tmp21_;
	GtkStyleContext* _tmp22_;
	GtkStyleContext* toplevel_context = NULL;
	GtkWidget* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkStyleContext* _tmp25_;
	GtkStateFlags toplevel_context_state = 0;
	GtkStyleContext* _tmp26_;
	GtkStateFlags _tmp27_;
	GdkRGBA border_color = {0};
	GtkStyleContext* _tmp28_;
	GtkStateFlags _tmp29_;
	GdkRGBA _tmp30_ = {0};
	GdkRGBA bg_color = {0};
	GtkStyleContext* _tmp31_;
	GtkStateFlags _tmp32_;
	GdkRGBA _tmp33_ = {0};
	gint center_x = 0;
	GtkAllocation _tmp34_;
	gint _tmp35_;
	gint center_y = 0;
	GtkAllocation _tmp36_;
	gint _tmp37_;
	gdouble final_angle = 0.0;
	BaobabRingschartItem* _tmp38_;
	gdouble _tmp39_;
	BaobabRingschartItem* _tmp40_;
	gdouble _tmp41_;
	BaobabChartItem* _tmp42_;
	guint _tmp43_;
	GtkStyleContext* _tmp128_;
	self = (BaobabRingschart*) base;
	g_return_if_fail (cr != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	_tmp2_ = self->priv->drawing_subtips;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		BaobabChartItem* _tmp5_;
		BaobabChartItem* _tmp6_;
		_tmp5_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != NULL) {
			BaobabChartItem* _tmp7_;
			GList* _tmp8_;
			_tmp7_ = item;
			_tmp8_ = _tmp7_->parent;
			_tmp4_ = _tmp8_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			BaobabChartItem* _tmp9_;
			GList* _tmp10_;
			gconstpointer _tmp11_;
			BaobabChartItem* _tmp12_;
			BaobabChartItem* _tmp13_;
			_tmp9_ = item;
			_tmp10_ = _tmp9_->parent;
			_tmp11_ = _tmp10_->data;
			_tmp12_ = baobab_chart_get_highlighted_item ((BaobabChart*) self);
			_tmp13_ = _tmp12_;
			_tmp3_ = ((BaobabChartItem*) _tmp11_) == _tmp13_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			BaobabChartItem* _tmp14_;
			BaobabChartItem* _tmp15_;
			_tmp14_ = item;
			_tmp15_ = _baobab_chart_item_ref0 (_tmp14_);
			self->priv->subtip_items = g_list_append (self->priv->subtip_items, _tmp15_);
		}
	}
	_tmp16_ = cr;
	cairo_set_line_width (_tmp16_, (gdouble) BAOBAB_RINGSCHART_ITEM_BORDER_WIDTH);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp17_);
	allocation = _tmp17_;
	_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	context = _tmp19_;
	_tmp20_ = context;
	_tmp21_ = gtk_style_context_get_state (_tmp20_);
	context_state = _tmp21_;
	_tmp22_ = context;
	gtk_style_context_save (_tmp22_);
	_tmp23_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp24_ = gtk_widget_get_style_context (_tmp23_);
	_tmp25_ = _g_object_ref0 (_tmp24_);
	toplevel_context = _tmp25_;
	_tmp26_ = toplevel_context;
	_tmp27_ = gtk_style_context_get_state (_tmp26_);
	toplevel_context_state = _tmp27_;
	_tmp28_ = context;
	_tmp29_ = context_state;
	gtk_style_context_get_border_color (_tmp28_, _tmp29_, &_tmp30_);
	border_color = _tmp30_;
	_tmp31_ = toplevel_context;
	_tmp32_ = toplevel_context_state;
	gtk_style_context_get_background_color (_tmp31_, _tmp32_, &_tmp33_);
	bg_color = _tmp33_;
	_tmp34_ = allocation;
	_tmp35_ = _tmp34_.width;
	center_x = _tmp35_ / 2;
	_tmp36_ = allocation;
	_tmp37_ = _tmp36_.height;
	center_y = _tmp37_ / 2;
	_tmp38_ = ringsitem;
	_tmp39_ = _tmp38_->start_angle;
	_tmp40_ = ringsitem;
	_tmp41_ = _tmp40_->angle;
	final_angle = _tmp39_ + _tmp41_;
	_tmp42_ = item;
	_tmp43_ = _tmp42_->depth;
	if (_tmp43_ == ((guint) 0)) {
		PangoLayout* layout = NULL;
		PangoLayout* _tmp44_;
		gchar* markup = NULL;
		BaobabChartItem* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		PangoLayout* _tmp53_;
		const gchar* _tmp54_;
		PangoLayout* _tmp55_;
		PangoLayout* _tmp56_;
		PangoRectangle layout_rect = {0};
		PangoLayout* _tmp57_;
		PangoRectangle _tmp58_ = {0};
		PangoRectangle _tmp59_;
		gint _tmp60_;
		BaobabRingschartItem* _tmp61_;
		gdouble _tmp62_;
		cairo_t* _tmp77_;
		gint _tmp78_;
		gint _tmp79_;
		BaobabRingschartItem* _tmp80_;
		gdouble _tmp81_;
		cairo_t* _tmp82_;
		GdkRGBA _tmp83_;
		cairo_t* _tmp84_;
		_tmp44_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
		layout = _tmp44_;
		_tmp45_ = item;
		_tmp46_ = _tmp45_->size;
		_tmp47_ = g_markup_escape_text (_tmp46_, (gssize) -1);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat ("<span size=\"small\">", _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_tmp50_, "</span>", NULL);
		_tmp52_ = _tmp51_;
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		markup = _tmp52_;
		_tmp53_ = layout;
		_tmp54_ = markup;
		pango_layout_set_markup (_tmp53_, _tmp54_, -1);
		_tmp55_ = layout;
		pango_layout_set_indent (_tmp55_, 0);
		_tmp56_ = layout;
		pango_layout_set_spacing (_tmp56_, 0);
		_tmp57_ = layout;
		pango_layout_get_pixel_extents (_tmp57_, NULL, &_tmp58_);
		layout_rect = _tmp58_;
		_tmp59_ = layout_rect;
		_tmp60_ = _tmp59_.width;
		_tmp61_ = ringsitem;
		_tmp62_ = _tmp61_->max_radius;
		if (((gdouble) _tmp60_) < (2 * _tmp62_)) {
			GtkStyleContext* _tmp63_;
			cairo_t* _tmp64_;
			gint _tmp65_;
			PangoRectangle _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			PangoRectangle _tmp69_;
			gint _tmp70_;
			PangoLayout* _tmp71_;
			cairo_t* _tmp72_;
			gint _tmp73_;
			BaobabRingschartItem* _tmp74_;
			gdouble _tmp75_;
			gint _tmp76_;
			_tmp63_ = context;
			_tmp64_ = cr;
			_tmp65_ = center_x;
			_tmp66_ = layout_rect;
			_tmp67_ = _tmp66_.width;
			_tmp68_ = center_y;
			_tmp69_ = layout_rect;
			_tmp70_ = _tmp69_.height;
			_tmp71_ = layout;
			gtk_render_layout (_tmp63_, _tmp64_, (gdouble) (_tmp65_ - (_tmp67_ / 2)), (gdouble) (_tmp68_ - (_tmp70_ / 2)), _tmp71_);
			_tmp72_ = cr;
			_tmp73_ = center_x;
			_tmp74_ = ringsitem;
			_tmp75_ = _tmp74_->max_radius;
			_tmp76_ = center_y;
			cairo_move_to (_tmp72_, (_tmp73_ + _tmp75_) + 1, (gdouble) _tmp76_);
		}
		_tmp77_ = cr;
		_tmp78_ = center_x;
		_tmp79_ = center_y;
		_tmp80_ = ringsitem;
		_tmp81_ = _tmp80_->max_radius;
		cairo_arc (_tmp77_, (gdouble) _tmp78_, (gdouble) _tmp79_, _tmp81_ + 1, (gdouble) 0, 2 * G_PI);
		_tmp82_ = cr;
		_tmp83_ = border_color;
		gdk_cairo_set_source_rgba (_tmp82_, &_tmp83_);
		_tmp84_ = cr;
		cairo_stroke (_tmp84_);
		_g_free0 (markup);
		_g_object_unref0 (layout);
	} else {
		GdkRGBA fill_color = {0};
		BaobabRingschartItem* _tmp85_;
		gdouble _tmp86_;
		BaobabChartItem* _tmp87_;
		guint _tmp88_;
		gboolean _tmp89_;
		GdkRGBA _tmp90_ = {0};
		cairo_t* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		BaobabRingschartItem* _tmp94_;
		gdouble _tmp95_;
		BaobabRingschartItem* _tmp96_;
		gdouble _tmp97_;
		gdouble _tmp98_;
		cairo_t* _tmp99_;
		gint _tmp100_;
		gint _tmp101_;
		BaobabRingschartItem* _tmp102_;
		gdouble _tmp103_;
		gdouble _tmp104_;
		BaobabRingschartItem* _tmp105_;
		gdouble _tmp106_;
		cairo_t* _tmp107_;
		cairo_t* _tmp108_;
		GdkRGBA _tmp109_;
		cairo_t* _tmp110_;
		cairo_t* _tmp111_;
		GdkRGBA _tmp112_;
		cairo_t* _tmp113_;
		BaobabRingschartItem* _tmp114_;
		gboolean _tmp115_;
		_tmp85_ = ringsitem;
		_tmp86_ = _tmp85_->start_angle;
		_tmp87_ = item;
		_tmp88_ = _tmp87_->depth;
		_tmp89_ = highlighted;
		baobab_chart_get_item_color ((BaobabChart*) self, (_tmp86_ / G_PI) * 99, _tmp88_, _tmp89_, &_tmp90_);
		fill_color = _tmp90_;
		_tmp91_ = cr;
		_tmp92_ = center_x;
		_tmp93_ = center_y;
		_tmp94_ = ringsitem;
		_tmp95_ = _tmp94_->min_radius;
		_tmp96_ = ringsitem;
		_tmp97_ = _tmp96_->start_angle;
		_tmp98_ = final_angle;
		cairo_arc (_tmp91_, (gdouble) _tmp92_, (gdouble) _tmp93_, _tmp95_, _tmp97_, _tmp98_);
		_tmp99_ = cr;
		_tmp100_ = center_x;
		_tmp101_ = center_y;
		_tmp102_ = ringsitem;
		_tmp103_ = _tmp102_->max_radius;
		_tmp104_ = final_angle;
		_tmp105_ = ringsitem;
		_tmp106_ = _tmp105_->start_angle;
		cairo_arc_negative (_tmp99_, (gdouble) _tmp100_, (gdouble) _tmp101_, _tmp103_, _tmp104_, _tmp106_);
		_tmp107_ = cr;
		cairo_close_path (_tmp107_);
		_tmp108_ = cr;
		_tmp109_ = fill_color;
		gdk_cairo_set_source_rgba (_tmp108_, &_tmp109_);
		_tmp110_ = cr;
		cairo_fill_preserve (_tmp110_);
		_tmp111_ = cr;
		_tmp112_ = bg_color;
		gdk_cairo_set_source_rgba (_tmp111_, &_tmp112_);
		_tmp113_ = cr;
		cairo_stroke (_tmp113_);
		_tmp114_ = ringsitem;
		_tmp115_ = _tmp114_->continued;
		if (_tmp115_) {
			cairo_t* _tmp116_;
			GdkRGBA _tmp117_;
			cairo_t* _tmp118_;
			cairo_t* _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			BaobabRingschartItem* _tmp122_;
			gdouble _tmp123_;
			BaobabRingschartItem* _tmp124_;
			gdouble _tmp125_;
			gdouble _tmp126_;
			cairo_t* _tmp127_;
			_tmp116_ = cr;
			_tmp117_ = border_color;
			gdk_cairo_set_source_rgba (_tmp116_, &_tmp117_);
			_tmp118_ = cr;
			cairo_set_line_width (_tmp118_, (gdouble) 3);
			_tmp119_ = cr;
			_tmp120_ = center_x;
			_tmp121_ = center_y;
			_tmp122_ = ringsitem;
			_tmp123_ = _tmp122_->max_radius;
			_tmp124_ = ringsitem;
			_tmp125_ = _tmp124_->start_angle;
			_tmp126_ = final_angle;
			cairo_arc (_tmp119_, (gdouble) _tmp120_, (gdouble) _tmp121_, _tmp123_ + 4, _tmp125_ + BAOBAB_RINGSCHART_EDGE_ANGLE, _tmp126_ - BAOBAB_RINGSCHART_EDGE_ANGLE);
			_tmp127_ = cr;
			cairo_stroke (_tmp127_);
		}
	}
	_tmp128_ = context;
	gtk_style_context_restore (_tmp128_);
	_g_object_unref0 (toplevel_context);
	_g_object_unref0 (context);
	_baobab_chart_item_unref0 (ringsitem);
}


static void baobab_ringschart_real_calculate_item_geometry (BaobabChart* base, BaobabChartItem* item) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_;
	BaobabRingschartItem* _tmp1_;
	BaobabRingschartItem* _tmp2_;
	BaobabRingschartItem* _tmp3_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp4_ = {0};
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStateFlags context_state = 0;
	GtkStyleContext* _tmp7_;
	GtkStateFlags _tmp8_;
	GtkBorder padding = {0};
	GtkStyleContext* _tmp9_;
	GtkStateFlags _tmp10_;
	GtkBorder _tmp11_ = {0};
	gint max_radius = 0;
	GtkAllocation _tmp12_;
	gint _tmp13_;
	GtkAllocation _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GtkBorder _tmp17_;
	gint16 _tmp18_;
	guint thickness = 0U;
	gint _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	BaobabRingschartItem* _tmp22_;
	GList* _tmp23_;
	BaobabRingschartItem* _tmp69_;
	BaobabChartItem* _tmp70_;
	self = (BaobabRingschart*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	_tmp2_ = ringsitem;
	_tmp2_->continued = FALSE;
	_tmp3_ = ringsitem;
	((BaobabChartItem*) _tmp3_)->visible = FALSE;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp4_);
	allocation = _tmp4_;
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	context = _tmp6_;
	_tmp7_ = context;
	_tmp8_ = gtk_style_context_get_state (_tmp7_);
	context_state = _tmp8_;
	_tmp9_ = context;
	_tmp10_ = context_state;
	gtk_style_context_get_padding (_tmp9_, _tmp10_, &_tmp11_);
	padding = _tmp11_;
	_tmp12_ = allocation;
	_tmp13_ = _tmp12_.width;
	_tmp14_ = allocation;
	_tmp15_ = _tmp14_.height;
	_tmp16_ = MIN (_tmp13_ / 2, _tmp15_ / 2);
	_tmp17_ = padding;
	_tmp18_ = _tmp17_.left;
	max_radius = _tmp16_ - _tmp18_;
	_tmp19_ = max_radius;
	_tmp20_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp21_ = _tmp20_;
	thickness = _tmp19_ / (_tmp21_ + 1);
	_tmp22_ = ringsitem;
	_tmp23_ = ((BaobabChartItem*) _tmp22_)->parent;
	if (_tmp23_ == NULL) {
		BaobabRingschartItem* _tmp24_;
		BaobabRingschartItem* _tmp25_;
		guint _tmp26_;
		BaobabRingschartItem* _tmp27_;
		BaobabRingschartItem* _tmp28_;
		_tmp24_ = ringsitem;
		_tmp24_->min_radius = (gdouble) 0;
		_tmp25_ = ringsitem;
		_tmp26_ = thickness;
		_tmp25_->max_radius = (gdouble) _tmp26_;
		_tmp27_ = ringsitem;
		_tmp27_->start_angle = (gdouble) 0;
		_tmp28_ = ringsitem;
		_tmp28_->angle = 2 * G_PI;
	} else {
		BaobabRingschartItem* parent = NULL;
		BaobabChartItem* _tmp29_;
		GList* _tmp30_;
		gconstpointer _tmp31_;
		BaobabChartItem* _tmp32_;
		BaobabRingschartItem* _tmp33_;
		BaobabRingschartItem* _tmp34_;
		BaobabRingschartItem* _tmp35_;
		guint _tmp36_;
		guint _tmp37_;
		BaobabRingschartItem* _tmp38_;
		guint _tmp39_;
		guint _tmp40_;
		guint _tmp41_;
		BaobabRingschartItem* _tmp46_;
		BaobabRingschartItem* _tmp47_;
		gdouble _tmp48_;
		BaobabRingschartItem* _tmp49_;
		gdouble _tmp50_;
		BaobabRingschartItem* _tmp51_;
		gdouble _tmp52_;
		BaobabRingschartItem* _tmp53_;
		BaobabRingschartItem* _tmp54_;
		gdouble _tmp55_;
		BaobabRingschartItem* _tmp56_;
		gdouble _tmp57_;
		BaobabRingschartItem* _tmp58_;
		gdouble _tmp59_;
		gboolean _tmp60_ = FALSE;
		BaobabRingschartItem* _tmp61_;
		gboolean _tmp62_;
		BaobabRingschartItem* _tmp67_;
		BaobabRingschartItem* _tmp68_;
		_tmp29_ = item;
		_tmp30_ = _tmp29_->parent;
		_tmp31_ = _tmp30_->data;
		_tmp32_ = (BaobabChartItem*) _tmp31_;
		_tmp33_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp32_) : NULL);
		parent = _tmp33_;
		_tmp34_ = ringsitem;
		_tmp35_ = ringsitem;
		_tmp36_ = ((BaobabChartItem*) _tmp35_)->depth;
		_tmp37_ = thickness;
		_tmp34_->min_radius = (gdouble) (_tmp36_ * _tmp37_);
		_tmp38_ = ringsitem;
		_tmp39_ = ((BaobabChartItem*) _tmp38_)->depth;
		_tmp40_ = baobab_chart_get_max_depth ((BaobabChart*) self);
		_tmp41_ = _tmp40_;
		if (_tmp39_ > _tmp41_) {
			_baobab_chart_item_unref0 (parent);
			_g_object_unref0 (context);
			_baobab_chart_item_unref0 (ringsitem);
			return;
		} else {
			BaobabRingschartItem* _tmp42_;
			BaobabRingschartItem* _tmp43_;
			gdouble _tmp44_;
			guint _tmp45_;
			_tmp42_ = ringsitem;
			_tmp43_ = ringsitem;
			_tmp44_ = _tmp43_->min_radius;
			_tmp45_ = thickness;
			_tmp42_->max_radius = _tmp44_ + _tmp45_;
		}
		_tmp46_ = ringsitem;
		_tmp47_ = parent;
		_tmp48_ = _tmp47_->angle;
		_tmp49_ = ringsitem;
		_tmp50_ = ((BaobabChartItem*) _tmp49_)->rel_size;
		_tmp46_->angle = (_tmp48_ * _tmp50_) / 100;
		_tmp51_ = ringsitem;
		_tmp52_ = _tmp51_->angle;
		if (_tmp52_ < BAOBAB_RINGSCHART_ITEM_MIN_ANGLE) {
			_baobab_chart_item_unref0 (parent);
			_g_object_unref0 (context);
			_baobab_chart_item_unref0 (ringsitem);
			return;
		}
		_tmp53_ = ringsitem;
		_tmp54_ = parent;
		_tmp55_ = _tmp54_->start_angle;
		_tmp56_ = parent;
		_tmp57_ = _tmp56_->angle;
		_tmp58_ = ringsitem;
		_tmp59_ = ((BaobabChartItem*) _tmp58_)->rel_start;
		_tmp53_->start_angle = _tmp55_ + ((_tmp57_ * _tmp59_) / 100);
		_tmp61_ = ringsitem;
		_tmp62_ = ((BaobabChartItem*) _tmp61_)->has_any_child;
		if (_tmp62_) {
			BaobabRingschartItem* _tmp63_;
			guint _tmp64_;
			guint _tmp65_;
			guint _tmp66_;
			_tmp63_ = ringsitem;
			_tmp64_ = ((BaobabChartItem*) _tmp63_)->depth;
			_tmp65_ = baobab_chart_get_max_depth ((BaobabChart*) self);
			_tmp66_ = _tmp65_;
			_tmp60_ = _tmp64_ == _tmp66_;
		} else {
			_tmp60_ = FALSE;
		}
		_tmp67_ = ringsitem;
		_tmp67_->continued = _tmp60_;
		_tmp68_ = parent;
		((BaobabChartItem*) _tmp68_)->has_visible_children = TRUE;
		_baobab_chart_item_unref0 (parent);
	}
	_tmp69_ = ringsitem;
	((BaobabChartItem*) _tmp69_)->visible = TRUE;
	_tmp70_ = item;
	baobab_chart_get_item_rectangle ((BaobabChart*) self, _tmp70_);
	_g_object_unref0 (context);
	_baobab_chart_item_unref0 (ringsitem);
}


static void baobab_ringschart_get_point_min_rect (BaobabRingschart* self, gdouble cx, gdouble cy, gdouble radius, gdouble angle, GdkRectangle* r) {
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	GdkRectangle _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GdkRectangle _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GdkRectangle _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GdkRectangle _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (r != NULL);
	_tmp0_ = cx;
	_tmp1_ = angle;
	_tmp2_ = cos (_tmp1_);
	_tmp3_ = radius;
	x = _tmp0_ + (_tmp2_ * _tmp3_);
	_tmp4_ = cy;
	_tmp5_ = angle;
	_tmp6_ = sin (_tmp5_);
	_tmp7_ = radius;
	y = _tmp4_ + (_tmp6_ * _tmp7_);
	_tmp8_ = *r;
	_tmp9_ = _tmp8_.x;
	_tmp10_ = MIN (_tmp9_, (gint) x);
	(*r).x = _tmp10_;
	_tmp11_ = *r;
	_tmp12_ = _tmp11_.y;
	_tmp13_ = MIN (_tmp12_, (gint) y);
	(*r).y = _tmp13_;
	_tmp14_ = *r;
	_tmp15_ = _tmp14_.width;
	_tmp16_ = MAX (_tmp15_, (gint) x);
	(*r).width = _tmp16_;
	_tmp17_ = *r;
	_tmp18_ = _tmp17_.height;
	_tmp19_ = MAX (_tmp18_, (gint) y);
	(*r).height = _tmp19_;
}


static void baobab_ringschart_real_get_item_rectangle (BaobabChart* base, BaobabChartItem* item) {
	BaobabRingschart * self;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_;
	BaobabRingschartItem* _tmp1_;
	GdkRectangle rect = {0};
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble r1 = 0.0;
	gdouble r2 = 0.0;
	gdouble a1 = 0.0;
	gdouble a2 = 0.0;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp2_ = {0};
	GtkAllocation _tmp3_;
	gint _tmp4_;
	GtkAllocation _tmp5_;
	gint _tmp6_;
	BaobabRingschartItem* _tmp7_;
	gdouble _tmp8_;
	BaobabRingschartItem* _tmp9_;
	gdouble _tmp10_;
	BaobabRingschartItem* _tmp11_;
	gdouble _tmp12_;
	BaobabRingschartItem* _tmp13_;
	gdouble _tmp14_;
	BaobabRingschartItem* _tmp15_;
	gdouble _tmp16_;
	GtkAllocation _tmp17_;
	gint _tmp18_;
	GtkAllocation _tmp19_;
	gint _tmp20_;
	gdouble _tmp21_;
	gdouble _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	gdouble _tmp25_;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	gdouble _tmp32_;
	gdouble _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gboolean _tmp37_ = FALSE;
	gdouble _tmp38_;
	gboolean _tmp46_ = FALSE;
	gdouble _tmp47_;
	gboolean _tmp55_ = FALSE;
	gdouble _tmp56_;
	gboolean _tmp64_ = FALSE;
	gdouble _tmp65_;
	gint _tmp73_;
	GdkRectangle _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	GdkRectangle _tmp77_;
	gint _tmp78_;
	BaobabRingschartItem* _tmp79_;
	GdkRectangle _tmp80_;
	self = (BaobabRingschart*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	memset (&rect, 0, sizeof (GdkRectangle));
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = allocation;
	_tmp4_ = _tmp3_.width;
	cx = (gdouble) (_tmp4_ / 2);
	_tmp5_ = allocation;
	_tmp6_ = _tmp5_.height;
	cy = (gdouble) (_tmp6_ / 2);
	_tmp7_ = ringsitem;
	_tmp8_ = _tmp7_->min_radius;
	r1 = _tmp8_;
	_tmp9_ = ringsitem;
	_tmp10_ = _tmp9_->max_radius;
	r2 = _tmp10_;
	_tmp11_ = ringsitem;
	_tmp12_ = _tmp11_->start_angle;
	a1 = _tmp12_;
	_tmp13_ = ringsitem;
	_tmp14_ = _tmp13_->start_angle;
	_tmp15_ = ringsitem;
	_tmp16_ = _tmp15_->angle;
	a2 = _tmp14_ + _tmp16_;
	_tmp17_ = allocation;
	_tmp18_ = _tmp17_.width;
	rect.x = _tmp18_;
	_tmp19_ = allocation;
	_tmp20_ = _tmp19_.height;
	rect.y = _tmp20_;
	rect.width = 0;
	rect.height = 0;
	_tmp21_ = cx;
	_tmp22_ = cy;
	_tmp23_ = r1;
	_tmp24_ = a1;
	baobab_ringschart_get_point_min_rect (self, _tmp21_, _tmp22_, _tmp23_, _tmp24_, &rect);
	_tmp25_ = cx;
	_tmp26_ = cy;
	_tmp27_ = r2;
	_tmp28_ = a1;
	baobab_ringschart_get_point_min_rect (self, _tmp25_, _tmp26_, _tmp27_, _tmp28_, &rect);
	_tmp29_ = cx;
	_tmp30_ = cy;
	_tmp31_ = r1;
	_tmp32_ = a2;
	baobab_ringschart_get_point_min_rect (self, _tmp29_, _tmp30_, _tmp31_, _tmp32_, &rect);
	_tmp33_ = cx;
	_tmp34_ = cy;
	_tmp35_ = r2;
	_tmp36_ = a2;
	baobab_ringschart_get_point_min_rect (self, _tmp33_, _tmp34_, _tmp35_, _tmp36_, &rect);
	_tmp38_ = a1;
	if (_tmp38_ <= (G_PI / 2)) {
		gdouble _tmp39_;
		_tmp39_ = a2;
		_tmp37_ = _tmp39_ >= (G_PI / 2);
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		GdkRectangle _tmp40_;
		gint _tmp41_;
		gdouble _tmp42_;
		gdouble _tmp43_;
		gdouble _tmp44_;
		gdouble _tmp45_;
		_tmp40_ = rect;
		_tmp41_ = _tmp40_.height;
		_tmp42_ = cy;
		_tmp43_ = sin (G_PI / 2);
		_tmp44_ = r2;
		_tmp45_ = MAX ((gdouble) _tmp41_, _tmp42_ + (_tmp43_ * _tmp44_));
		rect.height = (gint) _tmp45_;
	}
	_tmp47_ = a1;
	if (_tmp47_ <= G_PI) {
		gdouble _tmp48_;
		_tmp48_ = a2;
		_tmp46_ = _tmp48_ >= G_PI;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		GdkRectangle _tmp49_;
		gint _tmp50_;
		gdouble _tmp51_;
		gdouble _tmp52_;
		gdouble _tmp53_;
		gdouble _tmp54_;
		_tmp49_ = rect;
		_tmp50_ = _tmp49_.x;
		_tmp51_ = cx;
		_tmp52_ = cos (G_PI);
		_tmp53_ = r2;
		_tmp54_ = MIN ((gdouble) _tmp50_, _tmp51_ + (_tmp52_ * _tmp53_));
		rect.x = (gint) _tmp54_;
	}
	_tmp56_ = a1;
	if (_tmp56_ <= (G_PI * 1.5)) {
		gdouble _tmp57_;
		_tmp57_ = a2;
		_tmp55_ = _tmp57_ >= (G_PI * 1.5);
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		GdkRectangle _tmp58_;
		gint _tmp59_;
		gdouble _tmp60_;
		gdouble _tmp61_;
		gdouble _tmp62_;
		gdouble _tmp63_;
		_tmp58_ = rect;
		_tmp59_ = _tmp58_.y;
		_tmp60_ = cy;
		_tmp61_ = sin (G_PI * 1.5);
		_tmp62_ = r2;
		_tmp63_ = MIN ((gdouble) _tmp59_, _tmp60_ + (_tmp61_ * _tmp62_));
		rect.y = (gint) _tmp63_;
	}
	_tmp65_ = a1;
	if (_tmp65_ <= (G_PI * 2)) {
		gdouble _tmp66_;
		_tmp66_ = a2;
		_tmp64_ = _tmp66_ >= (G_PI * 2);
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		GdkRectangle _tmp67_;
		gint _tmp68_;
		gdouble _tmp69_;
		gdouble _tmp70_;
		gdouble _tmp71_;
		gdouble _tmp72_;
		_tmp67_ = rect;
		_tmp68_ = _tmp67_.width;
		_tmp69_ = cx;
		_tmp70_ = cos (G_PI * 2);
		_tmp71_ = r2;
		_tmp72_ = MAX ((gdouble) _tmp68_, _tmp69_ + (_tmp70_ * _tmp71_));
		rect.width = (gint) _tmp72_;
	}
	_tmp73_ = rect.width;
	_tmp74_ = rect;
	_tmp75_ = _tmp74_.x;
	rect.width = _tmp73_ - _tmp75_;
	_tmp76_ = rect.height;
	_tmp77_ = rect;
	_tmp78_ = _tmp77_.y;
	rect.height = _tmp76_ - _tmp78_;
	_tmp79_ = ringsitem;
	_tmp80_ = rect;
	((BaobabChartItem*) _tmp79_)->rect = _tmp80_;
	_baobab_chart_item_unref0 (ringsitem);
}


static gboolean baobab_ringschart_real_is_point_over_item (BaobabChart* base, BaobabChartItem* item, gdouble x, gdouble y) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	BaobabRingschartItem* ringsitem = NULL;
	BaobabChartItem* _tmp0_;
	BaobabRingschartItem* _tmp1_;
	GtkAllocation allocation = {0};
	GtkAllocation _tmp2_ = {0};
	gdouble _tmp3_;
	GtkAllocation _tmp4_;
	gint _tmp5_;
	gdouble _tmp6_;
	GtkAllocation _tmp7_;
	gint _tmp8_;
	gdouble radius = 0.0;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble angle = 0.0;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gdouble _tmp24_;
	BaobabRingschartItem* _tmp25_;
	gdouble _tmp26_;
	self = (BaobabRingschart*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = item;
	_tmp1_ = _baobab_chart_item_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_RINGSCHART_ITEM) ? ((BaobabRingschartItem*) _tmp0_) : NULL);
	ringsitem = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	allocation = _tmp2_;
	_tmp3_ = x;
	_tmp4_ = allocation;
	_tmp5_ = _tmp4_.width;
	x = _tmp3_ - (_tmp5_ / 2);
	_tmp6_ = y;
	_tmp7_ = allocation;
	_tmp8_ = _tmp7_.height;
	y = _tmp6_ - (_tmp8_ / 2);
	_tmp9_ = x;
	_tmp10_ = x;
	_tmp11_ = y;
	_tmp12_ = y;
	_tmp13_ = sqrt ((_tmp9_ * _tmp10_) + (_tmp11_ * _tmp12_));
	radius = _tmp13_;
	_tmp14_ = y;
	_tmp15_ = x;
	_tmp16_ = atan2 (_tmp14_, _tmp15_);
	angle = _tmp16_;
	_tmp18_ = angle;
	if (_tmp18_ > ((gdouble) 0)) {
		gdouble _tmp19_;
		_tmp19_ = angle;
		_tmp17_ = _tmp19_;
	} else {
		gdouble _tmp20_;
		_tmp20_ = angle;
		_tmp17_ = _tmp20_ + (2 * G_PI);
	}
	angle = _tmp17_;
	_tmp24_ = radius;
	_tmp25_ = ringsitem;
	_tmp26_ = _tmp25_->min_radius;
	if (_tmp24_ >= _tmp26_) {
		gdouble _tmp27_;
		BaobabRingschartItem* _tmp28_;
		gdouble _tmp29_;
		_tmp27_ = radius;
		_tmp28_ = ringsitem;
		_tmp29_ = _tmp28_->max_radius;
		_tmp23_ = _tmp27_ <= _tmp29_;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		gdouble _tmp30_;
		BaobabRingschartItem* _tmp31_;
		gdouble _tmp32_;
		_tmp30_ = angle;
		_tmp31_ = ringsitem;
		_tmp32_ = _tmp31_->start_angle;
		_tmp22_ = _tmp30_ >= _tmp32_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gdouble _tmp33_;
		BaobabRingschartItem* _tmp34_;
		gdouble _tmp35_;
		BaobabRingschartItem* _tmp36_;
		gdouble _tmp37_;
		_tmp33_ = angle;
		_tmp34_ = ringsitem;
		_tmp35_ = _tmp34_->start_angle;
		_tmp36_ = ringsitem;
		_tmp37_ = _tmp36_->angle;
		_tmp21_ = _tmp33_ <= (_tmp35_ + _tmp37_);
	} else {
		_tmp21_ = FALSE;
	}
	result = _tmp21_;
	_baobab_chart_item_unref0 (ringsitem);
	return result;
}


static gboolean baobab_ringschart_real_can_zoom_out (BaobabChart* base) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ < BAOBAB_CHART_MAX_DEPTH;
	return result;
}


static gboolean baobab_ringschart_real_can_zoom_in (BaobabChart* base) {
	BaobabRingschart * self;
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	self = (BaobabRingschart*) base;
	_tmp0_ = baobab_chart_get_max_depth ((BaobabChart*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ > BAOBAB_CHART_MIN_DEPTH;
	return result;
}


BaobabRingschart* baobab_ringschart_construct (GType object_type) {
	BaobabRingschart * self = NULL;
	self = (BaobabRingschart*) baobab_chart_construct (object_type);
	return self;
}


BaobabRingschart* baobab_ringschart_new (void) {
	return baobab_ringschart_construct (BAOBAB_TYPE_RINGSCHART);
}


static void _baobab_ringschart_subtips_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	baobab_ringschart_subtips_update ((BaobabRingschart*) self);
}


static GObject * baobab_ringschart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BaobabRingschart * self;
	parent_class = G_OBJECT_CLASS (baobab_ringschart_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART, BaobabRingschart);
	g_signal_connect_object ((GObject*) self, "notify::max-depth", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::highlighted-item", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::root", (GCallback) _baobab_ringschart_subtips_update_g_object_notify, self, 0);
	return obj;
}


static void baobab_ringschart_class_init (BaobabRingschartClass * klass) {
	baobab_ringschart_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabRingschartPrivate));
	((BaobabChartClass *) klass)->create_new_chartitem = (BaobabChartItem* (*) (BaobabChart *)) baobab_ringschart_real_create_new_chartitem;
	((BaobabChartClass *) klass)->post_draw = (void (*) (BaobabChart *, cairo_t*)) baobab_ringschart_real_post_draw;
	((BaobabChartClass *) klass)->draw_item = (void (*) (BaobabChart *, cairo_t*, BaobabChartItem*, gboolean)) baobab_ringschart_real_draw_item;
	((BaobabChartClass *) klass)->calculate_item_geometry = (void (*) (BaobabChart *, BaobabChartItem*)) baobab_ringschart_real_calculate_item_geometry;
	((BaobabChartClass *) klass)->get_item_rectangle = (void (*) (BaobabChart *, BaobabChartItem*)) baobab_ringschart_real_get_item_rectangle;
	((BaobabChartClass *) klass)->is_point_over_item = (gboolean (*) (BaobabChart *, BaobabChartItem*, gdouble, gdouble)) baobab_ringschart_real_is_point_over_item;
	((BaobabChartClass *) klass)->can_zoom_out = (gboolean (*) (BaobabChart *)) baobab_ringschart_real_can_zoom_out;
	((BaobabChartClass *) klass)->can_zoom_in = (gboolean (*) (BaobabChart *)) baobab_ringschart_real_can_zoom_in;
	G_OBJECT_CLASS (klass)->constructor = baobab_ringschart_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_ringschart_finalize;
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "ringschart");
}


static void baobab_ringschart_instance_init (BaobabRingschart * self) {
	self->priv = BAOBAB_RINGSCHART_GET_PRIVATE (self);
	self->priv->tips_timeout_id = (guint) 0;
	self->priv->drawing_subtips = FALSE;
}


static void baobab_ringschart_finalize (GObject * obj) {
	BaobabRingschart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_RINGSCHART, BaobabRingschart);
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->subtip_items);
	G_OBJECT_CLASS (baobab_ringschart_parent_class)->finalize (obj);
}


GType baobab_ringschart_get_type (void) {
	static volatile gsize baobab_ringschart_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_ringschart_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabRingschartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_ringschart_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabRingschart), 0, (GInstanceInitFunc) baobab_ringschart_instance_init, NULL };
		GType baobab_ringschart_type_id;
		baobab_ringschart_type_id = g_type_register_static (BAOBAB_TYPE_CHART, "BaobabRingschart", &g_define_type_info, 0);
		g_once_init_leave (&baobab_ringschart_type_id__volatile, baobab_ringschart_type_id);
	}
	return baobab_ringschart_type_id__volatile;
}



