/* baobab-scanner.c generated by valac 0.17.3.12-6a5ea3, the Vala compiler
 * generated from baobab-scanner.vala, do not modify */

/* -*- indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gunixmounts.h>


#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())

#define BAOBAB_TYPE_SCANNER (baobab_scanner_get_type ())
#define BAOBAB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_SCANNER, BaobabScanner))
#define BAOBAB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_SCANNER, BaobabScannerClass))
#define BAOBAB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_SCANNER))
#define BAOBAB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_SCANNER))
#define BAOBAB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_SCANNER, BaobabScannerClass))

typedef struct _BaobabScanner BaobabScanner;
typedef struct _BaobabScannerClass BaobabScannerClass;
typedef struct _BaobabScannerPrivate BaobabScannerPrivate;

#define BAOBAB_SCANNER_TYPE_HARD_LINK (baobab_scanner_hard_link_get_type ())
typedef struct _BaobabScannerHardLink BaobabScannerHardLink;
typedef struct _BaobabScannerResultsArray BaobabScannerResultsArray;

#define BAOBAB_SCANNER_TYPE_COLUMNS (baobab_scanner_columns_get_type ())

#define BAOBAB_SCANNER_TYPE_STATE (baobab_scanner_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BaobabScannerResults BaobabScannerResults;
#define _baobab_scanner_results_array_free0(var) ((var == NULL) ? NULL : (var = (baobab_scanner_results_array_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _baobab_scanner_results_free0(var) ((var == NULL) ? NULL : (var = (baobab_scanner_results_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define __g_list_free__g_unix_mount_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_unix_mount_free0_ (var), NULL)))

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;

struct _BaobabScanner {
	GtkTreeStore parent_instance;
	BaobabScannerPrivate * priv;
};

struct _BaobabScannerClass {
	GtkTreeStoreClass parent_class;
	void (*cancel) (BaobabScanner* self);
	void (*finish) (BaobabScanner* self, GError** error);
};

struct _BaobabScannerHardLink {
	guint64 inode;
	guint32 device;
};

struct _BaobabScannerPrivate {
	GFile* _directory;
	BaobabScanFlags _scan_flags;
	gint _max_depth;
	BaobabScannerHardLink* hardlinks;
	gint hardlinks_length1;
	gint _hardlinks_size_;
	GHashTable* excluded_locations;
	gboolean successful;
	GAsyncQueue* results_queue;
	BaobabScanner* self;
	GCancellable* cancellable;
	GError* scan_error;
};

typedef enum  {
	BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME,
	BAOBAB_SCANNER_COLUMNS_PARSE_NAME,
	BAOBAB_SCANNER_COLUMNS_PERCENT,
	BAOBAB_SCANNER_COLUMNS_SIZE,
	BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE,
	BAOBAB_SCANNER_COLUMNS_ELEMENTS,
	BAOBAB_SCANNER_COLUMNS_STATE,
	BAOBAB_SCANNER_COLUMNS_ERROR,
	BAOBAB_SCANNER_COLUMNS_COLUMNS
} BaobabScannerColumns;

typedef enum  {
	BAOBAB_SCANNER_STATE_SCANNING,
	BAOBAB_SCANNER_STATE_CANCELLED,
	BAOBAB_SCANNER_STATE_NEED_PERCENT,
	BAOBAB_SCANNER_STATE_ERROR,
	BAOBAB_SCANNER_STATE_DONE
} BaobabScannerState;

struct _BaobabScannerResults {
	BaobabScannerResults* parent;
	gchar* display_name;
	gchar* parse_name;
	guint64 size;
	guint64 alloc_size;
	gint elements;
	gdouble percent;
	gint max_depth;
	GError* error;
	GtkTreeIter iter;
	gboolean iter_is_set;
};

struct _BaobabScannerResultsArray {
	BaobabScannerResults** results;
	gint results_length1;
	gint _results_size_;
};


static gpointer baobab_scanner_parent_class = NULL;

GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
GType baobab_scanner_get_type (void) G_GNUC_CONST;
static GType baobab_scanner_hard_link_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BaobabScannerHardLink* baobab_scanner_hard_link_dup (const BaobabScannerHardLink* self);
static void baobab_scanner_hard_link_free (BaobabScannerHardLink* self);
static void baobab_scanner_results_array_free (BaobabScannerResultsArray* self);
#define BAOBAB_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_SCANNER, BaobabScannerPrivate))
enum  {
	BAOBAB_SCANNER_DUMMY_PROPERTY,
	BAOBAB_SCANNER_DIRECTORY,
	BAOBAB_SCANNER_SCAN_FLAGS,
	BAOBAB_SCANNER_MAX_DEPTH
};
GType baobab_scanner_columns_get_type (void) G_GNUC_CONST;
GType baobab_scanner_state_get_type (void) G_GNUC_CONST;
#define BAOBAB_SCANNER_ATTRIBUTES G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE "," G_FILE_ATTRIBUTE_UNIX_NLINK "," G_FILE_ATTRIBUTE_UNIX_INODE "," G_FILE_ATTRIBUTE_UNIX_DEVICE "," G_FILE_ATTRIBUTE_ACCESS_CAN_READ
static void baobab_scanner_results_free (BaobabScannerResults* self);
static BaobabScannerResults* baobab_scanner_add_directory (BaobabScanner* self, GFile* directory, GFileInfo* info, BaobabScannerResults* parent);
static BaobabScannerResultsArray* baobab_scanner_results_array_new (void);
static BaobabScannerResultsArray* baobab_scanner_results_array_new (void);
static BaobabScannerResults* baobab_scanner_results_new (void);
static BaobabScannerResults* baobab_scanner_results_new (void);
static void _vala_array_add1 (BaobabScannerResults*** array, int* length, int* size, BaobabScannerResults* value);
static void baobab_scanner_hard_link_init (BaobabScannerHardLink *self, GFileInfo* info);
static gboolean _baobab_scanner_hard_link_equal (const BaobabScannerHardLink* s1, const BaobabScannerHardLink* s2);
static gboolean _vala_baobab_scanner_hard_link_array_contains (BaobabScannerHardLink* stack, int stack_length, BaobabScannerHardLink* needle);
static void _vala_array_add2 (BaobabScannerHardLink** array, int* length, int* size, const BaobabScannerHardLink* value);
static void* baobab_scanner_scan_in_thread (BaobabScanner* self);
GFile* baobab_scanner_get_directory (BaobabScanner* self);
static void _vala_array_add3 (BaobabScannerResults*** array, int* length, int* size, BaobabScannerResults* value);
static void baobab_scanner_ensure_iter_exists (BaobabScanner* self, BaobabScannerResults* results);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static gboolean baobab_scanner_process_results (BaobabScanner* self);
gint baobab_scanner_get_max_depth (BaobabScanner* self);
void baobab_scanner_set_max_depth (BaobabScanner* self, gint value);
void baobab_scanner_scan (BaobabScanner* self, gboolean force);
static void* _baobab_scanner_scan_in_thread_gthread_thread_func (gpointer self);
static gboolean _baobab_scanner_process_results_gsource_func (gpointer self);
void baobab_scanner_cancel (BaobabScanner* self);
static void baobab_scanner_real_cancel (BaobabScanner* self);
void baobab_scanner_finish (BaobabScanner* self, GError** error);
static void baobab_scanner_real_finish (BaobabScanner* self, GError** error);
BaobabScanner* baobab_scanner_new (GFile* directory, BaobabScanFlags flags);
BaobabScanner* baobab_scanner_construct (GType object_type, GFile* directory, BaobabScanFlags flags);
static void baobab_scanner_set_directory (BaobabScanner* self, GFile* value);
static void baobab_scanner_set_scan_flags (BaobabScanner* self, BaobabScanFlags value);
GHashTable* baobab_application_get_excluded_locations (void);
static void _g_unix_mount_free0_ (gpointer var);
static void _g_list_free__g_unix_mount_free0_ (GList* self);
BaobabScanFlags baobab_scanner_get_scan_flags (BaobabScanner* self);
static void baobab_scanner_results_array_instance_init (BaobabScannerResultsArray * self);
static void baobab_scanner_results_instance_init (BaobabScannerResults * self);
static void baobab_scanner_finalize (GObject* obj);
static void _vala_baobab_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType baobab_scan_flags_get_type (void) {
	static volatile gsize baobab_scan_flags_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scan_flags_type_id__volatile)) {
		static const GFlagsValue values[] = {{BAOBAB_SCAN_FLAGS_NONE, "BAOBAB_SCAN_FLAGS_NONE", "none"}, {BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS, "BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS", "exclude-mounts"}, {0, NULL, NULL}};
		GType baobab_scan_flags_type_id;
		baobab_scan_flags_type_id = g_flags_register_static ("BaobabScanFlags", values);
		g_once_init_leave (&baobab_scan_flags_type_id__volatile, baobab_scan_flags_type_id);
	}
	return baobab_scan_flags_type_id__volatile;
}


GType baobab_scanner_columns_get_type (void) {
	static volatile gsize baobab_scanner_columns_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, "BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME", "display-name"}, {BAOBAB_SCANNER_COLUMNS_PARSE_NAME, "BAOBAB_SCANNER_COLUMNS_PARSE_NAME", "parse-name"}, {BAOBAB_SCANNER_COLUMNS_PERCENT, "BAOBAB_SCANNER_COLUMNS_PERCENT", "percent"}, {BAOBAB_SCANNER_COLUMNS_SIZE, "BAOBAB_SCANNER_COLUMNS_SIZE", "size"}, {BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, "BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE", "alloc-size"}, {BAOBAB_SCANNER_COLUMNS_ELEMENTS, "BAOBAB_SCANNER_COLUMNS_ELEMENTS", "elements"}, {BAOBAB_SCANNER_COLUMNS_STATE, "BAOBAB_SCANNER_COLUMNS_STATE", "state"}, {BAOBAB_SCANNER_COLUMNS_ERROR, "BAOBAB_SCANNER_COLUMNS_ERROR", "error"}, {BAOBAB_SCANNER_COLUMNS_COLUMNS, "BAOBAB_SCANNER_COLUMNS_COLUMNS", "columns"}, {0, NULL, NULL}};
		GType baobab_scanner_columns_type_id;
		baobab_scanner_columns_type_id = g_enum_register_static ("BaobabScannerColumns", values);
		g_once_init_leave (&baobab_scanner_columns_type_id__volatile, baobab_scanner_columns_type_id);
	}
	return baobab_scanner_columns_type_id__volatile;
}


GType baobab_scanner_state_get_type (void) {
	static volatile gsize baobab_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{BAOBAB_SCANNER_STATE_SCANNING, "BAOBAB_SCANNER_STATE_SCANNING", "scanning"}, {BAOBAB_SCANNER_STATE_CANCELLED, "BAOBAB_SCANNER_STATE_CANCELLED", "cancelled"}, {BAOBAB_SCANNER_STATE_NEED_PERCENT, "BAOBAB_SCANNER_STATE_NEED_PERCENT", "need-percent"}, {BAOBAB_SCANNER_STATE_ERROR, "BAOBAB_SCANNER_STATE_ERROR", "error"}, {BAOBAB_SCANNER_STATE_DONE, "BAOBAB_SCANNER_STATE_DONE", "done"}, {0, NULL, NULL}};
		GType baobab_scanner_state_type_id;
		baobab_scanner_state_type_id = g_enum_register_static ("BaobabScannerState", values);
		g_once_init_leave (&baobab_scanner_state_type_id__volatile, baobab_scanner_state_type_id);
	}
	return baobab_scanner_state_type_id__volatile;
}


static void _vala_array_add1 (BaobabScannerResults*** array, int* length, int* size, BaobabScannerResults* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean _baobab_scanner_hard_link_equal (const BaobabScannerHardLink* s1, const BaobabScannerHardLink* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->inode != s2->inode) {
		return FALSE;
	}
	if (s1->device != s2->device) {
		return FALSE;
	}
	return TRUE;
}


static gboolean _vala_baobab_scanner_hard_link_array_contains (BaobabScannerHardLink* stack, int stack_length, BaobabScannerHardLink* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (_baobab_scanner_hard_link_equal (&stack[i], needle) == TRUE) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add2 (BaobabScannerHardLink** array, int* length, int* size, const BaobabScannerHardLink* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerHardLink, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static BaobabScannerResults* baobab_scanner_add_directory (BaobabScanner* self, GFile* directory, GFileInfo* info, BaobabScannerResults* parent) {
	BaobabScannerResults* result = NULL;
	BaobabScannerResultsArray* _tmp0_;
	BaobabScannerResultsArray* results_array;
	GHashTable* _tmp1_;
	GFile* _tmp2_;
	gboolean _tmp3_ = FALSE;
	BaobabScannerResults* _tmp4_;
	BaobabScannerResults* results;
	BaobabScannerResults* _tmp5_;
	GFileInfo* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	BaobabScannerResults* _tmp9_;
	GFile* _tmp10_;
	gchar* _tmp11_ = NULL;
	BaobabScannerResults* _tmp12_;
	BaobabScannerResults* _tmp13_;
	BaobabScannerResults* _tmp14_;
	GFileInfo* _tmp15_;
	gint64 _tmp16_ = 0LL;
	GFileInfo* _tmp17_;
	gboolean _tmp18_ = FALSE;
	BaobabScannerResults* _tmp22_;
	BaobabScannerResults* _tmp23_;
	BaobabScannerResultsArray* _tmp94_;
	BaobabScannerResults** _tmp95_;
	gint _tmp95__length1;
	GAsyncQueue* _tmp101_;
	BaobabScannerResultsArray* _tmp102_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (directory != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = baobab_scanner_results_array_new ();
	results_array = _tmp0_;
	_tmp1_ = self->priv->excluded_locations;
	_tmp2_ = directory;
	_tmp3_ = g_hash_table_contains (_tmp1_, _tmp2_);
	if (_tmp3_) {
		result = NULL;
		_baobab_scanner_results_array_free0 (results_array);
		return result;
	}
	_tmp4_ = baobab_scanner_results_new ();
	results = _tmp4_;
	_tmp5_ = results;
	_tmp6_ = info;
	_tmp7_ = g_file_info_get_display_name (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_tmp5_->display_name);
	_tmp5_->display_name = _tmp8_;
	_tmp9_ = results;
	_tmp10_ = directory;
	_tmp11_ = g_file_get_parse_name (_tmp10_);
	_g_free0 (_tmp9_->parse_name);
	_tmp9_->parse_name = _tmp11_;
	_tmp12_ = results;
	_tmp13_ = parent;
	_tmp12_->parent = _tmp13_;
	_tmp14_ = results;
	_tmp15_ = info;
	_tmp16_ = g_file_info_get_size (_tmp15_);
	_tmp14_->size = (guint64) _tmp16_;
	_tmp17_ = info;
	_tmp18_ = g_file_info_has_attribute (_tmp17_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
	if (_tmp18_) {
		BaobabScannerResults* _tmp19_;
		GFileInfo* _tmp20_;
		guint64 _tmp21_ = 0ULL;
		_tmp19_ = results;
		_tmp20_ = info;
		_tmp21_ = g_file_info_get_attribute_uint64 (_tmp20_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
		_tmp19_->alloc_size = _tmp21_;
	}
	_tmp22_ = results;
	_tmp22_->elements = 1;
	_tmp23_ = results;
	_g_error_free0 (_tmp23_->error);
	_tmp23_->error = NULL;
	{
		GFile* _tmp24_;
		GCancellable* _tmp25_;
		GFileEnumerator* _tmp26_ = NULL;
		GFileEnumerator* children;
		GFileInfo* child_info = NULL;
		_tmp24_ = directory;
		_tmp25_ = self->priv->cancellable;
		_tmp26_ = g_file_enumerate_children (_tmp24_, BAOBAB_SCANNER_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, _tmp25_, &_inner_error_);
		children = _tmp26_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		while (TRUE) {
			GFileEnumerator* _tmp27_;
			GCancellable* _tmp28_;
			GFileInfo* _tmp29_ = NULL;
			GFileInfo* _tmp30_;
			GFileInfo* _tmp31_;
			GFileInfo* _tmp32_;
			GFileType _tmp33_ = 0;
			_tmp27_ = children;
			_tmp28_ = self->priv->cancellable;
			_tmp29_ = g_file_enumerator_next_file (_tmp27_, _tmp28_, &_inner_error_);
			_tmp30_ = _tmp29_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (child_info);
				_g_object_unref0 (children);
				goto __catch7_g_error;
			}
			_g_object_unref0 (child_info);
			child_info = _tmp30_;
			_tmp31_ = child_info;
			if (!(_tmp31_ != NULL)) {
				break;
			}
			_tmp32_ = child_info;
			_tmp33_ = g_file_info_get_file_type (_tmp32_);
			switch (_tmp33_) {
				case G_FILE_TYPE_DIRECTORY:
				{
					GFile* _tmp34_;
					GFileInfo* _tmp35_;
					const gchar* _tmp36_ = NULL;
					GFile* _tmp37_ = NULL;
					GFile* child;
					GFile* _tmp38_;
					GFileInfo* _tmp39_;
					BaobabScannerResults* _tmp40_;
					BaobabScannerResults* _tmp41_ = NULL;
					BaobabScannerResults* child_results;
					BaobabScannerResults* _tmp42_;
					_tmp34_ = directory;
					_tmp35_ = child_info;
					_tmp36_ = g_file_info_get_name (_tmp35_);
					_tmp37_ = g_file_get_child (_tmp34_, _tmp36_);
					child = _tmp37_;
					_tmp38_ = child;
					_tmp39_ = child_info;
					_tmp40_ = results;
					_tmp41_ = baobab_scanner_add_directory (self, _tmp38_, _tmp39_, _tmp40_);
					child_results = _tmp41_;
					_tmp42_ = child_results;
					if (_tmp42_ != NULL) {
						BaobabScannerResults* _tmp43_;
						BaobabScannerResults* _tmp44_;
						guint64 _tmp45_;
						BaobabScannerResults* _tmp46_;
						guint64 _tmp47_;
						BaobabScannerResults* _tmp48_;
						BaobabScannerResults* _tmp49_;
						guint64 _tmp50_;
						BaobabScannerResults* _tmp51_;
						guint64 _tmp52_;
						BaobabScannerResults* _tmp53_;
						BaobabScannerResults* _tmp54_;
						gint _tmp55_;
						BaobabScannerResults* _tmp56_;
						gint _tmp57_;
						BaobabScannerResults* _tmp58_;
						BaobabScannerResults* _tmp59_;
						gint _tmp60_;
						BaobabScannerResults* _tmp61_;
						gint _tmp62_;
						gint _tmp63_ = 0;
						BaobabScannerResultsArray* _tmp64_;
						BaobabScannerResultsArray* _tmp65_;
						BaobabScannerResults** _tmp66_;
						gint _tmp66__length1;
						BaobabScannerResults* _tmp67_;
						_tmp43_ = results;
						_tmp44_ = results;
						_tmp45_ = _tmp44_->size;
						_tmp46_ = child_results;
						_tmp47_ = _tmp46_->size;
						_tmp44_->size = _tmp45_ + _tmp47_;
						_tmp48_ = results;
						_tmp49_ = results;
						_tmp50_ = _tmp49_->alloc_size;
						_tmp51_ = child_results;
						_tmp52_ = _tmp51_->alloc_size;
						_tmp49_->alloc_size = _tmp50_ + _tmp52_;
						_tmp53_ = results;
						_tmp54_ = results;
						_tmp55_ = _tmp54_->elements;
						_tmp56_ = child_results;
						_tmp57_ = _tmp56_->elements;
						_tmp54_->elements = _tmp55_ + _tmp57_;
						_tmp58_ = results;
						_tmp59_ = results;
						_tmp60_ = _tmp59_->max_depth;
						_tmp61_ = child_results;
						_tmp62_ = _tmp61_->max_depth;
						_tmp63_ = MAX (_tmp60_, _tmp62_ + 1);
						_tmp58_->max_depth = _tmp63_;
						_tmp64_ = results_array;
						_tmp65_ = results_array;
						_tmp66_ = _tmp65_->results;
						_tmp66__length1 = _tmp65_->results_length1;
						_tmp67_ = child_results;
						child_results = NULL;
						_vala_array_add1 (&_tmp64_->results, &_tmp64_->results_length1, &_tmp64_->_results_size_, _tmp67_);
					}
					_baobab_scanner_results_free0 (child_results);
					_g_object_unref0 (child);
					break;
				}
				case G_FILE_TYPE_REGULAR:
				{
					GFileInfo* _tmp68_;
					gboolean _tmp69_ = FALSE;
					BaobabScannerResults* _tmp77_;
					BaobabScannerResults* _tmp78_;
					guint64 _tmp79_;
					GFileInfo* _tmp80_;
					gint64 _tmp81_ = 0LL;
					GFileInfo* _tmp82_;
					gboolean _tmp83_ = FALSE;
					BaobabScannerResults* _tmp89_;
					gint _tmp90_;
					_tmp68_ = child_info;
					_tmp69_ = g_file_info_has_attribute (_tmp68_, G_FILE_ATTRIBUTE_UNIX_NLINK);
					if (_tmp69_) {
						GFileInfo* _tmp70_;
						guint32 _tmp71_ = 0U;
						_tmp70_ = child_info;
						_tmp71_ = g_file_info_get_attribute_uint32 (_tmp70_, G_FILE_ATTRIBUTE_UNIX_NLINK);
						if (_tmp71_ > ((guint32) 1)) {
							GFileInfo* _tmp72_;
							BaobabScannerHardLink hl = {0};
							BaobabScannerHardLink _tmp73_;
							BaobabScannerHardLink* _tmp74_;
							gint _tmp74__length1;
							BaobabScannerHardLink* _tmp75_;
							gint _tmp75__length1;
							BaobabScannerHardLink _tmp76_;
							_tmp72_ = child_info;
							baobab_scanner_hard_link_init (&hl, _tmp72_);
							_tmp73_ = hl;
							_tmp74_ = self->priv->hardlinks;
							_tmp74__length1 = self->priv->hardlinks_length1;
							if (_vala_baobab_scanner_hard_link_array_contains (_tmp74_, _tmp74__length1, &_tmp73_)) {
								continue;
							}
							_tmp75_ = self->priv->hardlinks;
							_tmp75__length1 = self->priv->hardlinks_length1;
							_tmp76_ = hl;
							_vala_array_add2 (&self->priv->hardlinks, &self->priv->hardlinks_length1, &self->priv->_hardlinks_size_, &_tmp76_);
						}
					}
					_tmp77_ = results;
					_tmp78_ = results;
					_tmp79_ = _tmp78_->size;
					_tmp80_ = child_info;
					_tmp81_ = g_file_info_get_size (_tmp80_);
					_tmp78_->size = _tmp79_ + _tmp81_;
					_tmp82_ = child_info;
					_tmp83_ = g_file_info_has_attribute (_tmp82_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
					if (_tmp83_) {
						BaobabScannerResults* _tmp84_;
						BaobabScannerResults* _tmp85_;
						guint64 _tmp86_;
						GFileInfo* _tmp87_;
						guint64 _tmp88_ = 0ULL;
						_tmp84_ = results;
						_tmp85_ = results;
						_tmp86_ = _tmp85_->alloc_size;
						_tmp87_ = child_info;
						_tmp88_ = g_file_info_get_attribute_uint64 (_tmp87_, G_FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE);
						_tmp85_->alloc_size = _tmp86_ + _tmp88_;
					}
					_tmp89_ = results;
					_tmp90_ = _tmp89_->elements;
					_tmp89_->elements = _tmp90_ + 1;
					break;
				}
				default:
				{
					break;
				}
			}
		}
		_g_object_unref0 (child_info);
		_g_object_unref0 (children);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		BaobabScannerResults* _tmp91_;
		GError* _tmp92_;
		GError* _tmp93_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp91_ = results;
		_tmp92_ = e;
		_tmp93_ = _g_error_copy0 (_tmp92_);
		_g_error_free0 (_tmp91_->error);
		_tmp91_->error = _tmp93_;
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_baobab_scanner_results_free0 (results);
		_baobab_scanner_results_array_free0 (results_array);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp94_ = results_array;
	_tmp95_ = _tmp94_->results;
	_tmp95__length1 = _tmp94_->results_length1;
	{
		BaobabScannerResults** child_results_collection = NULL;
		gint child_results_collection_length1 = 0;
		gint _child_results_collection_size_ = 0;
		gint child_results_it = 0;
		child_results_collection = _tmp95_;
		child_results_collection_length1 = _tmp95__length1;
		for (child_results_it = 0; child_results_it < _tmp95__length1; child_results_it = child_results_it + 1) {
			BaobabScannerResults* child_results = NULL;
			child_results = child_results_collection[child_results_it];
			{
				BaobabScannerResults* _tmp96_;
				BaobabScannerResults* _tmp97_;
				guint64 _tmp98_;
				BaobabScannerResults* _tmp99_;
				guint64 _tmp100_;
				_tmp96_ = child_results;
				_tmp97_ = child_results;
				_tmp98_ = _tmp97_->size;
				_tmp99_ = results;
				_tmp100_ = _tmp99_->size;
				_tmp96_->percent = (100 * ((gdouble) _tmp98_)) / ((gdouble) _tmp100_);
			}
		}
	}
	_tmp101_ = self->priv->results_queue;
	_tmp102_ = results_array;
	results_array = NULL;
	g_async_queue_push (_tmp101_, _tmp102_);
	result = results;
	_baobab_scanner_results_array_free0 (results_array);
	return result;
}


static void _vala_array_add3 (BaobabScannerResults*** array, int* length, int* size, BaobabScannerResults* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BaobabScannerResults*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void* baobab_scanner_scan_in_thread (BaobabScanner* self) {
	void* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		BaobabScannerResultsArray* _tmp0_;
		BaobabScannerResultsArray* array;
		GFile* _tmp1_;
		GCancellable* _tmp2_;
		GFileInfo* _tmp3_ = NULL;
		GFileInfo* info;
		GFile* _tmp4_;
		BaobabScannerResults* _tmp5_ = NULL;
		BaobabScannerResults* results;
		BaobabScannerResults* _tmp6_;
		BaobabScannerResultsArray* _tmp7_;
		BaobabScannerResultsArray* _tmp8_;
		BaobabScannerResults** _tmp9_;
		gint _tmp9__length1;
		BaobabScannerResults* _tmp10_;
		GAsyncQueue* _tmp11_;
		BaobabScannerResultsArray* _tmp12_;
		_tmp0_ = baobab_scanner_results_array_new ();
		array = _tmp0_;
		_tmp1_ = self->priv->_directory;
		_tmp2_ = self->priv->cancellable;
		_tmp3_ = g_file_query_info (_tmp1_, BAOBAB_SCANNER_ATTRIBUTES, 0, _tmp2_, &_inner_error_);
		info = _tmp3_;
		if (_inner_error_ != NULL) {
			_baobab_scanner_results_array_free0 (array);
			goto __catch8_g_error;
		}
		_tmp4_ = self->priv->_directory;
		_tmp5_ = baobab_scanner_add_directory (self, _tmp4_, info, NULL);
		results = _tmp5_;
		_tmp6_ = results;
		_tmp6_->percent = 100.0;
		_tmp7_ = array;
		_tmp8_ = array;
		_tmp9_ = _tmp8_->results;
		_tmp9__length1 = _tmp8_->results_length1;
		_tmp10_ = results;
		results = NULL;
		_vala_array_add3 (&_tmp7_->results, &_tmp7_->results_length1, &_tmp7_->_results_size_, _tmp10_);
		_tmp11_ = self->priv->results_queue;
		_tmp12_ = array;
		array = NULL;
		g_async_queue_push (_tmp11_, _tmp12_);
		_baobab_scanner_results_free0 (results);
		_g_object_unref0 (info);
		_baobab_scanner_results_array_free0 (array);
	}
	goto __finally8;
	__catch8_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (self->priv->self);
	self->priv->self = NULL;
	result = NULL;
	return result;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static void baobab_scanner_ensure_iter_exists (BaobabScanner* self, BaobabScannerResults* results) {
	GtkTreeIter* parent_iter = NULL;
	BaobabScannerResults* _tmp0_;
	gboolean _tmp1_;
	BaobabScannerResults* _tmp2_;
	BaobabScannerResults* _tmp3_;
	BaobabScannerResults* _tmp10_;
	GtkTreeIter* _tmp11_;
	GtkTreeIter _tmp12_ = {0};
	BaobabScannerResults* _tmp13_;
	GtkTreeIter _tmp14_;
	BaobabScannerResults* _tmp15_;
	const gchar* _tmp16_;
	BaobabScannerResults* _tmp17_;
	const gchar* _tmp18_;
	BaobabScannerResults* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (results != NULL);
	_tmp0_ = results;
	_tmp1_ = _tmp0_->iter_is_set;
	if (_tmp1_) {
		_g_free0 (parent_iter);
		return;
	}
	_tmp2_ = results;
	_tmp3_ = _tmp2_->parent;
	if (_tmp3_ != NULL) {
		BaobabScannerResults* _tmp4_;
		BaobabScannerResults* _tmp5_;
		BaobabScannerResults* _tmp6_;
		BaobabScannerResults* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreeIter* _tmp9_;
		_tmp4_ = results;
		_tmp5_ = _tmp4_->parent;
		baobab_scanner_ensure_iter_exists (self, _tmp5_);
		_tmp6_ = results;
		_tmp7_ = _tmp6_->parent;
		_tmp8_ = _tmp7_->iter;
		_tmp9_ = __gtk_tree_iter_dup0 (&_tmp8_);
		_g_free0 (parent_iter);
		parent_iter = _tmp9_;
	} else {
		_g_free0 (parent_iter);
		parent_iter = NULL;
	}
	_tmp10_ = results;
	_tmp11_ = parent_iter;
	gtk_tree_store_append ((GtkTreeStore*) self, &_tmp12_, _tmp11_);
	_tmp10_->iter = _tmp12_;
	_tmp13_ = results;
	_tmp14_ = _tmp13_->iter;
	_tmp15_ = results;
	_tmp16_ = _tmp15_->display_name;
	_tmp17_ = results;
	_tmp18_ = _tmp17_->parse_name;
	gtk_tree_store_set ((GtkTreeStore*) self, &_tmp14_, BAOBAB_SCANNER_COLUMNS_STATE, BAOBAB_SCANNER_STATE_SCANNING, BAOBAB_SCANNER_COLUMNS_DISPLAY_NAME, _tmp16_, BAOBAB_SCANNER_COLUMNS_PARSE_NAME, _tmp18_, -1);
	_tmp19_ = results;
	_tmp19_->iter_is_set = TRUE;
	_g_free0 (parent_iter);
}


static gboolean baobab_scanner_process_results (BaobabScanner* self) {
	gboolean result = FALSE;
	BaobabScanner* _tmp40_;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		GAsyncQueue* _tmp0_;
		gpointer _tmp1_ = NULL;
		BaobabScannerResultsArray* results_array;
		BaobabScannerResultsArray* _tmp2_;
		BaobabScannerResultsArray* _tmp3_;
		BaobabScannerResults** _tmp4_;
		gint _tmp4__length1;
		_tmp0_ = self->priv->results_queue;
		_tmp1_ = g_async_queue_try_pop (_tmp0_);
		results_array = (BaobabScannerResultsArray*) _tmp1_;
		_tmp2_ = results_array;
		if (_tmp2_ == NULL) {
			_baobab_scanner_results_array_free0 (results_array);
			break;
		}
		_tmp3_ = results_array;
		_tmp4_ = _tmp3_->results;
		_tmp4__length1 = _tmp3_->results_length1;
		{
			BaobabScannerResults** results_collection = NULL;
			gint results_collection_length1 = 0;
			gint _results_collection_size_ = 0;
			gint results_it = 0;
			results_collection = _tmp4_;
			results_collection_length1 = _tmp4__length1;
			for (results_it = 0; results_it < _tmp4__length1; results_it = results_it + 1) {
				BaobabScannerResults* results = NULL;
				results = results_collection[results_it];
				{
					BaobabScannerResults* _tmp5_;
					BaobabScannerState _tmp6_ = 0;
					BaobabScannerResults* _tmp7_;
					GError* _tmp8_;
					BaobabScannerResults* _tmp9_;
					GtkTreeIter _tmp10_;
					BaobabScannerResults* _tmp11_;
					guint64 _tmp12_;
					BaobabScannerResults* _tmp13_;
					guint64 _tmp14_;
					BaobabScannerResults* _tmp15_;
					gdouble _tmp16_;
					BaobabScannerResults* _tmp17_;
					gint _tmp18_;
					BaobabScannerState _tmp19_;
					BaobabScannerResults* _tmp20_;
					GError* _tmp21_;
					BaobabScannerResults* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
					BaobabScannerResults* _tmp27_;
					GError* _tmp28_;
					BaobabScannerResults* _tmp38_;
					BaobabScannerResults* _tmp39_;
					_tmp5_ = results;
					baobab_scanner_ensure_iter_exists (self, _tmp5_);
					_tmp7_ = results;
					_tmp8_ = _tmp7_->error;
					if (_tmp8_ == NULL) {
						_tmp6_ = BAOBAB_SCANNER_STATE_DONE;
					} else {
						_tmp6_ = BAOBAB_SCANNER_STATE_ERROR;
					}
					_tmp9_ = results;
					_tmp10_ = _tmp9_->iter;
					_tmp11_ = results;
					_tmp12_ = _tmp11_->size;
					_tmp13_ = results;
					_tmp14_ = _tmp13_->alloc_size;
					_tmp15_ = results;
					_tmp16_ = _tmp15_->percent;
					_tmp17_ = results;
					_tmp18_ = _tmp17_->elements;
					_tmp19_ = _tmp6_;
					_tmp20_ = results;
					_tmp21_ = _tmp20_->error;
					gtk_tree_store_set ((GtkTreeStore*) self, &_tmp10_, BAOBAB_SCANNER_COLUMNS_SIZE, _tmp12_, BAOBAB_SCANNER_COLUMNS_ALLOC_SIZE, _tmp14_, BAOBAB_SCANNER_COLUMNS_PERCENT, _tmp16_, BAOBAB_SCANNER_COLUMNS_ELEMENTS, _tmp18_, BAOBAB_SCANNER_COLUMNS_STATE, _tmp19_, BAOBAB_SCANNER_COLUMNS_ERROR, _tmp21_, -1);
					_tmp22_ = results;
					_tmp23_ = _tmp22_->max_depth;
					_tmp24_ = self->priv->_max_depth;
					if (_tmp23_ > _tmp24_) {
						BaobabScannerResults* _tmp25_;
						gint _tmp26_;
						_tmp25_ = results;
						_tmp26_ = _tmp25_->max_depth;
						baobab_scanner_set_max_depth (self, _tmp26_);
					}
					_tmp27_ = results;
					_tmp28_ = _tmp27_->error;
					if (_tmp28_ != NULL) {
						BaobabScannerResults* _tmp29_;
						GError* _tmp30_;
						_tmp29_ = results;
						_tmp30_ = _tmp29_->error;
						if (g_error_matches (_tmp30_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
							BaobabScannerResults* _tmp31_;
							GError* _tmp32_;
							GError* _tmp33_;
							_tmp31_ = results;
							_tmp32_ = _tmp31_->error;
							_tmp33_ = _g_error_copy0 (_tmp32_);
							_g_error_free0 (self->priv->scan_error);
							self->priv->scan_error = _tmp33_;
							g_signal_emit_by_name (self, "completed");
							result = FALSE;
							_baobab_scanner_results_array_free0 (results_array);
							return result;
						} else {
							GError* _tmp34_;
							_tmp34_ = self->priv->scan_error;
							if (_tmp34_ == NULL) {
								BaobabScannerResults* _tmp35_;
								GError* _tmp36_;
								GError* _tmp37_;
								_tmp35_ = results;
								_tmp36_ = _tmp35_->error;
								_tmp37_ = _g_error_copy0 (_tmp36_);
								_g_error_free0 (self->priv->scan_error);
								self->priv->scan_error = _tmp37_;
							}
						}
					}
					_tmp38_ = results;
					_tmp39_ = _tmp38_->parent;
					if (_tmp39_ == NULL) {
						self->priv->successful = TRUE;
						g_signal_emit_by_name (self, "completed");
						result = FALSE;
						_baobab_scanner_results_array_free0 (results_array);
						return result;
					}
				}
			}
		}
		_baobab_scanner_results_array_free0 (results_array);
	}
	_tmp40_ = self->priv->self;
	result = _tmp40_ != NULL;
	return result;
}


static void* _baobab_scanner_scan_in_thread_gthread_thread_func (gpointer self) {
	void* result;
	result = baobab_scanner_scan_in_thread (self);
	return result;
}


static gboolean _baobab_scanner_process_results_gsource_func (gpointer self) {
	gboolean result;
	result = baobab_scanner_process_results (self);
	return result;
}


void baobab_scanner_scan (BaobabScanner* self, gboolean force) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = force;
	if (_tmp0_) {
		self->priv->successful = FALSE;
		gtk_tree_store_clear ((GtkTreeStore*) self);
	}
	_tmp1_ = self->priv->successful;
	if (!_tmp1_) {
		GThread* _tmp2_;
		GThread* _tmp3_;
		_tmp2_ = g_thread_new ("scanner", _baobab_scanner_scan_in_thread_gthread_thread_func, self);
		_tmp3_ = _tmp2_;
		_g_thread_unref0 (_tmp3_);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _baobab_scanner_process_results_gsource_func, g_object_ref (self), g_object_unref);
	} else {
		g_signal_emit_by_name (self, "completed");
	}
}


static void baobab_scanner_real_cancel (BaobabScanner* self) {
	GCancellable* _tmp0_;
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
}


void baobab_scanner_cancel (BaobabScanner* self) {
	g_return_if_fail (self != NULL);
	BAOBAB_SCANNER_GET_CLASS (self)->cancel (self);
}


static void baobab_scanner_real_finish (BaobabScanner* self, GError** error) {
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->scan_error;
	if (_tmp0_ != NULL) {
		GError* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = self->priv->scan_error;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void baobab_scanner_finish (BaobabScanner* self, GError** error) {
	g_return_if_fail (self != NULL);
	BAOBAB_SCANNER_GET_CLASS (self)->finish (self, error);
}


static void _g_unix_mount_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_unix_mount_free (var), NULL));
}


static void _g_list_free__g_unix_mount_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_unix_mount_free0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BaobabScanner* baobab_scanner_construct (GType object_type, GFile* directory, BaobabScanFlags flags) {
	BaobabScanner * self = NULL;
	GFile* _tmp0_;
	BaobabScanFlags _tmp1_;
	GCancellable* _tmp2_;
	GType* _tmp3_ = NULL;
	GType* _tmp4_;
	gint _tmp4__length1;
	GHashTable* _tmp5_ = NULL;
	BaobabScanFlags _tmp6_;
	GHashTable* _tmp12_;
	GFile* _tmp13_;
	GAsyncQueue* _tmp14_;
	BaobabScanner* _tmp15_;
	g_return_val_if_fail (directory != NULL, NULL);
	self = (BaobabScanner*) g_object_new (object_type, NULL);
	_tmp0_ = directory;
	baobab_scanner_set_directory (self, _tmp0_);
	_tmp1_ = flags;
	baobab_scanner_set_scan_flags (self, _tmp1_);
	_tmp2_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp2_;
	_g_error_free0 (self->priv->scan_error);
	self->priv->scan_error = NULL;
	_tmp3_ = g_new0 (GType, 8);
	_tmp3_[0] = G_TYPE_STRING;
	_tmp3_[1] = G_TYPE_STRING;
	_tmp3_[2] = G_TYPE_DOUBLE;
	_tmp3_[3] = G_TYPE_UINT64;
	_tmp3_[4] = G_TYPE_UINT64;
	_tmp3_[5] = G_TYPE_INT;
	_tmp3_[6] = BAOBAB_SCANNER_TYPE_STATE;
	_tmp3_[7] = G_TYPE_POINTER;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 8;
	gtk_tree_store_set_column_types ((GtkTreeStore*) self, 8, _tmp4_);
	_tmp4_ = (g_free (_tmp4_), NULL);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self, (gint) BAOBAB_SCANNER_COLUMNS_SIZE, GTK_SORT_DESCENDING);
	_tmp5_ = baobab_application_get_excluded_locations ();
	_g_hash_table_unref0 (self->priv->excluded_locations);
	self->priv->excluded_locations = _tmp5_;
	_tmp6_ = flags;
	if ((_tmp6_ & BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS) == BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS) {
		GList* _tmp7_ = NULL;
		_tmp7_ = g_unix_mounts_get (NULL);
		{
			GList* mount_collection = NULL;
			GList* mount_it = NULL;
			mount_collection = _tmp7_;
			for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
				GUnixMountEntry* mount = NULL;
				mount = (GUnixMountEntry*) mount_it->data;
				{
					GHashTable* _tmp8_;
					GUnixMountEntry* _tmp9_;
					const gchar* _tmp10_ = NULL;
					GFile* _tmp11_ = NULL;
					_tmp8_ = self->priv->excluded_locations;
					_tmp9_ = mount;
					_tmp10_ = g_unix_mount_get_mount_path (_tmp9_);
					_tmp11_ = g_file_new_for_path (_tmp10_);
					g_hash_table_add (_tmp8_, _tmp11_);
				}
			}
			__g_list_free__g_unix_mount_free0_0 (mount_collection);
		}
	}
	_tmp12_ = self->priv->excluded_locations;
	_tmp13_ = directory;
	g_hash_table_remove (_tmp12_, _tmp13_);
	_tmp14_ = g_async_queue_new ();
	_g_async_queue_unref0 (self->priv->results_queue);
	self->priv->results_queue = _tmp14_;
	_tmp15_ = _g_object_ref0 (self);
	_g_object_unref0 (self->priv->self);
	self->priv->self = _tmp15_;
	return self;
}


BaobabScanner* baobab_scanner_new (GFile* directory, BaobabScanFlags flags) {
	return baobab_scanner_construct (BAOBAB_TYPE_SCANNER, directory, flags);
}


GFile* baobab_scanner_get_directory (BaobabScanner* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_directory;
	result = _tmp0_;
	return result;
}


static void baobab_scanner_set_directory (BaobabScanner* self, GFile* value) {
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_directory);
	self->priv->_directory = _tmp1_;
	g_object_notify ((GObject *) self, "directory");
}


BaobabScanFlags baobab_scanner_get_scan_flags (BaobabScanner* self) {
	BaobabScanFlags result;
	BaobabScanFlags _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_scan_flags;
	result = _tmp0_;
	return result;
}


static void baobab_scanner_set_scan_flags (BaobabScanner* self, BaobabScanFlags value) {
	BaobabScanFlags _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_scan_flags = _tmp0_;
	g_object_notify ((GObject *) self, "scan-flags");
}


gint baobab_scanner_get_max_depth (BaobabScanner* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_max_depth;
	result = _tmp0_;
	return result;
}


void baobab_scanner_set_max_depth (BaobabScanner* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_max_depth = _tmp0_;
	g_object_notify ((GObject *) self, "max-depth");
}


static BaobabScannerResultsArray* baobab_scanner_results_array_new (void) {
	BaobabScannerResultsArray* self;
	self = g_slice_new0 (BaobabScannerResultsArray);
	baobab_scanner_results_array_instance_init (self);
	return self;
}


static void baobab_scanner_results_array_instance_init (BaobabScannerResultsArray * self) {
}


static void baobab_scanner_results_array_free (BaobabScannerResultsArray* self) {
	self->results = (_vala_array_free (self->results, self->results_length1, (GDestroyNotify) baobab_scanner_results_free), NULL);
	g_slice_free (BaobabScannerResultsArray, self);
}


static BaobabScannerResults* baobab_scanner_results_new (void) {
	BaobabScannerResults* self;
	self = g_slice_new0 (BaobabScannerResults);
	baobab_scanner_results_instance_init (self);
	return self;
}


static void baobab_scanner_results_instance_init (BaobabScannerResults * self) {
}


static void baobab_scanner_results_free (BaobabScannerResults* self) {
	_g_free0 (self->display_name);
	_g_free0 (self->parse_name);
	_g_error_free0 (self->error);
	g_slice_free (BaobabScannerResults, self);
}


static void baobab_scanner_hard_link_init (BaobabScannerHardLink *self, GFileInfo* info) {
	GFileInfo* _tmp0_;
	guint64 _tmp1_ = 0ULL;
	GFileInfo* _tmp2_;
	guint32 _tmp3_ = 0U;
	g_return_if_fail (info != NULL);
	memset (self, 0, sizeof (BaobabScannerHardLink));
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_attribute_uint64 (_tmp0_, G_FILE_ATTRIBUTE_UNIX_INODE);
	(*self).inode = _tmp1_;
	_tmp2_ = info;
	_tmp3_ = g_file_info_get_attribute_uint32 (_tmp2_, G_FILE_ATTRIBUTE_UNIX_DEVICE);
	(*self).device = _tmp3_;
}


static BaobabScannerHardLink* baobab_scanner_hard_link_dup (const BaobabScannerHardLink* self) {
	BaobabScannerHardLink* dup;
	dup = g_new0 (BaobabScannerHardLink, 1);
	memcpy (dup, self, sizeof (BaobabScannerHardLink));
	return dup;
}


static void baobab_scanner_hard_link_free (BaobabScannerHardLink* self) {
	g_free (self);
}


static GType baobab_scanner_hard_link_get_type (void) {
	static volatile gsize baobab_scanner_hard_link_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_hard_link_type_id__volatile)) {
		GType baobab_scanner_hard_link_type_id;
		baobab_scanner_hard_link_type_id = g_boxed_type_register_static ("BaobabScannerHardLink", (GBoxedCopyFunc) baobab_scanner_hard_link_dup, (GBoxedFreeFunc) baobab_scanner_hard_link_free);
		g_once_init_leave (&baobab_scanner_hard_link_type_id__volatile, baobab_scanner_hard_link_type_id);
	}
	return baobab_scanner_hard_link_type_id__volatile;
}


static void baobab_scanner_class_init (BaobabScannerClass * klass) {
	baobab_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabScannerPrivate));
	BAOBAB_SCANNER_CLASS (klass)->cancel = baobab_scanner_real_cancel;
	BAOBAB_SCANNER_CLASS (klass)->finish = baobab_scanner_real_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_scanner_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_DIRECTORY, g_param_spec_object ("directory", "directory", "directory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_SCAN_FLAGS, g_param_spec_flags ("scan-flags", "scan-flags", "scan-flags", BAOBAB_TYPE_SCAN_FLAGS, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_SCANNER_MAX_DEPTH, g_param_spec_int ("max-depth", "max-depth", "max-depth", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("completed", BAOBAB_TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void baobab_scanner_instance_init (BaobabScanner * self) {
	self->priv = BAOBAB_SCANNER_GET_PRIVATE (self);
	self->priv->successful = FALSE;
}


static void baobab_scanner_finalize (GObject* obj) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_SCANNER, BaobabScanner);
	_g_object_unref0 (self->priv->_directory);
	self->priv->hardlinks = (g_free (self->priv->hardlinks), NULL);
	_g_hash_table_unref0 (self->priv->excluded_locations);
	_g_async_queue_unref0 (self->priv->results_queue);
	_g_object_unref0 (self->priv->self);
	_g_object_unref0 (self->priv->cancellable);
	_g_error_free0 (self->priv->scan_error);
	G_OBJECT_CLASS (baobab_scanner_parent_class)->finalize (obj);
}


GType baobab_scanner_get_type (void) {
	static volatile gsize baobab_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabScanner), 0, (GInstanceInitFunc) baobab_scanner_instance_init, NULL };
		GType baobab_scanner_type_id;
		baobab_scanner_type_id = g_type_register_static (GTK_TYPE_TREE_STORE, "BaobabScanner", &g_define_type_info, 0);
		g_once_init_leave (&baobab_scanner_type_id__volatile, baobab_scanner_type_id);
	}
	return baobab_scanner_type_id__volatile;
}


static void _vala_baobab_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SCANNER, BaobabScanner);
	switch (property_id) {
		case BAOBAB_SCANNER_DIRECTORY:
		g_value_set_object (value, baobab_scanner_get_directory (self));
		break;
		case BAOBAB_SCANNER_SCAN_FLAGS:
		g_value_set_flags (value, baobab_scanner_get_scan_flags (self));
		break;
		case BAOBAB_SCANNER_MAX_DEPTH:
		g_value_set_int (value, baobab_scanner_get_max_depth (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_SCANNER, BaobabScanner);
	switch (property_id) {
		case BAOBAB_SCANNER_DIRECTORY:
		baobab_scanner_set_directory (self, g_value_get_object (value));
		break;
		case BAOBAB_SCANNER_SCAN_FLAGS:
		baobab_scanner_set_scan_flags (self, g_value_get_flags (value));
		break;
		case BAOBAB_SCANNER_MAX_DEPTH:
		baobab_scanner_set_max_depth (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



