/* baobab-application.c generated by valac 0.20.1.64-fa28c-dirty, the Vala compiler
 * generated from baobab-application.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 * Copyright (C) 2012  Paolo Borelli <pborelli@gnome.org>
 * Copyright (C) 2012  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define BAOBAB_TYPE_APPLICATION (baobab_application_get_type ())
#define BAOBAB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplication))
#define BAOBAB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))
#define BAOBAB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))

typedef struct _BaobabApplication BaobabApplication;
typedef struct _BaobabApplicationClass BaobabApplicationClass;
typedef struct _BaobabApplicationPrivate BaobabApplicationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BAOBAB_TYPE_WINDOW (baobab_window_get_type ())
#define BAOBAB_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_WINDOW, BaobabWindow))
#define BAOBAB_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_WINDOW, BaobabWindowClass))
#define BAOBAB_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_WINDOW))
#define BAOBAB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_WINDOW))
#define BAOBAB_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_WINDOW, BaobabWindowClass))

typedef struct _BaobabWindow BaobabWindow;
typedef struct _BaobabWindowClass BaobabWindowClass;

#define BAOBAB_TYPE_SCAN_FLAGS (baobab_scan_flags_get_type ())
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _BaobabApplication {
	GtkApplication parent_instance;
	BaobabApplicationPrivate * priv;
};

struct _BaobabApplicationClass {
	GtkApplicationClass parent_class;
};

struct _BaobabApplicationPrivate {
	GSettings* prefs_settings;
	GSettings* ui_settings;
};

typedef enum  {
	BAOBAB_SCAN_FLAGS_NONE = 1 << 0,
	BAOBAB_SCAN_FLAGS_EXCLUDE_MOUNTS = 1 << 1
} BaobabScanFlags;


static gpointer baobab_application_parent_class = NULL;
static BaobabApplication* baobab_application_baobab;
static BaobabApplication* baobab_application_baobab = NULL;
static gboolean baobab_application_print_version;
static gboolean baobab_application_print_version = FALSE;

GType baobab_application_get_type (void) G_GNUC_CONST;
#define BAOBAB_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_APPLICATION, BaobabApplicationPrivate))
enum  {
	BAOBAB_APPLICATION_DUMMY_PROPERTY
};
static void baobab_application_on_quit_activate (BaobabApplication* self);
static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void baobab_application_real_activate (GApplication* base);
BaobabWindow* baobab_window_new (BaobabApplication* app);
BaobabWindow* baobab_window_construct (GType object_type, BaobabApplication* app);
GType baobab_window_get_type (void) G_GNUC_CONST;
static void baobab_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint);
GType baobab_scan_flags_get_type (void) G_GNUC_CONST;
void baobab_window_scan_directory (BaobabWindow* self, GFile* directory, BaobabScanFlags flags);
GHashTable* baobab_application_get_excluded_locations (void);
static guint _g_file_hash_ghash_func (gconstpointer key);
static gboolean _g_file_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static gchar* _variant_get1 (GVariant* value);
static void baobab_application_real_startup (GApplication* base);
static gboolean baobab_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status);
static void baobab_application_real_shutdown (GApplication* base);
BaobabApplication* baobab_application_new (void);
BaobabApplication* baobab_application_construct (GType object_type);
GSettings* baobab_application_get_prefs_settings (void);
GSettings* baobab_application_get_ui_settings (void);
static void baobab_application_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);

static const GOptionEntry BAOBAB_APPLICATION_option_entries[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &baobab_application_print_version, "Print version information and exit", NULL}, {NULL}};
static const GActionEntry BAOBAB_APPLICATION_action_entries[1] = {{"quit", _baobab_application_on_quit_activate_gsimple_action_activate_callback}};

static void _baobab_application_on_quit_activate_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_application_on_quit_activate (self);
}


static void baobab_application_real_activate (GApplication* base) {
	BaobabApplication * self;
	BaobabWindow* _tmp0_ = NULL;
	BaobabWindow* _tmp1_ = NULL;
	self = (BaobabApplication*) base;
	_tmp0_ = baobab_window_new (self);
	g_object_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_application_real_open (GApplication* base, GFile** files, int files_length1, const gchar* hint) {
	BaobabApplication * self;
	GFile** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (BaobabApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = files;
	_tmp0__length1 = files_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = _tmp0_;
		file_collection_length1 = _tmp0__length1;
		for (file_it = 0; file_it < _tmp0__length1; file_it = file_it + 1) {
			GFile* _tmp1_ = NULL;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				BaobabWindow* window = NULL;
				BaobabWindow* _tmp2_ = NULL;
				BaobabWindow* _tmp3_ = NULL;
				GFile* _tmp4_ = NULL;
				_tmp2_ = baobab_window_new (self);
				g_object_ref_sink (_tmp2_);
				window = _tmp2_;
				_tmp3_ = window;
				_tmp4_ = file;
				baobab_window_scan_directory (_tmp3_, _tmp4_, BAOBAB_SCAN_FLAGS_NONE);
				_g_object_unref0 (window);
				_g_object_unref0 (file);
			}
		}
	}
}


static guint _g_file_hash_ghash_func (gconstpointer key) {
	guint result;
	result = g_file_hash (key);
	return result;
}


static gboolean _g_file_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = g_file_equal (a, b);
	return result;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gchar* _variant_get1 (GVariant* value) {
	return g_variant_dup_string (value, NULL);
}


GHashTable* baobab_application_get_excluded_locations (void) {
	GHashTable* result = NULL;
	BaobabApplication* app = NULL;
	BaobabApplication* _tmp0_ = NULL;
	BaobabApplication* _tmp1_ = NULL;
	GHashTable* excluded_locations = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GHashTable* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* home = NULL;
	const gchar* _tmp9_ = NULL;
	GFile* _tmp10_ = NULL;
	GHashTable* _tmp11_ = NULL;
	GFile* _tmp12_ = NULL;
	GFile* _tmp13_ = NULL;
	GFile* root = NULL;
	GFile* _tmp14_ = NULL;
	_tmp0_ = baobab_application_baobab;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = g_hash_table_new_full (_g_file_hash_ghash_func, _g_file_equal_gequal_func, _g_object_unref0_, NULL);
	excluded_locations = _tmp2_;
	_tmp3_ = excluded_locations;
	_tmp4_ = g_file_new_for_path ("/proc");
	g_hash_table_add (_tmp3_, _tmp4_);
	_tmp5_ = excluded_locations;
	_tmp6_ = g_file_new_for_path ("/sys");
	g_hash_table_add (_tmp5_, _tmp6_);
	_tmp7_ = excluded_locations;
	_tmp8_ = g_file_new_for_path ("/selinux");
	g_hash_table_add (_tmp7_, _tmp8_);
	_tmp9_ = g_get_home_dir ();
	_tmp10_ = g_file_new_for_path (_tmp9_);
	home = _tmp10_;
	_tmp11_ = excluded_locations;
	_tmp12_ = home;
	_tmp13_ = g_file_get_child (_tmp12_, ".gvfs");
	g_hash_table_add (_tmp11_, _tmp13_);
	_tmp14_ = g_file_new_for_path ("/");
	root = _tmp14_;
	{
		GVariantIter* _uri_it = NULL;
		BaobabApplication* _tmp15_ = NULL;
		GSettings* _tmp16_ = NULL;
		GVariant* _tmp17_ = NULL;
		GVariant* _tmp18_ = NULL;
		GVariantIter* _tmp19_ = NULL;
		GVariantIter* _tmp20_ = NULL;
		GVariant* uri = NULL;
		_tmp15_ = app;
		_tmp16_ = _tmp15_->priv->prefs_settings;
		_tmp17_ = g_settings_get_value (_tmp16_, "excluded-uris");
		_tmp18_ = _tmp17_;
		_tmp19_ = g_variant_iter_new (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_variant_unref0 (_tmp18_);
		_uri_it = _tmp20_;
		while (TRUE) {
			GVariantIter* _tmp21_ = NULL;
			GVariant* _tmp22_ = NULL;
			GVariant* _tmp23_ = NULL;
			GFile* file = NULL;
			GVariant* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			GFile* _tmp27_ = NULL;
			GFile* _tmp28_ = NULL;
			GFile* _tmp29_ = NULL;
			GFile* _tmp30_ = NULL;
			gboolean _tmp31_ = FALSE;
			_tmp21_ = _uri_it;
			_tmp22_ = g_variant_iter_next_value (_tmp21_);
			_g_variant_unref0 (uri);
			uri = _tmp22_;
			_tmp23_ = uri;
			if (!(_tmp23_ != NULL)) {
				break;
			}
			_tmp24_ = uri;
			_tmp25_ = _variant_get1 (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_file_new_for_uri (_tmp26_);
			_tmp28_ = _tmp27_;
			_g_free0 (_tmp26_);
			file = _tmp28_;
			_tmp29_ = file;
			_tmp30_ = root;
			_tmp31_ = g_file_equal (_tmp29_, _tmp30_);
			if (!_tmp31_) {
				GHashTable* _tmp32_ = NULL;
				GFile* _tmp33_ = NULL;
				GFile* _tmp34_ = NULL;
				_tmp32_ = excluded_locations;
				_tmp33_ = file;
				_tmp34_ = _g_object_ref0 (_tmp33_);
				g_hash_table_add (_tmp32_, _tmp34_);
			}
			_g_object_unref0 (file);
		}
		_g_variant_unref0 (uri);
		_g_variant_iter_free0 (_uri_it);
	}
	result = excluded_locations;
	_g_object_unref0 (root);
	_g_object_unref0 (home);
	_g_object_unref0 (app);
	return result;
}


static void baobab_application_real_startup (GApplication* base) {
	BaobabApplication * self;
	BaobabApplication* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp4_ = NULL;
	GMenuModel* app_menu = NULL;
	GObject* _tmp6_ = NULL;
	GMenuModel* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = (BaobabApplication*) base;
	G_APPLICATION_CLASS (baobab_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (baobab_application_baobab);
	baobab_application_baobab = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.baobab.ui");
	_g_object_unref0 (self->priv->ui_settings);
	self->priv->ui_settings = _tmp1_;
	_tmp2_ = g_settings_new ("org.gnome.baobab.preferences");
	_g_object_unref0 (self->priv->prefs_settings);
	self->priv->prefs_settings = _tmp2_;
	_tmp3_ = self->priv->ui_settings;
	g_settings_delay (_tmp3_);
	_tmp4_ = gtk_builder_new ();
	builder = _tmp4_;
	{
		gtk_builder_add_from_resource (builder, "/org/gnome/baobab/ui/baobab-menu.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e->message;
		g_error ("baobab-application.vala:89: loading menu builder file: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = gtk_builder_get_object (builder, "appmenu");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp6_) : NULL);
	app_menu = _tmp7_;
	gtk_application_set_app_menu ((GtkApplication*) self, app_menu);
	gtk_application_add_accelerator ((GtkApplication*) self, "F10", "win.gear-menu", NULL);
	gtk_application_add_accelerator ((GtkApplication*) self, "<Primary>r", "win.reload", NULL);
	_g_object_unref0 (app_menu);
	_g_object_unref0 (builder);
}


static gboolean baobab_application_real_local_command_line (GApplication* base, gchar*** arguments, gint* exit_status) {
	BaobabApplication * self;
	gint _vala_exit_status = 0;
	gboolean result = FALSE;
	GOptionContext* ctx = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	gchar** argv = NULL;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint argv_length1 = 0;
	gint _argv_size_ = 0;
	gboolean _tmp7_ = FALSE;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (BaobabApplication*) base;
	_tmp0_ = _ ("- Disk Usage Analyzer");
	_tmp1_ = g_option_context_new (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = ctx;
	g_option_context_add_main_entries (_tmp2_, BAOBAB_APPLICATION_option_entries, GETTEXT_PACKAGE);
	_tmp3_ = ctx;
	_tmp4_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp3_, _tmp4_);
	_tmp5_ = *arguments;
	_tmp5__length1 = _vala_array_length (*arguments);
	argv = _tmp5_;
	argv_length1 = _tmp5__length1;
	_argv_size_ = argv_length1;
	{
		GOptionContext* _tmp6_ = NULL;
		_tmp6_ = ctx;
		g_option_context_parse (_tmp6_, &argv_length1, &argv, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_vala_exit_status = 1;
		result = TRUE;
		_g_error_free0 (e);
		_g_option_context_free0 (ctx);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (ctx);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = baobab_application_print_version;
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		_tmp8_ = g_get_application_name ();
		g_print ("%s %s\n", _tmp8_, VERSION);
		_vala_exit_status = 0;
		result = TRUE;
		_g_option_context_free0 (ctx);
		if (exit_status) {
			*exit_status = _vala_exit_status;
		}
		return result;
	}
	_tmp10_ = G_APPLICATION_CLASS (baobab_application_parent_class)->local_command_line ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication), arguments, &_tmp9_);
	_vala_exit_status = _tmp9_;
	result = _tmp10_;
	_g_option_context_free0 (ctx);
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
	return result;
}


static void baobab_application_real_shutdown (GApplication* base) {
	BaobabApplication * self;
	GSettings* _tmp0_ = NULL;
	self = (BaobabApplication*) base;
	_tmp0_ = self->priv->ui_settings;
	g_settings_apply (_tmp0_);
	G_APPLICATION_CLASS (baobab_application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
}


BaobabApplication* baobab_application_construct (GType object_type) {
	BaobabApplication * self = NULL;
	self = (BaobabApplication*) g_object_new (object_type, "application-id", "org.gnome.baobab", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	g_action_map_add_action_entries ((GActionMap*) self, BAOBAB_APPLICATION_action_entries, G_N_ELEMENTS (BAOBAB_APPLICATION_action_entries), self);
	return self;
}


BaobabApplication* baobab_application_new (void) {
	return baobab_application_construct (BAOBAB_TYPE_APPLICATION);
}


GSettings* baobab_application_get_prefs_settings (void) {
	GSettings* result = NULL;
	BaobabApplication* app = NULL;
	BaobabApplication* _tmp0_ = NULL;
	BaobabApplication* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	_tmp0_ = baobab_application_baobab;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = app->priv->prefs_settings;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	_g_object_unref0 (app);
	return result;
}


GSettings* baobab_application_get_ui_settings (void) {
	GSettings* result = NULL;
	BaobabApplication* app = NULL;
	BaobabApplication* _tmp0_ = NULL;
	BaobabApplication* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GSettings* _tmp3_ = NULL;
	_tmp0_ = baobab_application_baobab;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	app = _tmp1_;
	_tmp2_ = app->priv->ui_settings;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	_g_object_unref0 (app);
	return result;
}


static void baobab_application_on_quit_activate (BaobabApplication* self) {
	g_return_if_fail (self != NULL);
	g_application_quit ((GApplication*) self);
}


static void baobab_application_class_init (BaobabApplicationClass * klass) {
	baobab_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabApplicationPrivate));
	G_APPLICATION_CLASS (klass)->activate = baobab_application_real_activate;
	G_APPLICATION_CLASS (klass)->open = baobab_application_real_open;
	G_APPLICATION_CLASS (klass)->startup = baobab_application_real_startup;
	G_APPLICATION_CLASS (klass)->local_command_line = baobab_application_real_local_command_line;
	G_APPLICATION_CLASS (klass)->shutdown = baobab_application_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = baobab_application_finalize;
}


static void baobab_application_instance_init (BaobabApplication * self) {
	self->priv = BAOBAB_APPLICATION_GET_PRIVATE (self);
}


static void baobab_application_finalize (GObject* obj) {
	BaobabApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_APPLICATION, BaobabApplication);
	_g_object_unref0 (self->priv->prefs_settings);
	_g_object_unref0 (self->priv->ui_settings);
	G_OBJECT_CLASS (baobab_application_parent_class)->finalize (obj);
}


GType baobab_application_get_type (void) {
	static volatile gsize baobab_application_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabApplication), 0, (GInstanceInitFunc) baobab_application_instance_init, NULL };
		GType baobab_application_type_id;
		baobab_application_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "BaobabApplication", &g_define_type_info, 0);
		g_once_init_leave (&baobab_application_type_id__volatile, baobab_application_type_id);
	}
	return baobab_application_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



