//
// FilterMp3.cs : Register for reading of mp3 files, id3v2 is read, then missing
//                 infos are filled with id3v1 values.
//
// Author:
//		Raphaël Slinckx <raf.raf@wol.be>
//
// Copyright 2004 (C) Raphaël Slinckx
//

//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//

using System;
using System.IO;
using Beagle.Util.AudioUtil;

namespace Beagle.Filters {

	public class FilterMp3 : FilterMusic {
		
		private Id3v1TagReader Id3v1Reader = new Id3v1TagReader ();
		private Id3v2TagReader Id3v2Reader = new Id3v2TagReader ();
		
		
		protected override Tag GetTag(Stream s)
		{
			Tag v2 = Id3v2Reader.Read ((FileStream)s);
			Tag v1 = Id3v1Reader.Read ((FileStream)s);
			
			v2.Merge (v1);
			return v2;
		}
		
		protected override void RegisterSupportedTypes()
		{
			AddSupportedMimeType ("audio/x-mp3");
			AddSupportedMimeType ("audio/mpeg");
		}
	}
}
