//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using Gtk;
using System;
using System.Runtime.InteropServices;

namespace Imendio.Blam {
   
    public class Spinner : Widget {
	[DllImport ("libblam.so")]
	    static extern IntPtr blam_spinner_new ();

	[DllImport ("libblam.so")]
	    static extern void blam_spinner_start (IntPtr obj);
	
	[DllImport ("libblam.so")]
	    static extern void blam_spinner_stop (IntPtr obj);
	
	[DllImport ("libblam.so")]
	    static extern void blam_spinner_set_small_mode (IntPtr obj, bool m);
    

	public Spinner() : base (IntPtr.Zero)
	{
	    Raw = blam_spinner_new();
	    blam_spinner_set_small_mode(Handle, true);
	}

	public void Start()
	{
	    blam_spinner_start(Handle);
	}

	public void Stop()
	{
	    blam_spinner_stop(Handle);
	}
    }
}

