//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using Gtk;
using System;
using System.Runtime.InteropServices;

namespace Imendio.Blam {
    public class TrayIcon : Gtk.Plug {
	private string       mName;
	private Gtk.EventBox mEventBox;
	private Gtk.Image    mImage;
	private Gtk.Tooltips mTooltips;

	public new event ButtonPressEventHandler ButtonPressEvent;

	public Gtk.Image Image {
	    get {
		return mImage;
	    }
	}

	public string Tooltip {
	    set {
		mTooltips.SetTip (mEventBox, value, value);
	    }
	}

	[DllImport ("libblam.so")]
	    static extern IntPtr egg_tray_icon_new (string name);
	
	public TrayIcon (string name) 
	{
	    mName = name;
	    
	    Init ();
	}

	public new void Show ()
	{
	    ShowAll ();
	}

	private void Init ()
	{
	    Raw = egg_tray_icon_new (mName);
	    
	    DestroyEvent += HandleDestroyEvent;

	    mImage = new Gtk.Image ();
	    mEventBox = new Gtk.EventBox ();
	    mEventBox.Add (mImage);

	    mEventBox.ButtonPressEvent += ButtonPressedCb;

	    mTooltips = new Gtk.Tooltips ();
	    
	    this.Add (mEventBox);	
	}

	private void ButtonPressedCb (object o, ButtonPressEventArgs args)
	{
	    if (this.ButtonPressEvent != null) {
		this.ButtonPressEvent (o, args);
	    }
	}

	private void HandleDestroyEvent (object o, DestroyEventArgs args)
	{
	    Init ();
	}
    }
}
