//
// Author: 
//   Mikael Hallendal <micke@imendio.com>
//
// (C) 2004 Imendio HB
// 

using Gdk;
using Gtk;
using Glade;
using System;
using System.Text;

namespace Imendio.Blam {
    public class ChannelDialog {
	[Widget] Gtk.Dialog channelDialog;
	[Widget] Gtk.Entry  nameEntry;
	[Widget] Gtk.Entry  urlEntry;
	[Widget] Gtk.Button okButton;
	[Widget] Gtk.Image  dialogImage;

	private Channel     mChannel;
	
	private Application mApp;

	private static Gtk.FileSelection fileDialog = null;

	public string Name {
	    get {
		return nameEntry.Text;
	    }
	    set {
		nameEntry.Text = value;
	    }
	}
	
	public string Url {
	    get {
		return urlEntry.Text;
	    }
	    set {
		urlEntry.Text = value;
	    }
	}
	
	public ChannelDialog (Application app)
	{
	    mApp = app;
	    
	    Glade.XML gladeXML = Glade.XML.FromAssembly("blam.glade",
							"channelDialog",
							null);
	    gladeXML.Autoconnect(this);
	    channelDialog.TransientFor = mApp.Window;
	    channelDialog.Icon = Gdk.Pixbuf.LoadFromResource("blam.png");
	    
	    dialogImage.Pixbuf = 
		Gdk.Pixbuf.LoadFromResource ("blam-edit-news.png");
	}

	public void Show (Channel channel)
	{
	    mChannel = channel;
	    
	    nameEntry.Text = channel.Name;
	    urlEntry.Text = channel.Url;
	    
	    channelDialog.ShowAll ();
	}
	
	private void CancelButtonClicked (object obj, EventArgs args)
	{
	    channelDialog.Hide();
	}

	private void OkButtonClicked (object obj, EventArgs args)
	{
	    mChannel.Name = nameEntry.Text;
	    mChannel.Url = urlEntry.Text;

	    mApp.CCollection.Update (mChannel);

	    channelDialog.Hide ();
	}

	private void EntryChanged (object obj, EventArgs args)
	{
	    if (!nameEntry.Text.Equals("") && !urlEntry.Text.Equals("")) {
		okButton.Sensitive = true;
	    } else {
		okButton.Sensitive = false;
	    }
	}

	private void EntryActivated (object obj, EventArgs args)
	{
	    if (!nameEntry.Text.Equals("") && !urlEntry.Text.Equals("")) {
		okButton.Click();
	    }
	}
    }
}
