/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <cairo.h>
#include <jg_jnu.h>

#ifndef _Included_org_freedesktop_cairo_ImageSurface
#define _Included_org_freedesktop_cairo_ImageSurface
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_freedesktop_cairo_ImageSurface
 * Method:    cairo_image_surface_create
 * Signature: (III)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_ImageSurface_cairo_1image_1surface_1create
  (JNIEnv *env, jclass cls, jint format, jint width, jint height)
{
	cairo_surface_t *surface = cairo_image_surface_create(
			(cairo_format_t)format, width, height);
	return getHandleFromPointer(env, surface);
}

/*
 * Class:     org_freedesktop_cairo_ImageSurface
 * Method:    cairo_image_surface_create_for_data
 * Signature: ([CIIII)Lorg/gnu/glib/Handle;
 */
JNIEXPORT jobject JNICALL Java_org_freedesktop_cairo_ImageSurface_cairo_1image_1surface_1create_1for_1data
  (JNIEnv *env, jclass cls, jcharArray data, jint format, jint width, jint height, jint stride)
{
	unsigned char* data_g;
	cairo_surface_t *surface;

	/* FIXME: This is entirely bogus; cairo_image_surcace_create_for_data()
	 * doesn't make a copy.  We also need to check that the array passed
	 * in is the right size.
	 */	
	data_g = (unsigned char*)(*env)->GetCharArrayElements(env, data, NULL);
	surface = cairo_image_surface_create_for_data(data_g,
			(cairo_format_t)format, width, height, stride);
	(*env)->ReleaseCharArrayElements(env, data, (jchar*)data_g, 0);
	return getHandleFromPointer(env, surface);
}

#ifdef __cplusplus
}
#endif
#endif
