/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2005 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.freedesktop.cairo;

import org.gnu.glib.Enum;

/**
 * The subpixel order specifies the order of color elements within each pixel on
 * the display device when rendering with an antialiasing mode of SUBPIXEL.
 *
 * @deprecated This class is part of the java-gnome 2.x family of libraries,
 *             which, due to their inefficiency and complexity, are no longer
 *             being maintained and have been abandoned by the java-gnome
 *             project. This class may exist in java-gnome 4.0; look out for
 *             <code>org.freedesktop.cairo.SubpixelOrder</code>.
 *             As this package was never correctly implemented in java-gnome 2.x,
 *             any new code written will likely have a considerably different
 *             public API.
 */
public class SubpixelOrder extends Enum {

    static final private int _DEFAULT = 0;

    /**
     * Use the default subpixel order for for the target device
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public SubpixelOrder DEFAULT = new SubpixelOrder(_DEFAULT);

    static final private int _RGB = 1;

    /**
     * Subpixel elements are arranged horizontally with red at the left
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public SubpixelOrder RGB = new SubpixelOrder(_RGB);

    static final private int _BGR = 2;

    /**
     * Subpixel elements are arranged horizontally with blue at the left
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public SubpixelOrder BGR = new SubpixelOrder(_BGR);

    static final private int _VRGB = 3;

    /**
     * Subpixel elements are arranged vertically with red at the top
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public SubpixelOrder VRGB = new SubpixelOrder(_VRGB);

    static final private int _VBGR = 4;

    /**
     * Subpixel elements are arranged vertically with blue at the top
     * @deprecated Superceeded by java-gnome 4.0; this method or constant
     *             will no doubt exist conceptually, but it may have a different
     *             name or signature in order that the presented API is an
     *             algorithmic mapping of the underlying native libraries.
     */
    static final public SubpixelOrder VBGR = new SubpixelOrder(_VBGR);

    static final private SubpixelOrder[] theInterned = new SubpixelOrder[] {
            DEFAULT, RGB, BGR, VRGB, VBGR };

    static private java.util.Hashtable theInternedExtras;

    static final private SubpixelOrder theSacrificialOne = new SubpixelOrder(0);

    static public SubpixelOrder intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        SubpixelOrder already = (SubpixelOrder) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new SubpixelOrder(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private SubpixelOrder(int value) {
        value_ = value;
    }

    public boolean test(SubpixelOrder other) {
        return (value_ & other.value_) == other.value_;
    }
}
