/* cheese-window.c generated by valac, the Vala compiler
 * generated from cheese-window.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <clutter/clutter.h>
#include <clutter-gtk/clutter-gtk.h>
#include <thumbview/eog-thumb-nav.h>
#include <thumbview/cheese-thumb-view.h>
#include <mx/mx.h>
#include <gee.h>
#include <cheese-camera.h>
#include <cheese-flash.h>
#include <cheese-gconf.h>
#include <cheese-effect.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <cheese-config.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
typedef struct _CheeseMainWindowPrivate CheeseMainWindowPrivate;

#define CHEESE_TYPE_EFFECTS_MANAGER (cheese_effects_manager_get_type ())
#define CHEESE_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManager))
#define CHEESE_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))
#define CHEESE_IS_EFFECTS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_IS_EFFECTS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_EFFECTS_MANAGER))
#define CHEESE_EFFECTS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_EFFECTS_MANAGER, CheeseEffectsManagerClass))

typedef struct _CheeseEffectsManager CheeseEffectsManager;
typedef struct _CheeseEffectsManagerClass CheeseEffectsManagerClass;

#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define CHEESE_TYPE_COUNTDOWN (cheese_countdown_get_type ())
#define CHEESE_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdown))
#define CHEESE_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))
#define CHEESE_IS_COUNTDOWN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_IS_COUNTDOWN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_COUNTDOWN))
#define CHEESE_COUNTDOWN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_COUNTDOWN, CheeseCountdownClass))

typedef struct _CheeseCountdown CheeseCountdown;
typedef struct _CheeseCountdownClass CheeseCountdownClass;
typedef struct _CheeseEffectsManagerPrivate CheeseEffectsManagerPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_slist_free0(var) ((var == NULL) ? NULL : (var = (g_slist_free (var), NULL)))

struct _CheeseMainWindow {
	GtkWindow parent_instance;
	CheeseMainWindowPrivate * priv;
};

struct _CheeseMainWindowClass {
	GtkWindowClass parent_class;
};

struct _CheeseMainWindowPrivate {
	CheeseMediaMode current_mode;
	GtkBuilder* gtk_builder;
	ClutterScript* clutter_builder;
	GtkWidget* thumbnails;
	GtkClutterEmbed* viewport_widget;
	GtkVBox* main_vbox;
	EogThumbNav* thumb_nav;
	CheeseThumbView* thumb_view;
	GtkAlignment* thumbnails_right;
	GtkAlignment* thumbnails_bottom;
	GtkMenuBar* menubar;
	GtkHBox* leave_fullscreen_button_container;
	GtkToggleButton* photo_toggle_button;
	GtkToggleButton* video_toggle_button;
	GtkToggleButton* burst_toggle_button;
	GtkButton* take_action_button;
	GtkLabel* take_action_button_label;
	GtkImage* take_action_button_image;
	GtkToggleButton* effects_toggle_button;
	GtkButton* leave_fullscreen_button;
	GtkHBox* buttons_area;
	GtkMenu* popup_menu;
	ClutterStage* viewport;
	ClutterBox* viewport_layout;
	ClutterTexture* video_preview;
	ClutterBinLayout* viewport_layout_manager;
	ClutterText* countdown_layer;
	ClutterRectangle* background_layer;
	MxGrid* current_effects_grid;
	gint current_effects_page;
	GeeArrayList* effects_grids;
	GtkAction* take_photo_action;
	GtkAction* take_video_action;
	GtkAction* take_burst_action;
	GtkAction* photo_mode_action;
	GtkAction* video_mode_action;
	GtkAction* burst_mode_action;
	GtkToggleAction* effects_toggle_action;
	GtkToggleAction* wide_mode_action;
	GtkAction* countdown_action;
	GtkAction* effects_page_prev_action;
	GtkAction* effects_page_next_action;
	gboolean is_fullscreen;
	gboolean is_wide_mode;
	gboolean is_recording;
	gboolean is_bursting;
	gboolean is_effects_selector_active;
	GtkButton** buttons;
	gint buttons_length1;
	gint _buttons_size_;
	CheeseCamera* camera;
	CheeseFileUtil* fileutil;
	CheeseFlash* flash;
	CheeseGConf* conf;
	CheeseEffectsManager* effects_manager;
	CheesePreferencesDialog* preferences_dialog;
	CheeseEffect* selected_effect;
	GSource* fullscreen_timeout;
	gint burst_count;
};

typedef void (*CheeseCountdownCountdownCallback) (void* user_data);
struct _CheeseEffectsManager {
	GObject parent_instance;
	CheeseEffectsManagerPrivate * priv;
	GeeArrayList* effects;
};

struct _CheeseEffectsManagerClass {
	GObjectClass parent_class;
};


static gpointer cheese_main_window_parent_class = NULL;

#define FULLSCREEN_TIMEOUT_INTERVAL (5 * 1000)
#define EFFECTS_PER_PAGE 9
GType cheese_main_window_get_type (void);
GType cheese_effects_manager_get_type (void);
GType cheese_preferences_dialog_get_type (void);
#define CHEESE_MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowPrivate))
enum  {
	CHEESE_MAIN_WINDOW_DUMMY_PROPERTY
};
void cheese_main_window_on_quit (GtkAction* action, CheeseMainWindow* self);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
void cheese_main_window_on_preferences_dialog (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self);
gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event);
void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_help_contents (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_help_about (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode);
void cheese_main_window_on_layout_fullscreen (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode);
void cheese_main_window_on_mode_change (GtkRadioAction* action, CheeseMainWindow* self);
static void cheese_main_window_enable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_disable_mode_change (CheeseMainWindow* self);
static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self);
static gboolean _lambda0_ (CheeseMainWindow* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self);
static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e);
static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags);
void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self);
static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self);
CheeseCountdown* cheese_countdown_new (ClutterText* countdown_actor);
CheeseCountdown* cheese_countdown_construct (GType object_type, ClutterText* countdown_actor);
GType cheese_countdown_get_type (void);
void cheese_countdown_start_countdown (CheeseCountdown* self, CheeseCountdownCountdownCallback completed_callback, void* completed_callback_target);
static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self);
void cheese_main_window_take_photo (CheeseMainWindow* self);
static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self);
static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self);
void cheese_main_window_on_take_action (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active);
void cheese_main_window_on_effects_toggle (GtkToggleAction* action, CheeseMainWindow* self);
void cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, MxButton* button);
static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number);
void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self);
void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self);
static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self);
CheeseEffectsManager* cheese_effects_manager_new (void);
CheeseEffectsManager* cheese_effects_manager_construct (GType object_type);
void cheese_effects_manager_load_effects (CheeseEffectsManager* self);
static void _cheese_main_window_on_selected_effect_change_mx_button_clicked (MxButton* _sender, gpointer self);
static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self);
static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* p0, ClutterAllocationFlags p1, gpointer self);
static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, CheeseGConf* conf);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, CheeseGConf* conf);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
CheeseMainWindow* cheese_main_window_new (void);
CheeseMainWindow* cheese_main_window_construct (GType object_type);
static void cheese_main_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



void cheese_main_window_on_quit (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	gtk_object_destroy ((GtkObject*) self);
}


void cheese_main_window_on_preferences_dialog (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	cheese_preferences_dialog_show (self->priv->preferences_dialog);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


gboolean cheese_main_window_on_thumbnail_mouse_button_press (CheeseMainWindow* self, GtkWidget* iconview, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path;
	GtkTreePath* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iconview != NULL, FALSE);
	path = NULL;
	path = (_tmp0_ = _gtk_tree_path_copy0 (gtk_icon_view_get_path_at_pos ((GtkIconView*) self->priv->thumb_view, (gint) (*event).x, (gint) (*event).y)), _gtk_tree_path_free0 (path), _tmp0_);
	if (path == NULL) {
		result = FALSE;
		_gtk_tree_path_free0 (path);
		return result;
	}
	if (!gtk_icon_view_path_is_selected ((GtkIconView*) self->priv->thumb_view, path)) {
		g_signal_emit_by_name ((GtkIconView*) self->priv->thumb_view, "unselect-all");
		gtk_icon_view_select_path ((GtkIconView*) self->priv->thumb_view, path);
		gtk_icon_view_set_cursor ((GtkIconView*) self->priv->thumb_view, path, NULL, FALSE);
	}
	if ((*event).type == GDK_BUTTON_PRESS) {
		if ((*event).button == 3) {
			gtk_menu_popup (self->priv->popup_menu, NULL, (GtkWidget*) self->priv->thumb_view, NULL, NULL, (*event).button, (*event).time);
		}
	} else {
		if ((*event).type == GDK_2BUTTON_PRESS) {
			cheese_main_window_on_file_open (NULL, self);
		}
	}
	result = FALSE;
	_gtk_tree_path_free0 (path);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void cheese_main_window_on_file_open (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_;
	char* filename;
	char* uri;
	GdkScreen* screen;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	GdkScreen* _tmp3_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	filename = NULL;
	uri = NULL;
	screen = NULL;
	filename = (_tmp0_ = cheese_thumb_view_get_selected_image (self->priv->thumb_view), _g_free0 (filename), _tmp0_);
	if (filename == NULL) {
		_g_free0 (filename);
		_g_free0 (uri);
		_g_object_unref0 (screen);
		return;
	}
	_tmp1_ = g_filename_to_uri (filename, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_free0 (uri);
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	uri = (_tmp2_ = _tmp1_, _g_free0 (uri), _tmp2_);
	screen = (_tmp3_ = _g_object_ref0 (gtk_window_get_screen ((GtkWindow*) self)), _g_object_unref0 (screen), _tmp3_);
	gtk_show_uri (screen, uri, gtk_get_current_event_time (), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_free0 (uri);
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (filename);
	_g_free0 (uri);
	_g_object_unref0 (screen);
}


void cheese_main_window_on_file_delete (GtkAction* action, CheeseMainWindow* self) {
	char* filename;
	char* basename;
	GtkMessageDialog* confirmation_dialog;
	gint response = 0;
	char* _tmp0_;
	char* _tmp1_;
	GtkMessageDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	filename = NULL;
	basename = NULL;
	confirmation_dialog = NULL;
	filename = (_tmp0_ = cheese_thumb_view_get_selected_image (self->priv->thumb_view), _g_free0 (filename), _tmp0_);
	if (filename == NULL) {
		_g_free0 (filename);
		_g_free0 (basename);
		_g_object_unref0 (confirmation_dialog);
		return;
	}
	basename = (_tmp1_ = g_filename_display_basename (filename), _g_free0 (basename), _tmp1_);
	confirmation_dialog = (_tmp2_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new_with_markup ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, "Are you sure you want to permanently delete the file \"%s\"?", basename, NULL)), _g_object_unref0 (confirmation_dialog), _tmp2_);
	gtk_dialog_add_button ((GtkDialog*) confirmation_dialog, GTK_STOCK_CANCEL, (gint) GTK_RESPONSE_CANCEL);
	gtk_dialog_add_button ((GtkDialog*) confirmation_dialog, GTK_STOCK_DELETE, (gint) GTK_RESPONSE_ACCEPT);
	gtk_message_dialog_format_secondary_text (confirmation_dialog, "%s", "If you delete an item, it will be permanently lost", NULL);
	response = gtk_dialog_run ((GtkDialog*) confirmation_dialog);
	gtk_object_destroy ((GtkObject*) confirmation_dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		g_remove (filename);
	}
	_g_free0 (filename);
	_g_free0 (basename);
	_g_object_unref0 (confirmation_dialog);
}


void cheese_main_window_on_file_move_to_trash (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_;
	char* filename;
	char* _tmp0_;
	GFile* file_to_trash;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_inner_error_ = NULL;
	filename = NULL;
	filename = (_tmp0_ = cheese_thumb_view_get_selected_image (self->priv->thumb_view), _g_free0 (filename), _tmp0_);
	if (filename == NULL) {
		_g_free0 (filename);
		return;
	}
	file_to_trash = g_file_new_for_path (filename);
	g_file_trash (file_to_trash, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		_g_object_unref0 (file_to_trash);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (filename);
	_g_object_unref0 (file_to_trash);
}


void cheese_main_window_on_file_move_to_trash_all (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_inner_error_ = NULL;
	{
		GFile* file_to_trash;
		GFileInfo* file_info;
		GFile* directory;
		GFileEnumerator* enumerator;
		GFile* _tmp5_;
		GFileEnumerator* _tmp6_;
		GFileEnumerator* _tmp7_;
		file_to_trash = NULL;
		file_info = NULL;
		directory = g_file_new_for_path (cheese_fileutil_get_photo_path (self->priv->fileutil));
		enumerator = g_file_enumerate_children (directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file_to_trash);
			_g_object_unref0 (file_info);
			_g_object_unref0 (directory);
			goto __catch1_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp0_;
			GFileInfo* _tmp1_;
			GFile* _tmp4_;
			char* _tmp3_;
			char* _tmp2_;
			_tmp0_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file_to_trash);
				_g_object_unref0 (file_info);
				_g_object_unref0 (directory);
				_g_object_unref0 (enumerator);
				goto __catch1_g_error;
			}
			if (!((file_info = (_tmp1_ = _tmp0_, _g_object_unref0 (file_info), _tmp1_)) != NULL)) {
				break;
			}
			file_to_trash = (_tmp4_ = g_file_new_for_path (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (cheese_fileutil_get_photo_path (self->priv->fileutil), G_DIR_SEPARATOR_S, NULL), g_file_info_get_name (file_info), NULL)), _g_object_unref0 (file_to_trash), _tmp4_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp2_);
			g_file_trash (file_to_trash, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file_to_trash);
				_g_object_unref0 (file_info);
				_g_object_unref0 (directory);
				_g_object_unref0 (enumerator);
				goto __catch1_g_error;
			}
		}
		directory = (_tmp5_ = g_file_new_for_path (cheese_fileutil_get_video_path (self->priv->fileutil)), _g_object_unref0 (directory), _tmp5_);
		_tmp6_ = g_file_enumerate_children (directory, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (file_to_trash);
			_g_object_unref0 (file_info);
			_g_object_unref0 (directory);
			_g_object_unref0 (enumerator);
			goto __catch1_g_error;
		}
		enumerator = (_tmp7_ = _tmp6_, _g_object_unref0 (enumerator), _tmp7_);
		while (TRUE) {
			GFileInfo* _tmp8_;
			GFileInfo* _tmp9_;
			GFile* _tmp12_;
			char* _tmp11_;
			char* _tmp10_;
			_tmp8_ = g_file_enumerator_next_file (enumerator, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file_to_trash);
				_g_object_unref0 (file_info);
				_g_object_unref0 (directory);
				_g_object_unref0 (enumerator);
				goto __catch1_g_error;
			}
			if (!((file_info = (_tmp9_ = _tmp8_, _g_object_unref0 (file_info), _tmp9_)) != NULL)) {
				break;
			}
			file_to_trash = (_tmp12_ = g_file_new_for_path (_tmp11_ = g_strconcat (_tmp10_ = g_strconcat (cheese_fileutil_get_photo_path (self->priv->fileutil), G_DIR_SEPARATOR_S, NULL), g_file_info_get_name (file_info), NULL)), _g_object_unref0 (file_to_trash), _tmp12_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp10_);
			g_file_trash (file_to_trash, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (file_to_trash);
				_g_object_unref0 (file_info);
				_g_object_unref0 (directory);
				_g_object_unref0 (enumerator);
				goto __catch1_g_error;
			}
		}
		_g_object_unref0 (file_to_trash);
		_g_object_unref0 (file_info);
		_g_object_unref0 (directory);
		_g_object_unref0 (enumerator);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("cheese-window.vala:230: Error: %s\n", e->message);
			_g_error_free0 (e);
			return;
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void cheese_main_window_on_file_save_as (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_;
	char* filename;
	char* basename;
	GtkFileChooserDialog* save_as_dialog;
	gint response = 0;
	char* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_inner_error_ = NULL;
	filename = NULL;
	basename = NULL;
	save_as_dialog = NULL;
	filename = (_tmp0_ = cheese_thumb_view_get_selected_image (self->priv->thumb_view), _g_free0 (filename), _tmp0_);
	if (filename == NULL) {
		_g_free0 (filename);
		_g_free0 (basename);
		_g_object_unref0 (save_as_dialog);
		return;
	}
	save_as_dialog = (_tmp1_ = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Save File", (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL)), _g_object_unref0 (save_as_dialog), _tmp1_);
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) save_as_dialog, TRUE);
	basename = (_tmp2_ = g_filename_display_basename (filename), _g_free0 (basename), _tmp2_);
	gtk_file_chooser_set_current_name ((GtkFileChooser*) save_as_dialog, basename);
	response = gtk_dialog_run ((GtkDialog*) save_as_dialog);
	gtk_widget_hide ((GtkWidget*) save_as_dialog);
	if (response == GTK_RESPONSE_ACCEPT) {
		char* target_filename;
		char* _tmp3_;
		GFile* src;
		GFile* dest;
		target_filename = NULL;
		target_filename = (_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) save_as_dialog), _g_free0 (target_filename), _tmp3_);
		src = g_file_new_for_path (filename);
		dest = g_file_new_for_path (target_filename);
		{
			g_file_copy (src, dest, G_FILE_COPY_OVERWRITE, NULL, NULL, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError * err;
			err = _inner_error_;
			_inner_error_ = NULL;
			{
				GtkMessageDialog* error_dialog;
				error_dialog = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "Could not save %s", target_filename));
				gtk_dialog_run ((GtkDialog*) error_dialog);
				gtk_object_destroy ((GtkObject*) error_dialog);
				_g_error_free0 (err);
				_g_object_unref0 (error_dialog);
			}
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_g_free0 (target_filename);
			_g_object_unref0 (src);
			_g_object_unref0 (dest);
			_g_free0 (filename);
			_g_free0 (basename);
			_g_object_unref0 (save_as_dialog);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (target_filename);
		_g_object_unref0 (src);
		_g_object_unref0 (dest);
	}
	gtk_object_destroy ((GtkObject*) save_as_dialog);
	_g_free0 (filename);
	_g_free0 (basename);
	_g_object_unref0 (save_as_dialog);
}


void cheese_main_window_on_help_contents (GtkAction* action, CheeseMainWindow* self) {
	GError * _inner_error_;
	GdkScreen* screen;
	GdkScreen* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_inner_error_ = NULL;
	screen = NULL;
	screen = (_tmp0_ = _g_object_ref0 (gtk_window_get_screen ((GtkWindow*) self)), _g_object_unref0 (screen), _tmp0_);
	{
		gtk_show_uri (screen, "ghelp:cheese", gtk_get_current_event_time (), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("cheese-window.vala:298: Error: %s\n", err->message);
			_g_error_free0 (err);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
}


void cheese_main_window_on_help_about (GtkAction* action, CheeseMainWindow* self) {
	GtkAboutDialog* about_dialog;
	GtkAboutDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	about_dialog = NULL;
	about_dialog = (_tmp0_ = _g_object_ref0 (GTK_ABOUT_DIALOG (gtk_builder_get_object (self->priv->gtk_builder, "aboutdialog"))), _g_object_unref0 (about_dialog), _tmp0_);
	gtk_about_dialog_set_version (about_dialog, VERSION);
	gtk_dialog_run ((GtkDialog*) about_dialog);
	gtk_widget_hide ((GtkWidget*) about_dialog);
	_g_object_unref0 (about_dialog);
}


void cheese_main_window_on_layout_wide_mode (GtkToggleAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	cheese_main_window_set_wide_mode (self, gtk_toggle_action_get_active (action));
}


void cheese_main_window_on_layout_fullscreen (GtkToggleAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	cheese_main_window_set_fullscreen_mode (self, gtk_toggle_action_get_active (action));
}


void cheese_main_window_on_mode_change (GtkRadioAction* action, CheeseMainWindow* self) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	cheese_main_window_set_mode (self, (CheeseMediaMode) (g_object_get (action, "value", &_tmp0_, NULL), _tmp0_));
}


static void cheese_main_window_enable_mode_change (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	gtk_action_set_sensitive (self->priv->photo_mode_action, TRUE);
	gtk_action_set_sensitive (self->priv->video_mode_action, TRUE);
	gtk_action_set_sensitive (self->priv->burst_mode_action, TRUE);
}


static void cheese_main_window_disable_mode_change (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	switch (self->priv->current_mode) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			gtk_action_set_sensitive (self->priv->photo_mode_action, TRUE);
			gtk_action_set_sensitive (self->priv->video_mode_action, FALSE);
			gtk_action_set_sensitive (self->priv->burst_mode_action, FALSE);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gtk_action_set_sensitive (self->priv->photo_mode_action, FALSE);
			gtk_action_set_sensitive (self->priv->video_mode_action, TRUE);
			gtk_action_set_sensitive (self->priv->burst_mode_action, FALSE);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			gtk_action_set_sensitive (self->priv->photo_mode_action, FALSE);
			gtk_action_set_sensitive (self->priv->video_mode_action, FALSE);
			gtk_action_set_sensitive (self->priv->burst_mode_action, TRUE);
			break;
		}
	}
}


static void cheese_main_window_set_mode (CheeseMainWindow* self, CheeseMediaMode mode) {
	char* _tmp1_;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->current_mode = mode;
	switch (self->priv->current_mode) {
		case CHEESE_MEDIA_MODE_PHOTO:
		{
			gtk_action_set_sensitive (self->priv->take_photo_action, TRUE);
			gtk_action_set_sensitive (self->priv->take_video_action, FALSE);
			gtk_action_set_sensitive (self->priv->take_burst_action, FALSE);
			gtk_activatable_set_related_action ((GtkActivatable*) self->priv->take_action_button, self->priv->take_photo_action);
			break;
		}
		case CHEESE_MEDIA_MODE_VIDEO:
		{
			gtk_action_set_sensitive (self->priv->take_photo_action, FALSE);
			gtk_action_set_sensitive (self->priv->take_video_action, TRUE);
			gtk_action_set_sensitive (self->priv->take_burst_action, FALSE);
			gtk_activatable_set_related_action ((GtkActivatable*) self->priv->take_action_button, self->priv->take_video_action);
			break;
		}
		case CHEESE_MEDIA_MODE_BURST:
		{
			gtk_action_set_sensitive (self->priv->take_photo_action, FALSE);
			gtk_action_set_sensitive (self->priv->take_video_action, FALSE);
			gtk_action_set_sensitive (self->priv->take_burst_action, TRUE);
			gtk_activatable_set_related_action ((GtkActivatable*) self->priv->take_action_button, self->priv->take_burst_action);
			break;
		}
	}
	gtk_label_set_label (self->priv->take_action_button_label, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("<b>", gtk_action_get_label (gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button)), NULL), "</b>", NULL));
	_g_free0 (_tmp1_);
	_g_free0 (_tmp0_);
}


static void cheese_main_window_clear_fullscreen_timeout (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->fullscreen_timeout != NULL) {
		GSource* _tmp0_;
		g_source_destroy (self->priv->fullscreen_timeout);
		self->priv->fullscreen_timeout = (_tmp0_ = NULL, _g_source_unref0 (self->priv->fullscreen_timeout), _tmp0_);
	}
}


static gboolean _lambda0_ (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gtk_widget_hide ((GtkWidget*) self->priv->buttons_area);
	cheese_main_window_clear_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


static void cheese_main_window_set_fullscreen_timeout (CheeseMainWindow* self) {
	GSource* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->fullscreen_timeout = (_tmp0_ = g_timeout_source_new ((guint) FULLSCREEN_TIMEOUT_INTERVAL), _g_source_unref0 (self->priv->fullscreen_timeout), _tmp0_);
	g_source_attach (self->priv->fullscreen_timeout, NULL);
	g_source_set_callback (self->priv->fullscreen_timeout, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
}


static gboolean cheese_main_window_fullscreen_motion_notify_callback (CheeseMainWindow* self, GtkWidget* viewport, GdkEventMotion* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (viewport != NULL, FALSE);
	cheese_main_window_clear_fullscreen_timeout (self);
	gtk_widget_show ((GtkWidget*) self->priv->buttons_area);
	cheese_main_window_set_fullscreen_timeout (self);
	result = TRUE;
	return result;
}


static gboolean _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_fullscreen_motion_notify_callback (self, _sender, event);
	return result;
}


static void cheese_main_window_set_fullscreen_mode (CheeseMainWindow* self, gboolean fullscreen_mode) {
	g_return_if_fail (self != NULL);
	self->priv->is_fullscreen = fullscreen_mode;
	if (fullscreen_mode) {
		if (self->priv->is_wide_mode) {
			gtk_widget_hide_all ((GtkWidget*) self->priv->thumbnails_right);
		} else {
			gtk_widget_hide_all ((GtkWidget*) self->priv->thumbnails_bottom);
		}
		gtk_widget_hide_all ((GtkWidget*) self->priv->menubar);
		gtk_widget_set_no_show_all ((GtkWidget*) self->priv->leave_fullscreen_button_container, FALSE);
		gtk_widget_show_all ((GtkWidget*) self->priv->leave_fullscreen_button_container);
		{
			GtkButton** b_collection;
			int b_collection_length1;
			int b_it;
			b_collection = self->priv->buttons;
			b_collection_length1 = self->priv->buttons_length1;
			for (b_it = 0; b_it < self->priv->buttons_length1; b_it = b_it + 1) {
				GtkButton* b;
				b = _g_object_ref0 (b_collection[b_it]);
				{
					gtk_button_set_relief (b, GTK_RELIEF_NONE);
					_g_object_unref0 (b);
				}
			}
		}
		gtk_window_fullscreen ((GtkWindow*) self);
		g_signal_connect_object ((GtkWidget*) self->priv->viewport_widget, "motion-notify-event", (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self, 0);
		cheese_main_window_set_fullscreen_timeout (self);
	} else {
		guint _tmp0_;
		if (self->priv->is_wide_mode) {
			gtk_widget_show_all ((GtkWidget*) self->priv->thumbnails_right);
		} else {
			gtk_widget_show_all ((GtkWidget*) self->priv->thumbnails_bottom);
		}
		gtk_widget_show_all ((GtkWidget*) self->priv->menubar);
		gtk_widget_hide_all ((GtkWidget*) self->priv->leave_fullscreen_button_container);
		{
			GtkButton** b_collection;
			int b_collection_length1;
			int b_it;
			b_collection = self->priv->buttons;
			b_collection_length1 = self->priv->buttons_length1;
			for (b_it = 0; b_it < self->priv->buttons_length1; b_it = b_it + 1) {
				GtkButton* b;
				b = _g_object_ref0 (b_collection[b_it]);
				{
					gtk_button_set_relief (b, GTK_RELIEF_NORMAL);
					_g_object_unref0 (b);
				}
			}
		}
		gtk_widget_show ((GtkWidget*) self->priv->buttons_area);
		g_signal_parse_name ("motion-notify-event", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
		g_signal_handlers_disconnect_matched ((GtkWidget*) self->priv->viewport_widget, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _cheese_main_window_fullscreen_motion_notify_callback_gtk_widget_motion_notify_event, self);
		gtk_window_unfullscreen ((GtkWindow*) self);
	}
}


static void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode) {
	GtkAllocation alloc = {0};
	GtkRequisition req = {0};
	g_return_if_fail (self != NULL);
	self->priv->is_wide_mode = wide_mode;
	g_object_set (self->priv->conf, "gconf-prop-wide-mode", wide_mode, NULL);
	gtk_widget_get_allocation ((GtkWidget*) self->priv->viewport_widget, &alloc);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->viewport_widget, alloc.width, alloc.height);
	if (self->priv->is_wide_mode) {
		gtk_icon_view_set_columns ((GtkIconView*) self->priv->thumb_view, 1);
		eog_thumb_nav_set_vertical (self->priv->thumb_nav, TRUE);
		if (gtk_bin_get_child ((GtkBin*) self->priv->thumbnails_bottom) != NULL) {
			gtk_container_remove ((GtkContainer*) self->priv->thumbnails_bottom, (GtkWidget*) self->priv->thumb_nav);
		}
		gtk_container_add ((GtkContainer*) self->priv->thumbnails_right, (GtkWidget*) self->priv->thumb_nav);
		gtk_widget_show_all ((GtkWidget*) self->priv->thumbnails_right);
		gtk_container_resize_children ((GtkContainer*) self->priv->thumbnails_right);
		gtk_widget_hide_all ((GtkWidget*) self->priv->thumbnails_bottom);
	} else {
		gtk_icon_view_set_columns ((GtkIconView*) self->priv->thumb_view, 5000);
		eog_thumb_nav_set_vertical (self->priv->thumb_nav, FALSE);
		if (gtk_bin_get_child ((GtkBin*) self->priv->thumbnails_right) != NULL) {
			gtk_container_remove ((GtkContainer*) self->priv->thumbnails_right, (GtkWidget*) self->priv->thumb_nav);
		}
		gtk_container_add ((GtkContainer*) self->priv->thumbnails_bottom, (GtkWidget*) self->priv->thumb_nav);
		gtk_widget_show_all ((GtkWidget*) self->priv->thumbnails_bottom);
		gtk_container_resize_children ((GtkContainer*) self->priv->thumbnails_bottom);
		gtk_widget_hide_all ((GtkWidget*) self->priv->thumbnails_right);
	}
	gtk_widget_size_request ((GtkWidget*) self, &req);
	gtk_window_resize ((GtkWindow*) self, req.width, req.height);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->viewport_widget, -1, -1);
}


void cheese_main_window_on_stage_resize (CheeseMainWindow* self, ClutterActor* actor, ClutterActorBox* box, ClutterAllocationFlags flags) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (actor != NULL);
	clutter_actor_set_size ((ClutterActor*) self->priv->viewport_layout, clutter_actor_get_width ((ClutterActor*) self->priv->viewport), clutter_actor_get_height ((ClutterActor*) self->priv->viewport));
	clutter_actor_set_size ((ClutterActor*) self->priv->background_layer, clutter_actor_get_width ((ClutterActor*) self->priv->viewport), clutter_actor_get_height ((ClutterActor*) self->priv->viewport));
	if (self->priv->current_effects_grid != NULL) {
		clutter_actor_set_size ((ClutterActor*) self->priv->current_effects_grid, clutter_actor_get_width ((ClutterActor*) self->priv->viewport), clutter_actor_get_height ((ClutterActor*) self->priv->viewport));
	}
}


void cheese_main_window_on_countdown_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_object_set (self->priv->conf, "gconf-prop-countdown", gtk_toggle_action_get_active (action), NULL);
}


static void cheese_main_window_finish_countdown_callback (CheeseMainWindow* self) {
	char* file_name;
	g_return_if_fail (self != NULL);
	file_name = g_strdup (cheese_fileutil_get_new_media_filename (self->priv->fileutil, self->priv->current_mode));
	cheese_flash_fire (self->priv->flash);
	cheese_camera_take_photo (self->priv->camera, file_name);
	_g_free0 (file_name);
}


static void _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback (gpointer self) {
	cheese_main_window_finish_countdown_callback (self);
}


void cheese_main_window_take_photo (CheeseMainWindow* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	if ((g_object_get (self->priv->conf, "gconf-prop-countdown", &_tmp0_, NULL), _tmp0_)) {
		CheeseCountdown* cd;
		cd = cheese_countdown_new (self->priv->countdown_layer);
		cheese_countdown_start_countdown (cd, _cheese_main_window_finish_countdown_callback_cheese_countdown_countdown_callback, self);
		_g_object_unref0 (cd);
	} else {
		cheese_main_window_finish_countdown_callback (self);
	}
}


static gboolean cheese_main_window_burst_take_photo (CheeseMainWindow* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->is_bursting) {
		gint _tmp1_;
		_tmp0_ = self->priv->burst_count < (g_object_get (self->priv->conf, "gconf-prop-burst-repeat", &_tmp1_, NULL), _tmp1_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		cheese_main_window_take_photo (self);
		self->priv->burst_count++;
		result = TRUE;
		return result;
	} else {
		self->priv->is_bursting = FALSE;
		cheese_main_window_enable_mode_change (self);
		gtk_action_set_sensitive (gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button), TRUE);
		gtk_action_set_sensitive ((GtkAction*) self->priv->effects_toggle_action, TRUE);
		self->priv->burst_count = 0;
		cheese_fileutil_reset_burst (self->priv->fileutil);
		result = FALSE;
		return result;
	}
}


static gboolean _cheese_main_window_burst_take_photo_gsource_func (gpointer self) {
	gboolean result;
	result = cheese_main_window_burst_take_photo (self);
	return result;
}


void cheese_main_window_on_take_action (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->current_mode == CHEESE_MEDIA_MODE_PHOTO) {
		cheese_main_window_take_photo (self);
	} else {
		if (self->priv->current_mode == CHEESE_MEDIA_MODE_VIDEO) {
			if (!self->priv->is_recording) {
				char* _tmp1_;
				char* _tmp0_;
				cheese_camera_start_video_recording (self->priv->camera, cheese_fileutil_get_new_media_filename (self->priv->fileutil, self->priv->current_mode));
				gtk_label_set_label (self->priv->take_action_button_label, _tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("<b>", _ ("Stop _Recording"), NULL), "</b>", NULL));
				_g_free0 (_tmp1_);
				_g_free0 (_tmp0_);
				gtk_image_set_from_stock (self->priv->take_action_button_image, GTK_STOCK_MEDIA_STOP, GTK_ICON_SIZE_BUTTON);
				self->priv->is_recording = TRUE;
				cheese_main_window_disable_mode_change (self);
				gtk_action_set_sensitive ((GtkAction*) self->priv->effects_toggle_action, FALSE);
			} else {
				char* _tmp3_;
				char* _tmp2_;
				cheese_camera_stop_video_recording (self->priv->camera);
				gtk_label_set_label (self->priv->take_action_button_label, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat ("<b>", gtk_action_get_label (gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button)), NULL), "</b>", NULL));
				_g_free0 (_tmp3_);
				_g_free0 (_tmp2_);
				gtk_image_set_from_stock (self->priv->take_action_button_image, GTK_STOCK_MEDIA_RECORD, GTK_ICON_SIZE_BUTTON);
				self->priv->is_recording = FALSE;
				cheese_main_window_enable_mode_change (self);
				gtk_action_set_sensitive ((GtkAction*) self->priv->effects_toggle_action, TRUE);
			}
		} else {
			if (self->priv->current_mode == CHEESE_MEDIA_MODE_BURST) {
				gint _tmp4_;
				self->priv->is_bursting = TRUE;
				cheese_main_window_disable_mode_change (self);
				gtk_action_set_sensitive (gtk_activatable_get_related_action ((GtkActivatable*) self->priv->take_action_button), FALSE);
				gtk_action_set_sensitive ((GtkAction*) self->priv->effects_toggle_action, FALSE);
				cheese_main_window_burst_take_photo (self);
				g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (((g_object_get (self->priv->conf, "gconf-prop-burst-delay", &_tmp4_, NULL), _tmp4_) / 1000) * 3500), _cheese_main_window_burst_take_photo_gsource_func, g_object_ref (self), g_object_unref);
			}
		}
	}
}


void cheese_main_window_on_effects_toggle (GtkToggleAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	cheese_main_window_toggle_effects_selector (self, gtk_toggle_action_get_active (action));
	gtk_action_set_sensitive (self->priv->take_photo_action, !gtk_toggle_action_get_active (action));
	gtk_action_set_sensitive (self->priv->take_video_action, !gtk_toggle_action_get_active (action));
	gtk_action_set_sensitive (self->priv->take_burst_action, !gtk_toggle_action_get_active (action));
	gtk_action_set_sensitive (self->priv->photo_mode_action, !gtk_toggle_action_get_active (action));
	gtk_action_set_sensitive (self->priv->video_mode_action, !gtk_toggle_action_get_active (action));
	gtk_action_set_sensitive (self->priv->burst_mode_action, !gtk_toggle_action_get_active (action));
}


void cheese_main_window_on_selected_effect_change (CheeseMainWindow* self, MxButton* button) {
	CheeseEffect* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	self->priv->selected_effect = (_tmp0_ = _g_object_ref0 ((CheeseEffect*) g_object_get_data ((GObject*) button, "effect")), _g_object_unref0 (self->priv->selected_effect), _tmp0_);
	cheese_camera_set_effect (self->priv->camera, self->priv->selected_effect);
	gtk_toggle_action_set_active (self->priv->effects_toggle_action, FALSE);
}


void cheese_main_window_on_prev_effects_page (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->current_effects_page != 0) {
		cheese_main_window_activate_effects_page (self, self->priv->current_effects_page - 1);
	}
}


void cheese_main_window_on_next_effects_page (GtkAction* action, CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	if (self->priv->current_effects_page != (gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects) / EFFECTS_PER_PAGE)) {
		cheese_main_window_activate_effects_page (self, self->priv->current_effects_page + 1);
	}
}


static void cheese_main_window_activate_effects_page (CheeseMainWindow* self, gint number) {
	GList* _tmp0_;
	gboolean _tmp1_;
	MxGrid* _tmp2_;
	g_return_if_fail (self != NULL);
	if (!self->priv->is_effects_selector_active) {
		return;
	}
	self->priv->current_effects_page = number;
	if ((_tmp1_ = g_list_index (_tmp0_ = clutter_container_get_children ((ClutterContainer*) self->priv->viewport_layout), (ClutterActor*) self->priv->current_effects_grid) != (-1), _g_list_free0 (_tmp0_), _tmp1_)) {
		clutter_container_remove ((ClutterContainer*) self->priv->viewport_layout, CLUTTER_ACTOR (self->priv->current_effects_grid), NULL);
	}
	self->priv->current_effects_grid = (_tmp2_ = (MxGrid*) gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_grids, number), _g_object_unref0 (self->priv->current_effects_grid), _tmp2_);
	clutter_container_add ((ClutterContainer*) self->priv->viewport_layout, CLUTTER_ACTOR (self->priv->current_effects_grid), NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint page_of_effect;
				if (!_tmp3_) {
					i++;
				}
				_tmp3_ = FALSE;
				if (!(i < (gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects) - 1))) {
					break;
				}
				page_of_effect = i / EFFECTS_PER_PAGE;
				if (page_of_effect == page_of_effect) {
					CheeseEffect* _tmp4_;
					cheese_effect_enable_preview (_tmp4_ = (CheeseEffect*) gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_manager->effects, i));
					_g_object_unref0 (_tmp4_);
				} else {
					CheeseEffect* _tmp5_;
					cheese_effect_disable_preview (_tmp5_ = (CheeseEffect*) gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_manager->effects, i));
					_g_object_unref0 (_tmp5_);
				}
			}
		}
	}
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
	clutter_actor_set_size ((ClutterActor*) self->priv->current_effects_grid, clutter_actor_get_width ((ClutterActor*) self->priv->viewport), clutter_actor_get_height ((ClutterActor*) self->priv->viewport));
}


static void cheese_main_window_setup_effects_page_switch_sensitivity (CheeseMainWindow* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->is_effects_selector_active) {
		_tmp0_ = self->priv->current_effects_page != 0;
	} else {
		_tmp0_ = FALSE;
	}
	gtk_action_set_sensitive (self->priv->effects_page_prev_action, _tmp0_);
	if (self->priv->is_effects_selector_active) {
		_tmp1_ = self->priv->current_effects_page != (gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects) / EFFECTS_PER_PAGE);
	} else {
		_tmp1_ = FALSE;
	}
	gtk_action_set_sensitive (self->priv->effects_page_next_action, _tmp1_);
}


static void cheese_main_window_toggle_effects_selector (CheeseMainWindow* self, gboolean active) {
	g_return_if_fail (self != NULL);
	self->priv->is_effects_selector_active = active;
	if (active) {
		clutter_actor_hide ((ClutterActor*) self->priv->video_preview);
		clutter_actor_show ((ClutterActor*) self->priv->current_effects_grid);
		cheese_main_window_activate_effects_page (self, self->priv->current_effects_page);
	} else {
		clutter_actor_show ((ClutterActor*) self->priv->video_preview);
		clutter_actor_hide ((ClutterActor*) self->priv->current_effects_grid);
	}
	cheese_camera_toggle_effects_pipeline (self->priv->camera, active);
	cheese_main_window_setup_effects_page_switch_sensitivity (self);
}


static void _cheese_main_window_on_selected_effect_change_mx_button_clicked (MxButton* _sender, gpointer self) {
	cheese_main_window_on_selected_effect_change (self, _sender);
}


static void cheese_main_window_setup_effects_selector (CheeseMainWindow* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->current_effects_grid == NULL) {
		CheeseEffectsManager* _tmp0_;
		GeeArrayList* _tmp1_;
		MxGrid* _tmp11_;
		self->priv->effects_manager = (_tmp0_ = cheese_effects_manager_new (), _g_object_unref0 (self->priv->effects_manager), _tmp0_);
		cheese_effects_manager_load_effects (self->priv->effects_manager);
		self->priv->effects_grids = (_tmp1_ = gee_array_list_new (MX_TYPE_GRID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->effects_grids), _tmp1_);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					MxGrid* grid;
					if (!_tmp2_) {
						i++;
					}
					_tmp2_ = FALSE;
					if (!(i <= (gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects) / EFFECTS_PER_PAGE))) {
						break;
					}
					grid = g_object_ref_sink ((MxGrid*) mx_grid_new ());
					gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->effects_grids, grid);
					mx_grid_set_line_alignment (grid, MX_ALIGN_MIDDLE);
					mx_grid_set_child_x_align (grid, MX_ALIGN_MIDDLE);
					mx_grid_set_child_y_align (grid, MX_ALIGN_MIDDLE);
					mx_grid_set_orientation (grid, MX_ORIENTATION_VERTICAL);
					mx_grid_set_column_spacing (grid, (float) 20);
					mx_grid_set_row_spacing (grid, (float) 20);
					_g_object_unref0 (grid);
				}
			}
		}
		cheese_camera_stop (self->priv->camera);
		{
			gint i;
			i = 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					CheeseEffect* effect;
					ClutterTexture* texture;
					ClutterBinLayout* layout;
					ClutterBox* box;
					ClutterText* text;
					ClutterRectangle* rect;
					ClutterColor _tmp4_ = {0};
					ClutterColor _tmp5_;
					MxButton* button;
					char* _tmp7_;
					char* _tmp6_ = NULL;
					ClutterColor _tmp8_ = {0};
					ClutterColor _tmp9_;
					MxGrid* _tmp10_;
					if (!_tmp3_) {
						i++;
					}
					_tmp3_ = FALSE;
					if (!(i < (gee_collection_get_size ((GeeCollection*) self->priv->effects_manager->effects) - 1))) {
						break;
					}
					effect = (CheeseEffect*) gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_manager->effects, i);
					texture = g_object_ref_sink ((ClutterTexture*) clutter_texture_new ());
					layout = g_object_ref_sink ((ClutterBinLayout*) clutter_bin_layout_new (CLUTTER_BIN_ALIGNMENT_FILL, CLUTTER_BIN_ALIGNMENT_FILL));
					box = g_object_ref_sink ((ClutterBox*) clutter_box_new ((ClutterLayoutManager*) layout));
					text = g_object_ref_sink ((ClutterText*) clutter_text_new ());
					rect = g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new ());
					clutter_actor_set_opacity ((ClutterActor*) rect, (guint) 128);
					clutter_rectangle_set_color (rect, (_tmp5_ = (clutter_color_from_string (&_tmp4_, "black"), _tmp4_), &_tmp5_));
					clutter_actor_set_width ((ClutterActor*) box, (float) 160);
					clutter_actor_set_height ((ClutterActor*) box, (float) 120);
					button = g_object_ref_sink ((MxButton*) mx_button_new ());
					clutter_container_add ((ClutterContainer*) button, CLUTTER_ACTOR (box), NULL);
					clutter_box_pack (box, CLUTTER_ACTOR (texture), "x-align", CLUTTER_BIN_ALIGNMENT_FILL, "y-align", CLUTTER_BIN_ALIGNMENT_FILL, NULL, NULL);
					g_object_set_data_full ((GObject*) button, "effect", _g_object_ref0 (effect), g_object_unref);
					g_signal_connect_object (button, "clicked", (GCallback) _cheese_main_window_on_selected_effect_change_mx_button_clicked, self, 0);
					clutter_text_set_text (text, _tmp7_ = (g_object_get (effect, "name", &_tmp6_, NULL), _tmp6_));
					_g_free0 (_tmp7_);
					clutter_text_set_color (text, (_tmp9_ = (clutter_color_from_string (&_tmp8_, "white"), _tmp8_), &_tmp9_));
					clutter_actor_set_height ((ClutterActor*) rect, clutter_actor_get_height ((ClutterActor*) text) + 5);
					clutter_box_pack (box, CLUTTER_ACTOR (rect), "x-align", CLUTTER_BIN_ALIGNMENT_FILL, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					clutter_box_pack (box, CLUTTER_ACTOR (text), "x-align", CLUTTER_BIN_ALIGNMENT_CENTER, "y-align", CLUTTER_BIN_ALIGNMENT_END, NULL, NULL);
					clutter_container_add ((ClutterContainer*) (_tmp10_ = (MxGrid*) gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_grids, i / EFFECTS_PER_PAGE)), CLUTTER_ACTOR (button), NULL);
					_g_object_unref0 (_tmp10_);
					cheese_camera_connect_effect_texture (self->priv->camera, effect, texture);
					_g_object_unref0 (effect);
					_g_object_unref0 (texture);
					_g_object_unref0 (layout);
					_g_object_unref0 (box);
					_g_object_unref0 (text);
					_g_object_unref0 (rect);
					_g_object_unref0 (button);
				}
			}
		}
		cheese_camera_play (self->priv->camera);
		cheese_main_window_setup_effects_page_switch_sensitivity (self);
		self->priv->current_effects_grid = (_tmp11_ = (MxGrid*) gee_abstract_list_get ((GeeAbstractList*) self->priv->effects_grids, 0), _g_object_unref0 (self->priv->current_effects_grid), _tmp11_);
	}
}


static void _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* p0, ClutterAllocationFlags p1, gpointer self) {
	cheese_main_window_on_stage_resize (self, _sender, p0, p1);
}


static gboolean _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = cheese_main_window_on_thumbnail_mouse_button_press (self, _sender, event);
	return result;
}


void cheese_main_window_setup_ui (CheeseMainWindow* self) {
	GError * _inner_error_;
	GtkBuilder* _tmp0_;
	ClutterScript* _tmp1_;
	CheeseFileUtil* _tmp2_;
	CheeseFlash* _tmp3_;
	CheeseGConf* _tmp4_;
	GtkVBox* _tmp9_;
	GtkWidget* _tmp10_;
	GtkClutterEmbed* _tmp11_;
	ClutterStage* _tmp12_;
	GtkAlignment* _tmp13_;
	GtkAlignment* _tmp14_;
	GtkMenuBar* _tmp15_;
	GtkHBox* _tmp16_;
	GtkToggleButton* _tmp17_;
	GtkToggleButton* _tmp18_;
	GtkToggleButton* _tmp19_;
	GtkButton* _tmp20_;
	GtkLabel* _tmp21_;
	GtkImage* _tmp22_;
	GtkToggleButton* _tmp23_;
	GtkButton* _tmp24_;
	GtkHBox* _tmp25_;
	GtkMenu* _tmp26_;
	GtkAction* _tmp27_;
	GtkAction* _tmp28_;
	GtkAction* _tmp29_;
	GtkAction* _tmp30_;
	GtkAction* _tmp31_;
	GtkAction* _tmp32_;
	GtkToggleAction* _tmp33_;
	GtkAction* _tmp34_;
	GtkToggleAction* _tmp35_;
	GtkAction* _tmp36_;
	GtkAction* _tmp37_;
	GtkButton** _tmp39_;
	GtkButton** _tmp38_ = NULL;
	ClutterTexture* _tmp40_;
	ClutterBox* _tmp41_;
	ClutterBinLayout* _tmp42_;
	ClutterText* _tmp43_;
	ClutterRectangle* _tmp44_;
	CheeseCamera* _tmp49_;
	char* _tmp46_;
	char* _tmp45_ = NULL;
	gint _tmp47_;
	gint _tmp48_;
	CheeseThumbView* _tmp50_;
	EogThumbNav* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	CheesePreferencesDialog* _tmp57_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	self->priv->gtk_builder = (_tmp0_ = gtk_builder_new (), _g_object_unref0 (self->priv->gtk_builder), _tmp0_);
	self->priv->clutter_builder = (_tmp1_ = clutter_script_new (), _g_object_unref0 (self->priv->clutter_builder), _tmp1_);
	self->priv->fileutil = (_tmp2_ = cheese_fileutil_new (), _g_object_unref0 (self->priv->fileutil), _tmp2_);
	self->priv->flash = (_tmp3_ = cheese_flash_new ((GtkWidget*) self), _g_object_unref0 (self->priv->flash), _tmp3_);
	self->priv->conf = (_tmp4_ = cheese_gconf_new (), _g_object_unref0 (self->priv->conf), _tmp4_);
	{
		char* _tmp5_;
		char* _tmp6_;
		char* _tmp7_;
		char* _tmp8_;
		gtk_builder_add_from_file (self->priv->gtk_builder, _tmp5_ = g_build_filename (PACKAGE_DATADIR, "cheese-actions.ui", NULL), &_inner_error_);
		_g_free0 (_tmp5_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		gtk_builder_add_from_file (self->priv->gtk_builder, _tmp6_ = g_build_filename (PACKAGE_DATADIR, "cheese-about.ui", NULL), &_inner_error_);
		_g_free0 (_tmp6_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		gtk_builder_add_from_file (self->priv->gtk_builder, _tmp7_ = g_build_filename (PACKAGE_DATADIR, "cheese-main-window.ui", NULL), &_inner_error_);
		_g_free0 (_tmp7_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		gtk_builder_connect_signals (self->priv->gtk_builder, self);
		clutter_script_load_from_file (self->priv->clutter_builder, _tmp8_ = g_build_filename (PACKAGE_DATADIR, "cheese-viewport.json", NULL), &_inner_error_);
		_g_free0 (_tmp8_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("cheese-window.vala:811: Error: %s\n", err->message);
			_g_error_free0 (err);
			return;
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->main_vbox = (_tmp9_ = _g_object_ref0 (GTK_VBOX (gtk_builder_get_object (self->priv->gtk_builder, "mainbox_normal"))), _g_object_unref0 (self->priv->main_vbox), _tmp9_);
	self->priv->thumbnails = (_tmp10_ = _g_object_ref0 (GTK_WIDGET (gtk_builder_get_object (self->priv->gtk_builder, "thumbnails"))), _g_object_unref0 (self->priv->thumbnails), _tmp10_);
	self->priv->viewport_widget = (_tmp11_ = _g_object_ref0 (GTK_CLUTTER_EMBED (gtk_builder_get_object (self->priv->gtk_builder, "viewport"))), _g_object_unref0 (self->priv->viewport_widget), _tmp11_);
	self->priv->viewport = (_tmp12_ = _g_object_ref0 (CLUTTER_STAGE (gtk_clutter_embed_get_stage (self->priv->viewport_widget))), _g_object_unref0 (self->priv->viewport), _tmp12_);
	self->priv->thumbnails_right = (_tmp13_ = _g_object_ref0 (GTK_ALIGNMENT (gtk_builder_get_object (self->priv->gtk_builder, "thumbnails_right"))), _g_object_unref0 (self->priv->thumbnails_right), _tmp13_);
	self->priv->thumbnails_bottom = (_tmp14_ = _g_object_ref0 (GTK_ALIGNMENT (gtk_builder_get_object (self->priv->gtk_builder, "thumbnails_bottom"))), _g_object_unref0 (self->priv->thumbnails_bottom), _tmp14_);
	self->priv->menubar = (_tmp15_ = _g_object_ref0 (GTK_MENU_BAR (gtk_builder_get_object (self->priv->gtk_builder, "main_menubar"))), _g_object_unref0 (self->priv->menubar), _tmp15_);
	self->priv->leave_fullscreen_button_container = (_tmp16_ = _g_object_ref0 (GTK_HBOX (gtk_builder_get_object (self->priv->gtk_builder, "leave_fullscreen_button_bin"))), _g_object_unref0 (self->priv->leave_fullscreen_button_container), _tmp16_);
	self->priv->photo_toggle_button = (_tmp17_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (gtk_builder_get_object (self->priv->gtk_builder, "photo_toggle_button"))), _g_object_unref0 (self->priv->photo_toggle_button), _tmp17_);
	self->priv->video_toggle_button = (_tmp18_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (gtk_builder_get_object (self->priv->gtk_builder, "video_toggle_button"))), _g_object_unref0 (self->priv->video_toggle_button), _tmp18_);
	self->priv->burst_toggle_button = (_tmp19_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (gtk_builder_get_object (self->priv->gtk_builder, "burst_toggle_button"))), _g_object_unref0 (self->priv->burst_toggle_button), _tmp19_);
	self->priv->take_action_button = (_tmp20_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (self->priv->gtk_builder, "take_action_button"))), _g_object_unref0 (self->priv->take_action_button), _tmp20_);
	self->priv->take_action_button_label = (_tmp21_ = _g_object_ref0 (GTK_LABEL (gtk_builder_get_object (self->priv->gtk_builder, "take_action_button_internal_label"))), _g_object_unref0 (self->priv->take_action_button_label), _tmp21_);
	self->priv->take_action_button_image = (_tmp22_ = _g_object_ref0 (GTK_IMAGE (gtk_builder_get_object (self->priv->gtk_builder, "take_action_button_internal_image"))), _g_object_unref0 (self->priv->take_action_button_image), _tmp22_);
	self->priv->effects_toggle_button = (_tmp23_ = _g_object_ref0 (GTK_TOGGLE_BUTTON (gtk_builder_get_object (self->priv->gtk_builder, "effects_toggle_button"))), _g_object_unref0 (self->priv->effects_toggle_button), _tmp23_);
	self->priv->leave_fullscreen_button = (_tmp24_ = _g_object_ref0 (GTK_BUTTON (gtk_builder_get_object (self->priv->gtk_builder, "leave_fullscreen_button"))), _g_object_unref0 (self->priv->leave_fullscreen_button), _tmp24_);
	self->priv->buttons_area = (_tmp25_ = _g_object_ref0 (GTK_HBOX (gtk_builder_get_object (self->priv->gtk_builder, "buttons_area"))), _g_object_unref0 (self->priv->buttons_area), _tmp25_);
	self->priv->popup_menu = (_tmp26_ = _g_object_ref0 (GTK_MENU (gtk_builder_get_object (self->priv->gtk_builder, "thumbnail_popup"))), _g_object_unref0 (self->priv->popup_menu), _tmp26_);
	self->priv->take_photo_action = (_tmp27_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "take_photo"))), _g_object_unref0 (self->priv->take_photo_action), _tmp27_);
	self->priv->take_video_action = (_tmp28_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "take_video"))), _g_object_unref0 (self->priv->take_video_action), _tmp28_);
	self->priv->take_burst_action = (_tmp29_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "take_burst"))), _g_object_unref0 (self->priv->take_burst_action), _tmp29_);
	self->priv->photo_mode_action = (_tmp30_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "photo_mode"))), _g_object_unref0 (self->priv->photo_mode_action), _tmp30_);
	self->priv->video_mode_action = (_tmp31_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "video_mode"))), _g_object_unref0 (self->priv->video_mode_action), _tmp31_);
	self->priv->burst_mode_action = (_tmp32_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "burst_mode"))), _g_object_unref0 (self->priv->burst_mode_action), _tmp32_);
	self->priv->effects_toggle_action = (_tmp33_ = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "effects_toggle"))), _g_object_unref0 (self->priv->effects_toggle_action), _tmp33_);
	self->priv->countdown_action = (_tmp34_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "countdown"))), _g_object_unref0 (self->priv->countdown_action), _tmp34_);
	self->priv->wide_mode_action = (_tmp35_ = _g_object_ref0 (GTK_TOGGLE_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "wide_mode"))), _g_object_unref0 (self->priv->wide_mode_action), _tmp35_);
	self->priv->effects_page_next_action = (_tmp36_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "effects_page_next"))), _g_object_unref0 (self->priv->effects_page_next_action), _tmp36_);
	self->priv->effects_page_prev_action = (_tmp37_ = _g_object_ref0 (GTK_ACTION (gtk_builder_get_object (self->priv->gtk_builder, "effects_page_prev"))), _g_object_unref0 (self->priv->effects_page_prev_action), _tmp37_);
	self->priv->buttons = (_tmp39_ = (_tmp38_ = g_new0 (GtkButton*, 6 + 1), _tmp38_[0] = _g_object_ref0 ((GtkButton*) self->priv->photo_toggle_button), _tmp38_[1] = _g_object_ref0 ((GtkButton*) self->priv->video_toggle_button), _tmp38_[2] = _g_object_ref0 ((GtkButton*) self->priv->burst_toggle_button), _tmp38_[3] = _g_object_ref0 (self->priv->take_action_button), _tmp38_[4] = _g_object_ref0 ((GtkButton*) self->priv->effects_toggle_button), _tmp38_[5] = _g_object_ref0 (self->priv->leave_fullscreen_button), _tmp38_), self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL), self->priv->buttons_length1 = 6, self->priv->_buttons_size_ = self->priv->buttons_length1, _tmp39_);
	self->priv->video_preview = (_tmp40_ = _g_object_ref0 (CLUTTER_TEXTURE (clutter_script_get_object (self->priv->clutter_builder, "video_preview"))), _g_object_unref0 (self->priv->video_preview), _tmp40_);
	self->priv->viewport_layout = (_tmp41_ = _g_object_ref0 (CLUTTER_BOX (clutter_script_get_object (self->priv->clutter_builder, "viewport_layout"))), _g_object_unref0 (self->priv->viewport_layout), _tmp41_);
	self->priv->viewport_layout_manager = (_tmp42_ = _g_object_ref0 (CLUTTER_BIN_LAYOUT (clutter_script_get_object (self->priv->clutter_builder, "viewport_layout_manager"))), _g_object_unref0 (self->priv->viewport_layout_manager), _tmp42_);
	self->priv->countdown_layer = (_tmp43_ = _g_object_ref0 (CLUTTER_TEXT (clutter_script_get_object (self->priv->clutter_builder, "countdown_layer"))), _g_object_unref0 (self->priv->countdown_layer), _tmp43_);
	self->priv->background_layer = (_tmp44_ = _g_object_ref0 (CLUTTER_RECTANGLE (clutter_script_get_object (self->priv->clutter_builder, "background"))), _g_object_unref0 (self->priv->background_layer), _tmp44_);
	clutter_texture_set_keep_aspect_ratio (self->priv->video_preview, TRUE);
	clutter_actor_set_request_mode ((ClutterActor*) self->priv->video_preview, CLUTTER_REQUEST_HEIGHT_FOR_WIDTH);
	clutter_container_add_actor ((ClutterContainer*) self->priv->viewport, (ClutterActor*) self->priv->background_layer);
	clutter_box_set_layout_manager (self->priv->viewport_layout, (ClutterLayoutManager*) self->priv->viewport_layout_manager);
	self->priv->camera = (_tmp49_ = cheese_camera_new (self->priv->video_preview, _tmp46_ = (g_object_get (self->priv->conf, "gconf-prop-camera", &_tmp45_, NULL), _tmp45_), (g_object_get (self->priv->conf, "gconf-prop-x-resolution", &_tmp47_, NULL), _tmp47_), (g_object_get (self->priv->conf, "gconf-prop-y-resolution", &_tmp48_, NULL), _tmp48_)), _g_object_unref0 (self->priv->camera), _tmp49_);
	_g_free0 (_tmp46_);
	clutter_container_add_actor ((ClutterContainer*) self->priv->viewport, (ClutterActor*) self->priv->viewport_layout);
	g_signal_connect_object ((ClutterActor*) self->priv->viewport, "allocation-changed", (GCallback) _cheese_main_window_on_stage_resize_clutter_actor_allocation_changed, self, 0);
	self->priv->thumb_view = (_tmp50_ = g_object_ref_sink (cheese_thumb_view_new ()), _g_object_unref0 (self->priv->thumb_view), _tmp50_);
	self->priv->thumb_nav = (_tmp51_ = g_object_ref_sink (eog_thumb_nav_new ((GtkWidget*) self->priv->thumb_view, FALSE)), _g_object_unref0 (self->priv->thumb_nav), _tmp51_);
	g_signal_connect_object ((GtkWidget*) self->priv->thumb_view, "button-press-event", (GCallback) _cheese_main_window_on_thumbnail_mouse_button_press_gtk_widget_button_press_event, self, 0);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->main_vbox);
	gtk_widget_show_all ((GtkWidget*) self->priv->main_vbox);
	gtk_widget_realize ((GtkWidget*) self->priv->viewport_widget);
	gtk_toggle_action_set_active (self->priv->wide_mode_action, (g_object_get (self->priv->conf, "gconf-prop-wide-mode", &_tmp52_, NULL), _tmp52_));
	if (!(g_object_get (self->priv->conf, "gconf-prop-wide-mode", &_tmp53_, NULL), _tmp53_)) {
		gtk_toggle_action_toggled (self->priv->wide_mode_action);
	}
	{
		char* _tmp55_;
		char* _tmp54_ = NULL;
		cheese_camera_setup (self->priv->camera, _tmp55_ = (g_object_get (self->priv->conf, "gconf-prop-camera", &_tmp54_, NULL), _tmp54_), &_inner_error_);
		_g_free0 (_tmp55_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			ClutterText* error_layer;
			GSList* objects;
			char* _tmp56_[11] = {0};
			char* active_actions[11] = {0};
			gboolean flag = FALSE;
			error_layer = _g_object_ref0 (CLUTTER_TEXT (clutter_script_get_object (self->priv->clutter_builder, "error_layer")));
			clutter_actor_hide ((ClutterActor*) self->priv->video_preview);
			g_warning ("cheese-window.vala:902: Error: %s\n", err->message);
			clutter_text_set_text (error_layer, err->message);
			clutter_actor_show ((ClutterActor*) error_layer);
			objects = gtk_builder_get_objects (self->priv->gtk_builder);
			memcpy (active_actions, (_tmp56_[0] = g_strdup ("cheese_action"), _tmp56_[1] = g_strdup ("edit_action"), _tmp56_[2] = g_strdup ("help_action"), _tmp56_[3] = g_strdup ("quit"), _tmp56_[4] = g_strdup ("help_contents"), _tmp56_[5] = g_strdup ("about"), _tmp56_[6] = g_strdup ("open"), _tmp56_[7] = g_strdup ("save_as"), _tmp56_[8] = g_strdup ("move_to_trash"), _tmp56_[9] = g_strdup ("delete"), _tmp56_[10] = g_strdup ("move_all_to_trash"), _tmp56_), 11 * sizeof (char*));
			{
				GSList* obj_collection;
				GSList* obj_it;
				obj_collection = objects;
				for (obj_it = obj_collection; obj_it != NULL; obj_it = obj_it->next) {
					GObject* obj;
					obj = _g_object_ref0 ((GObject*) obj_it->data);
					{
						flag = FALSE;
						if (GTK_IS_ACTION (obj)) {
							GtkAction* action;
							action = _g_object_ref0 (GTK_ACTION (obj));
							{
								char** s_collection;
								int s_collection_length1;
								int s_it;
								s_collection = active_actions;
								s_collection_length1 = 11;
								for (s_it = 0; s_it < 11; s_it = s_it + 1) {
									char* s;
									s = g_strdup (s_collection[s_it]);
									{
										if (_vala_strcmp0 (gtk_action_get_name (action), s) == 0) {
											flag = TRUE;
										}
										_g_free0 (s);
									}
								}
							}
							if (!flag) {
								gtk_action_set_sensitive (GTK_ACTION (obj), FALSE);
							}
							_g_object_unref0 (action);
						}
						_g_object_unref0 (obj);
					}
				}
			}
			_g_error_free0 (err);
			_g_object_unref0 (error_layer);
			_g_slist_free0 (objects);
			_vala_array_destroy (active_actions, 11, (GDestroyNotify) g_free);
			return;
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	cheese_camera_play (self->priv->camera);
	cheese_main_window_set_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	cheese_main_window_setup_effects_selector (self);
	self->priv->preferences_dialog = (_tmp57_ = cheese_preferences_dialog_new (self->priv->camera, self->priv->conf), _g_object_unref0 (self->priv->preferences_dialog), _tmp57_);
}


CheeseMainWindow* cheese_main_window_construct (GType object_type) {
	CheeseMainWindow * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


CheeseMainWindow* cheese_main_window_new (void) {
	return cheese_main_window_construct (CHEESE_TYPE_MAIN_WINDOW);
}


static void cheese_main_window_class_init (CheeseMainWindowClass * klass) {
	cheese_main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseMainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_main_window_finalize;
}


static void cheese_main_window_instance_init (CheeseMainWindow * self) {
	self->priv = CHEESE_MAIN_WINDOW_GET_PRIVATE (self);
	self->priv->current_effects_page = 0;
}


static void cheese_main_window_finalize (GObject* obj) {
	CheeseMainWindow * self;
	self = CHEESE_MAIN_WINDOW (obj);
	_g_object_unref0 (self->priv->gtk_builder);
	_g_object_unref0 (self->priv->clutter_builder);
	_g_object_unref0 (self->priv->thumbnails);
	_g_object_unref0 (self->priv->viewport_widget);
	_g_object_unref0 (self->priv->main_vbox);
	_g_object_unref0 (self->priv->thumb_nav);
	_g_object_unref0 (self->priv->thumb_view);
	_g_object_unref0 (self->priv->thumbnails_right);
	_g_object_unref0 (self->priv->thumbnails_bottom);
	_g_object_unref0 (self->priv->menubar);
	_g_object_unref0 (self->priv->leave_fullscreen_button_container);
	_g_object_unref0 (self->priv->photo_toggle_button);
	_g_object_unref0 (self->priv->video_toggle_button);
	_g_object_unref0 (self->priv->burst_toggle_button);
	_g_object_unref0 (self->priv->take_action_button);
	_g_object_unref0 (self->priv->take_action_button_label);
	_g_object_unref0 (self->priv->take_action_button_image);
	_g_object_unref0 (self->priv->effects_toggle_button);
	_g_object_unref0 (self->priv->leave_fullscreen_button);
	_g_object_unref0 (self->priv->buttons_area);
	_g_object_unref0 (self->priv->popup_menu);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->priv->viewport_layout);
	_g_object_unref0 (self->priv->video_preview);
	_g_object_unref0 (self->priv->viewport_layout_manager);
	_g_object_unref0 (self->priv->countdown_layer);
	_g_object_unref0 (self->priv->background_layer);
	_g_object_unref0 (self->priv->current_effects_grid);
	_g_object_unref0 (self->priv->effects_grids);
	_g_object_unref0 (self->priv->take_photo_action);
	_g_object_unref0 (self->priv->take_video_action);
	_g_object_unref0 (self->priv->take_burst_action);
	_g_object_unref0 (self->priv->photo_mode_action);
	_g_object_unref0 (self->priv->video_mode_action);
	_g_object_unref0 (self->priv->burst_mode_action);
	_g_object_unref0 (self->priv->effects_toggle_action);
	_g_object_unref0 (self->priv->wide_mode_action);
	_g_object_unref0 (self->priv->countdown_action);
	_g_object_unref0 (self->priv->effects_page_prev_action);
	_g_object_unref0 (self->priv->effects_page_next_action);
	self->priv->buttons = (_vala_array_free (self->priv->buttons, self->priv->buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->fileutil);
	_g_object_unref0 (self->priv->flash);
	_g_object_unref0 (self->priv->conf);
	_g_object_unref0 (self->priv->effects_manager);
	_g_object_unref0 (self->priv->preferences_dialog);
	_g_object_unref0 (self->priv->selected_effect);
	_g_source_unref0 (self->priv->fullscreen_timeout);
	G_OBJECT_CLASS (cheese_main_window_parent_class)->finalize (obj);
}


GType cheese_main_window_get_type (void) {
	static volatile gsize cheese_main_window_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseMainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseMainWindow), 0, (GInstanceInitFunc) cheese_main_window_instance_init, NULL };
		GType cheese_main_window_type_id;
		cheese_main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "CheeseMainWindow", &g_define_type_info, 0);
		g_once_init_leave (&cheese_main_window_type_id__volatile, cheese_main_window_type_id);
	}
	return cheese_main_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




