/* cheese-application.c generated by valac 0.32.0.1-80f0, the Vala compiler
 * generated from cheese-application.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <cheese-camera.h>
#include <stdlib.h>
#include <string.h>
#include <cheese-gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <config.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gst/gst.h>
#include <cheese-fileutil.h>


#define CHEESE_TYPE_APPLICATION (cheese_application_get_type ())
#define CHEESE_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_APPLICATION, CheeseApplication))
#define CHEESE_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_APPLICATION, CheeseApplicationClass))
#define CHEESE_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_APPLICATION))
#define CHEESE_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_APPLICATION))
#define CHEESE_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_APPLICATION, CheeseApplicationClass))

typedef struct _CheeseApplication CheeseApplication;
typedef struct _CheeseApplicationClass CheeseApplicationClass;
typedef struct _CheeseApplicationPrivate CheeseApplicationPrivate;

#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CHEESE_TYPE_MAIN_WINDOW (cheese_main_window_get_type ())
#define CHEESE_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindow))
#define CHEESE_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))
#define CHEESE_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_MAIN_WINDOW))
#define CHEESE_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_MAIN_WINDOW, CheeseMainWindowClass))

typedef struct _CheeseMainWindow CheeseMainWindow;
typedef struct _CheeseMainWindowClass CheeseMainWindowClass;
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _CheeseApplication {
	GtkApplication parent_instance;
	CheeseApplicationPrivate * priv;
};

struct _CheeseApplicationClass {
	GtkApplicationClass parent_class;
};

struct _CheeseApplicationPrivate {
	GSettings* settings;
	guint inhibited;
	CheeseCamera* camera;
	CheesePreferencesDialog* preferences_dialog;
};


static gpointer cheese_application_parent_class = NULL;
static gchar* cheese_application_device;
static gchar* cheese_application_device = NULL;
static CheeseMainWindow* cheese_application_main_window;
static CheeseMainWindow* cheese_application_main_window = NULL;

GType cheese_application_get_type (void) G_GNUC_CONST;
GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CHEESE_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_APPLICATION, CheeseApplicationPrivate))
enum  {
	CHEESE_APPLICATION_DUMMY_PROPERTY
};
GType cheese_main_window_get_type (void) G_GNUC_CONST;
static void cheese_application_on_shoot (CheeseApplication* self);
static void _cheese_application_on_shoot_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_application_on_action_radio (CheeseApplication* self, GSimpleAction* action, GVariant* parameter);
static void _cheese_application_on_action_radio_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_application_on_mode_change (CheeseApplication* self, GSimpleAction* action, GVariant* value);
static void _cheese_application_on_mode_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void cheese_application_on_action_toggle (CheeseApplication* self, GSimpleAction* action, GVariant* parameter);
static void _cheese_application_on_action_toggle_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_application_on_fullscreen_change (CheeseApplication* self, GSimpleAction* action, GVariant* value);
static void _cheese_application_on_fullscreen_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void cheese_application_on_wide_mode_change (CheeseApplication* self, GSimpleAction* action, GVariant* value);
static void _cheese_application_on_wide_mode_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void cheese_application_on_effects_change (CheeseApplication* self, GSimpleAction* action, GVariant* value);
static void _cheese_application_on_effects_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self);
static void cheese_application_on_preferences (CheeseApplication* self);
static void _cheese_application_on_preferences_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_application_on_help (CheeseApplication* self);
static void _cheese_application_on_help_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_application_on_about (CheeseApplication* self);
static void _cheese_application_on_about_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void cheese_application_on_quit (CheeseApplication* self);
static void _cheese_application_on_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
CheeseApplication* cheese_application_new (void);
CheeseApplication* cheese_application_construct (GType object_type);
static void cheese_application_real_startup (GApplication* base);
static void cheese_application_common_init (CheeseApplication* self);
CheeseMainWindow* cheese_main_window_new (GtkApplication* application);
CheeseMainWindow* cheese_main_window_construct (GType object_type, GtkApplication* application);
void cheese_main_window_setup_ui (CheeseMainWindow* self);
void cheese_main_window_start_thumbview_monitors (CheeseMainWindow* self);
static gboolean cheese_application_on_webcam_key_pressed (CheeseApplication* self, GdkEventKey* event);
static gboolean _cheese_application_on_webcam_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void cheese_application_setup_camera (CheeseApplication* self);
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera);
static void cheese_application_on_preferences_enabled (CheeseApplication* self);
static void _cheese_application_on_preferences_enabled_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void cheese_application_real_activate (GApplication* base);
static gint cheese_application_real_command_line (GApplication* base, GApplicationCommandLine* cl);
static gint cheese_application_real_handle_local_options (GApplication* base, GVariantDict* opts);
ClutterActor* cheese_main_window_get_video_preview (CheeseMainWindow* self);
void cheese_main_window_show_error (CheeseMainWindow* self, const gchar* _error_);
static void cheese_application_on_camera_state_flags_changed (CheeseApplication* self, GstState new_state);
static void _cheese_application_on_camera_state_flags_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self);
void cheese_main_window_set_camera (CheeseMainWindow* self, CheeseCamera* camera);
void cheese_main_window_camera_state_change_playing (CheeseMainWindow* self);
void cheese_main_window_camera_state_change_null (CheeseMainWindow* self);
static void cheese_application_update_mode (CheeseApplication* self, CheeseMediaMode mode);
void cheese_main_window_set_current_mode (CheeseMainWindow* self, CheeseMediaMode mode);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
void cheese_main_window_shoot (CheeseMainWindow* self);
void cheese_main_window_set_fullscreen (CheeseMainWindow* self, gboolean fullscreen);
void cheese_main_window_set_wide_mode (CheeseMainWindow* self, gboolean wide_mode);
void cheese_main_window_set_effects (CheeseMainWindow* self, gboolean effects);
static void cheese_application_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry CHEESE_APPLICATION_action_entries[9] = {{"shoot", _cheese_application_on_shoot_gsimple_action_activate_callback}, {"mode", _cheese_application_on_action_radio_gsimple_action_activate_callback, "s", "'photo'", _cheese_application_on_mode_change_gsimple_action_change_state_callback}, {"fullscreen", _cheese_application_on_action_toggle_gsimple_action_activate_callback, NULL, "false", _cheese_application_on_fullscreen_change_gsimple_action_change_state_callback}, {"wide-mode", _cheese_application_on_action_toggle_gsimple_action_activate_callback, NULL, "false", _cheese_application_on_wide_mode_change_gsimple_action_change_state_callback}, {"effects", _cheese_application_on_action_toggle_gsimple_action_activate_callback, NULL, "false", _cheese_application_on_effects_change_gsimple_action_change_state_callback}, {"preferences", _cheese_application_on_preferences_gsimple_action_activate_callback}, {"help", _cheese_application_on_help_gsimple_action_activate_callback}, {"about", _cheese_application_on_about_gsimple_action_activate_callback}, {"quit", _cheese_application_on_quit_gsimple_action_activate_callback}};
static const GOptionEntry CHEESE_APPLICATION_options[5] = {{"wide", 'w', 0, G_OPTION_ARG_NONE, NULL, "Start in wide mode", NULL}, {"device", 'd', 0, G_OPTION_ARG_FILENAME, NULL, "Device to use as a camera", "DEVICE"}, {"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Output version information and exit", NULL}, {"fullscreen", 'f', 0, G_OPTION_ARG_NONE, NULL, "Start in fullscreen mode", NULL}, {NULL}};

static void _cheese_application_on_shoot_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_application_on_shoot ((CheeseApplication*) self);
}


static void _cheese_application_on_action_radio_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_application_on_action_radio ((CheeseApplication*) self, action, parameter);
}


static void _cheese_application_on_mode_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	cheese_application_on_mode_change ((CheeseApplication*) self, action, value);
}


static void _cheese_application_on_action_toggle_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_application_on_action_toggle ((CheeseApplication*) self, action, parameter);
}


static void _cheese_application_on_fullscreen_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	cheese_application_on_fullscreen_change ((CheeseApplication*) self, action, value);
}


static void _cheese_application_on_wide_mode_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	cheese_application_on_wide_mode_change ((CheeseApplication*) self, action, value);
}


static void _cheese_application_on_effects_change_gsimple_action_change_state_callback (GSimpleAction* action, GVariant* value, gpointer self) {
	cheese_application_on_effects_change ((CheeseApplication*) self, action, value);
}


static void _cheese_application_on_preferences_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_application_on_preferences ((CheeseApplication*) self);
}


static void _cheese_application_on_help_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_application_on_help ((CheeseApplication*) self);
}


static void _cheese_application_on_about_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_application_on_about ((CheeseApplication*) self);
}


static void _cheese_application_on_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	cheese_application_on_quit ((CheeseApplication*) self);
}


CheeseApplication* cheese_application_construct (GType object_type) {
	CheeseApplication * self = NULL;
	self = (CheeseApplication*) g_object_new (object_type, "application-id", "org.gnome.Cheese", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, CHEESE_APPLICATION_options);
	return self;
}


CheeseApplication* cheese_application_new (void) {
	return cheese_application_construct (CHEESE_TYPE_APPLICATION);
}


/**
     * Perform one-time initialization tasks.
     */
static void cheese_application_real_startup (GApplication* base) {
	CheeseApplication * self;
	GSettings* _tmp0_ = NULL;
	gchar** args = NULL;
	gchar** _tmp1_ = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	gchar** arguments = NULL;
	gint arguments_length1 = 0;
	gint _arguments_size_ = 0;
	gboolean _tmp2_ = FALSE;
	self = (CheeseApplication*) base;
	_tmp0_ = g_settings_new ("org.gnome.Cheese");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) self, CHEESE_APPLICATION_action_entries, G_N_ELEMENTS (CHEESE_APPLICATION_action_entries), self);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = NULL;
	args = _tmp1_;
	args_length1 = 1;
	_args_size_ = args_length1;
	arguments = args;
	arguments_length1 = args_length1;
	_arguments_size_ = arguments_length1;
	_tmp2_ = cheese_gtk_init (&arguments_length1, &arguments);
	if (!_tmp2_) {
		g_error ("cheese-application.vala:86: Unable to initialize libcheese-gtk");
	}
	G_APPLICATION_CLASS (cheese_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * Ensure that the main window has been shown, camera set up and so on.
     */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _cheese_application_on_webcam_key_pressed_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = cheese_application_on_webcam_key_pressed ((CheeseApplication*) self, event);
	return result;
}


static void _cheese_application_on_preferences_enabled_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	cheese_application_on_preferences_enabled ((CheeseApplication*) self);
}


static void cheese_application_common_init (CheeseApplication* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (_tmp0_ == NULL) {
		GtkSettings* gtk_settings = NULL;
		GtkSettings* _tmp1_ = NULL;
		GtkSettings* _tmp2_ = NULL;
		GtkSettings* _tmp3_ = NULL;
		CheeseMainWindow* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		CheeseMainWindow* _tmp7_ = NULL;
		CheeseMainWindow* _tmp8_ = NULL;
		CheeseMainWindow* _tmp9_ = NULL;
		CheeseMainWindow* _tmp10_ = NULL;
		CheeseMainWindow* _tmp11_ = NULL;
		CheeseCamera* _tmp12_ = NULL;
		CheesePreferencesDialog* _tmp13_ = NULL;
		GAction* preferences = NULL;
		GAction* _tmp14_ = NULL;
		GAction* _tmp15_ = NULL;
		GAction* _tmp16_ = NULL;
		CheeseMainWindow* _tmp17_ = NULL;
		_tmp1_ = gtk_settings_get_default ();
		_tmp2_ = _g_object_ref0 (_tmp1_);
		gtk_settings = _tmp2_;
		_tmp3_ = gtk_settings;
		if (_tmp3_ != NULL) {
			GtkSettings* _tmp4_ = NULL;
			_tmp4_ = gtk_settings;
			g_object_set (_tmp4_, "gtk-application-prefer-dark-theme", TRUE, NULL);
		}
		_tmp5_ = cheese_main_window_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (cheese_application_main_window);
		cheese_application_main_window = _tmp5_;
		g_setenv ("PULSE_PROP_media.role", "production", TRUE);
		_tmp6_ = _ ("Cheese");
		g_set_application_name (_tmp6_);
		gtk_window_set_default_icon_name ("org.gnome.Cheese");
		gtk_application_add_accelerator ((GtkApplication*) self, "space", "app.shoot", NULL);
		_tmp7_ = cheese_application_main_window;
		cheese_main_window_setup_ui (_tmp7_);
		_tmp8_ = cheese_application_main_window;
		cheese_main_window_start_thumbview_monitors (_tmp8_);
		_tmp9_ = cheese_application_main_window;
		gtk_widget_add_events ((GtkWidget*) _tmp9_, (gint) (GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK));
		_tmp10_ = cheese_application_main_window;
		g_signal_connect_object ((GtkWidget*) _tmp10_, "key-press-event", (GCallback) _cheese_application_on_webcam_key_pressed_gtk_widget_key_press_event, self, 0);
		_tmp11_ = cheese_application_main_window;
		gtk_widget_show ((GtkWidget*) _tmp11_);
		cheese_application_setup_camera (self);
		_tmp12_ = self->priv->camera;
		_tmp13_ = cheese_preferences_dialog_new (_tmp12_);
		g_object_ref_sink (_tmp13_);
		_g_object_unref0 (self->priv->preferences_dialog);
		self->priv->preferences_dialog = _tmp13_;
		_tmp14_ = g_action_map_lookup_action ((GActionMap*) self, "preferences");
		_tmp15_ = _g_object_ref0 (_tmp14_);
		preferences = _tmp15_;
		_tmp16_ = preferences;
		g_signal_connect_object ((GObject*) _tmp16_, "notify::enabled", (GCallback) _cheese_application_on_preferences_enabled_g_object_notify, self, 0);
		_tmp17_ = cheese_application_main_window;
		gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp17_);
		_g_object_unref0 (preferences);
		_g_object_unref0 (gtk_settings);
	}
}


/**
     * Present the existing main window, or create a new one.
     */
static void cheese_application_real_activate (GApplication* base) {
	CheeseApplication * self;
	GList* _tmp0_ = NULL;
	self = (CheeseApplication*) base;
	_tmp0_ = gtk_application_get_windows ((GtkApplication*) self);
	if (_tmp0_ != NULL) {
		CheeseMainWindow* _tmp1_ = NULL;
		_tmp1_ = cheese_application_main_window;
		gtk_window_present ((GtkWindow*) _tmp1_);
	} else {
		cheese_application_common_init (self);
	}
}


static gpointer _g_variant_dict_ref0 (gpointer self) {
	return self ? g_variant_dict_ref (self) : NULL;
}


static gint cheese_application_real_command_line (GApplication* base, GApplicationCommandLine* cl) {
	CheeseApplication * self;
	gint result = 0;
	GVariantDict* opts = NULL;
	GApplicationCommandLine* _tmp0_ = NULL;
	GVariantDict* _tmp1_ = NULL;
	GVariantDict* _tmp2_ = NULL;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GVariantDict* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GVariantDict* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	self = (CheeseApplication*) base;
	g_return_val_if_fail (cl != NULL, 0);
	_tmp0_ = cl;
	_tmp1_ = g_application_command_line_get_options_dict (_tmp0_);
	_tmp2_ = _g_variant_dict_ref0 (_tmp1_);
	opts = _tmp2_;
	_tmp3_ = opts;
	_tmp4_ = g_variant_dict_lookup (_tmp3_, "device", "^ay", &cheese_application_device, NULL, NULL);
	if (_tmp4_) {
		GSettings* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp5_ = self->priv->settings;
		_tmp6_ = cheese_application_device;
		g_settings_set_string (_tmp5_, "camera", _tmp6_);
	}
	_tmp7_ = opts;
	_tmp8_ = g_variant_dict_contains (_tmp7_, "fullscreen");
	if (_tmp8_) {
		g_action_group_activate_action ((GActionGroup*) self, "fullscreen", NULL);
	}
	_tmp9_ = opts;
	_tmp10_ = g_variant_dict_contains (_tmp9_, "wide");
	if (_tmp10_) {
		g_action_group_activate_action ((GActionGroup*) self, "wide-mode", NULL);
	}
	g_application_activate ((GApplication*) self);
	result = 0;
	_g_variant_dict_unref0 (opts);
	return result;
}


static gint cheese_application_real_handle_local_options (GApplication* base, GVariantDict* opts) {
	CheeseApplication * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (CheeseApplication*) base;
	g_return_val_if_fail (opts != NULL, 0);
	_tmp0_ = opts;
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
	if (_tmp1_) {
		FILE* _tmp2_ = NULL;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
		result = 0;
		return result;
	}
	result = -1;
	return result;
}


/**
     * Setup the camera listed in GSettings.
     */
static void _cheese_application_on_camera_state_flags_changed_cheese_camera_state_flags_changed (CheeseCamera* _sender, GstState new_state, gpointer self) {
	cheese_application_on_camera_state_flags_changed ((CheeseApplication*) self, new_state);
}


void cheese_application_setup_camera (CheeseApplication* self) {
	GSimpleAction* effects = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GSimpleAction* mode = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* shoot = NULL;
	GAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	ClutterActor* video_preview = NULL;
	CheeseMainWindow* _tmp9_ = NULL;
	ClutterActor* _tmp10_ = NULL;
	ClutterActor* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GSettings* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	CheeseCamera* _tmp17_ = NULL;
	gdouble value = 0.0;
	GSettings* _tmp26_ = NULL;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	GSettings* _tmp31_ = NULL;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	GSettings* _tmp36_ = NULL;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	GSettings* _tmp41_ = NULL;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	CheeseCamera* _tmp46_ = NULL;
	CheeseMainWindow* _tmp47_ = NULL;
	CheeseCamera* _tmp48_ = NULL;
	CheeseCamera* _tmp49_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "effects");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	effects = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "shoot");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp4_) : NULL);
	shoot = _tmp5_;
	_tmp6_ = effects;
	g_simple_action_set_enabled (_tmp6_, FALSE);
	_tmp7_ = mode;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = shoot;
	g_simple_action_set_enabled (_tmp8_, FALSE);
	_tmp9_ = cheese_application_main_window;
	_tmp10_ = cheese_main_window_get_video_preview (_tmp9_);
	video_preview = _tmp10_;
	_tmp11_ = video_preview;
	_tmp12_ = cheese_application_device;
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_int (_tmp13_, "photo-x-resolution");
	_tmp15_ = self->priv->settings;
	_tmp16_ = g_settings_get_int (_tmp15_, "photo-y-resolution");
	_tmp17_ = cheese_camera_new (_tmp11_, _tmp12_, _tmp14_, _tmp16_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp17_;
	{
		CheeseCamera* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		_tmp18_ = self->priv->camera;
		_tmp19_ = cheese_application_device;
		cheese_camera_setup (_tmp18_, _tmp19_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		ClutterActor* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		CheeseMainWindow* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = video_preview;
		clutter_actor_hide (_tmp20_);
		_tmp21_ = err;
		_tmp22_ = _tmp21_->message;
		g_message ("cheese-application.vala:211: Error during camera setup: %s\n", _tmp22_);
		_tmp23_ = cheese_application_main_window;
		_tmp24_ = err;
		_tmp25_ = _tmp24_->message;
		cheese_main_window_show_error (_tmp23_, _tmp25_);
		_g_error_free0 (err);
		_g_object_unref0 (video_preview);
		_g_object_unref0 (shoot);
		_g_object_unref0 (mode);
		_g_object_unref0 (effects);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (video_preview);
		_g_object_unref0 (shoot);
		_g_object_unref0 (mode);
		_g_object_unref0 (effects);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp26_ = self->priv->settings;
	_tmp27_ = g_settings_get_double (_tmp26_, "brightness");
	value = _tmp27_;
	_tmp28_ = value;
	if (_tmp28_ != 0.0) {
		CheeseCamera* _tmp29_ = NULL;
		gdouble _tmp30_ = 0.0;
		_tmp29_ = self->priv->camera;
		_tmp30_ = value;
		cheese_camera_set_balance_property (_tmp29_, "brightness", _tmp30_);
	}
	_tmp31_ = self->priv->settings;
	_tmp32_ = g_settings_get_double (_tmp31_, "contrast");
	value = _tmp32_;
	_tmp33_ = value;
	if (_tmp33_ != 1.0) {
		CheeseCamera* _tmp34_ = NULL;
		gdouble _tmp35_ = 0.0;
		_tmp34_ = self->priv->camera;
		_tmp35_ = value;
		cheese_camera_set_balance_property (_tmp34_, "contrast", _tmp35_);
	}
	_tmp36_ = self->priv->settings;
	_tmp37_ = g_settings_get_double (_tmp36_, "hue");
	value = _tmp37_;
	_tmp38_ = value;
	if (_tmp38_ != 0.0) {
		CheeseCamera* _tmp39_ = NULL;
		gdouble _tmp40_ = 0.0;
		_tmp39_ = self->priv->camera;
		_tmp40_ = value;
		cheese_camera_set_balance_property (_tmp39_, "hue", _tmp40_);
	}
	_tmp41_ = self->priv->settings;
	_tmp42_ = g_settings_get_double (_tmp41_, "saturation");
	value = _tmp42_;
	_tmp43_ = value;
	if (_tmp43_ != 1.0) {
		CheeseCamera* _tmp44_ = NULL;
		gdouble _tmp45_ = 0.0;
		_tmp44_ = self->priv->camera;
		_tmp45_ = value;
		cheese_camera_set_balance_property (_tmp44_, "saturation", _tmp45_);
	}
	_tmp46_ = self->priv->camera;
	g_signal_connect_object (_tmp46_, "state-flags-changed", (GCallback) _cheese_application_on_camera_state_flags_changed_cheese_camera_state_flags_changed, self, 0);
	_tmp47_ = cheese_application_main_window;
	_tmp48_ = self->priv->camera;
	cheese_main_window_set_camera (_tmp47_, _tmp48_);
	_tmp49_ = self->priv->camera;
	cheese_camera_play (_tmp49_);
	_g_object_unref0 (video_preview);
	_g_object_unref0 (shoot);
	_g_object_unref0 (mode);
	_g_object_unref0 (effects);
}


/**
     * Handle the webcam take photo button being pressed.
     *
     * @param event the Gdk.KeyEvent
     * @return true to stop other handlers being invoked, false to propagate
     * the event further
     */
static gboolean cheese_application_on_webcam_key_pressed (CheeseApplication* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventKey* _tmp1_ = NULL;
	GdkModifierType _tmp2_ = 0;
	GdkEventKey* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->state;
	if (_tmp2_ != 0) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GdkEventKey* _tmp7_ = NULL;
		GdkModifierType _tmp8_ = 0;
		_tmp7_ = event;
		_tmp8_ = _tmp7_->state;
		if ((_tmp8_ & GDK_CONTROL_MASK) != 0) {
			_tmp6_ = TRUE;
		} else {
			GdkEventKey* _tmp9_ = NULL;
			GdkModifierType _tmp10_ = 0;
			_tmp9_ = event;
			_tmp10_ = _tmp9_->state;
			_tmp6_ = (_tmp10_ & GDK_MOD1_MASK) != 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			GdkEventKey* _tmp11_ = NULL;
			GdkModifierType _tmp12_ = 0;
			_tmp11_ = event;
			_tmp12_ = _tmp11_->state;
			_tmp5_ = (_tmp12_ & GDK_MOD3_MASK) != 0;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			GdkEventKey* _tmp13_ = NULL;
			GdkModifierType _tmp14_ = 0;
			_tmp13_ = event;
			_tmp14_ = _tmp13_->state;
			_tmp4_ = (_tmp14_ & GDK_MOD4_MASK) != 0;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			GdkEventKey* _tmp15_ = NULL;
			GdkModifierType _tmp16_ = 0;
			_tmp15_ = event;
			_tmp16_ = _tmp15_->state;
			_tmp3_ = (_tmp16_ & GDK_MOD5_MASK) != 0;
		}
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp17_ = event;
	_tmp18_ = _tmp17_->keyval;
	switch (_tmp18_) {
		case GDK_KEY_WebCam:
		{
			g_action_group_activate_action ((GActionGroup*) self, "shoot", NULL);
			result = TRUE;
			return result;
		}
		default:
		break;
	}
	result = FALSE;
	return result;
}


/**
     * Handle the camera state changing.
     *
     * @param new_state the new Cheese.Camera state
     */
static void cheese_application_on_camera_state_flags_changed (CheeseApplication* self, GstState new_state) {
	GSimpleAction* effects = NULL;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	GSimpleAction* mode = NULL;
	GAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GSimpleAction* shoot = NULL;
	GAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GstState _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "effects");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	effects = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	mode = _tmp3_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "shoot");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp4_) : NULL);
	shoot = _tmp5_;
	_tmp6_ = new_state;
	switch (_tmp6_) {
		case GST_STATE_PLAYING:
		{
			GSimpleAction* _tmp7_ = NULL;
			GVariant* _tmp8_ = NULL;
			GVariant* _tmp9_ = NULL;
			GVariant* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			GSimpleAction* _tmp17_ = NULL;
			CheeseMainWindow* _tmp18_ = NULL;
			CheeseMainWindow* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			guint _tmp21_ = 0U;
			_tmp7_ = effects;
			_tmp8_ = g_action_get_state ((GAction*) _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = g_variant_get_boolean (_tmp10_);
			_tmp12_ = _tmp11_;
			_g_variant_unref0 (_tmp10_);
			if (_tmp12_) {
				GSimpleAction* _tmp13_ = NULL;
				GSimpleAction* _tmp14_ = NULL;
				_tmp13_ = mode;
				g_simple_action_set_enabled (_tmp13_, FALSE);
				_tmp14_ = shoot;
				g_simple_action_set_enabled (_tmp14_, FALSE);
			} else {
				GSimpleAction* _tmp15_ = NULL;
				GSimpleAction* _tmp16_ = NULL;
				_tmp15_ = mode;
				g_simple_action_set_enabled (_tmp15_, TRUE);
				_tmp16_ = shoot;
				g_simple_action_set_enabled (_tmp16_, TRUE);
			}
			_tmp17_ = effects;
			g_simple_action_set_enabled (_tmp17_, TRUE);
			_tmp18_ = cheese_application_main_window;
			cheese_main_window_camera_state_change_playing (_tmp18_);
			_tmp19_ = cheese_application_main_window;
			_tmp20_ = _ ("Webcam in use");
			_tmp21_ = gtk_application_inhibit ((GtkApplication*) self, (GtkWindow*) _tmp19_, GTK_APPLICATION_INHIBIT_SWITCH | GTK_APPLICATION_INHIBIT_IDLE, _tmp20_);
			self->priv->inhibited = _tmp21_;
			break;
		}
		case GST_STATE_NULL:
		{
			GSimpleAction* _tmp22_ = NULL;
			GSimpleAction* _tmp23_ = NULL;
			GSimpleAction* _tmp24_ = NULL;
			CheeseMainWindow* _tmp25_ = NULL;
			guint _tmp26_ = 0U;
			_tmp22_ = effects;
			g_simple_action_set_enabled (_tmp22_, FALSE);
			_tmp23_ = mode;
			g_simple_action_set_enabled (_tmp23_, FALSE);
			_tmp24_ = shoot;
			g_simple_action_set_enabled (_tmp24_, FALSE);
			_tmp25_ = cheese_application_main_window;
			cheese_main_window_camera_state_change_null (_tmp25_);
			_tmp26_ = self->priv->inhibited;
			if (_tmp26_ != ((guint) 0)) {
				guint _tmp27_ = 0U;
				_tmp27_ = self->priv->inhibited;
				gtk_application_uninhibit ((GtkApplication*) self, _tmp27_);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_g_object_unref0 (shoot);
	_g_object_unref0 (mode);
	_g_object_unref0 (effects);
}


/**
     * Update the current capture mode in the main window and preferences
     * dialog.
     *
     * @param mode the mode to set
     */
static void cheese_application_update_mode (CheeseApplication* self, CheeseMediaMode mode) {
	CheeseMainWindow* _tmp0_ = NULL;
	CheeseMediaMode _tmp1_ = 0;
	CheesePreferencesDialog* _tmp2_ = NULL;
	CheeseMediaMode _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_application_main_window;
	_tmp1_ = mode;
	cheese_main_window_set_current_mode (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->preferences_dialog;
	_tmp3_ = mode;
	cheese_preferences_dialog_set_current_mode (_tmp2_, _tmp3_);
}


/**
     * Handle radio actions by setting the new state.
     *
     * @param action the action which was triggered
     * @param parameter the new value to set on the action
     */
static void cheese_application_on_action_radio (CheeseApplication* self, GSimpleAction* action, GVariant* parameter) {
	GSimpleAction* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = parameter;
	g_signal_emit_by_name (_tmp0_, "change-state", _tmp1_);
}


/**
     * Handle toggle actions by toggling the current state.
     *
     * @param action the action which was triggered
     * @param parameter unused
     */
static void cheese_application_on_action_toggle (CheeseApplication* self, GSimpleAction* action, GVariant* parameter) {
	GVariant* state = NULL;
	GSimpleAction* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = action;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	state = _tmp1_;
	_tmp2_ = action;
	_tmp3_ = g_variant_get_boolean (state);
	_tmp4_ = g_variant_new_boolean (!_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_signal_emit_by_name (_tmp2_, "change-state", _tmp5_);
	_g_variant_unref0 (_tmp5_);
	_g_variant_unref0 (state);
}


/**
     * Handle the shoot action being activated.
     */
static void cheese_application_on_shoot (CheeseApplication* self) {
	CheeseMainWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_application_main_window;
	cheese_main_window_shoot (_tmp0_);
}


/**
     * Handle the fullscreen state being changed.
     *
     * @param action the action that emitted the signal
     * @param value the state to switch to
     */
static void cheese_application_on_fullscreen_change (CheeseApplication* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	gboolean state = FALSE;
	GVariant* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	CheeseMainWindow* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = value;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = value;
	_tmp2_ = g_variant_get_boolean (_tmp1_);
	state = _tmp2_;
	cheese_application_common_init (self);
	_tmp3_ = cheese_application_main_window;
	cheese_main_window_set_fullscreen (_tmp3_, state);
	_tmp4_ = action;
	_tmp5_ = value;
	g_simple_action_set_state (_tmp4_, _tmp5_);
}


/**
     * Handle the wide-mode state being changed.
     *
     * @param action the action that emitted the signal
     * @param value the state to switch to
     */
static void cheese_application_on_wide_mode_change (CheeseApplication* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	gboolean state = FALSE;
	GVariant* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	CheeseMainWindow* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = value;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = value;
	_tmp2_ = g_variant_get_boolean (_tmp1_);
	state = _tmp2_;
	cheese_application_common_init (self);
	_tmp3_ = cheese_application_main_window;
	cheese_main_window_set_wide_mode (_tmp3_, state);
	_tmp4_ = action;
	_tmp5_ = value;
	g_simple_action_set_state (_tmp4_, _tmp5_);
}


/**
     * Handle the effects state being changed.
     *
     * @param action the action that emitted the signal
     * @param value the state to switch to
     */
static void cheese_application_on_effects_change (CheeseApplication* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	gboolean state = FALSE;
	GVariant* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* shoot = NULL;
	GAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GSimpleAction* mode = NULL;
	GAction* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	CheeseMainWindow* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = value;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = value;
	_tmp2_ = g_variant_get_boolean (_tmp1_);
	state = _tmp2_;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) self, "shoot");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp3_) : NULL);
	shoot = _tmp4_;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) self, "mode");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp5_) : NULL);
	mode = _tmp6_;
	g_simple_action_set_enabled (shoot, !state);
	g_simple_action_set_enabled (mode, !state);
	_tmp7_ = cheese_application_main_window;
	cheese_main_window_set_effects (_tmp7_, state);
	_tmp8_ = action;
	_tmp9_ = value;
	g_simple_action_set_state (_tmp8_, _tmp9_);
	_g_object_unref0 (mode);
	_g_object_unref0 (shoot);
}


/**
     * Change the media capture mode (photo, video or burst).
     *
     * @param action the action that emitted the signal
     * @param parameter the mode to switch to, or null
     */
static void cheese_application_on_mode_change (CheeseApplication* self, GSimpleAction* action, GVariant* value) {
	GVariant* _tmp0_ = NULL;
	gchar* state = NULL;
	GVariant* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GSimpleAction* _tmp7_ = NULL;
	GVariant* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = value;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = value;
	_tmp2_ = g_variant_get_string (_tmp1_, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	state = _tmp3_;
	_tmp4_ = state;
	if (g_strcmp0 (_tmp4_, "photo") == 0) {
		cheese_application_update_mode (self, CHEESE_MEDIA_MODE_PHOTO);
	} else {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = state;
		if (g_strcmp0 (_tmp5_, "video") == 0) {
			cheese_application_update_mode (self, CHEESE_MEDIA_MODE_VIDEO);
		} else {
			const gchar* _tmp6_ = NULL;
			_tmp6_ = state;
			if (g_strcmp0 (_tmp6_, "burst") == 0) {
				cheese_application_update_mode (self, CHEESE_MEDIA_MODE_BURST);
			} else {
				g_assert_not_reached ();
			}
		}
	}
	_tmp7_ = action;
	_tmp8_ = value;
	g_simple_action_set_state (_tmp7_, _tmp8_);
	_g_free0 (state);
}


/**
     * Show the preferences dialog.
     */
static void cheese_application_on_preferences (CheeseApplication* self) {
	CheesePreferencesDialog* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_dialog;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}


/**
     * Show the Cheese help contents.
     */
static void cheese_application_on_help (CheeseApplication* self) {
	GdkScreen* screen = NULL;
	CheeseMainWindow* _tmp0_ = NULL;
	GdkScreen* _tmp1_ = NULL;
	GdkScreen* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_application_main_window;
	_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	screen = _tmp2_;
	{
		guint32 _tmp3_ = 0U;
		_tmp3_ = gtk_get_current_event_time ();
		gtk_show_uri (screen, "help:cheese", _tmp3_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_message ("cheese-application.vala:484: Error opening help: %s", _tmp5_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (screen);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (screen);
}


/**
     * Show the about dialog.
     */
static void cheese_application_on_about (CheeseApplication* self) {
	gchar** artists = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar** _tmp6_ = NULL;
	gint artists_length1 = 0;
	gint _artists_size_ = 0;
	gchar** authors = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	gchar** _tmp34_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar** _tmp38_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	CheeseMainWindow* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Andreas Nilsson <andreas@andreasn.se>");
	_tmp1_ = g_strdup ("Josef Vybíral <josef.vybiral@gmail.com>");
	_tmp2_ = g_strdup ("Kalle Persson <kalle@kallepersson.se>");
	_tmp3_ = g_strdup ("Lapo Calamandrei <calamandrei@gmail.com>");
	_tmp4_ = g_strdup ("Or Dvory <gnudles@nana.co.il>");
	_tmp5_ = g_strdup ("Ulisse Perusin <ulisail@yahoo.it>");
	_tmp6_ = g_new0 (gchar*, 7 + 1);
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	_tmp6_[6] = NULL;
	artists = _tmp6_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp7_ = g_strdup ("daniel g. siegel <dgsiegel@gnome.org>");
	_tmp8_ = g_strdup ("Jaap A. Haitsma <jaap@haitsma.org>");
	_tmp9_ = g_strdup ("Filippo Argiolas <fargiolas@gnome.org>");
	_tmp10_ = g_strdup ("Yuvaraj Pandian T <yuvipanda@yuvi.in>");
	_tmp11_ = g_strdup ("Luciana Fujii Pontello <luciana@fujii.eti.br>");
	_tmp12_ = g_strdup ("David King <amigadave@amigadave.com>");
	_tmp13_ = g_strdup ("");
	_tmp14_ = g_strdup ("Aidan Delaney <a.j.delaney@brighton.ac.uk>");
	_tmp15_ = g_strdup ("Alex \"weej\" Jones <alex@weej.com>");
	_tmp16_ = g_strdup ("Andrea Cimitan <andrea.cimitan@gmail.com>");
	_tmp17_ = g_strdup ("Baptiste Mille-Mathias <bmm80@free.fr>");
	_tmp18_ = g_strdup ("Cosimo Cecchi <anarki@lilik.it>");
	_tmp19_ = g_strdup ("Diego Escalante Urrelo <dieguito@gmail.com>");
	_tmp20_ = g_strdup ("Felix Kaser <f.kaser@gmx.net>");
	_tmp21_ = g_strdup ("Gintautas Miliauskas <gintas@akl.lt>");
	_tmp22_ = g_strdup ("Hans de Goede <jwrdegoede@fedoraproject.org>");
	_tmp23_ = g_strdup ("James Liggett <jrliggett@cox.net>");
	_tmp24_ = g_strdup ("Luca Ferretti <elle.uca@libero.it>");
	_tmp25_ = g_strdup ("Mirco \"MacSlow\" Müller <macslow@bangang.de>");
	_tmp26_ = g_strdup ("Patryk Zawadzki <patrys@pld-linux.org>");
	_tmp27_ = g_strdup ("Ryan Zeigler <zeiglerr@gmail.com>");
	_tmp28_ = g_strdup ("Sebastian Keller <sebastian-keller@gmx.de>");
	_tmp29_ = g_strdup ("Steve Magoun <steve.magoun@canonical.com>");
	_tmp30_ = g_strdup ("Thomas Perl <thp@thpinfo.com>");
	_tmp31_ = g_strdup ("Tim Philipp Müller <tim@centricular.net>");
	_tmp32_ = g_strdup ("Todd Eisenberger <teisenberger@gmail.com>");
	_tmp33_ = g_strdup ("Tommi Vainikainen <thv@iki.fi>");
	_tmp34_ = g_new0 (gchar*, 28 + 1);
	_tmp34_[0] = _tmp7_;
	_tmp34_[1] = _tmp8_;
	_tmp34_[2] = _tmp9_;
	_tmp34_[3] = _tmp10_;
	_tmp34_[4] = _tmp11_;
	_tmp34_[5] = _tmp12_;
	_tmp34_[6] = _tmp13_;
	_tmp34_[7] = _tmp14_;
	_tmp34_[8] = _tmp15_;
	_tmp34_[9] = _tmp16_;
	_tmp34_[10] = _tmp17_;
	_tmp34_[11] = _tmp18_;
	_tmp34_[12] = _tmp19_;
	_tmp34_[13] = _tmp20_;
	_tmp34_[14] = _tmp21_;
	_tmp34_[15] = _tmp22_;
	_tmp34_[16] = _tmp23_;
	_tmp34_[17] = _tmp24_;
	_tmp34_[18] = _tmp25_;
	_tmp34_[19] = _tmp26_;
	_tmp34_[20] = _tmp27_;
	_tmp34_[21] = _tmp28_;
	_tmp34_[22] = _tmp29_;
	_tmp34_[23] = _tmp30_;
	_tmp34_[24] = _tmp31_;
	_tmp34_[25] = _tmp32_;
	_tmp34_[26] = _tmp33_;
	_tmp34_[27] = NULL;
	authors = _tmp34_;
	authors_length1 = 28;
	_authors_size_ = authors_length1;
	_tmp35_ = g_strdup ("Joshua Henderson <joshhendo@gmail.com>");
	_tmp36_ = g_strdup ("Jaap A. Haitsma <jaap@haitsma.org>");
	_tmp37_ = g_strdup ("Felix Kaser <f.kaser@gmx.net>");
	_tmp38_ = g_new0 (gchar*, 4 + 1);
	_tmp38_[0] = _tmp35_;
	_tmp38_[1] = _tmp36_;
	_tmp38_[2] = _tmp37_;
	_tmp38_[3] = NULL;
	documenters = _tmp38_;
	documenters_length1 = 4;
	_documenters_size_ = documenters_length1;
	_tmp39_ = cheese_application_main_window;
	_tmp40_ = _ ("Take photos and videos with your webcam, with fun graphical effects");
	_tmp41_ = _ ("Cheese");
	_tmp42_ = _ ("translator-credits");
	_tmp43_ = _ ("Cheese Website");
	gtk_show_about_dialog ((GtkWindow*) _tmp39_, "artists", artists, "authors", authors, "comments", _tmp40_, "copyright", "Copyright © 2011 - 2014 David King <amigadave@amigadave.com>\n" \
"Copyright © 2007 - 2011 daniel g. siegel <dgsiegel@gnome.org>", "documenters", documenters, "license-type", GTK_LICENSE_GPL_2_0, "logo-icon-name", "org.gnome.Cheese", "program-name", _tmp41_, "translator-credits", _tmp42_, "website", PACKAGE_URL, "website-label", _tmp43_, "version", PACKAGE_VERSION, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
}


/**
     * Destroy the main window, and shutdown the application, when quitting.
     */
static void cheese_application_on_quit (CheeseApplication* self) {
	CheeseMainWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = cheese_application_main_window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


/**
     * Close the preferences dialog when the preferences action is disabled.
     */
static void cheese_application_on_preferences_enabled (CheeseApplication* self) {
	GAction* preferences = NULL;
	GAction* _tmp0_ = NULL;
	GAction* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "preferences");
	_tmp1_ = _g_object_ref0 (_tmp0_);
	preferences = _tmp1_;
	_tmp2_ = preferences;
	_tmp3_ = g_action_get_enabled (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		CheesePreferencesDialog* _tmp5_ = NULL;
		_tmp5_ = self->priv->preferences_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
	_g_object_unref0 (preferences);
}


static void cheese_application_class_init (CheeseApplicationClass * klass) {
	cheese_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheeseApplicationPrivate));
	((GApplicationClass *) klass)->startup = cheese_application_real_startup;
	((GApplicationClass *) klass)->activate = cheese_application_real_activate;
	((GApplicationClass *) klass)->command_line = cheese_application_real_command_line;
	((GApplicationClass *) klass)->handle_local_options = cheese_application_real_handle_local_options;
	G_OBJECT_CLASS (klass)->finalize = cheese_application_finalize;
}


static void cheese_application_instance_init (CheeseApplication * self) {
	self->priv = CHEESE_APPLICATION_GET_PRIVATE (self);
	self->priv->inhibited = (guint) 0;
}


static void cheese_application_finalize (GObject* obj) {
	CheeseApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CHEESE_TYPE_APPLICATION, CheeseApplication);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->preferences_dialog);
	G_OBJECT_CLASS (cheese_application_parent_class)->finalize (obj);
}


GType cheese_application_get_type (void) {
	static volatile gsize cheese_application_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheeseApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheeseApplication), 0, (GInstanceInitFunc) cheese_application_instance_init, NULL };
		GType cheese_application_type_id;
		cheese_application_type_id = g_type_register_static (gtk_application_get_type (), "CheeseApplication", &g_define_type_info, 0);
		g_once_init_leave (&cheese_application_type_id__volatile, cheese_application_type_id);
	}
	return cheese_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



