/* cheese-preferences.c generated by valac 0.14.0, the Vala compiler
 * generated from cheese-preferences.vala, do not modify */

/*
 * Copyright © 2010 Yuvaraj Pandian T <yuvipanda@yuvi.in>
 * Copyright © 2010 daniel g. siegel <dgsiegel@gnome.org>
 * Copyright © 2008 Filippo Argiolas <filippo.argiolas@gmail.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <cheese-camera.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <cheese-fileutil.h>
#include <cheese-config.h>
#include <float.h>
#include <math.h>
#include <cheese-camera-device.h>
#include <stdlib.h>
#include <string.h>


#define CHEESE_TYPE_PREFERENCES_DIALOG (cheese_preferences_dialog_get_type ())
#define CHEESE_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialog))
#define CHEESE_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))
#define CHEESE_IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CHEESE_TYPE_PREFERENCES_DIALOG))
#define CHEESE_PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogClass))

typedef struct _CheesePreferencesDialog CheesePreferencesDialog;
typedef struct _CheesePreferencesDialogClass CheesePreferencesDialogClass;
typedef struct _CheesePreferencesDialogPrivate CheesePreferencesDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CheesePreferencesDialog {
	GObject parent_instance;
	CheesePreferencesDialogPrivate * priv;
};

struct _CheesePreferencesDialogClass {
	GObjectClass parent_class;
};

struct _CheesePreferencesDialogPrivate {
	CheeseCamera* camera;
	GSettings* settings;
	GtkDialog* dialog;
	GtkComboBox* photo_resolution_combo;
	GtkComboBox* video_resolution_combo;
	GtkComboBox* source_combo;
	GtkAdjustment* brightness_adjustment;
	GtkAdjustment* contrast_adjustment;
	GtkAdjustment* hue_adjustment;
	GtkAdjustment* saturation_adjustment;
	GtkScale* brightness_scale;
	GtkScale* contrast_scale;
	GtkScale* hue_scale;
	GtkScale* saturation_scale;
	GtkSpinButton* burst_repeat_spin;
	GtkSpinButton* burst_delay_spin;
	GtkCheckButton* countdown_check;
	GtkCheckButton* flash_check;
	CheeseMediaMode current_mode;
};


static gpointer cheese_preferences_dialog_parent_class = NULL;

GType cheese_preferences_dialog_get_type (void) G_GNUC_CONST;
#define CHEESE_PREFERENCES_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CHEESE_TYPE_PREFERENCES_DIALOG, CheesePreferencesDialogPrivate))
enum  {
	CHEESE_PREFERENCES_DIALOG_DUMMY_PROPERTY
};
CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings);
CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings);
static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self);
static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device);
void cheese_preferences_dialog_on_source_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_photo_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_video_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_delete (GtkDialog* dialog, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_dialog_close (GtkButton* button, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_countdown_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_flash_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_burst_repeat_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_burst_delay_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_brightness_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_contrast_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_hue_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_on_saturation_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self);
void cheese_preferences_dialog_show (CheesePreferencesDialog* self);
void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode);
static void cheese_preferences_dialog_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CheesePreferencesDialog* cheese_preferences_dialog_construct (GType object_type, CheeseCamera* camera, GSettings* settings) {
	CheesePreferencesDialog * self = NULL;
	CheeseCamera* _tmp0_;
	CheeseCamera* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GtkBuilder* _tmp4_;
	GtkBuilder* builder;
	GObject* _tmp8_ = NULL;
	GtkDialog* _tmp9_;
	GObject* _tmp10_ = NULL;
	GtkAdjustment* _tmp11_;
	GObject* _tmp12_ = NULL;
	GtkAdjustment* _tmp13_;
	GObject* _tmp14_ = NULL;
	GtkAdjustment* _tmp15_;
	GObject* _tmp16_ = NULL;
	GtkAdjustment* _tmp17_;
	GObject* _tmp18_ = NULL;
	GtkScale* _tmp19_;
	GObject* _tmp20_ = NULL;
	GtkScale* _tmp21_;
	GObject* _tmp22_ = NULL;
	GtkScale* _tmp23_;
	GObject* _tmp24_ = NULL;
	GtkScale* _tmp25_;
	GtkScale* _tmp26_;
	GtkScale* _tmp27_;
	GtkScale* _tmp28_;
	GtkScale* _tmp29_;
	GObject* _tmp30_ = NULL;
	GtkComboBox* _tmp31_;
	GObject* _tmp32_ = NULL;
	GtkComboBox* _tmp33_;
	GObject* _tmp34_ = NULL;
	GtkComboBox* _tmp35_;
	GObject* _tmp36_ = NULL;
	GtkSpinButton* _tmp37_;
	GObject* _tmp38_ = NULL;
	GtkSpinButton* _tmp39_;
	GObject* _tmp40_ = NULL;
	GtkCheckButton* _tmp41_;
	GObject* _tmp42_ = NULL;
	GtkCheckButton* _tmp43_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (camera != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (CheesePreferencesDialog*) g_object_new (object_type, NULL);
	_tmp0_ = camera;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->camera);
	self->priv->camera = _tmp1_;
	_tmp2_ = settings;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = gtk_builder_new ();
	builder = _tmp4_;
	{
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = g_build_filename (PACKAGE_DATADIR, "cheese-prefs.ui", NULL);
		_tmp6_ = _tmp5_;
		gtk_builder_add_from_file (builder, _tmp6_, &_inner_error_);
		_g_free0 (_tmp6_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp7_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = err->message;
		g_error ("cheese-preferences.vala:66: Error: %s", _tmp7_);
		_g_error_free0 (err);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = gtk_builder_get_object (builder, "cheese_prefs_dialog");
	_tmp9_ = _g_object_ref0 (GTK_DIALOG (_tmp8_));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp9_;
	_tmp10_ = gtk_builder_get_object (builder, "brightness_adjustment");
	_tmp11_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp10_));
	_g_object_unref0 (self->priv->brightness_adjustment);
	self->priv->brightness_adjustment = _tmp11_;
	_tmp12_ = gtk_builder_get_object (builder, "contrast_adjustment");
	_tmp13_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp12_));
	_g_object_unref0 (self->priv->contrast_adjustment);
	self->priv->contrast_adjustment = _tmp13_;
	_tmp14_ = gtk_builder_get_object (builder, "hue_adjustment");
	_tmp15_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp14_));
	_g_object_unref0 (self->priv->hue_adjustment);
	self->priv->hue_adjustment = _tmp15_;
	_tmp16_ = gtk_builder_get_object (builder, "saturation_adjustment");
	_tmp17_ = _g_object_ref0 (GTK_ADJUSTMENT (_tmp16_));
	_g_object_unref0 (self->priv->saturation_adjustment);
	self->priv->saturation_adjustment = _tmp17_;
	_tmp18_ = gtk_builder_get_object (builder, "brightness_scale");
	_tmp19_ = _g_object_ref0 (GTK_SCALE (_tmp18_));
	_g_object_unref0 (self->priv->brightness_scale);
	self->priv->brightness_scale = _tmp19_;
	_tmp20_ = gtk_builder_get_object (builder, "contrast_scale");
	_tmp21_ = _g_object_ref0 (GTK_SCALE (_tmp20_));
	_g_object_unref0 (self->priv->contrast_scale);
	self->priv->contrast_scale = _tmp21_;
	_tmp22_ = gtk_builder_get_object (builder, "hue_scale");
	_tmp23_ = _g_object_ref0 (GTK_SCALE (_tmp22_));
	_g_object_unref0 (self->priv->hue_scale);
	self->priv->hue_scale = _tmp23_;
	_tmp24_ = gtk_builder_get_object (builder, "saturation_scale");
	_tmp25_ = _g_object_ref0 (GTK_SCALE (_tmp24_));
	_g_object_unref0 (self->priv->saturation_scale);
	self->priv->saturation_scale = _tmp25_;
	_tmp26_ = self->priv->brightness_scale;
	gtk_scale_add_mark (_tmp26_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp27_ = self->priv->contrast_scale;
	gtk_scale_add_mark (_tmp27_, (gdouble) 1, GTK_POS_BOTTOM, NULL);
	_tmp28_ = self->priv->hue_scale;
	gtk_scale_add_mark (_tmp28_, (gdouble) 0, GTK_POS_BOTTOM, NULL);
	_tmp29_ = self->priv->saturation_scale;
	gtk_scale_add_mark (_tmp29_, (gdouble) 1, GTK_POS_BOTTOM, NULL);
	_tmp30_ = gtk_builder_get_object (builder, "photo_resolution_combo_box");
	_tmp31_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp30_));
	_g_object_unref0 (self->priv->photo_resolution_combo);
	self->priv->photo_resolution_combo = _tmp31_;
	_tmp32_ = gtk_builder_get_object (builder, "video_resolution_combo_box");
	_tmp33_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp32_));
	_g_object_unref0 (self->priv->video_resolution_combo);
	self->priv->video_resolution_combo = _tmp33_;
	_tmp34_ = gtk_builder_get_object (builder, "camera_combo_box");
	_tmp35_ = _g_object_ref0 (GTK_COMBO_BOX (_tmp34_));
	_g_object_unref0 (self->priv->source_combo);
	self->priv->source_combo = _tmp35_;
	_tmp36_ = gtk_builder_get_object (builder, "burst_repeat");
	_tmp37_ = _g_object_ref0 (GTK_SPIN_BUTTON (_tmp36_));
	_g_object_unref0 (self->priv->burst_repeat_spin);
	self->priv->burst_repeat_spin = _tmp37_;
	_tmp38_ = gtk_builder_get_object (builder, "burst_delay");
	_tmp39_ = _g_object_ref0 (GTK_SPIN_BUTTON (_tmp38_));
	_g_object_unref0 (self->priv->burst_delay_spin);
	self->priv->burst_delay_spin = _tmp39_;
	_tmp40_ = gtk_builder_get_object (builder, "countdown");
	_tmp41_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp40_));
	_g_object_unref0 (self->priv->countdown_check);
	self->priv->countdown_check = _tmp41_;
	_tmp42_ = gtk_builder_get_object (builder, "flash");
	_tmp43_ = _g_object_ref0 (GTK_CHECK_BUTTON (_tmp42_));
	_g_object_unref0 (self->priv->flash_check);
	self->priv->flash_check = _tmp43_;
	cheese_preferences_dialog_setup_combo_box_models (self);
	cheese_preferences_dialog_initialize_camera_devices (self);
	cheese_preferences_dialog_initialize_values_from_settings (self);
	gtk_builder_connect_signals (builder, self);
	_g_object_unref0 (builder);
	return self;
}


CheesePreferencesDialog* cheese_preferences_dialog_new (CheeseCamera* camera, GSettings* settings) {
	return cheese_preferences_dialog_construct (CHEESE_TYPE_PREFERENCES_DIALOG, camera, settings);
}


static void cheese_preferences_dialog_setup_combo_box_models (CheesePreferencesDialog* self) {
	GtkCellRendererText* _tmp0_;
	GtkCellRendererText* _tmp1_;
	GtkCellRendererText* cell;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkComboBox* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp1_ = g_object_ref_sink (_tmp0_);
	cell = _tmp1_;
	_tmp2_ = self->priv->photo_resolution_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp2_, (GtkCellRenderer*) cell, FALSE);
	_tmp3_ = self->priv->photo_resolution_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp3_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_tmp4_ = self->priv->video_resolution_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp4_, (GtkCellRenderer*) cell, FALSE);
	_tmp5_ = self->priv->video_resolution_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp5_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_tmp6_ = self->priv->source_combo;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) cell, FALSE);
	_tmp7_ = self->priv->source_combo;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp7_, (GtkCellRenderer*) cell, "text", 0, NULL);
	_g_object_unref0 (cell);
}


static void cheese_preferences_dialog_initialize_camera_devices (CheesePreferencesDialog* self) {
	CheeseCameraDevice* dev = NULL;
	CheeseCamera* _tmp0_;
	GPtrArray* _tmp1_ = NULL;
	GPtrArray* devices;
	GtkListStore* _tmp2_;
	GtkListStore* camera_model;
	GtkComboBox* _tmp3_;
	GtkListStore* _tmp4_;
	GPtrArray* _tmp5_;
	guint _tmp6_;
	GSettings* _tmp40_;
	CheeseCamera* _tmp41_;
	CheeseCameraDevice* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	CheeseCamera* _tmp44_;
	CheeseCameraDevice* _tmp45_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = cheese_camera_get_camera_devices (_tmp0_);
	devices = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_CAMERA_DEVICE);
	camera_model = _tmp2_;
	_tmp3_ = self->priv->source_combo;
	_tmp4_ = camera_model;
	gtk_combo_box_set_model (_tmp3_, (GtkTreeModel*) _tmp4_);
	_tmp5_ = devices;
	_tmp6_ = _tmp5_->len;
	if (_tmp6_ <= ((guint) 1)) {
		GtkComboBox* _tmp7_;
		_tmp7_ = self->priv->source_combo;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				gboolean _tmp9_;
				gint _tmp11_;
				GPtrArray* _tmp12_;
				guint _tmp13_;
				GtkTreeIter iter = {0};
				GPtrArray* _tmp14_;
				gint _tmp15_;
				void* _tmp16_ = NULL;
				CheeseCameraDevice* _tmp17_;
				GtkListStore* _tmp18_;
				GtkTreeIter _tmp19_ = {0};
				GtkListStore* _tmp20_;
				GtkTreeIter _tmp21_;
				CheeseCameraDevice* _tmp22_;
				const gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gchar* _tmp25_;
				CheeseCameraDevice* _tmp26_;
				const gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				CheeseCameraDevice* _tmp32_;
				CheeseCamera* _tmp33_;
				CheeseCameraDevice* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				CheeseCameraDevice* _tmp36_;
				const gchar* _tmp37_ = NULL;
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = devices;
				_tmp13_ = _tmp12_->len;
				if (!(((guint) _tmp11_) < _tmp13_)) {
					break;
				}
				_tmp14_ = devices;
				_tmp15_ = i;
				_tmp16_ = g_ptr_array_index (_tmp14_, (guint) _tmp15_);
				_tmp17_ = _g_object_ref0 (CHEESE_CAMERA_DEVICE (_tmp16_));
				_g_object_unref0 (dev);
				dev = _tmp17_;
				_tmp18_ = camera_model;
				gtk_list_store_append (_tmp18_, &_tmp19_);
				iter = _tmp19_;
				_tmp20_ = camera_model;
				_tmp21_ = iter;
				_tmp22_ = dev;
				_tmp23_ = cheese_camera_device_get_name (_tmp22_);
				_tmp24_ = g_strconcat (_tmp23_, " (", NULL);
				_tmp25_ = _tmp24_;
				_tmp26_ = dev;
				_tmp27_ = cheese_camera_device_get_device_file (_tmp26_);
				_tmp28_ = g_strconcat (_tmp25_, _tmp27_, NULL);
				_tmp29_ = _tmp28_;
				_tmp30_ = g_strconcat (_tmp29_, " )", NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = dev;
				gtk_list_store_set (_tmp20_, &_tmp21_, 0, _tmp31_, 1, _tmp32_, -1);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp29_);
				_g_free0 (_tmp25_);
				_tmp33_ = self->priv->camera;
				_tmp34_ = cheese_camera_get_selected_device (_tmp33_);
				_tmp35_ = cheese_camera_device_get_device_file (_tmp34_);
				_tmp36_ = dev;
				_tmp37_ = cheese_camera_device_get_device_file (_tmp36_);
				if (g_strcmp0 (_tmp35_, _tmp37_) == 0) {
					GtkComboBox* _tmp38_;
					GtkTreeIter _tmp39_;
					_tmp38_ = self->priv->source_combo;
					_tmp39_ = iter;
					gtk_combo_box_set_active_iter (_tmp38_, &_tmp39_);
				}
			}
		}
	}
	_tmp40_ = self->priv->settings;
	_tmp41_ = self->priv->camera;
	_tmp42_ = cheese_camera_get_selected_device (_tmp41_);
	_tmp43_ = cheese_camera_device_get_device_file (_tmp42_);
	g_settings_set_string (_tmp40_, "camera", _tmp43_);
	_tmp44_ = self->priv->camera;
	_tmp45_ = cheese_camera_get_selected_device (_tmp44_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp45_);
	_g_object_unref0 (camera_model);
	_g_object_unref0 (dev);
}


static void cheese_preferences_dialog_setup_resolutions_for_device (CheesePreferencesDialog* self, CheeseCameraDevice* device) {
	CheeseCameraDevice* _tmp0_;
	GList* _tmp1_ = NULL;
	GList* formats;
	CheeseVideoFormat* format = NULL;
	GtkListStore* _tmp2_;
	GtkListStore* resolution_model;
	GtkComboBox* _tmp3_;
	GtkListStore* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkListStore* _tmp6_;
	GtkComboBox* _tmp66_;
	gint _tmp67_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	_tmp1_ = cheese_camera_device_get_format_list (_tmp0_);
	formats = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, CHEESE_TYPE_VIDEO_FORMAT);
	resolution_model = _tmp2_;
	_tmp3_ = self->priv->photo_resolution_combo;
	_tmp4_ = resolution_model;
	gtk_combo_box_set_model (_tmp3_, (GtkTreeModel*) _tmp4_);
	_tmp5_ = self->priv->video_resolution_combo;
	_tmp6_ = resolution_model;
	gtk_combo_box_set_model (_tmp5_, (GtkTreeModel*) _tmp6_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				GList* _tmp11_;
				guint _tmp12_ = 0U;
				GtkTreeIter iter = {0};
				GList* _tmp13_;
				gint _tmp14_;
				GList* _tmp15_ = NULL;
				gconstpointer _tmp16_;
				GtkListStore* _tmp17_;
				GtkTreeIter _tmp18_ = {0};
				GtkListStore* _tmp19_;
				GtkTreeIter _tmp20_;
				CheeseVideoFormat* _tmp21_;
				gint _tmp22_;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				CheeseVideoFormat* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				CheeseVideoFormat* _tmp33_;
				gboolean _tmp34_ = FALSE;
				CheeseCamera* _tmp35_;
				CheeseVideoFormat* _tmp36_ = NULL;
				gint _tmp37_;
				CheeseVideoFormat* _tmp38_;
				gint _tmp39_;
				gboolean _tmp45_;
				gboolean _tmp54_ = FALSE;
				GSettings* _tmp55_;
				gint _tmp56_ = 0;
				CheeseVideoFormat* _tmp57_;
				gint _tmp58_;
				gboolean _tmp63_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = formats;
				_tmp12_ = g_list_length (_tmp11_);
				if (!(((guint) _tmp10_) < _tmp12_)) {
					break;
				}
				_tmp13_ = formats;
				_tmp14_ = i;
				_tmp15_ = g_list_nth (_tmp13_, (guint) _tmp14_);
				_tmp16_ = _tmp15_->data;
				format = (CheeseVideoFormat*) _tmp16_;
				_tmp17_ = resolution_model;
				gtk_list_store_append (_tmp17_, &_tmp18_);
				iter = _tmp18_;
				_tmp19_ = resolution_model;
				_tmp20_ = iter;
				_tmp21_ = format;
				_tmp22_ = _tmp21_->width;
				_tmp23_ = g_strdup_printf ("%i", _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strconcat (_tmp24_, " x ", NULL);
				_tmp26_ = _tmp25_;
				_tmp27_ = format;
				_tmp28_ = _tmp27_->height;
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (_tmp26_, _tmp30_, NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = format;
				gtk_list_store_set (_tmp19_, &_tmp20_, 0, _tmp32_, 1, _tmp33_, -1);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				_g_free0 (_tmp26_);
				_g_free0 (_tmp24_);
				_tmp35_ = self->priv->camera;
				_tmp36_ = cheese_camera_get_current_video_format (_tmp35_);
				_tmp37_ = _tmp36_->width;
				_tmp38_ = format;
				_tmp39_ = _tmp38_->width;
				if (_tmp37_ == _tmp39_) {
					CheeseCamera* _tmp40_;
					CheeseVideoFormat* _tmp41_ = NULL;
					gint _tmp42_;
					CheeseVideoFormat* _tmp43_;
					gint _tmp44_;
					_tmp40_ = self->priv->camera;
					_tmp41_ = cheese_camera_get_current_video_format (_tmp40_);
					_tmp42_ = _tmp41_->height;
					_tmp43_ = format;
					_tmp44_ = _tmp43_->height;
					_tmp34_ = _tmp42_ == _tmp44_;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp45_ = _tmp34_;
				if (_tmp45_) {
					GtkComboBox* _tmp46_;
					GtkTreeIter _tmp47_;
					GSettings* _tmp48_;
					CheeseVideoFormat* _tmp49_;
					gint _tmp50_;
					GSettings* _tmp51_;
					CheeseVideoFormat* _tmp52_;
					gint _tmp53_;
					_tmp46_ = self->priv->photo_resolution_combo;
					_tmp47_ = iter;
					gtk_combo_box_set_active_iter (_tmp46_, &_tmp47_);
					_tmp48_ = self->priv->settings;
					_tmp49_ = format;
					_tmp50_ = _tmp49_->width;
					g_settings_set_int (_tmp48_, "photo-x-resolution", _tmp50_);
					_tmp51_ = self->priv->settings;
					_tmp52_ = format;
					_tmp53_ = _tmp52_->height;
					g_settings_set_int (_tmp51_, "photo-y-resolution", _tmp53_);
				}
				_tmp55_ = self->priv->settings;
				_tmp56_ = g_settings_get_int (_tmp55_, "video-x-resolution");
				_tmp57_ = format;
				_tmp58_ = _tmp57_->width;
				if (_tmp56_ == _tmp58_) {
					GSettings* _tmp59_;
					gint _tmp60_ = 0;
					CheeseVideoFormat* _tmp61_;
					gint _tmp62_;
					_tmp59_ = self->priv->settings;
					_tmp60_ = g_settings_get_int (_tmp59_, "video-y-resolution");
					_tmp61_ = format;
					_tmp62_ = _tmp61_->height;
					_tmp54_ = _tmp60_ == _tmp62_;
				} else {
					_tmp54_ = FALSE;
				}
				_tmp63_ = _tmp54_;
				if (_tmp63_) {
					GtkComboBox* _tmp64_;
					GtkTreeIter _tmp65_;
					_tmp64_ = self->priv->video_resolution_combo;
					_tmp65_ = iter;
					gtk_combo_box_set_active_iter (_tmp64_, &_tmp65_);
				}
			}
		}
	}
	_tmp66_ = self->priv->video_resolution_combo;
	_tmp67_ = gtk_combo_box_get_active (_tmp66_);
	if (_tmp67_ == (-1)) {
		GtkComboBox* _tmp68_;
		GtkComboBox* _tmp69_;
		gint _tmp70_ = 0;
		GSettings* _tmp71_;
		GSettings* _tmp72_;
		gint _tmp73_ = 0;
		GSettings* _tmp74_;
		GSettings* _tmp75_;
		gint _tmp76_ = 0;
		_tmp68_ = self->priv->video_resolution_combo;
		_tmp69_ = self->priv->photo_resolution_combo;
		_tmp70_ = gtk_combo_box_get_active (_tmp69_);
		gtk_combo_box_set_active (_tmp68_, _tmp70_);
		_tmp71_ = self->priv->settings;
		_tmp72_ = self->priv->settings;
		_tmp73_ = g_settings_get_int (_tmp72_, "photo-x-resolution");
		g_settings_set_int (_tmp71_, "video-x-resolution", _tmp73_);
		_tmp74_ = self->priv->settings;
		_tmp75_ = self->priv->settings;
		_tmp76_ = g_settings_get_int (_tmp75_, "photo-y-resolution");
		g_settings_set_int (_tmp74_, "video-y-resolution", _tmp76_);
	}
	_g_object_unref0 (resolution_model);
}


static void cheese_preferences_dialog_initialize_values_from_settings (CheesePreferencesDialog* self) {
	GtkAdjustment* _tmp0_;
	GSettings* _tmp1_;
	gdouble _tmp2_ = 0.0;
	GtkAdjustment* _tmp3_;
	GSettings* _tmp4_;
	gdouble _tmp5_ = 0.0;
	GtkAdjustment* _tmp6_;
	GSettings* _tmp7_;
	gdouble _tmp8_ = 0.0;
	GtkAdjustment* _tmp9_;
	GSettings* _tmp10_;
	gdouble _tmp11_ = 0.0;
	GtkSpinButton* _tmp12_;
	GSettings* _tmp13_;
	gint _tmp14_ = 0;
	GtkSpinButton* _tmp15_;
	GSettings* _tmp16_;
	gint _tmp17_ = 0;
	GtkCheckButton* _tmp18_;
	GSettings* _tmp19_;
	gboolean _tmp20_ = FALSE;
	GtkCheckButton* _tmp21_;
	GSettings* _tmp22_;
	gboolean _tmp23_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->brightness_adjustment;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_double (_tmp1_, "brightness");
	gtk_adjustment_set_value (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->contrast_adjustment;
	_tmp4_ = self->priv->settings;
	_tmp5_ = g_settings_get_double (_tmp4_, "contrast");
	gtk_adjustment_set_value (_tmp3_, _tmp5_);
	_tmp6_ = self->priv->hue_adjustment;
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_double (_tmp7_, "hue");
	gtk_adjustment_set_value (_tmp6_, _tmp8_);
	_tmp9_ = self->priv->saturation_adjustment;
	_tmp10_ = self->priv->settings;
	_tmp11_ = g_settings_get_double (_tmp10_, "saturation");
	gtk_adjustment_set_value (_tmp9_, _tmp11_);
	_tmp12_ = self->priv->burst_repeat_spin;
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_int (_tmp13_, "burst-repeat");
	gtk_spin_button_set_value (_tmp12_, (gdouble) _tmp14_);
	_tmp15_ = self->priv->burst_delay_spin;
	_tmp16_ = self->priv->settings;
	_tmp17_ = g_settings_get_int (_tmp16_, "burst-delay");
	gtk_spin_button_set_value (_tmp15_, (gdouble) (_tmp17_ / 1000));
	_tmp18_ = self->priv->countdown_check;
	_tmp19_ = self->priv->settings;
	_tmp20_ = g_settings_get_boolean (_tmp19_, "countdown");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp18_, _tmp20_);
	_tmp21_ = self->priv->flash_check;
	_tmp22_ = self->priv->settings;
	_tmp23_ = g_settings_get_boolean (_tmp22_, "flash");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp21_, _tmp23_);
}


void cheese_preferences_dialog_on_source_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseCameraDevice* dev = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	CheeseCamera* _tmp6_;
	const gchar* _tmp7_ = NULL;
	CheeseCamera* _tmp8_;
	CheeseCamera* _tmp9_;
	CheeseCameraDevice* _tmp10_ = NULL;
	GSettings* _tmp11_;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &dev, -1);
	_tmp6_ = self->priv->camera;
	_tmp7_ = cheese_camera_device_get_device_file (dev);
	cheese_camera_set_device_by_dev_file (_tmp6_, _tmp7_);
	_tmp8_ = self->priv->camera;
	cheese_camera_switch_camera_device (_tmp8_);
	_tmp9_ = self->priv->camera;
	_tmp10_ = cheese_camera_get_selected_device (_tmp9_);
	cheese_preferences_dialog_setup_resolutions_for_device (self, _tmp10_);
	_tmp11_ = self->priv->settings;
	_tmp12_ = cheese_camera_device_get_device_file (dev);
	g_settings_set_string (_tmp11_, "camera", _tmp12_);
	_g_object_unref0 (dev);
}


void cheese_preferences_dialog_on_photo_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	gboolean _tmp6_ = FALSE;
	CheeseMediaMode _tmp7_;
	gboolean _tmp9_;
	GSettings* _tmp12_;
	CheeseVideoFormat* _tmp13_;
	gint _tmp14_;
	GSettings* _tmp15_;
	CheeseVideoFormat* _tmp16_;
	gint _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &format, -1);
	_tmp7_ = self->priv->current_mode;
	if (_tmp7_ == CHEESE_MEDIA_MODE_PHOTO) {
		_tmp6_ = TRUE;
	} else {
		CheeseMediaMode _tmp8_;
		_tmp8_ = self->priv->current_mode;
		_tmp6_ = _tmp8_ == CHEESE_MEDIA_MODE_BURST;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		CheeseCamera* _tmp10_;
		CheeseVideoFormat* _tmp11_;
		_tmp10_ = self->priv->camera;
		_tmp11_ = format;
		cheese_camera_set_video_format (_tmp10_, _tmp11_);
	}
	_tmp12_ = self->priv->settings;
	_tmp13_ = format;
	_tmp14_ = _tmp13_->width;
	g_settings_set_int (_tmp12_, "photo-x-resolution", _tmp14_);
	_tmp15_ = self->priv->settings;
	_tmp16_ = format;
	_tmp17_ = _tmp16_->height;
	g_settings_set_int (_tmp15_, "photo-y-resolution", _tmp17_);
}


void cheese_preferences_dialog_on_video_resolution_change (GtkComboBox* combo, CheesePreferencesDialog* self) {
	GtkTreeIter iter = {0};
	CheeseVideoFormat* format = NULL;
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	CheeseMediaMode _tmp6_;
	GSettings* _tmp9_;
	CheeseVideoFormat* _tmp10_;
	gint _tmp11_;
	GSettings* _tmp12_;
	CheeseVideoFormat* _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &format, -1);
	_tmp6_ = self->priv->current_mode;
	if (_tmp6_ == CHEESE_MEDIA_MODE_VIDEO) {
		CheeseCamera* _tmp7_;
		CheeseVideoFormat* _tmp8_;
		_tmp7_ = self->priv->camera;
		_tmp8_ = format;
		cheese_camera_set_video_format (_tmp7_, _tmp8_);
	}
	_tmp9_ = self->priv->settings;
	_tmp10_ = format;
	_tmp11_ = _tmp10_->width;
	g_settings_set_int (_tmp9_, "video-x-resolution", _tmp11_);
	_tmp12_ = self->priv->settings;
	_tmp13_ = format;
	_tmp14_ = _tmp13_->height;
	g_settings_set_int (_tmp12_, "video-y-resolution", _tmp14_);
}


void cheese_preferences_dialog_on_delete (GtkDialog* dialog, CheesePreferencesDialog* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dialog != NULL);
	_tmp0_ = dialog;
	gtk_widget_hide_on_delete ((GtkWidget*) _tmp0_);
}


void cheese_preferences_dialog_on_dialog_close (GtkButton* button, CheesePreferencesDialog* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


void cheese_preferences_dialog_on_countdown_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self) {
	GSettings* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (checkbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = checkbutton;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "countdown", _tmp3_);
}


void cheese_preferences_dialog_on_flash_toggle (GtkCheckButton* checkbutton, CheesePreferencesDialog* self) {
	GSettings* _tmp0_;
	GtkCheckButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (checkbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = checkbutton;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_boolean (_tmp0_, "flash", _tmp3_);
}


void cheese_preferences_dialog_on_burst_repeat_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self) {
	GSettings* _tmp0_;
	GtkSpinButton* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = spinbutton;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp0_, "burst-repeat", (gint) _tmp3_);
}


void cheese_preferences_dialog_on_burst_delay_change (GtkSpinButton* spinbutton, CheesePreferencesDialog* self) {
	GSettings* _tmp0_;
	GtkSpinButton* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (spinbutton != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = spinbutton;
	_tmp2_ = gtk_spin_button_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	g_settings_set_int (_tmp0_, "burst-delay", ((gint) _tmp3_) * 1000);
}


void cheese_preferences_dialog_on_brightness_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "brightness", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "brightness", _tmp7_);
}


void cheese_preferences_dialog_on_contrast_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "contrast", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "contrast", _tmp7_);
}


void cheese_preferences_dialog_on_hue_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "hue", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "hue", _tmp7_);
}


void cheese_preferences_dialog_on_saturation_change (GtkAdjustment* adjustment, CheesePreferencesDialog* self) {
	CheeseCamera* _tmp0_;
	GtkAdjustment* _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	GSettings* _tmp4_;
	GtkAdjustment* _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjustment != NULL);
	_tmp0_ = self->priv->camera;
	_tmp1_ = adjustment;
	_tmp2_ = gtk_adjustment_get_value (_tmp1_);
	_tmp3_ = _tmp2_;
	cheese_camera_set_balance_property (_tmp0_, "saturation", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = adjustment;
	_tmp6_ = gtk_adjustment_get_value (_tmp5_);
	_tmp7_ = _tmp6_;
	g_settings_set_double (_tmp4_, "saturation", _tmp7_);
}


void cheese_preferences_dialog_show (CheesePreferencesDialog* self) {
	GtkDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
}


void cheese_preferences_dialog_set_current_mode (CheesePreferencesDialog* self, CheeseMediaMode mode) {
	CheeseMediaMode _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = mode;
	self->priv->current_mode = _tmp0_;
}


static void cheese_preferences_dialog_class_init (CheesePreferencesDialogClass * klass) {
	cheese_preferences_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CheesePreferencesDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = cheese_preferences_dialog_finalize;
}


static void cheese_preferences_dialog_instance_init (CheesePreferencesDialog * self) {
	self->priv = CHEESE_PREFERENCES_DIALOG_GET_PRIVATE (self);
}


static void cheese_preferences_dialog_finalize (GObject* obj) {
	CheesePreferencesDialog * self;
	self = CHEESE_PREFERENCES_DIALOG (obj);
	_g_object_unref0 (self->priv->camera);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->photo_resolution_combo);
	_g_object_unref0 (self->priv->video_resolution_combo);
	_g_object_unref0 (self->priv->source_combo);
	_g_object_unref0 (self->priv->brightness_adjustment);
	_g_object_unref0 (self->priv->contrast_adjustment);
	_g_object_unref0 (self->priv->hue_adjustment);
	_g_object_unref0 (self->priv->saturation_adjustment);
	_g_object_unref0 (self->priv->brightness_scale);
	_g_object_unref0 (self->priv->contrast_scale);
	_g_object_unref0 (self->priv->hue_scale);
	_g_object_unref0 (self->priv->saturation_scale);
	_g_object_unref0 (self->priv->burst_repeat_spin);
	_g_object_unref0 (self->priv->burst_delay_spin);
	_g_object_unref0 (self->priv->countdown_check);
	_g_object_unref0 (self->priv->flash_check);
	G_OBJECT_CLASS (cheese_preferences_dialog_parent_class)->finalize (obj);
}


GType cheese_preferences_dialog_get_type (void) {
	static volatile gsize cheese_preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&cheese_preferences_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CheesePreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cheese_preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CheesePreferencesDialog), 0, (GInstanceInitFunc) cheese_preferences_dialog_instance_init, NULL };
		GType cheese_preferences_dialog_type_id;
		cheese_preferences_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "CheesePreferencesDialog", &g_define_type_info, 0);
		g_once_init_leave (&cheese_preferences_dialog_type_id__volatile, cheese_preferences_dialog_type_id);
	}
	return cheese_preferences_dialog_type_id__volatile;
}



