//Sample. Calculating and displaying 2D Hue-Saturation histogram of a color imag
//file:///usr/share/doc/opencv-doc/ref/opencvref_cv.htm
//
//compilar amb:
//gcc `pkg-config --cflags --libs opencv` hue_saturation.c -o hue_saturation

#include <cv.h>
#include <highgui.h>
#include "stdio.h"

int main( int argc, char** argv )
{
	IplImage* src;
	if( argc == 2 && (src=cvLoadImage(argv[1], 1))!= 0)
	{
		IplImage* h_plane = cvCreateImage( cvGetSize(src), 8, 1 );
		IplImage* s_plane = cvCreateImage( cvGetSize(src), 8, 1 );
		IplImage* v_plane = cvCreateImage( cvGetSize(src), 8, 1 );
		IplImage* planes[] = { h_plane, s_plane };
		IplImage* hsv = cvCreateImage( cvGetSize(src), 8, 3 );
		int h_bins = 30, s_bins = 32;
		int hist_size[] = {h_bins, s_bins};
		float h_ranges[] = { 0, 180 }; /* hue varies from 0 (~0°red) to 180 (~360°red again) */
		float s_ranges[] = { 0, 255 }; /* saturation varies from 0 (black-gray-white) to 255 (pure spectrum color) */
		float* ranges[] = { h_ranges, s_ranges };
		int scale = 10;
		IplImage* hist_img = cvCreateImage( cvSize(h_bins*scale,s_bins*scale), 8, 3 );
		CvHistogram* hist;
		float max_value = 0;
		int h, s;

		cvCvtColor( src, hsv, CV_BGR2HSV );
		cvCvtPixToPlane( hsv, h_plane, s_plane, v_plane, 0 );
		hist = cvCreateHist( 2, hist_size, CV_HIST_ARRAY, ranges, 1 );
		cvCalcHist( planes, hist, 0, 0 );
		cvGetMinMaxHistValue( hist, 0, &max_value, 0, 0 );
		cvZero( hist_img );

		int intensitySum = 0;
		for( h = 0; h < h_bins; h++ )
		{
			for( s = 0; s < s_bins; s++ )
			{
				float bin_val = cvQueryHistValue_2D( hist, h, s );
				int intensity = cvRound(bin_val*255/max_value);
				intensitySum += intensity;
				cvRectangle( hist_img, cvPoint( h*scale, s*scale ),
						cvPoint( (h+1)*scale - 1, (s+1)*scale - 1),
						CV_RGB(intensity,intensity,intensity),
						//CV_FILLED );
						CV_FILLED,1,1 );
				/* graw a grayscale histogram.
				   if you have idea how to do it
				   nicer let us know */
			}
		}

		printf("intensityDiv: %f\n", (double) 100 * intensitySum / (h_bins * s_bins) );

		cvNamedWindow( "Source", 1 );
		cvShowImage( "Source", src );

		cvNamedWindow( "H-S Histogram", 1 );
		cvShowImage( "H-S Histogram", hist_img );

		cvWaitKey(0);
	}
}

