// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BEHAVIOUR_PATH_H
#define _CLUTTERMM_BEHAVIOUR_PATH_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/behaviour.h>
#include <cluttermm/scriptable.h>
#include <cluttermm/alpha.h>
#include <cluttermm/types.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBehaviourPath ClutterBehaviourPath;
typedef struct _ClutterBehaviourPathClass ClutterBehaviourPathClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BehaviourPath_Class; } // namespace Clutter
namespace Clutter
{


class BehaviourPath 
: public Behaviour, 
  public Scriptable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BehaviourPath CppObjectType;
  typedef BehaviourPath_Class CppClassType;
  typedef ClutterBehaviourPath BaseObjectType;
  typedef ClutterBehaviourPathClass BaseClassType;

private:  friend class BehaviourPath_Class;
  static CppClassType behaviourpath_class_;

private:
  // noncopyable
  BehaviourPath(const BehaviourPath&);
  BehaviourPath& operator=(const BehaviourPath&);

protected:
  explicit BehaviourPath(const Glib::ConstructParams& construct_params);
  explicit BehaviourPath(ClutterBehaviourPath* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BehaviourPath();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBehaviourPath*       gobj()       { return reinterpret_cast<ClutterBehaviourPath*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBehaviourPath* gobj() const { return reinterpret_cast<ClutterBehaviourPath*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBehaviourPath* gobj_copy();

private:

  
protected:
  // TODO: pass the knots as a C++ container
  explicit BehaviourPath(const Glib::RefPtr<Alpha>& alpha, const ClutterKnot* knots, guint n_knots);

public:
  // TODO: pass the knots as a C++ container
  
  static Glib::RefPtr<BehaviourPath> create(const Glib::RefPtr<Alpha>& alpha, const ClutterKnot* knots, guint n_knots);


  /** Appends a Clutter::Knot to the path
   * 
   * Since: 0.2
   * @param knot A Clutter::Knot to append.
   */
  void append_knot(const Knot& knot);
  
  /** Inserts a Clutter::Knot in the path at specified position. Values greater
   * than total number of knots will append the knot at the end of path.
   * 
   * Since: 0.2
   * @param offset Position in path to insert knot.
   * @param knot A Clutter::Knot to append.
   */
  void insert_knot(guint offset, const Knot& knot);
  
  /** Removes a Clutter::Knot in the path at specified offset.
   * 
   * Since: 0.2
   * @param offset Position in path to remove knot.
   */
  void remove_knot(guint offset);
  
  /** Removes all knots from a path
   * 
   * Since: 0.2
   */
  void clear();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%knot_reached(const Knot& knot)</tt>
   */

  Glib::SignalProxy1< void,const Knot& > signal_knot_reached();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Can be used to append a knot to the path.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly<Knot> property_knot() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_knot_reached(const Knot& knot);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter
// vim:ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BehaviourPath
   */
  Glib::RefPtr<Clutter::BehaviourPath> wrap(ClutterBehaviourPath* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BEHAVIOUR_PATH_H */

