// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_TEXTURE_H
#define _CLUTTERMM_TEXTURE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/actor.h>
#include <cluttermm/types.h>
#include <gdkmm/pixbuf.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterTexture ClutterTexture;
typedef struct _ClutterTextureClass ClutterTextureClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Texture_Class; } // namespace Clutter
namespace Clutter
{

/** @addtogroup cluttermmEnums Enums and Flags */

/**
 * @ingroup cluttermmEnums
 * @par Bitwise operators:
 * <tt>%TextureFlags operator|(TextureFlags, TextureFlags)</tt><br>
 * <tt>%TextureFlags operator&(TextureFlags, TextureFlags)</tt><br>
 * <tt>%TextureFlags operator^(TextureFlags, TextureFlags)</tt><br>
 * <tt>%TextureFlags operator~(TextureFlags)</tt><br>
 * <tt>%TextureFlags& operator|=(TextureFlags&, TextureFlags)</tt><br>
 * <tt>%TextureFlags& operator&=(TextureFlags&, TextureFlags)</tt><br>
 * <tt>%TextureFlags& operator^=(TextureFlags&, TextureFlags)</tt><br>
 */
enum TextureFlags
{
  TEXTURE_RGB_FLAG_BGR = 1 << 1,
  TEXTURE_RGB_FLAG_PREMULT = 1 << 2,
  TEXTURE_YUV_FLAG_YUV2 = 1 << 3
};

/** @ingroup cluttermmEnums */
inline TextureFlags operator|(TextureFlags lhs, TextureFlags rhs)
  { return static_cast<TextureFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline TextureFlags operator&(TextureFlags lhs, TextureFlags rhs)
  { return static_cast<TextureFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline TextureFlags operator^(TextureFlags lhs, TextureFlags rhs)
  { return static_cast<TextureFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup cluttermmEnums */
inline TextureFlags operator~(TextureFlags flags)
  { return static_cast<TextureFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup cluttermmEnums */
inline TextureFlags& operator|=(TextureFlags& lhs, TextureFlags rhs)
  { return (lhs = static_cast<TextureFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline TextureFlags& operator&=(TextureFlags& lhs, TextureFlags rhs)
  { return (lhs = static_cast<TextureFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup cluttermmEnums */
inline TextureFlags& operator^=(TextureFlags& lhs, TextureFlags rhs)
  { return (lhs = static_cast<TextureFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** Exception class for Clutter::Texture errors.
 */
class TextureError : public Glib::Error
{
public:
  enum Code
  {
    OUT_OF_MEMORY,
    NO_YUV
  };

  TextureError(Code error_code, const Glib::ustring& error_message);
  explicit TextureError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Clutter

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Clutter::TextureError::Code> : public Glib::Value_Enum<Clutter::TextureError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{


class Texture :
  public Actor
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Texture CppObjectType;
  typedef Texture_Class CppClassType;
  typedef ClutterTexture BaseObjectType;
  typedef ClutterTextureClass BaseClassType;

private:  friend class Texture_Class;
  static CppClassType texture_class_;

private:
  // noncopyable
  Texture(const Texture&);
  Texture& operator=(const Texture&);

protected:
  explicit Texture(const Glib::ConstructParams& construct_params);
  explicit Texture(ClutterTexture* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Texture();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterTexture*       gobj()       { return reinterpret_cast<ClutterTexture*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterTexture* gobj() const { return reinterpret_cast<ClutterTexture*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterTexture* gobj_copy();

private:


protected:
  Texture();
  explicit Texture(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);

public:
 

  static Glib::RefPtr<Texture> create();

  
  static Glib::RefPtr<Texture> create(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
;

  
  /** Sets a  Clutter::Texture image data from a Gdk::Pixbuf. In case of
   * failure, <tt>false</tt> is returned and @a error is set.
   * @param pixbuf A Gdk::Pixbuf.
   * @return <tt>true</tt> if the pixbuf was successfully set
   * 
   * Since: 0.4.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf);
#else
  bool set_pixbuf(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Gets a Gdk::Pixbuf representation of the Clutter::Texture data.
   * The created Gdk::Pixbuf is not owned by the texture but the caller.
   * @return A Gdk::Pixbuf.
   */
  Glib::RefPtr<Gdk::Pixbuf> get_pixbuf() const;
  
  /** Gets the size in pixels of the untransformed underlying texture pixbuf data.
   * @param width Pointer to <tt>int</tt> to be populated with width value if non <tt>0</tt>.
   * @param height Pointer to <tt>int</tt> to be populated with height value if non <tt>0</tt>.
   */
  void get_base_size(gint& width, gint& height) const;
  
  /** Sets Clutter::Texture image data.
   * 
   * @note This function is likely to change in future versions.
   * @param data Image data in RGB type colorspace.
   * @param has_alpha Set to <tt>true</tt> if image data has a alpha channel.
   * @param width Width in pixels of image data.
   * @param height Height in pixels of image data.
   * @param rowstride Distance in bytes between row starts.
   * @param bpp Bytes per pixel ( Currently only 4 supported ).
   * @param flags Clutter::TextureFlags.
   * @return <tt>true</tt> on success, <tt>false</tt> on failure.
   * 
   * Since: 0.4.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_from_rgb_data(const guchar* data, bool has_alpha, int width, int height, int rowstride, int bpp, TextureFlags flags);
#else
  bool set_from_rgb_data(const guchar* data, bool has_alpha, int width, int height, int rowstride, int bpp, TextureFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Sets a Clutter::Texture from YUV image data. If an error occurred,
   * <tt>false</tt> is returned and @a error is set.
   * 
   * This function is likely to change in future versions.
   * @param data Image data in RGB type colorspace.
   * @param width Width in pixels of image data.
   * @param height Height in pixels of image data.
   * @param flags Clutter::TextureFlags.
   * @return <tt>true</tt> if the texture was successfully updated
   * 
   * Since 0.4.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool set_from_yuv_data(const guchar* data, int width, int height, TextureFlags flags);
#else
  bool set_from_yuv_data(const guchar* data, int width, int height, TextureFlags flags, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /**
   * @par Prototype:
   * <tt>void on_my_%size_change(gint width, gint height)</tt>
   */

  Glib::SignalProxy2< void,gint,gint > signal_size_change();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%pixbuf_change()</tt>
   */

  Glib::SignalProxy0< void > signal_pixbuf_change();


protected:
  
  /** Checks if Clutter::Texture is tiled.
   * 
   * This function is only useful for sub class implementations
   * and never should be called by an application.
   * @return <tt>true</tt> if texture is tiled.
   */
  bool is_tiled() const;
  
  /** Retreives internal tile dimentioning.
   * 
   * This function is only useful for sub class implementations
   * and never should be called by an application.
   * @param n_x_tiles Location to store number of tiles in horizonally axis.
   * @param n_y_tiles Location to store number of tiles in vertical axis.
   */
  void get_n_tiles(gint& n_x_tiles, gint& n_y_tiles);
  
  /** Retreives details of a tile on y axis.
   * 
   * This function is only useful for sub class implementations
   * and never should be called by an application.
   * @param y_index Y index of tile to query.
   * @param pos Location to store tiles Y position.
   * @param size Location to store tiles vertical size in pixels.
   * @param waste Location to store tiles vertical wastage in pixels.
   */
  void get_y_tile_detail(int y_index, int& pos, int& size, int& waste) const;
  
  /** Retreives details of a tile on x axis.
   * 
   * This function is only useful for sub class implementations
   * and never should be called by an application.
   * @param x_index X index of tile to query.
   * @param pos Location to store tiles X position.
   * @param size Location to store tiles horizontal size in pixels.
   * @param waste Location to store tiles horizontal wastage in pixels.
   */
  void get_x_tile_detail(int x_index, int& pos, int& size, int& waste) const;
  
  /** Checks if Clutter::Texture has generated underlying GL texture tiles.
   * 
   * This function is only useful for sub class implementations
   * and never should be called by an application.
   * @return <tt>true</tt> if texture has pregenerated GL tiles.
   */
  bool has_generated_tiles() const;
  
  /** Proxys a call to glBindTexture a to bind an internal 'tile'.
   * 
   * This function is only useful for sub class implementations
   * and never should be called by an application.
   * @param index Tile index to bind.
   */
  void bind_tile(int index);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_size_change(gint width, gint height);
  virtual void on_pixbuf_change();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Texture
   */
  Glib::RefPtr<Clutter::Texture> wrap(ClutterTexture* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_TEXTURE_H */

