// Generated by gtkmmproc -- DO NOT MODIFY!


#include <cluttermm/stage.h>
#include <cluttermm/private/stage_p.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter-stage.h>

namespace Clutter
{

Color Stage::get_color() const
{
  Color color;
  clutter_stage_get_color(const_cast<ClutterStage*>(gobj()), color.gobj());
  return color;
}

} //namespace Clutter


namespace
{


static const Glib::SignalProxyInfo Stage_signal_fullscreen_info =
{
  "fullscreen",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Stage_signal_unfullscreen_info =
{
  "unfullscreen",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Stage_signal_activate_info =
{
  "activate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Stage_signal_deactivate_info =
{
  "deactivate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Clutter::Stage> wrap(ClutterStage* object, bool take_copy)
{
  return Glib::RefPtr<Clutter::Stage>( dynamic_cast<Clutter::Stage*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Clutter
{


/* The *_Class implementation: */

const Glib::Class& Stage_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Stage_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(clutter_stage_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Stage_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->set_fullscreen = &set_fullscreen_vfunc_callback;
  klass->set_cursor_visible = &set_cursor_visible_vfunc_callback;
  klass->draw_to_pixbuf = &draw_to_pixbuf_vfunc_callback;
  klass->set_title = &set_title_vfunc_callback;
  klass->set_user_resize = &set_user_resize_vfunc_callback;
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->fullscreen = &fullscreen_callback;
  klass->unfullscreen = &unfullscreen_callback;
  klass->activate = &activate_callback;
  klass->deactivate = &deactivate_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
void Stage_Class::set_fullscreen_vfunc_callback(ClutterStage* self, gboolean fullscreen)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_fullscreen_vfunc(fullscreen
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_fullscreen)
    (*base->set_fullscreen)(self, fullscreen);

}
void Stage_Class::set_cursor_visible_vfunc_callback(ClutterStage* self, gboolean visible)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_cursor_visible_vfunc(visible
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_cursor_visible)
    (*base->set_cursor_visible)(self, visible);

}
GdkPixbuf* Stage_Class::draw_to_pixbuf_vfunc_callback(ClutterStage* self, gint x, gint y, gint width, gint height)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->draw_to_pixbuf_vfunc(x
, y
, width
, height
));
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->draw_to_pixbuf)
    return (*base->draw_to_pixbuf)(self, x, y, width, height);


  typedef GdkPixbuf* RType;
  return RType();
}
void Stage_Class::set_title_vfunc_callback(ClutterStage* self, const gchar* title)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_title_vfunc(Glib::convert_const_gchar_ptr_to_ustring(title)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_title)
    (*base->set_title)(self, title);

}
void Stage_Class::set_user_resize_vfunc_callback(ClutterStage* self, gboolean value)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->set_user_resize_vfunc(value
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->set_user_resize)
    (*base->set_user_resize)(self, value);

}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Stage_Class::fullscreen_callback(ClutterStage* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_fullscreen();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->fullscreen)
    (*base->fullscreen)(self);
}
void Stage_Class::unfullscreen_callback(ClutterStage* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_unfullscreen();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unfullscreen)
    (*base->unfullscreen)(self);
}
void Stage_Class::activate_callback(ClutterStage* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_activate();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->activate)
    (*base->activate)(self);
}
void Stage_Class::deactivate_callback(ClutterStage* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_deactivate();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->deactivate)
    (*base->deactivate)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Stage_Class::wrap_new(GObject* object)
{
  return new Stage((ClutterStage*)object);
}


/* The implementation: */

ClutterStage* Stage::gobj_copy()
{
  reference();
  return gobj();
}

Stage::Stage(const Glib::ConstructParams& construct_params)
:
  Group(construct_params)
{

}

Stage::Stage(ClutterStage* castitem)
:
  Group((ClutterGroup*)(castitem))
{}

Stage::~Stage()
{}


Stage::CppClassType Stage::stage_class_; // initialize static member

GType Stage::get_type()
{
  return stage_class_.init().get_type();
}

GType Stage::get_base_type()
{
  return clutter_stage_get_type();
}


Stage::Stage()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Group(Glib::ConstructParams(stage_class_.init()))
{
  

}

Glib::RefPtr<Stage> Stage::get_default()
{

  Glib::RefPtr<Stage> retvalue = Glib::wrap((ClutterStage*)clutter_stage_get_default());

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}


void Stage::set_color(const Color& color)
{
clutter_stage_set_color(gobj(), (color).gobj()); 
}

void Stage::set_perspectivex(ClutterPerspective* perspective)
{
clutter_stage_set_perspectivex(gobj(), perspective); 
}

void Stage::get_perspectivex(ClutterPerspective* perspective) const
{
clutter_stage_get_perspectivex(const_cast<ClutterStage*>(gobj()), perspective); 
}

void Stage::set_perspective(float fovy, float aspect, float z_near, float z_far)
{
clutter_stage_set_perspective(gobj(), fovy, aspect, z_near, z_far); 
}

void Stage::get_perspective(float& fovy, float& aspect, float& z_near, float& z_far)
{
clutter_stage_get_perspective(gobj(), &(fovy), &(aspect), &(z_near), &(z_far)); 
}

void Stage::fullscreen()
{
clutter_stage_fullscreen(gobj()); 
}

void Stage::unfullscreen()
{
clutter_stage_unfullscreen(gobj()); 
}

void Stage::show_cursor()
{
clutter_stage_show_cursor(gobj()); 
}

void Stage::hide_cursor()
{
clutter_stage_hide_cursor(gobj()); 
}

Glib::ustring Stage::get_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(clutter_stage_get_title(const_cast<ClutterStage*>(gobj())));
}

void Stage::set_title(const Glib::ustring& title)
{
clutter_stage_set_title(gobj(), title.c_str()); 
}

void Stage::set_user_resizable(bool value)
{
clutter_stage_set_user_resizable(gobj(), static_cast<int>(value)); 
}

bool Stage::get_user_resizable() const
{
  return clutter_stage_get_user_resizable(const_cast<ClutterStage*>(gobj()));
}

Glib::RefPtr<Actor> Stage::get_actor_at_pos(int x, int y)
{

  Glib::RefPtr<Actor> retvalue = Glib::wrap(clutter_stage_get_actor_at_pos(gobj(), x, y));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Actor> Stage::get_actor_at_pos(int x, int y) const
{
  return const_cast<Stage*>(this)->get_actor_at_pos(x, y);
}

Glib::RefPtr<Actor> Stage::get_key_focus()
{

  Glib::RefPtr<Actor> retvalue = Glib::wrap(clutter_stage_get_key_focus(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Actor> Stage::get_key_focus() const
{
  return const_cast<Stage*>(this)->get_key_focus();
}

void Stage::set_key_focus(const Glib::RefPtr<Actor>& actor)
{
clutter_stage_set_key_focus(gobj(), Glib::unwrap(actor)); 
}

Glib::RefPtr<Gdk::Pixbuf> Stage::snapshot(int x, int y, int width, int height) const
{
  return Glib::wrap(clutter_stage_snapshot(const_cast<ClutterStage*>(gobj()), x, y, width, height));
}

bool Stage::get_use_fog() const
{
  return clutter_stage_get_use_fog(const_cast<ClutterStage*>(gobj()));
}

void Stage::set_use_fog(bool fog)
{
clutter_stage_set_use_fog(gobj(), static_cast<int>(fog)); 
}

void Stage::set_fog(double density, double z_near, double z_far)
{
clutter_stage_set_fog(gobj(), density, z_near, z_far); 
}

void Stage::get_fog(double& density, double& z_near, double& z_far) const
{
clutter_stage_get_fog(const_cast<ClutterStage*>(gobj()), &(density), &(z_near), &(z_far)); 
}

void Stage::set_fogx(const Fog& fog)
{
clutter_stage_set_fogx(gobj(), const_cast<ClutterFog*>(&(fog))); 
}

void Stage::get_fogx(Fog& fog) const
{
clutter_stage_get_fogx(const_cast<ClutterStage*>(gobj()), &(fog)); 
}

double Stage::get_resolution() const
{
  return clutter_stage_get_resolution(const_cast<ClutterStage*>(gobj()));
}

Fixed Stage::get_resolutionx() const
{
  return clutter_stage_get_resolutionx(const_cast<ClutterStage*>(gobj()));
}

void Stage::stage_event(Event* event)
{
clutter_stage_event(gobj(), event); 
}


Glib::SignalProxy0< void > Stage::signal_fullscreen()
{
  return Glib::SignalProxy0< void >(this, &Stage_signal_fullscreen_info);
}


Glib::SignalProxy0< void > Stage::signal_unfullscreen()
{
  return Glib::SignalProxy0< void >(this, &Stage_signal_unfullscreen_info);
}


Glib::SignalProxy0< void > Stage::signal_activate()
{
  return Glib::SignalProxy0< void >(this, &Stage_signal_activate_info);
}


Glib::SignalProxy0< void > Stage::signal_deactivate()
{
  return Glib::SignalProxy0< void >(this, &Stage_signal_deactivate_info);
}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Clutter::Stage::on_fullscreen()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->fullscreen)
    (*base->fullscreen)(gobj());
}
void Clutter::Stage::on_unfullscreen()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unfullscreen)
    (*base->unfullscreen)(gobj());
}
void Clutter::Stage::on_activate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->activate)
    (*base->activate)(gobj());
}
void Clutter::Stage::on_deactivate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->deactivate)
    (*base->deactivate)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
void Clutter::Stage::set_fullscreen_vfunc(bool fullscreen) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_fullscreen)
    (*base->set_fullscreen)(gobj(),static_cast<int>(fullscreen));
}
void Clutter::Stage::set_cursor_visible_vfunc(bool visible) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_cursor_visible)
    (*base->set_cursor_visible)(gobj(),static_cast<int>(visible));
}
Glib::RefPtr<Gdk::Pixbuf> Clutter::Stage::draw_to_pixbuf_vfunc(int x, int y, int width, int height) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->draw_to_pixbuf)
    return Glib::wrap((*base->draw_to_pixbuf)(gobj(),x,y,width,height));

  typedef Glib::RefPtr<Gdk::Pixbuf> RType;
  return RType();
}
void Clutter::Stage::set_title_vfunc(const Glib::ustring& title) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_title)
    (*base->set_title)(gobj(),title.c_str());
}
void Clutter::Stage::set_user_resize_vfunc(bool value) 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->set_user_resize)
    (*base->set_user_resize)(gobj(),static_cast<int>(value));
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Clutter


