// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_BEHAVIOUR_BSPLINE_H
#define _CLUTTERMM_BEHAVIOUR_BSPLINE_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/behaviour.h>
#include <cluttermm/alpha.h>
#include <cluttermm/scriptable.h>
#include <cluttermm/types.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterBehaviourBspline ClutterBehaviourBspline;
typedef struct _ClutterBehaviourBsplineClass ClutterBehaviourBsplineClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class BehaviourBspline_Class; } // namespace Clutter
namespace Clutter
{


class BehaviourBspline
: public Behaviour,
  public Scriptable
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef BehaviourBspline CppObjectType;
  typedef BehaviourBspline_Class CppClassType;
  typedef ClutterBehaviourBspline BaseObjectType;
  typedef ClutterBehaviourBsplineClass BaseClassType;

private:  friend class BehaviourBspline_Class;
  static CppClassType behaviourbspline_class_;

private:
  // noncopyable
  BehaviourBspline(const BehaviourBspline&);
  BehaviourBspline& operator=(const BehaviourBspline&);

protected:
  explicit BehaviourBspline(const Glib::ConstructParams& construct_params);
  explicit BehaviourBspline(ClutterBehaviourBspline* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~BehaviourBspline();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterBehaviourBspline*       gobj()       { return reinterpret_cast<ClutterBehaviourBspline*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterBehaviourBspline* gobj() const { return reinterpret_cast<ClutterBehaviourBspline*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterBehaviourBspline* gobj_copy();

private:

  
protected:
  // TODO: pass the knots as a C++ container
  explicit BehaviourBspline(const Glib::RefPtr<Alpha>& alpha, const ClutterKnot* knots, guint n_knots);

public:
  // TODO: pass the knots as a C++ container
  
  static Glib::RefPtr<BehaviourBspline> create(const Glib::RefPtr<Alpha>& alpha, const ClutterKnot* knots, guint n_knots);


  /** Appends a Clutter::Knot control point to the bezier spline bs. Note, that
   * since a bezier is defined by 4 control points, the point gets stored in
   * a temporary chache, and only when there are enough control points to
   * create a new bezier curve will the bspline extended.
   * 
   * Since: 0.4
   * @param knot A Clutter::Knot control point to append.
   */
  void append_knot(const Knot& knot);
  
  /** Truncates the bezier spline at the control point; if the control point at
   * offset is not one of the on-curve points, the bspline will be
   * truncated at the nearest preceeding on-curve point.
   * 
   * Since: 0.4
   * @param offset Offset of control where the bspline should be truncated.
   */
  void truncate(guint offset);
  
  /** Joins a copy of bezier spline bs2 onto the end of bezier spline bs1; bs2 is
   * not modified.
   * 
   * Since: 0.4
   * @param bs2 A Clutter::BehaviourBspline.
   */
  void join(const Glib::RefPtr<const BehaviourBspline>& bs2);
  // TODO: is this cast ok?
 

  /** Splits a bezier spline into two at the control point at offset; if the
   * control point at offset is not one of the on-curve bezier points, the
   * bspline will be split at the nearest on-curve point before the offset.
   * The original bspline is shortened appropriately.
   * @param offset An offset of the control point at which to split the spline.
   * @return New ClutterBehaviourBspline.
   * 
   * Since: 0.4.
   */
  Glib::RefPtr<BehaviourBspline> split(guint offset);
  
  /** Empties a bspline.
   * 
   * Since: 0.4
   */
  void clear();
  
  /** Change the coordinaces of control point at index to those represented by
   * the knot.
   * 
   * Since: 0.4
   * @param offset An index of control point to ajdust.
   * @param knot A Clutter::Knot with new coordinances for the control point.
   */
  void adjust(guint offset, Knot& knot);
  
  /** Sets the origin of the bezier to the point represented by knot. (Initially
   * the origin of a bspline is given by the position of the first control point
   * of the first bezier curve.)
   * 
   * Since: 0.4
   * @param knot A Clutter::Knot origin for the bezier.
   */
  void set_origin(Knot& knot);
  Knot get_origin() const;
  

  /**
   * @par Prototype:
   * <tt>void on_my_%knot_reached(const Knot& knot)</tt>
   */

  Glib::SignalProxy1< void,const Knot& > signal_knot_reached();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_knot_reached(const Knot& knot);
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter
// vim:ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::BehaviourBspline
   */
  Glib::RefPtr<Clutter::BehaviourBspline> wrap(ClutterBehaviourBspline* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_BEHAVIOUR_BSPLINE_H */

