// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ENTRY_H
#define _CLUTTERMM_ENTRY_H


#include <glibmm.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <cluttermm/actor.h>
#include <cluttermm/color.h>
#include <pangomm.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterEntry ClutterEntry;
typedef struct _ClutterEntryClass ClutterEntryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Entry_Class; } // namespace Clutter
namespace Clutter
{


class Entry :
  public Actor
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Entry CppObjectType;
  typedef Entry_Class CppClassType;
  typedef ClutterEntry BaseObjectType;
  typedef ClutterEntryClass BaseClassType;

private:  friend class Entry_Class;
  static CppClassType entry_class_;

private:
  // noncopyable
  Entry(const Entry&);
  Entry& operator=(const Entry&);

protected:
  explicit Entry(const Glib::ConstructParams& construct_params);
  explicit Entry(ClutterEntry* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Entry();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterEntry*       gobj()       { return reinterpret_cast<ClutterEntry*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterEntry* gobj() const { return reinterpret_cast<ClutterEntry*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterEntry* gobj_copy();

private:


protected:
  Entry();
  explicit Entry(const Glib::ustring& font_name, const Glib::ustring& text);
  explicit Entry(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color);

public:
  
  static Glib::RefPtr<Entry> create();

  
  static Glib::RefPtr<Entry> create(const Glib::ustring& font_name, const Glib::ustring& text);
;
  
  static Glib::RefPtr<Entry> create(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color);
;

 
  /** Sets @a text as the text to be displayed by @a entry. The
   * ClutterEntry::text-changed signal is emitted.
   * 
   * Since: 0.4
   * @param text The text to be displayed.
   */
  void set_text(const Glib::ustring& text);
  
  /** Retrieves the text displayed by @a entry.
   * @return The text of the entry.  The returned string is
   * owned by Clutter::Entry and should not be modified or freed.
   * 
   * Since: 0.4.
   */
  Glib::ustring get_text() const;
  
  /** Sets @a font_name as the font used by @a entry.
   * 
   *  @a font_name must be a string containing the font name and its
   * size, similarly to what you would feed to the
   * pango_font_description_from_string() function.
   * 
   * Since: 0.4
   * @param font_name A font name and size, or <tt>0</tt> for the default font.
   */
  void set_font_name(const Glib::ustring& font_name);
  
  /** Retrieves the font used by @a entry.
   * @return A string containing the font name, in a format
   * understandable by pango_font_description_from_string().  The
   * string is owned by Clutter::Entry and should not be modified
   * or freed.
   * 
   * Since: 0.4.
   */
  Glib::ustring get_font_name() const;

  
  /** Retrieves the color of @a entry.
   * 
   * Since: 0.4
   * @param color Return location for a Clutter::Color.
   */

  Color get_color() const;
  
  
  /** Sets the color of @a entry.
   * 
   * Since: 0.4
   * @param color A Clutter::Color.
   */
  void set_color(const Color& color);

  
  /** Gets the Pango::Layout used to display the entry.
   * The layout is useful to e.g. convert text positions to
   * pixel positions.
   * The returned layout is owned by the entry so need not be
   * freed by the caller.
   * @return The Pango::Layout for this entry
   * 
   * Since: 0.4.
   */
  Glib::RefPtr<Pango::Layout> get_layout();
  
  /** Gets the Pango::Layout used to display the entry.
   * The layout is useful to e.g. convert text positions to
   * pixel positions.
   * The returned layout is owned by the entry so need not be
   * freed by the caller.
   * @return The Pango::Layout for this entry
   * 
   * Since: 0.4.
   */
  Glib::RefPtr<const Pango::Layout> get_layout() const;

  
  /** Return value: The entry's Pango::Alignment
   * @return The entry's Pango::Alignment
   * 
   * Since 0.4.
   */
  Pango::Alignment get_alignment() const;
  
  /** Sets text alignment of the entry.
   * 
   * Since: 0.4
   * @param alignment A Pango::Alignment.
   */
  void set_alignment(Pango::Alignment wrap_mode);

  
  /** Gets the position, in characters, of the cursor in @a entry.
   * @return The position of the cursor.
   * 
   * Since: 0.6.
   */
  int get_cursor_position() const;
  
  /** Sets the position of the cursor. The @a position must be less than or
   * equal to the number of characters in the entry. A value of -1 indicates
   * that the position should be set after the last character in the entry.
   * Note that this position is in characters, not in bytes.
   * 
   * Since: 0.6
   * @param position The position of the cursor.
   */
  void set_cursor_position(int position);

  
  /** Insert a character to the right of the current position of the cursor,
   * and updates the position of the cursor.
   * 
   * Since: 0.4
   * @param wc A Unicode character.
   */
  void insert(gunichar wc);
  
  /** Insert text at a specifc position.
   * 
   * A value of 0 indicates  that the text will be inserted before the first
   * character in the entry's text, and a value of -1 indicates that the text
   * will be inserted after the last character in the entry's text.
   * 
   * Since: 0.4
   * @param text The text to insert.
   * @param position The position at which to insert the text.
   */
  void insert(const Glib::ustring& text, gssize position);

  
  /** Characters are removed from before the current postion of the cursor.
   * 
   * Since: 0.4
   * @param len The number of characters to remove.
   */
  void delete_chars(guint len);
  
  /** Deletes a sequence of characters. The characters that are deleted are
   * those characters at positions from @a start_pos up to, but not including,
   *  @a end_pos. If @a end_pos is negative, then the characters deleted will be
   * those characters from @a start_pos to the end of the text.
   * 
   * Since: 0.4
   * @param start_pos The starting position.
   * @param end_pos The end position.
   */
  void delete_text(gssize start_pos, gssize end_pos);

  
  /** Sets the visibility of the input cursor.
   * 
   * Since: 0.4
   * @param visible Whether the input cursor should be visible.
   */
  void set_visible_cursor(bool visible);
  
  /** Return value: whether the input cursor is visible
   * @return Whether the input cursor is visible
   * 
   * Since: 0.4.
   */
  bool get_visible_cursor() const;

  
  /** Sets whether the contents of the entry are visible or not. When visibility
   * is set to <tt>false</tt>, characters are displayed as the invisible char, and will
   * also appear that way when the text in the entry widget is copied elsewhere.
   * 
   * The default invisible char is the asterisk '*', but it can be changed with
   * set_invisible_char().
   * 
   * Since: 0.4
   * @param visible <tt>true</tt> if the contents of the entry are displayed as plaintext.
   */
  void set_visibility(bool visible);
  
  /** Return value: <tt>true</tt> if the contents of the entry are displayed as plaintext.
   * @return <tt>true</tt> if the contents of the entry are displayed as plaintext.
   * 
   * Since: 0.4.
   */
  bool get_visibility() const;

  
  /** Sets the character to use in place of the actual text when
   * set_visibility() has been called to set text visibility
   * to <tt>false</tt>. i.e. this is the character used in "password mode" to show the
   * user how many characters have been typed. The default invisible char is an
   * asterisk ('*'). If you set the invisible char to 0, then the user will get
   * no feedback at all; there will be no text on the screen as they type.
   * 
   * Since: 0.4
   * @param wc A Unicode character.
   */
  void set_invisible_char(gunichar wc);
  
  /** Return value: a Unicode character
   * @return A Unicode character.
   */
  gunichar get_invisible_char() const;

  
  /** Gets the maximum length of text that can be set into @a entry.
   * See set_max_length().
   * @return The maximum number of characters.
   * 
   * Since: 0.4.
   */
  int get_max_length() const;
  
  /** Sets the maximum allowed length of the contents of the actor. If the
   * current contents are longer than the given length, then they will be
   * truncated to fit.
   * 
   * Since: 0.4
   * @param max The maximum number of characters allowed in the entry; 0
   * to disable or -1 to set the length of the current string.
   */
  void set_max_length(int max_length);

  
  /** This function will handle a Clutter::KeyEvent, like those returned in a
   * key-press/release-event, and will translate it for the @a entry. This includes
   * non-alphanumeric keys, such as the arrows keys, which will move the
   * input cursor. You should use this function inside a handler for the
   * ClutterStage::key-press-event or ClutterStage::key-release-event.
   * 
   * Since: 0.4
   * 
   * Deprecated: 0.8: The key events will automatically be handled when
   * giving the key focus to an entry using Clutter::Stage::set_key_focus().
   * @param kev A Clutter::KeyEvent.
   */
  void handle_key_event(KeyEvent* kev);

 
  /**
   * @par Prototype:
   * <tt>void on_my_%text_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_text_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%cursor_event(const Geometry& geometry)</tt>
   */

  Glib::SignalProxy1< void,const Geometry& > signal_cursor_event();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred alignment for the string
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Pango::Alignment> property_alignment() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The preferred alignment for the string
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Pango::Alignment> property_alignment() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Font Colour.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Color> property_color() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Font Colour.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Color> property_color() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the input cursor is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_cursor_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the input cursor is visible.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_cursor_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The padding space between the text and the left and right borders.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<unsigned int> property_entry_padding() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The padding space between the text and the left and right borders.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<unsigned int> property_entry_padding() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Pango font description.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_font_name() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Pango font description.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_font_name() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The maximum length of the entry text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_max_length() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The maximum length of the entry text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_max_length() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<int> property_position() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The cursor position.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_position() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Text to render.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_text() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Text to render.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_text() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is visible in plain form.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<bool> property_text_visible() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the text is visible in plain form.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_text_visible() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The horizontal alignment to be used for the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_x_align() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The horizontal alignment to be used for the text.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_x_align() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


protected:
  #ifdef GLIBMM_VFUNCS_ENABLED
  virtual void paint_cursor_vfunc();
#endif //GLIBMM_VFUNCS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_text_changed();
  virtual void on_cursor_event(const Geometry& geometry);
  virtual void on_activate();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter

//vim: ts=2,sw=2


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Entry
   */
  Glib::RefPtr<Clutter::Entry> wrap(ClutterEntry* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ENTRY_H */

