// Generated by gtkmmproc -- DO NOT MODIFY!


#include <cluttermm/entry.h>
#include <cluttermm/private/entry_p.h>

/* Copyright (C) 2007 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <clutter/clutter.h>

namespace Clutter
{

Color Entry::get_color() const
{
    Color color;
    clutter_entry_get_color(const_cast<ClutterEntry*>(gobj()), color.gobj());
    return color;
}

} //namespace Clutter


namespace
{


static const Glib::SignalProxyInfo Entry_signal_text_changed_info =
{
  "text_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Entry_signal_cursor_event_callback(ClutterEntry* self, ClutterGeometry* p0,void* data)
{
  using namespace Clutter;
  typedef sigc::slot< void,const Geometry& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Entry_signal_cursor_event_info =
{
  "cursor_event",
  (GCallback) &Entry_signal_cursor_event_callback,
  (GCallback) &Entry_signal_cursor_event_callback
};


static const Glib::SignalProxyInfo Entry_signal_activate_info =
{
  "activate",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Clutter::Entry> wrap(ClutterEntry* object, bool take_copy)
{
  return Glib::RefPtr<Clutter::Entry>( dynamic_cast<Clutter::Entry*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Clutter
{


/* The *_Class implementation: */

const Glib::Class& Entry_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Entry_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(clutter_entry_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void Entry_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
  klass->paint_cursor = &paint_cursor_vfunc_callback;
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->text_changed = &text_changed_callback;
  klass->cursor_event = &cursor_event_callback;
  klass->activate = &activate_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
void Entry_Class::paint_cursor_vfunc_callback(ClutterEntry* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->paint_cursor_vfunc();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->paint_cursor)
    (*base->paint_cursor)(self);

}
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Entry_Class::text_changed_callback(ClutterEntry* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_text_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->text_changed)
    (*base->text_changed)(self);
}
void Entry_Class::cursor_event_callback(ClutterEntry* self, ClutterGeometry* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_cursor_event(Glib::wrap(p0)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->cursor_event)
    (*base->cursor_event)(self, p0);
}
void Entry_Class::activate_callback(ClutterEntry* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_activate();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->activate)
    (*base->activate)(self);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Entry_Class::wrap_new(GObject* object)
{
  return new Entry((ClutterEntry*)object);
}


/* The implementation: */

ClutterEntry* Entry::gobj_copy()
{
  reference();
  return gobj();
}

Entry::Entry(const Glib::ConstructParams& construct_params)
:
  Actor(construct_params)
{

}

Entry::Entry(ClutterEntry* castitem)
:
  Actor((ClutterActor*)(castitem))
{}

Entry::~Entry()
{}


Entry::CppClassType Entry::entry_class_; // initialize static member

GType Entry::get_type()
{
  return entry_class_.init().get_type();
}

GType Entry::get_base_type()
{
  return clutter_entry_get_type();
}


Entry::Entry()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Actor(Glib::ConstructParams(entry_class_.init()))
{
  

}

Entry::Entry(const Glib::ustring& font_name, const Glib::ustring& text)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Actor(Glib::ConstructParams(entry_class_.init(), "font_name", font_name.c_str(), "text", text.c_str(), static_cast<char*>(0)))
{
  

}

Entry::Entry(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Actor(Glib::ConstructParams(entry_class_.init(), "font_name", font_name.c_str(), "text", text.c_str(), "color", (color).gobj(), static_cast<char*>(0)))
{
  

}

Glib::RefPtr<Entry> Entry::create()
{
  return Glib::RefPtr<Entry>( new Entry() );
}
Glib::RefPtr<Entry> Entry::create(const Glib::ustring& font_name, const Glib::ustring& text)
{
  return Glib::RefPtr<Entry>( new Entry(font_name, text) );
}
Glib::RefPtr<Entry> Entry::create(const Glib::ustring& font_name, const Glib::ustring& text, const Color& color)
{
  return Glib::RefPtr<Entry>( new Entry(font_name, text, color) );
}
void Entry::set_text(const Glib::ustring& text)
{
clutter_entry_set_text(gobj(), text.c_str()); 
}

Glib::ustring Entry::get_text() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(clutter_entry_get_text(const_cast<ClutterEntry*>(gobj())));
}

void Entry::set_font_name(const Glib::ustring& font_name)
{
clutter_entry_set_font_name(gobj(), font_name.c_str()); 
}

Glib::ustring Entry::get_font_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(clutter_entry_get_font_name(const_cast<ClutterEntry*>(gobj())));
}

void Entry::set_color(const Color& color)
{
clutter_entry_set_color(gobj(), (color).gobj()); 
}

Glib::RefPtr<Pango::Layout> Entry::get_layout()
{
  return Glib::wrap(clutter_entry_get_layout(gobj()));
}

Glib::RefPtr<const Pango::Layout> Entry::get_layout() const
{
  return const_cast<Entry*>(this)->get_layout();
}

Pango::Alignment Entry::get_alignment() const
{
  return ((Pango::Alignment)(clutter_entry_get_alignment(const_cast<ClutterEntry*>(gobj()))));
}

void Entry::set_alignment(Pango::Alignment wrap_mode)
{
clutter_entry_set_alignment(gobj(), ((PangoAlignment)(wrap_mode))); 
}

int Entry::get_cursor_position() const
{
  return clutter_entry_get_cursor_position(const_cast<ClutterEntry*>(gobj()));
}

void Entry::set_cursor_position(int position)
{
clutter_entry_set_cursor_position(gobj(), position); 
}

void Entry::insert(gunichar wc)
{
clutter_entry_insert_unichar(gobj(), wc); 
}

void Entry::insert(const Glib::ustring& text, gssize position)
{
clutter_entry_insert_text(gobj(), text.c_str(), position); 
}

void Entry::delete_chars(guint len)
{
clutter_entry_delete_chars(gobj(), len); 
}

void Entry::delete_text(gssize start_pos, gssize end_pos)
{
clutter_entry_delete_text(gobj(), start_pos, end_pos); 
}

void Entry::set_visible_cursor(bool visible)
{
clutter_entry_set_visible_cursor(gobj(), static_cast<int>(visible)); 
}

bool Entry::get_visible_cursor() const
{
  return clutter_entry_get_visible_cursor(const_cast<ClutterEntry*>(gobj()));
}

void Entry::set_visibility(bool visible)
{
clutter_entry_set_visibility(gobj(), static_cast<int>(visible)); 
}

bool Entry::get_visibility() const
{
  return clutter_entry_get_visibility(const_cast<ClutterEntry*>(gobj()));
}

void Entry::set_invisible_char(gunichar wc)
{
clutter_entry_set_invisible_char(gobj(), wc); 
}

gunichar Entry::get_invisible_char() const
{
  return clutter_entry_get_invisible_char(const_cast<ClutterEntry*>(gobj()));
}

int Entry::get_max_length() const
{
  return clutter_entry_get_max_length(const_cast<ClutterEntry*>(gobj()));
}

void Entry::set_max_length(int max_length)
{
clutter_entry_set_max_length(gobj(), max_length); 
}

void Entry::handle_key_event(KeyEvent* kev)
{
clutter_entry_handle_key_event(gobj(), kev); 
}


Glib::SignalProxy0< void > Entry::signal_text_changed()
{
  return Glib::SignalProxy0< void >(this, &Entry_signal_text_changed_info);
}


Glib::SignalProxy1< void,const Geometry& > Entry::signal_cursor_event()
{
  return Glib::SignalProxy1< void,const Geometry& >(this, &Entry_signal_cursor_event_info);
}


Glib::SignalProxy0< void > Entry::signal_activate()
{
  return Glib::SignalProxy0< void >(this, &Entry_signal_activate_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Pango::Alignment> Entry::property_alignment() 
{
  return Glib::PropertyProxy<Pango::Alignment>(this, "alignment");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Pango::Alignment> Entry::property_alignment() const
{
  return Glib::PropertyProxy_ReadOnly<Pango::Alignment>(this, "alignment");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Color> Entry::property_color() 
{
  return Glib::PropertyProxy<Color>(this, "color");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Color> Entry::property_color() const
{
  return Glib::PropertyProxy_ReadOnly<Color>(this, "color");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Entry::property_cursor_visible() 
{
  return Glib::PropertyProxy<bool>(this, "cursor-visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Entry::property_cursor_visible() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "cursor-visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<unsigned int> Entry::property_entry_padding() 
{
  return Glib::PropertyProxy<unsigned int>(this, "entry-padding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<unsigned int> Entry::property_entry_padding() const
{
  return Glib::PropertyProxy_ReadOnly<unsigned int>(this, "entry-padding");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Entry::property_font_name() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "font-name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Entry::property_font_name() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "font-name");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Entry::property_max_length() 
{
  return Glib::PropertyProxy<int>(this, "max-length");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Entry::property_max_length() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "max-length");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Entry::property_position() 
{
  return Glib::PropertyProxy<int>(this, "position");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Entry::property_position() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "position");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Entry::property_text() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "text");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Entry::property_text() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "text");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Entry::property_text_visible() 
{
  return Glib::PropertyProxy<bool>(this, "text-visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Entry::property_text_visible() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "text-visible");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Entry::property_x_align() 
{
  return Glib::PropertyProxy<double>(this, "x-align");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Entry::property_x_align() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "x-align");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Clutter::Entry::on_text_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->text_changed)
    (*base->text_changed)(gobj());
}
void Clutter::Entry::on_cursor_event(const Geometry& geometry)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->cursor_event)
    (*base->cursor_event)(gobj(),const_cast<ClutterGeometry*>((geometry).gobj()));
}
void Clutter::Entry::on_activate()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->activate)
    (*base->activate)(gobj());
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
void Clutter::Entry::paint_cursor_vfunc() 
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->paint_cursor)
    (*base->paint_cursor)(gobj());
}
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Clutter


