// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _CLUTTERMM_ANIMATION_H
#define _CLUTTERMM_ANIMATION_H


#include <glibmm.h>

/* Copyright (C) 2009 The cluttermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <cluttermm/alpha.h>
#include <cluttermm/actor.h>
#include <cluttermm/interval.h>
#include <cluttermm/timeline.h>
#include <clutter/clutter.h>
 

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _ClutterAnimation ClutterAnimation;
typedef struct _ClutterAnimationClass ClutterAnimationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Clutter
{ class Animation_Class; } // namespace Clutter
namespace Clutter
{


class Animation : public Glib::Object
{

  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Animation CppObjectType;
  typedef Animation_Class CppClassType;
  typedef ClutterAnimation BaseObjectType;
  typedef ClutterAnimationClass BaseClassType;

private:  friend class Animation_Class;
  static CppClassType animation_class_;

private:
  // noncopyable
  Animation(const Animation&);
  Animation& operator=(const Animation&);

protected:
  explicit Animation(const Glib::ConstructParams& construct_params);
  explicit Animation(ClutterAnimation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Animation();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  ClutterAnimation*       gobj()       { return reinterpret_cast<ClutterAnimation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const ClutterAnimation* gobj() const { return reinterpret_cast<ClutterAnimation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  ClutterAnimation* gobj_copy();

private:


protected:
  Animation();

public:
  
  static Glib::RefPtr<Animation> create();


  void set_object(const Glib::RefPtr<Glib::Object>& object);
  
  Glib::RefPtr<Glib::Object> get_object();
  
  Glib::RefPtr<const Glib::Object> get_object() const;
  
  void set_mode(gulong mode);
  
  gulong get_mode() const;
  
  void set_duration(int msecs);
  
  guint get_duration() const;
  
  void set_loop(bool loop=true);
  
  bool get_loop() const;
  
  /** Sets the Clutter::Timeline used by @a animation.
   * 
   * The Clutter::Animation:duration and Clutter::Animation:loop properties
   * will be set using the corresponding Clutter::Timeline properties as a
   * side effect.
   * 
   * If @a timeline is <tt>0</tt> a new Clutter::Timeline will be constructed
   * using the current values of the Clutter::Animation:duration and
   * Clutter::Animation:loop properties.
   * 
   * Since: 1.0
   * @param timeline A Clutter::Timeline or <tt>0</tt>.
   */
  void set_timeline(const Glib::RefPtr<Timeline>& timeline);
  
  Glib::RefPtr<Timeline> get_timeline() const;
  
  void set_alpha(const Glib::RefPtr<Alpha>& alpha);
  
  /** Retrieves the Clutter::Alpha used by @a animation.
   * @return (transfer none): the alpha object used by the animation
   * 
   * Since: 1.0.
   */
  Glib::RefPtr<Alpha> get_alpha() const;
  
  void completed();
  
  Glib::RefPtr<Animation> bind(const std::string& property_name, const Glib::ValueBase& final);
  
  /** Binds @a interval to the @a property_name of the Object
   * attached to @a animation. The Clutter::Animation will take
   * ownership of the passed Clutter::Interval.  For more information
   * about animations, see Clutter::Actor::animate().
   * 
   * If you need to update the interval instance use
   * clutter_animation_update_property() instead.
   * @param property_name The property to control.
   * @param interval (transfer full): a Clutter::Interval.
   * @return (transfer none): The animation itself.
   * Since: 1.0.
   */
  void bind_interval(const std::string& property_name, const Glib::RefPtr<Interval>& interval);
  
  void update_interval(const std::string& property_name, const Glib::RefPtr<Interval>& interval);
  
  bool has_property(const std::string& property_name) const;
  
  void unbind_property(const std::string& property_name);
  
  Glib::RefPtr<Interval> get_interval(const std::string& property_name) const;

  
  /**
   * @par Prototype:
   * <tt>void on_my_%started()</tt>
   */

  Glib::SignalProxy0< void > signal_started();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%completed()</tt>
   */

  Glib::SignalProxy0< void > signal_completed();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_started();
  virtual void on_completed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Clutter


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Clutter::Animation
   */
  Glib::RefPtr<Clutter::Animation> wrap(ClutterAnimation* object, bool take_copy = false);
}


#endif /* _CLUTTERMM_ANIMATION_H */

